// app code start
phonon.options({
    navigator: {
        defaultPage: 'home',
        animatePages: true,
        enableBrowserBackButton: false // should be disabled on Cordova
    },
    i18n: null
});

var app = phonon.navigator();

function getcurrency(icoin1, icoin2, value, callback) {
    var indicator = phonon.indicator("Atualizando cotação...", false);
    currency(icoin1, icoin2, value, function(data) {
        indicator.close();
        callback(data);
    }, function() {
        indicator.close();
        app.changePage('noconnection');
    });
}

app.on({page: 'home', content: null}, function(activity) {

    activity.onReady(function() {

        // init
        if(typeof store.get('running_since')=='undefined') {
            // start new game
            store.set('running_since', time());
            store.set('wallet_btc', 1);
            store.set('wallet_brl', 0);
            $("#closestartup").on('click', function() {
                phonon.notif('+1 BTC', 5000, false);
                setTimeout(function() {
                    $("#wallet_btc").text(converteFloatMoeda(1.0));
                    $("#wallet_brl").text('0.00000000');
                    getcurrency('btc', 'brl', 1, function(data) {
                        $("#wallet_total").text('R$ '+converteFloatMoeda(data));
                        $("#valor_btc").text('R$ '+converteFloatMoeda(data));
                    });
                }, 5000);
            });
            
            phonon.panel('#startup-panel').open();
        }

       $("#wallet_btc").text((store.get('wallet_btc').toFixed(8)));
       $("#wallet_brl").text(converteFloatMoeda(store.get('wallet_brl'))); 
       getcurrency('btc', 'brl', 1, function(data) {
            $("#wallet_total").text('R$ '+converteFloatMoeda((store.get('wallet_btc')*data)+store.get('wallet_brl')));
            $("#valor_btc").text("R$ "+(converteFloatMoeda(data)));
       });
    });
});

app.on({page: 'buy', content: null}, function(activity) {
    activity.onReady(function() {
        getcurrency('btc', 'brl', 1, function(data) {

            var btc2brl = data;
            var brl2btc = 1/btc2brl;

            var preview = function() {
                var value = $('buy .iValue').val();
                var moeda = $('input[name=digitei]:checked', 'buy').val();
                var total;
                if(moeda=='brl') {
                    total = value*brl2btc;
                    $("buy .iSymbol").text("BTC");
                    $("buy .iTotal").text(total.toFixed(8));
                } else {
                    total = value*btc2brl;
                    $("buy .iSymbol").text("BRL");
                    $("buy .iTotal").text(converteFloatMoeda(total));
                }   
            }

            $("buy .iValue").unbind('keyup');
            $("buy input[name=digitei]:radio").unbind('click');
            $("buy .iSubmit").unbind('click');

            $("buy .iValue").keyup(preview);
            $("buy input[name=digitei]:radio").click(preview);

            $("buy .iSubmit").click(function() {
                var value = parseFloat($('buy .iValue').val());
                var moeda = $('input[name=digitei]:checked', 'buy').val();
                var total;
                if(!value) return 0;

                if(moeda=='brl') {
                    if(store.get('wallet_brl')<value) {
                        phonon.alert("Você não possui fundos suficientes para comprar esta quantidade.", "Fundos insuficientes", true);
                    } else {
                        total = value*brl2btc;
                        var confirm = phonon.confirm("Confirma a operação?", "Compra de bitcoins", true);
                        confirm.on('confirm', function() {
                            store.set('wallet_brl', parseFloat(parseFloat(store.get('wallet_brl'))-value));
                            store.set('wallet_btc', parseFloat(parseFloat(store.get('wallet_btc'))+total));
                            phonon.notif('Depositando BRL...', 5000, false);
                            setTimeout(function() {
                                phonon.notif('Aguardando confirmação do BTC...', 5000, false);
                                setTimeout(function() {
                                    app.changePage('home');
                                }, 5000);
                            }, 5000);
                        });
                    }
                } else {
                    total = value*btc2brl;
                    if(store.get('wallet_brl')<total) {
                        phonon.alert("Você não possui fundos suficientes para comprar esta quantidade.", "Fundos insuficientes", true);
                    } else {
                        var confirm = phonon.confirm("Confirma a operação?", "Compra de bitcoins", true);
                        confirm.on('confirm', function() {
                            store.set('wallet_btc', parseFloat(parseFloat(store.get('wallet_btc'))+value));
                            store.set('wallet_brl', parseFloat(parseFloat(store.get('wallet_brl'))-total));
                            phonon.notif('Depositando BRL...', 5000, false);
                            setTimeout(function() {
                                phonon.notif('Aguardando confirmação do BTC...', 5000, false);
                                setTimeout(function() {
                                    app.changePage('home');
                                }, 5000);
                            }, 5000);
                        });
                    }
                }
            });
        });
    });
});

app.on({page: 'sell', content: null}, function(activity) {
    activity.onReady(function() {
        getcurrency('btc', 'brl', 1, function(data) {

            var btc2brl = data;
            var brl2btc = 1/btc2brl;

            var preview = function() {
                var value = $('sell .iValue').val();
                var moeda = $('input[name=digitei2]:checked', 'sell').val();
                var total;
                if(moeda=='brl') {
                    total = value*brl2btc;
                    $("sell .iSymbol").text("BTC");
                    $("sell .iTotal").text(total.toFixed(8));
                } else {
                    total = value*btc2brl;
                    $("sell .iSymbol").text("BRL");
                    $("sell .iTotal").text(converteFloatMoeda(total));
                }   
            }

            $("sell .iValue").unbind('keyup');
            $("sell input[name=digitei2]:radio").unbind('click');
            $("sell .iSubmit").unbind('click');

            $("sell .iValue").keyup(preview);
            $("sell input[name=digitei2]:radio").click(preview);

            $("sell .iSubmit").click(function() {
                var value = parseFloat($('sell .iValue').val());
                var moeda = $('input[name=digitei2]:checked', 'sell').val();
                var total;
                if(!value) return 0;

                if(moeda=='brl') {
                    total = value*brl2btc;
                    if(store.get('wallet_btc')<total) {
                        phonon.alert("Você não possui esta quantidade para vender.", "Fundos insuficientes", true);
                    } else {
                        var confirm = phonon.confirm("Confirma a operação?", "Venda de bitcoins", true);
                        confirm.on('confirm', function() {
                            store.set('wallet_brl', parseFloat(parseFloat(store.get('wallet_brl'))+value));
                            store.set('wallet_btc', parseFloat(parseFloat(store.get('wallet_btc'))-total));
                            phonon.notif('Aguardando confirmação do BTC...', 5000, false);
                            setTimeout(function() {
                                phonon.notif('Aguardando finalização da ordem...', 5000, false);
                                setTimeout(function() {
                                    app.changePage('home');
                                }, 5000);
                            }, 5000);
                        });
                    }
                } else {
                    total = value*btc2brl;
                    if(store.get('wallet_btc')<value) {
                        phonon.alert("Você não possui esta quantidade para vender.", "Fundos insuficientes", true);
                    } else {
                        var confirm = phonon.confirm("Confirma a operação?", "Venda de bitcoins", true);
                        confirm.on('confirm', function() {
                            store.set('wallet_btc', parseFloat(parseFloat(store.get('wallet_btc'))-value));
                            store.set('wallet_brl', parseFloat(parseFloat(store.get('wallet_brl'))+total));
                            phonon.notif('Aguardando confirmação do BTC...', 5000, false);
                            setTimeout(function() {
                                phonon.notif('Aguardando finalização da ordem...', 5000, false);
                                setTimeout(function() {
                                    app.changePage('home');
                                }, 5000);
                            }, 5000);
                        });
                    }
                }
            });
        });
    });
});

app.on({page: 'config', content: null}, function(activity) {
    activity.onCreate(function() {
        $("#newgame").click(function() {
            var confirm = phonon.confirm('Tem certeza que deseja reiniciar o jogo? Todo o progresso até agora será perdido.', 'Novo jogo', true);
            confirm.on('confirm', function() {
                // start new game
                store.set('running_since', time());
                store.set('wallet_btc', 1);
                store.set('wallet_brl', 0);

                phonon.alert("Você recebeu 1 bitcoin para começar.", "Jogo reiniciado", false);
                phonon.notif('+1 BTC', 5000, false);
                $("#wallet_btc").text(converteFloatMoeda(1.0));
                $("#wallet_brl").text(converteFloatMoeda(0.0));
                getcurrency('btc', 'brl', 1, function(data) {
                    $("#wallet_total").text('R$ '+converteFloatMoeda(data));
                    $("#valor_btc").text('R$ '+converteFloatMoeda(data));
                });
            });
        });
    });
})

app.start();
// app code end