// JustRequire - seamless Javascript require function
// Developed by Jefrey S. Santos - jefrey[at]jefrey.ml

require = function(scripts, callback) {
	if(typeof scripts == 'string') {
		scripts = [scripts];
	}

	var j = scripts.length-1;
	for(i = 0; i<=j; i++) {
		// create script element
		script = document.createElement('script');
		script.setAttribute('type', 'text/javascript');
		script.setAttribute('src', scripts[i]+'.js');

		// load callback
		if(typeof callback == 'function') {
			// for IE
			if(elm.attachEvent) {
				script.attachEvent('onreadystatechange', function() {
					if(script.readyState=='complete' || script.readyState=='loaded') {
						callback();
					}
				});
			}

			// for decent browsers
			if(script.addEventListener) {
				script.addEventListener('load', callback, false);
			}
		}

		// add to DOM
		document.getElementsByTagName('head')[0].appendChild(script);
	}
}