var Game = {};

Game.fps = 60;

Game.G = .01; //1

Game.initialize = function() {

	this.G = .01;

	this.entities = [];
	this.bullets = [];
	this.particles = [];
	this.context = document.getElementById("viewport").getContext("2d");
	this.score = 0;
	this.hiscore = localStorage.getItem("hiscore");
	if (this.hiscore != null) {
		this.hiscoreInt = parseInt(this.hiscore);
	} else {
		this.hiscoreInt = 0;
	}

	this.game_over_time = -1;

	this.game_over_dialog_time = -1;

	if (Math.random() > .5) {
		var rstart = -1;
	} else {
		var rstart = 1;
	}

	this.addBlackStar(0 + (Math.random() + 1) * 50 * scale, 0 + (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w * .5 + (Math.random() - .5) * 50 * scale, 0 + (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w - (Math.random() + 1) * 50 * scale, 0 + (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w - (Math.random() + 1) * 50 * scale, h * .5 + rstart * (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w - (Math.random() + 1) * 50 * scale, h - (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w * .5 + (Math.random() - .5) * 50 * scale, h - (Math.random() + 1) * 50 * scale);
	this.addBlackStar(0 + (Math.random() + 1) * 50 * scale, h - (Math.random() + 1) * 50 * scale);
	this.addBlackStar(0 + (Math.random() + 1) * 50 * scale, h * .5 - rstart * (Math.random() + 1) * 50 * scale);

	this.addRocket();

	game_over = false;

};

Game.startMenu = function() {

	this.G = .2;

	this.entities = [];
	this.bullets = [];
	this.particles = [];
	this.context = document.getElementById("viewport").getContext("2d");
	this.score = 0;
	this.hiscore = localStorage.getItem("hiscore");
	if (this.hiscore != null) {
		this.hiscoreInt = parseInt(this.hiscore);
	} else {
		this.hiscoreInt = 0;
	}

	if (Math.random() > .5) {
		var rstart = -1;
	} else {
		var rstart = 1;
	}

	this.addBlackStar(0 + (Math.random() + 1) * 50 * scale, 0 + (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w * .5 + (Math.random() - .5) * 50 * scale, 0 + (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w - (Math.random() + 1) * 50 * scale, 0 + (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w - (Math.random() + 1) * 50 * scale, h * .5 + rstart * (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w - (Math.random() + 1) * 50 * scale, h - (Math.random() + 1) * 50 * scale);
	this.addBlackStar(w * .5 + (Math.random() - .5) * 50 * scale, h - (Math.random() + 1) * 50 * scale);
	this.addBlackStar(0 + (Math.random() + 1) * 50 * scale, h - (Math.random() + 1) * 50 * scale);
	this.addBlackStar(0 + (Math.random() + 1) * 50 * scale, h * .5 - rstart * (Math.random() + 1) * 50 * scale);

};

Game.draw = function() {
	this.context.clearRect(0, 0, w, h);

	for (var i = 0; i < this.bullets.length; i++) {
		this.bullets[i].draw(this.context);
	}

	for (var i = 0; i < this.entities.length; i++) {
		this.entities[i].draw(this.context);
	}

	for (var i = 0; i < this.particles.length; i++) {
		this.particles[i].draw(this.context);
	}

	if (!game_over) this.rocket.draw(this.context);
};

Game.update = function() {

	if (game_over && this.game_over_time != -1) {
		var now = (new Date()).getTime();
		if (now - this.game_over_time > 1000) {
			this.game_over_time = -1;
			$("#score").hide();
			$("#main_menu").show();
			$("#game_over").show();
			this.game_over_dialog_time = (new Date()).getTime();
		}
	}

	for (var i = 0; i < Game.entities.length; i++) {
		for (var k = 0; k < Game.bullets.length; k++) {
			var rx = Game.bullets[k].x - Game.entities[i].x;
			var ry = Game.bullets[k].y - Game.entities[i].y;

			var r = Math.sqrt(rx * rx + ry * ry);

			if (Game.bullets[k].active && r < Game.entities[i].radius) {
				Game.bullets[k].x = 2 * w;
				if (Game.entities[i].radius > 16 * scale) {
					Game.entities[i].radius = Game.entities[i].radius * .9;
					Game.entities[i].local_scale_factor = Game.entities[i].local_scale_factor * .9;
					if (!game_over) {
						this.score += 10;
						if (this.score > 1000000) this.score = 1000000;
					}
					playSound("hit");
				} else {
					Game.entities[i].radius = 20 * scale;
					Game.entities[i].local_scale_factor = 1;

					this.G += .005;
					if (this.G > 1) this.G = 1;

					this.smallExplosion(Game.entities[i].x, Game.entities[i].y);

					if (Math.random() > .5) {
						Game.entities[i].x = 1.5 * w;
					} else {
						Game.entities[i].x = -1.5 * w;
					}
					Game.entities[i].y = Math.random() * h;
					if (!game_over) {
						this.score += 100;
						if (this.score > 1000000) this.score = 1000000;
					}
				}
			}
		}

		if (!game_over) {

			var rx_rocket = Game.rocket.x - Game.entities[i].x;
			var ry_rocket = Game.rocket.y - Game.entities[i].y;

			var r_rocket = Math.sqrt(rx_rocket * rx_rocket + ry_rocket * ry_rocket);

			if (r_rocket < Game.entities[i].radius + this.rocket.radius) {
				Game.entities[i].x = 1.5 * w;
				game_over = true;
				if (this.score > this.hiscoreInt) {
					this.hiscoreInt = this.score;
					localStorage.setItem("hiscore", "" + this.hiscoreInt);
				}
				this.bigExplosion(this.rocket.x, this.rocket.y);

				var date = new Date();
				this.game_over_time = date.getTime();
			}
		}
	}

	for (var i = 0; i < this.bullets.length; i++) {
		this.bullets[i].update();
	}

	for (var i = 0; i < this.entities.length; i++) {
		this.entities[i].update();
	}

	for (var i = 0; i < this.particles.length; i++) {
		this.particles[i].update();
	}

	if (!game_over) this.rocket.update();

	document.getElementById("score").innerHTML = "score:" + this.score;

};

Game.addBlackStar = function(x, y) {
	this.entities.push(new BlackStar(x, y));
};

Game.addRocket = function() {
	this.rocket = new Rocket();
};

Game.addBullet = function() {
	var b_len = this.bullets.length;
	var recycle = false;
	if (b_len > 0) {
		for (var i=0; i < b_len; i++) {
			if (this.bullets[i].x - this.bullets[i].radius > w || this.bullets[i].x + this.bullets[i].radius < 0 || this.bullets[i].y - this.bullets[i].radius > h || this.bullets[i].y + this.bullets[i].radius < 0) {
				this.bullets[i].x = this.rocket.x;
				this.bullets[i].y = this.rocket.y;
				this.bullets[i].r = this.rocket.r;
				this.bullets[i].active = true;
				recycle = true;
				break;
			}
		}
		if (!recycle) {
			this.bullets.push(new Bullet());
		}
	} else {
		this.bullets.push(new Bullet());
	}

	playSound("bullet");
};

Game.addParticle = function(x, y, particle_scale, scale_speed, xy_speed) {
	var p_len = this.particles.length;
	var recycle = false;
	if (p_len > 0) {
		for (var i=0; i < p_len; i++) {
			if (this.particles[i].scale == 0) {
				this.particles[i].x = x;
				this.particles[i].y = y;
				this.particles[i].scale = particle_scale;
				this.particles[i].scaleSpeed = scale_speed;
				this.particles[i].velocityX = (Math.random() - .5) * xy_speed;
				this.particles[i].velocityY = (Math.random() - .5) * xy_speed;
				recycle = true;
				break;
			}
		}
		if (!recycle) {
			this.particles.push(new Particle(x, y, particle_scale, scale_speed, (Math.random() - .5) * xy_speed, (Math.random() - .5) * xy_speed));
		}
	} else {
		this.particles.push(new Particle(x, y, particle_scale, scale_speed, (Math.random() - .5) * xy_speed, (Math.random() - .5) * xy_speed));
	}
};

Game.smallExplosion = function(x, y) {
	
	this.addParticle(x, y, .7, (Math.random() + 1) * .02, (Math.random() - .5) * 50);
	this.addParticle(x, y, .7, (Math.random() + 1) * .02, (Math.random() - .5) * 50);
	this.addParticle(x, y, .7, (Math.random() + 1) * .02, (Math.random() - .5) * 50);

	playSound("explosion");
};

Game.bigExplosion = function(x, y) {
	
	this.addParticle(x, y, 1, (Math.random() + 1) * .02, (Math.random() - .5) * 80);
	this.addParticle(x, y, 1, (Math.random() + 1) * .02, (Math.random() - .5) * 80);
	this.addParticle(x, y, 1, (Math.random() + 1) * .02, (Math.random() - .5) * 80);
	this.addParticle(x, y, 1, (Math.random() + 1) * .02, (Math.random() - .5) * 80);
	this.addParticle(x, y, 1, (Math.random() + 1) * .02, (Math.random() - .5) * 80);

	playSound("explosion");

	window.navigator.vibrate(100);
};