baseH = 540;

AX = 0;
AY = 0;

AXR = 0;
AYR = 0;

gamma = 0;
beta = 0;

game_over = true;

//navigator.mozPower.screenBrightness = 1; // This API is available on Firefox OS for certified applications only. Certified Apps: Certified apps can currently only be pre-installed on the device.

window.screen.mozLockOrientation("portrait-primary");

/*window.onresize = function() {
	console.log(window.screen.mozLockOrientation("landscape-primary"));
}*/

/*window.addEventListener("focus", function(event) { 

	window.screen.mozLockOrientation("portrait-primary"); 

}, false);*/

//window.addEventListener("blur", function(event) { window.screen.mozUnlockOrientation(); }, false);

/*window.screen.addEventListener("orientationchange", function () {
	var canvas = document.getElementById('viewport');

	var w = window.innerWidth;
	var h = window.innerHeight;

	if (h > w) {
		var tmp = h;
		h = w;
		w = tmp;
	}

	canvas.width = w;
	canvas.height = h;
});*/

function handleOrientation(event) {

	gamma = event.gamma; // In degree in the range [-90,90]
	beta = event.beta;  // In degree in the range [-180,180]

	if (gamma > 30) gamma = 30;
	if (gamma < -30) gamma = -30;

	if (beta > 30) beta = 30;
	if (beta < -30) beta = -30;
	
	AX = AX * .2 + gamma * .8;
	AY = AY * .2 + beta * .8;

	AXR = AXR * .4 + gamma * .6;
	AYR = AYR * .4 + beta * .6;
}

window.addEventListener('deviceorientation', handleOrientation);

var channel_max = 10;										
audiochannels = new Array();
for (i = 0; i < channel_max; i++) {									
	audiochannels[i] = new Array();
	audiochannels[i]['channel'] = new Audio();
	audiochannels[i]['finished'] = -1;					
}
function playSound(id) {
	for (var i = 0; i < audiochannels.length; i++) {
		thistime = new Date();
		if (audiochannels[i]['finished'] < thistime.getTime()) {
			audiochannels[i]['finished'] = thistime.getTime() + document.getElementById(id).duration*1000;
			audiochannels[i]['channel'].src = document.getElementById(id).src;
			audiochannels[i]['channel'].load();
			audiochannels[i]['channel'].play();
			break;
		}
	}
}

$("#username").filter_input({regex:"[a-zA-Z0-9]"}); 

$("#menu_start").on("click", function(event){
	playSound("switch");
	Game.initialize();
	$("#main_menu").hide();
	$("#help").hide();
	$("#game_over").hide();
	$("#score").show();
});

$("#menu_help").on("click", function(event){
	playSound("switch");
	$("#help").show();
});

$("#menu_highscores").on("click", function(event){
	playSound("switch");
	$("#top10").hide();
	$("#submit_highscore").hide();
	$("#submit_form").hide();
	$("#game_over").hide();
	$("#help").hide();
	$("#get_error").hide();
	$("#highscores").show();
	$("#loading").show();
	$("#your_highscore").html("YOUR HIGHSCORE: " + Game.hiscoreInt);

	var xhr = new XMLHttpRequest({mozSystem: true});
	xhr.open("GET", "http://blackstar.bitorbit.biz?t=" + new Date().getTime(), true);
	xhr.timeout = 15000;
	xhr.onreadystatechange = function () {
		if (xhr.status === 200 && xhr.readyState === 4) {
			$("#loading").hide();
			var obj = JSON.parse(xhr.responseText);
			if (obj.length != 10) {
				$("#get_error").show();
			} else {
				var lastSubmitedHiscore = localStorage.getItem("lastSubmitedHiscore");
				if (lastSubmitedHiscore != null) {
					var lastSubmitedHiscoreInt = parseInt(lastSubmitedHiscore);
				} else {
					var lastSubmitedHiscoreInt = 0;
				}
				if (Game.hiscoreInt > parseInt(obj[9][1]) && Game.hiscoreInt > lastSubmitedHiscoreInt) {
					$("#submit_highscore").show();
				}
				var top10html = "";
				for (var i = 0; i < 10; i++) {
					top10html += "<li>&nbsp;" + (i + 1) + "&nbsp;";
					if (i < 9) top10html += "&nbsp;";
					top10html += obj[i][0] + "&nbsp;&nbsp;";
					var name_len = obj[i][0].length;
					for(var k = 0; k < 4 - name_len; k++) {
						top10html += "&nbsp;";
					}
					top10html += obj[i][1];
					top10html += "</li>";
				}
				$("#top10").html(top10html);
				$("#top10").show();
			}
		}
	}
	xhr.onerror = function () {
		$("#loading").hide();
		$("#get_error").show();
	};
	xhr.ontimeout = function () {
		$("#loading").hide();
		$("#get_error").show();
	};
	xhr.send();
});

$("#submit_highscore").on("click", function(event){
	event.stopPropagation();
	playSound("switch");
	$("#top10").hide();
	$("#submit_form").show();
});

$("#help .wrapper").on("click", function(event){
	$("#help").hide();
});

$("#game_over .wrapper").on("click", function(event){
	var now = (new Date()).getTime();
	if (now - Game.game_over_dialog_time > 1000) {
		$("#game_over").hide();
	}
});

$("#highscores .wrapper").on("click", function(event){
	$("#highscores").hide();
});

$("#submit_form").on("click", function(event){
	$("#highscores").hide();
});

$("#username").on("click", function(event){
	event.stopPropagation();
});

$("#go").on("click", function(event){
	event.stopPropagation();
	playSound("switch");

	$("#submit_highscore").hide();

	if ($("#username").val() != "") {
		$("#submit_form").hide();
		$("#loading").show();

		var xhr = new XMLHttpRequest({mozSystem: true});
		xhr.open("POST", "http://blackstar.bitorbit.biz?t=" + new Date().getTime(), true);
		xhr.timeout = 15000;
		xhr.setRequestHeader("Content-type","application/x-www-form-urlencoded");
		xhr.onreadystatechange = function () {
			if (xhr.status === 200 && xhr.readyState === 4) {
				$("#loading").hide();
				var obj = JSON.parse(xhr.responseText);
				if (obj.length != 10) {
					$("#get_error").show();
				} else {
					localStorage.setItem("lastSubmitedHiscore", "" + Game.hiscoreInt);
					var lastSubmitedHiscore = localStorage.getItem("lastSubmitedHiscore");
					if (lastSubmitedHiscore != null) {
						var lastSubmitedHiscoreInt = parseInt(lastSubmitedHiscore);
					} else {
						var lastSubmitedHiscoreInt = 0;
					}
					if (Game.hiscoreInt > parseInt(obj[9][1]) && Game.hiscoreInt > lastSubmitedHiscoreInt) {
						$("#submit_highscore").show();
					}
					var top10html = "";
					for (var i = 0; i < 10; i++) {
						top10html += "<li>&nbsp;" + (i + 1) + "&nbsp;";
						if (i < 9) top10html += "&nbsp;";
						top10html += obj[i][0] + "&nbsp;&nbsp;";
						var name_len = obj[i][0].length;
						for(var k = 0; k < 4 - name_len; k++) {
							top10html += "&nbsp;";
						}
						top10html += obj[i][1];
						top10html += "</li>";
					}
					$("#top10").html(top10html);
					$("#top10").show();
				}
			}
		}
		xhr.onerror = function () {
			$("#loading").hide();
			$("#get_error").show();
		};
		xhr.ontimeout = function () {
			$("#loading").hide();
			$("#get_error").show();
		};
		xhr.send("name="+$("#username").val()+"&score="+Game.hiscoreInt);
	} else {
		window.navigator.vibrate(100);
	}
});

var canvas = document.getElementById("viewport");

var w = window.innerWidth;
var h = window.innerHeight;

/*if (h > w) {
	var tmp = h;
	h = w;
	w = tmp;
}*/

canvas.width = w;
canvas.height = h;

realH = w;
if (h < w) realH = w;

scale = realH / baseH;
if (scale > 1) scale = 1;

// BLACK STAR CANVAS

bs_canvas = document.createElement("canvas");
bs_canvas.width = 64;
bs_canvas.height = 64;
bs_context = bs_canvas.getContext("2d");

//bs_context.scale(scale, scale);

gr_bs=bs_context.createRadialGradient(32,32,20,32,32,32);
gr_bs.addColorStop(0,"rgba(0, 0, 0, 255)");
gr_bs.addColorStop(.2,"rgba(255, 255, 255, 255)");
gr_bs.addColorStop(1,"rgba(0, 0, 0, 0)");
bs_context.fillStyle = gr_bs;
bs_context.beginPath();
bs_context.arc(32,32,32,0,2*Math.PI);
bs_context.closePath();
bs_context.fill();

// BULLET CANVAS

bl_canvas = document.createElement("canvas");
bl_canvas.width = 20;
bl_canvas.height = 20;
bl_context = bl_canvas.getContext("2d");

bl_context.scale(scale, scale);

gr_bl=bl_context.createRadialGradient(10,10,0,10,10,10);
gr_bl.addColorStop(0,"rgba(255, 0, 0, 255)");
gr_bl.addColorStop(1,"rgba(255, 0, 0, 0)");
bl_context.fillStyle = gr_bl;
bl_context.beginPath();
bl_context.arc(10,10,10,0,2*Math.PI);
bl_context.closePath();
bl_context.fill();

// PARTICLE CANVAS

pa_canvas = document.createElement("canvas");
pa_canvas.width = 64;
pa_canvas.height = 64;
pa_context = pa_canvas.getContext("2d");

pa_context.scale(scale, scale);

pa_context.fillStyle = "#fff";
pa_context.beginPath();
pa_context.arc(32,32,32,0,2*Math.PI);
pa_context.closePath();
pa_context.fill();

function rocketMove(e) {
	if (mouseDown) {
		mouseX = e.pageX;
		mouseY = e.pageY;
	}
}

mouseDown = 0;
function mDown (e) { 
	mouseDown = 1;
	if (!game_over) {
		Game.addBullet();
	} else {
		$("#help").hide();
		$("#highscores").hide();

		var now = (new Date()).getTime();
		if (now - Game.game_over_dialog_time > 1000) {
			$("#game_over").hide();
		}
	}
}
function mUp(e) {
	mouseDown = 0;
}
function mOut(e) {
	mouseDown = 0;
}

//canvas.addEventListener("mousemove", rocketMove, false);
canvas.addEventListener("mousedown", mDown, false);
//canvas.addEventListener("mouseup", mUp, false);
//canvas.addEventListener("mouseout", mOut, false);

Game.startMenu();

Game.run = (function() {

var loops = 0, skipTicks = 1000 / Game.fps,
	maxFrameSkip = 10,
	nextGameTick = (new Date).getTime();

return function() {
  loops = 0;

  while ((new Date).getTime() > nextGameTick) {
	Game.update();
	nextGameTick += skipTicks;
	loops++;
  }

  if (loops) Game.draw();

};
})();

(function() {
var onEachFrame;
if (window.requestAnimationFrame) {
  onEachFrame = function(cb) {
	var _cb = function() { cb(); requestAnimationFrame(_cb); }
	_cb();
  };
} else if (window.webkitRequestAnimationFrame) {
  onEachFrame = function(cb) {
	var _cb = function() { cb(); webkitRequestAnimationFrame(_cb); }
	_cb();
  };
} else if (window.mozRequestAnimationFrame) {
	onEachFrame = function(cb) {
		var _cb = function() { cb(); mozRequestAnimationFrame(_cb); }
	_cb();
	};
} else {
  onEachFrame = function(cb) {
	//setInterval(cb, 1000 / 60);
  }
}

window.onEachFrame = onEachFrame;
})();

window.onEachFrame(Game.run);