function Particle(x, y, p_scale, scaleSpeed, vx, vy) {
	this.scale = p_scale;
	this.x = x;
	this.y = y;
	this.color = "#fff";
	this.velocityX = vx;
	this.velocityY = vy;
	this.scaleSpeed = scaleSpeed;

	this.draw = function(ctx) {
		if (this.scale > 0) {
			ctx.drawImage(pa_canvas, this.x - pa_canvas.width * .5 * scale * this.scale, this.y - pa_canvas.height * .5 * scale * this.scale, 
				pa_canvas.width * scale * this.scale, pa_canvas.height * scale * this.scale);
		}
	};

	this.update = function() {

		this.scale -= this.scaleSpeed;

		if (this.scale <= 0) {
			this.scale = 0;
		} else {
			this.x += this.velocityX;
			this.y += this.velocityY;
		}
	};

}