﻿$(function () {

    //init table

    var $overlay = $('.overlay');
    var $chips;
    //create cash

    var cash = 2000;
    var bet = 0;
    var $cash = $('.cash .sum');
    var $bet = $('.bet .betsum');
    $cash.text(cash.toString());
    $bet.text(bet.toString());

    $('#bjTable section').height((window.innerHeight - 50) / 2);

    //chips
    var chips = [];
    chips.push({ 'index': 1, 'color': 'red' });
    chips.push({ 'index': 10, 'color': 'orange' });
    chips.push({ 'index': 20, 'color': 'blue' });
    chips.push({ 'index': 100, 'color': 'green' });
    chips.push({ 'index': 500, 'color': 'black' });


    var cards = [];
    var symbols = ['clubs', 'hearts', 'spades', 'diamonds'];
    var cardHeight = $('#uTablePart').height() * 0.6;
    var playerStanded = false; var tooMuch = false;
    var aceInDaHouse = false;

    function Card(symbol, number) {
        this.symbol = symbol;
        this.number = number;
    }
    createCards();
    function createCards() {
        Card.prototype.add = function () {
            cards.push(card);
        }

        var i = 0;

        while (i < 4) {
            var j = 2;
            while (j < 14) {
                var card = new Card(symbols[i], j);
                card.add();
                j++;
            }
            i++;
        }

        shuffleCards();
        showBetOverlay();
    }


    //bet
    function showBetOverlay() {
        tooMuch = false;
        playerStanded = false;
        $overlay.append('<h1>place your bets!</h1><span class="temp_bet">0</span><span class="bet_button">bet</span><div class="chips"></div>');
        $chips = $('.chips');
        $.each(chips, function (i, item) {
            $chips.append('<div class="fish ' + item.color + '"><div>' + item.index + '</div></div>');
        });
        checkAvailableChips();
        showOverlay();
        var temp_bet;
        $chips.on('tap click', '.fish', function () {
            temp_bet = parseInt($('.temp_bet').text());
            if ($('.temp_bet').text() === '')
                temp_bet = 0;
            var that = $(this);
            that.addClass('active', 1000);
            setTimeout(function () {
                that.removeClass('active', 1000);
            }, 500);
            temp_bet += parseInt(that.text());
            $('.temp_bet').text(temp_bet);
            checkAvailableChips(temp_bet);
        });

        $('.bet_button').on('click', function () {
            if (typeof temp_bet !== 'undefined') {
                setStandings(temp_bet);
                $('.buttons span').removeClass('hidden');
                $('.hit').removeClass('disabled');
                clearTable();
                hideOverlay();
                baseDeal();
            }
        });
    }


    function checkAvailableChips(a) {
        $chips.children().each(function (i, item) {
            var that = $(this);
            if (parseInt(that.children('div').text()) > cash || (cash - a) < parseInt(that.children('div').text())) {
                that.addClass('disabled');
            }
        });
    }

    function setStandings(b) {
        cash = cash - b;
        $cash.text(cash);
        $bet.text(b);
    }

    //create cards



    //shuffle cards
    function shuffleCards() {
        var tmp, current, top = cards.length;

        if (top) while (--top) {
            current = Math.floor(Math.random() * (top + 1));
            tmp = cards[current];
            cards[current] = cards[top];
            cards[top] = tmp;
        }
    }


    //deal cards
    var bankcards, playercards;
    function baseDeal() {
        bankcards = [];
        playercards = [];
        //card to the bank
        cardToTheBank(0, 0);
        //card to the player
        cardToThePlayer(0, 1);
        cardToTheBank(1, 2);
        cardToThePlayer(1, 3);
    }
    //ask for card

    //add card to user

    function cardToThePlayer(n, i) {
        playercards.push(cards[i]);
        var left = (n * 20) + 10;
        var top = (n * 10) + 10;
        if (cards[i].number === 11) {
            $('#uTablePart .u-cards').append('<div style="left: ' + left + 'px;top: ' + top + 'px" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><span>J</span><div class="' + cards[i].symbol + '"></div><span>J</span></div>');
        }
        else if (cards[i].number === 12) {
            $('#uTablePart .u-cards').append('<div style="left: ' + left + 'px;top: ' + top + 'px" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><span>Q</span><div class="' + cards[i].symbol + '"></div><span>Q</span></div>');
        }
        else if (cards[i].number === 13) {
            $('#uTablePart .u-cards').append('<div style="left: ' + left + 'px;top: ' + top + 'px" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><span>K</span><div class="' + cards[i].symbol + '"></div><span>K</span></div>');
        }
        else if (cards[i].number === 14) {
            aceInDaHouse = true;
            $('#uTablePart .u-cards').append('<div style="left: ' + left + 'px;top: ' + top + 'px" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + 11 + '"><span>A</span><div class="' + cards[i].symbol + '"></div><span>A</span></div>');
        }
        else {
            $('#uTablePart .u-cards').append('<div style="left: ' + left + 'px;top: ' + top + 'px" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + cards[i].number + '"><span>' + cards[i].number + '</span><div class="' + cards[i].symbol + '"></div><span>' + cards[i].number + '</span></div>');
        }
        $('.card').css({ 'height': cardHeight, 'width': cardHeight / 1.4 });
        sumCards('p');
    }

    //add card to computer

    function cardToTheBank(n, i) {
        bankcards.push(cards[i]);
        var left = (n * 20) + 10;
        var top = (n * 10) + 10;
        if (cards[i].number === 11) {
            if (n == 1) {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px" class="card  card-back card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><div class="inner"><div class="front"></div><div class="back"><span>J</span><div class="' + cards[i].symbol + '"></div><span>J</span></div></div></div>');
            }
            else {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px;z-index:' + n * 3 + '" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><span>J</span><div class="' + cards[i].symbol + '"></div><span>J</span></div>');
            }
        }
        else if (cards[i].number === 12) {
            if (n == 1) {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px" class="card card-back card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><div class="inner"><div class="front"></div><div class="back"><span>Q</span><div class="' + cards[i].symbol + '"></div><span>Q</span></div></div></div>');
            }
            else {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px;z-index:' + n * 3 + '" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><span>Q</span><div class="' + cards[i].symbol + '"></div><span>Q</span></div>');
            }
        }
        else if (cards[i].number === 13) {
            if (n == 1) {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px" class="card card-back card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><div class="inner"><div class="front"></div><div class="back"><span>K</span><div class="' + cards[i].symbol + '"></div><span>K</span></div></div></div>');
            }
            else {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px;z-index:' + n * 3 + '" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + 10 + '"><span>K</span><div class="' + cards[i].symbol + '"></div><span>K</span></div>');
            }
        }
        else if (cards[i].number === 14) {
            if (n == 1) {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px" class="card card-back card-' + n + ' ' + cards[i].symbol + '" data-value="' + 11 + '"><div class="inner"><div class="front"></div><div class="back"><span>A</span><div class="' + cards[i].symbol + '"></div><span>A</span></div></div></div>');
            }
            else {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px;z-index:' + n * 3 + '" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + 11 + '"><span>A</span><div class="' + cards[i].symbol + '"></div><span>A</span></div>');
            }
        }
        else {
            if (n == 1) {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px" class="card card-back card-' + n + ' ' + cards[i].symbol + '" data-value="' + cards[i].number + '"><div class="inner"><div class="front"></div><div class="back"><span>' + cards[i].number + '</span><div class="' + cards[i].symbol + '"></div><span>' + cards[i].number + '</span></div></div></div>');
            }
            else {
                $('#cTablePart .c-cards').append('<div style="right: ' + left + 'px;top: ' + top + 'px;z-index:' + n * 3 + '" class="card card-' + n + ' ' + cards[i].symbol + '" data-value="' + cards[i].number + '"><span>' + cards[i].number + '</span><div class="' + cards[i].symbol + '"></div><span>' + cards[i].number + '</span></div>');
            }
        }
        $('.card').css({ 'height': cardHeight, 'width': cardHeight / 1.4 });
        if (n > 1)
            sumCards('b');
    }

    //hit

    $('span.hit').on('click', function () {
        if (!$(this).hasClass('disabled')) {
            var cardNum = $('.u-cards .card').length;
            var allNum = $('#bjTable .card').length;
            cardToThePlayer(cardNum, allNum);
        }
    });

    //stand

    $('span.stand').on('click', function () {
        if (!$(this).hasClass('disabled')) {
            playerStanded = true;
            $('.stand, .hit').addClass('disabled');
            endGame();
        }
    });

    function endGame() {
        flipCard();
        setTimeout(function () { 
            sumCards('b');
        },500);
    }

    function flipCard() {
        $('.c-cards div .inner').addClass('flipped');
    }

    //match two players cards
    //sum cards

    var pSum, bSum;
    function sumCards(p) {
        if (p === 'p') {
            pSum = 0;
            $.each(playercards, function (i, item) {
                if (item.number > 10 && item.number < 14)
                    pSum += 10;
                else if (item.number === 14)
                    pSum += 11;
                else
                    pSum += item.number;
            });
            $('.p-sum').text(pSum);
            if (pSum > 21) {
                if (!aceInDaHouse)
                    ptooMuch();
                else
                    rearrangeBecauseAce();

            }
            else if ($('.u-cards .card').length === 2 && pSum === 21) {
                blackJack();
            }
            else if ($('.u-cards .card').length !== 2 && pSum === 21) {
                endGame();
            }
            else if (pSum > 14)
                $('.stand').removeClass('disabled');
            else if (pSum < 14)
                $('.stand').addClass('disabled');
        }
        else {
            bSum = 0;
            $.each(bankcards, function (i, item) {
                if (item.number > 10 && item.number < 14)
                    bSum += 10;
                else if (item.number === 14)
                    bSum += 11;
                else
                    bSum += item.number;
            });
            $('.b-sum').text(bSum);
            if (playerStanded && bSum > 14 && bSum > pSum && bSum < 22) {
                playerLoose();
            }
            else if (playerStanded && bSum > 21 || pSum === 21 && bSum > 21) {
                playerWon();
            }
            else if (playerStanded && pSum === bSum) {
                draw();
            }
            else if (tooMuch && bSum > 14) {
                playerLoose();
            }
            else {
                var cardNum = $('.c-cards .card').length;
                var allNum = $('#bjTable .card').length;
                cardToTheBank(cardNum, allNum);
            }
        }
    }

    function rearrangeBecauseAce() {
        $.each(playercards, function (i, item) {
            if (item.number === 11) {
                item.number = 1;
            }
        });
        $('.u-cards .card').each(function () {
            if ($(this).attr('data-value') === '11') {
                $(this).attr('data-value', '1');
            }
        });
        sumCards('p');
    }

    //too much

    function ptooMuch() {
        playerStanded = true; tooMuch = true;
        $('.stand, .hit').addClass('disabled');
        endGame();
    }

    //too little
    //win

    function playerWon() {
        cash += (parseInt($('.betsum').text()) * 2);
        bet = 0;
        $cash.text(cash);
        $bet.text(bet);
        $overlay.append('<h1>you won!</h1>');
        shuffleCards();
        showBetOverlay();
    }

    //black jack

    function blackJack() {
        $.each(bankcards, function (i, item) {
            if (item.number > 10 && item.number < 14)
                bSum += 10;
            else if (item.number === 14)
                bSum += 11;
            else
                bSum += item.number;
        });
        if ($('.c-cards .card').length === 2 && bsum === 21) {
            draw();
        }
        else {
            cash += (parseInt($('.betsum').text()) * 3);
            bet = 0;
            $cash.text(cash);
            $bet.text(bet);
            $overlay.append('<h1>black jack!</h1>');
            shuffleCards();
            showBetOverlay();
        }
    }

    //loose

    function playerLoose() {
        bet = 0;
        $bet.text(bet);
        if (tooMuch)
            $overlay.append('<h1>bust!</h1>');
        else
            $overlay.append('<h1>you loose!</h1>');
        shuffleCards();
        if (cash > 0)
            showBetOverlay();
        else
            $overlay.append("<p>you're out of cash</p><br /><p>get more from the menu!</p>");
            showOverlay();
    }

    //draw

    function draw() {
        cash += parseInt($('.betsum').text());
        bet = 0;
        $bet.text(bet);
        $cash.text(cash);
        $overlay.append('<h1>draw!</h1>');
        shuffleCards();
        showBetOverlay();
    }

    //menu

    $('.menu').on('tap click', function () {
        if (!$(this).hasClass('active')) {
            $("nav").show();
            $("nav").height($(document).height() - 35);
            $("nav").animate({
                right: "0"
            }, 1000);
            $(this).addClass('active');
        }
        else {
            menuClose();
            $(this).removeClass('active');
        }
    });

    function menuClose() {
        $("nav").animate({
            right: "-150"
        }, 1000);
        $('.menu').removeClass('active');
    }


    //about

    $('.about').on('tap click', function () {
        menuClose();
        $overlay.html('<div><h2>About Black Jack</h2><p>Version 1.0</p>Made by Aniko Litvanyi<p>Firefox OS Course, Óbuda University</p><div class="start-button" id="closeButton"></div></div>');
        showOverlay();
        $('#closeButton').on('tap click', function () {
            $overlay.html('');
            showBetOverlay();
        });
    });

    //help

    $('.help').on('tap click', function () {
        menuClose();
        $overlay.html('<div class="help-overlay">Blackjack, also known as twenty-one, is the most widely played casino banking game in the world. Blackjack is a comparing card game between a player and dealer, meaning that players compete against the dealer but not against any other players. It is played with one or more decks of 52 cards. <br />The object of the game is to "beat the dealer", which can be done in a number of ways:<ul><li>Get 21 points on your first two cards (called a blackjack), without a dealer blackjack</li><li>Reach a final score higher than the dealer without exceeding 21</li><li>Let the dealer draw additional cards until his hand exceeds 21.</li></ul><div class="start-button" id="closeButton"></div></div>');
        $overlay.css('top',0);
        showOverlay();
        $('#closeButton').on('tap click', function () {
            $overlay.html('');
            $overlay.css('top', '30%');
            showBetOverlay();
        });
    });

    //more cash

    $('.more-cash').on('tap click', function () {
        menuClose();
        clearTable();
        cash = 2000;
        $cash.text(cash);
        $overlay.html('');
        showBetOverlay();
    });

    function clearTable() {
        $('.u-cards, .c-cards, .b-sum, .p-sum').html('');
    }

    function showOverlay() {
        $overlay.hide();
        $overlay.fadeIn();
    }

    function hideOverlay() {
        $overlay.fadeOut("slow", function () {
            $overlay.html('');
        });
    }

    //window resize

    function onResized(e) {
        $('#bjTable section').height((window.innerHeight - 50) / 2);
        cardHeight = $('#uTablePart').height() * 0.6;
        $('.card').css({ 'height': cardHeight, 'width': cardHeight / 1.4 });
    }
    $(window).on("resize", onResized);
    $(window).on("orientationchange", onResized);

});