//-------------------------------------------------------------------------
// game variables (initialized during reset)
//-------------------------------------------------------------------------

var dx, dy, // pixel size of a single tetris block
blocks, // 2 dimensional array (nx*ny) representing tetris court - either empty block or occupied by a 'piece'
current, // the current piece
next;// the next piece

var invalid = {};

function invalidate(){
	invalid.court = true;
}// fim função invalidate

function invalidateNext(){
	invalid.next = true;
}// fim função invalidateNext

function invalidateScore(){
	invalid.score = true;
}// fim função invalidateScore

function invalidateLevel(){
	invalid.level= true;
}// fim função invalidateLevel

function invalidateRows(){
	invalid.rows = true;
}// fim função invalidateRows

function getBlock(x, y){
	return (blocks&&blocks[x]?blocks[x][y]:null);
}// fim função getBlock

function setBlock(x, y, type){
	blocks[x] = blocks[x] || [];
	blocks[x][y] = type;
	invalidate();
}// fim função setBlock

function clearBlocks(){
	blocks = [];
	invalidate();
}// fim função clearBlocks

//------------------------------------------------
// do the bit manipulation and iterate through each
// occupied block (x,y) for a given piece
//------------------------------------------------
function eachblock(type, x, y, dir, funcao){
	var bit, result, row = 0, col = 0, blocks = type.blocks[dir];
	for(bit = 0x8000; bit > 0; bit = bit>>1){
		if(blocks & bit){
			funcao(x + col, y + row);
		}// fim if (blocks)
		if(++col === 4){
			col = 0; ++row;
		}// fim if (col)
	}// fim for(bit)
}// fim função eachblock

function setCurrentPiece(piece){
	current = piece||randomPiece();
	invalidate();
}// fim função

function setNextPiece(piece){
	next = piece||randomPiece();
	invalidateNext();
}// fim função

function move(dir){
	var x = current.x, y = current.y;
	switch(dir){
		case DIR.RIGHT:
			x = x + 1;
			break;
		case DIR.LEFT:
			x = x - 1;
			break;
		case DIR.DOWN:
			y = y + 1;
			break;
	}// fim switch
	// se a posição estiver vazia move a peca
	if(unoccupied(current.type, x, y, current.dir)){
		current.x = x;
		current.y = y;
		invalidate();
		return true;
	} else{
		return false;
	}// fim if else
}// fim função

function rotate(){
	var newdir = (current.dir == DIR.MAX ? DIR.MIN : current.dir + 1);
	if(unoccupied(current.type, current.x, current.y, newdir)){
		current.dir = newdir;
		invalidate();
	}// im if
}// fim função

function drop(){
	if(!move(DIR.DOWN)){
		addScore(10);
		dropPiece();
		removeLines();
		setCurrentPiece(next);
		setNextPiece(randomPiece());
		clearActions();
		if(occupied(current.type, current.x, current.y, current.dir)){
			lose();
		}// fim if
	}// fim if
}// fim função

function dropPiece(){
	eachblock(current.type, current.x, current.y, current.dir, function(x, y){
		setBlock(x, y, current.type);
	});
}// fim função

function removeLines(){
	var x, y, complete, n = 0;
	for(y = ny; y > 0; --y){
		complete = true;
		for(x = 0; x < nx; ++x){
			if (!getBlock(x, y)){
				complete = false;
			}// fim if
		}// fim for(x)
		if(complete){
			removeLine(y);
			y = y + 1;
			// recheck same line
			n++;
		}// fim if
	}// fim for(y)
	if(n > 0){
		addRows(n);
		addScore(100 * Math.pow(2, n - 1));
		// 1: 100, 2: 200, 3: 400, 4: 800
	}// fim if
}// fim função

function removeLine(n){
	var x, y;
	for(y = n; y >= 0; --y){
		for(x = 0; x < nx; ++x){
			setBlock(x, y, (y == 0)?null:getBlock(x, y - 1));
		}// fim for(y)
	}// fim for(x)
}// fim função


