
function drawPiece(ctx, type, x, y, dir){
	eachblock(type, x, y, dir, function(x, y){
		drawBlock(ctx, x, y, /*type.color, */type.pos.x, type.pos.y);
	});// fim eachblock
}// fim função drawPiece

function drawBlock(ctx, x, y, /*color,*/ posX, posY){
	//ctx.fillStyle = color;
	//ctx.fillRect(x*dx, y*dy, dx, dy);
	//ctx.strokeRect(x*dx, y*dy, dx, dy);
	ctx.drawImage(ASSETS[8]/*nome_da_imagem*/, 
					posX, posY, /*posição que vai pegar dentro da imagem*/
					32, 32, /*tamanho original da imagem*/
					x*dx, y*dy, /*posição (x, y) a começar a desenhar*/
					dx, dy/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
}// fim função drawBlock

function drawCourt(ctx){
	if(invalid.court){
		ctx.clearRect(0, 0, canvas.width-120, canvas.height-50);
		ctx.drawImage(ASSETS[3]/*nome_da_imagem*/, 
					0, 	0, /*posição que vai pegar dentro da imagem*/
					626, 800, /*tamanho original da imagem*/
					0, 	0, /*posição (x, y) a começar a desenhar*/
					200, 430/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
		if(playing){
			drawPiece(ctx, current.type, current.x, current.y, current.dir);
		}// fim if
		var x, y, block;
		for(y = 0; y < ny; y++){
			for(x = 0; x < nx; x++) {
				if( block = getBlock(x, y)){
					drawBlock(ctx, x, y, /*block.color*/block.pos.x, block.pos.y);
				}// fim if
			}// fim for(x)
		}// fim for(y)
		ctx.strokeRect(0, 0, nx * dx - 1, ny * dy - 1);
		// court boundary
		invalid.court = true;
	}// fim if invalid.court
}// fim draw court

function drawScore(ctx,/* html ,*/ score){
	if(invalid.score){
		//html('score', ("00000" + Math.floor(vscore)).slice(-5));
		invalid.score = false;
	}// fim if
	ctx.clearRect(205, 10, 110, 50);/*limpa o canvas*/
	ctx.save();
	ctx.fillStyle = 'rgba(40, 40, 40, 0.6)';
	ctx.fillRect(205, 10, 110, 50);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 12px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "PONTOS", 260, 20 );
	ctx.fillStyle = '#c11c1c';
	ctx.font = "bolder 17px Helvetica";
	ctx.fillText((("00000000000"+Math.floor(vscore)).slice(-11)), 260, 36 );
	ctx.restore();
}// fim função drawScore

function drawLevel(ctx){
	if(invalid.level){
		invalid.score = false;
	}// fim if
	ctx.clearRect(205, 94, 110, 30);/*limpa o canvas*/
	ctx.save();
	ctx.fillStyle = 'rgba(40, 40, 40, 0.6)';
	ctx.fillRect(205, 94, 110, 30);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 12px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText("LEVEL: "+vLEVEL, 260, 104);
	ctx.restore();
}// fim função drawLevel

function drawRows(ctx){
	if(invalid.rows){
		//html('rows', rows);
		invalid.rows = false;
	}// fim if
	ctx.clearRect(205, 62, 110, 30);/*limpa o canvas*/
	ctx.save();
	ctx.fillStyle = 'rgba(40, 40, 40, 0.6)';
	ctx.fillRect(205, 62, 110, 30);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 12px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText("Linhas: "+rows, 260, 72);
	ctx.restore();
}// fim função drawRows

function drawNext(ctx){
	//if(invalid.next){
		var paddingX = (26 - next.type.size)/2;
		var paddingY = (17.2 - next.type.size)/2;
		//half-arsed attempt at centering next piece display
		ctx.clearRect(215, 140, 90, 90);
		ctx.save();
		ctx.translate(0.5, 0.5);
		ctx.fillStyle = "rgba(0, 0, 0, 0.5)";
		ctx.fillRect(215, 140, 90, 90);
		//drawPiece(ctx, next.type, paddingX, paddingY, next.dir);
		drawPiece(ctx, next.type, paddingX, paddingY, next.dir);
		ctx.lineWidth = 2;
		ctx.strokeStyle = 'black';
		ctx.strokeRect(215, 140, 90, 90);
		ctx.restore();
		invalid.next = false;
	//}// fim if
}// fim função drawNext

function drawRightButtom(ctx){
	ctx.clearRect(120, 435, 110, 40),
	ctx.save();
	ctx.fillStyle = 'red';
	ctx.fillRect(120, 435, 110, 40);
	ctx.lineWidth = 2;
	ctx.strokeStyle = "black";
	ctx.strokeRect(120, 435, 110, 40);
	ctx.drawImage(ASSETS[6]/*nome_da_imagem*/, 
					0, 	0, /*posição que vai pegar dentro da imagem*/
					512, 192, /*tamanho original da imagem*/
					120, 435, /*posição (x, y) a começar a desenhar*/
					110, 40/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 18px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "DIR.", 176, 446 );
	ctx.restore();
}// fim função drawRightButtom

function drawLeftButtom(ctx){
	ctx.clearRect(5, 435, 110, 40),
	ctx.save();
	ctx.fillStyle = 'red';
	ctx.fillRect(5, 435, 110, 40);
	ctx.lineWidth = 2;
	ctx.strokeStyle = "black";
	ctx.strokeRect(5, 435, 110, 40);
	ctx.drawImage(ASSETS[7]/*nome_da_imagem*/, 
					0, 	0, /*posição que vai pegar dentro da imagem*/
					512, 192, /*tamanho original da imagem*/
					5, 435, /*posição (x, y) a começar a desenhar*/
					110, 40/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 16px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "ESQ.", 60, 448 );
	ctx.restore();
}// fim função drawLeftButtom

function drawDownButtom(ctx){
	ctx.clearRect(240, 405, 65, 65),
	ctx.save();
	ctx.fillStyle = '#388057';
	ctx.fillRect(240, 405, 65, 65);
	ctx.lineWidth = 2;
	ctx.strokeStyle = "black";
	ctx.strokeRect(240, 405, 65, 65);
	ctx.drawImage(ASSETS[5]/*nome_da_imagem*/, 
					0, 	0, /*posição que vai pegar dentro da imagem*/
					512, 512, /*tamanho original da imagem*/
					240, 405, /*posição (x, y) a começar a desenhar*/
					65, 65/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 20px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "BAIXO", 272, 428 );
	ctx.restore();
}// fim função drawDownButtom

function drawRotateButtom(ctx){
	ctx.clearRect(218, 315, 80, 80);
	ctx.save();
	ctx.fillStyle = '#1d549f';
	ctx.fillRect(218, 315, 80, 80);
	ctx.lineWidth = 2;
	ctx.strokeStyle = "black";
	ctx.strokeRect(218, 315, 80, 80);
	ctx.drawImage(ASSETS[4]/*nome_da_imagem*/, 
					0, 	0, /*posição que vai pegar dentro da imagem*/
					512, 512, /*tamanho original da imagem*/
					218, 315, /*posição (x, y) a começar a desenhar*/
					80, 80/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 20px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "GIRAR", 256, 346 );
	ctx.restore();
}// fim função drawRotateButtom

function splashScreen(ctx){
	ctx.clearRect(0, 0, 320, 480);/*limpa o canvas*/
	ctx.save();
	ctx.drawImage(ASSETS[1]/*nome_da_imagem*/, 
					0, 	0, /*posição que vai pegar dentro da imagem*/
					287, 468, /*tamanho original da imagem*/
					0, 	0, /*posição (x, y) a começar a desenhar*/
					320, 480/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
	ctx.fillStyle = 'rgba(0, 0, 0, 0.6)';
	ctx.fillRect(0, 0, 320, 480);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 50px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "BLOCOS", 160, 140 );
	ctx.fillStyle = 'rgba(40, 250, 40, 0.8)';
	ctx.fillRect(100, 225, 120, 40);
	ctx.fillStyle = 'rgba(250, 40, 40, 0.8)';
	ctx.fillRect(100, 285, 120, 40);
	ctx.lineWidth = 2;
	ctx.strokeStyle = "white";
	ctx.strokeRect(100, 225, 120, 40);
	ctx.strokeRect(100, 285, 120, 40);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 22px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "Novo Jogo", 160, 236 );
	ctx.fillText( "Créditos", 160, 296 );
	ctx.restore();
}// fim função splashScreen

function gameOverScreen(ctx){
	ctx.clearRect(0, 0, 320, 480);/*limpa o canvas*/
	ctx.save();
	ctx.drawImage(ASSETS[2]/*nome_da_imagem*/, 
					0, 	0, /*posição que vai pegar dentro da imagem*/
					287, 468, /*tamanho original da imagem*/
					0, 	0, /*posição (x, y) a começar a desenhar*/
					320, 480/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
	ctx.fillStyle = 'rgba(20, 20, 20, 0.8)';
	ctx.fillRect(0, 0, 320, 480);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 38px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "GAME OVER", 160, 120 );
	ctx.lineWidth = 2;
	ctx.strokeStyle = "rgb(210, 47, 57)";
	ctx.strokeRect(20, 180, 280, 70);
	ctx.fillStyle = 'rgba(250, 250, 250, 0.2)';
	ctx.fillRect(20, 180, 280, 70);
	ctx.fillStyle = "rgb(210, 47, 57)";
	ctx.font = "600 16px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "Pontuação Final:", 160, 196 );
	ctx.fillStyle = "rgb(212, 194, 93)";
	ctx.font = "bold 20px Helvetica";
	ctx.fillText( vscore, 160, 220 );
	ctx.fillStyle = 'rgba(92, 105, 203, 0.6)';
	ctx.fillRect(100, 265, 120, 40);
	ctx.fillStyle = 'rgba(40, 250, 40, 0.6)';
	ctx.fillRect(100, 325, 120, 40);
	ctx.lineWidth = 2;
	ctx.strokeStyle = "white";
	ctx.strokeRect(100, 265, 120, 40);
	ctx.strokeRect(100, 325, 120, 40);
	ctx.strokeStyle = "rgba(250, 250, 250, 0.5)";
	ctx.strokeRect(2, 2, 316, 476);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 22px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText( "Inicio", 160, 276 );
	ctx.fillText( "Novo Jogo", 160, 336 );
	ctx.restore();
}// fim função gameOverScreen

function creditsScreen(ctx){
	ctx.clearRect(0, 0, 320, 480);/*limpa o canvas*/
	ctx.save();
	ctx.fillStyle = 'rgba(10, 10, 10, 0.8)';
	ctx.fillRect(0, 0, 320, 480);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 36px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText("Créditos", 160, 80);
	ctx.font = "bold 16px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "left";
	ctx.fillText("Desenvolvimento:", 30, 135);
	ctx.fillText("Cod. Fonte:", 30, 235);
	ctx.fillText("Design Peças:", 30, 295);
	ctx.font = "600 21px Helvetica";
	ctx.fillText("Ricardo C. Touma", 46, 160);
	ctx.font = "400 20px Helvetica";
	ctx.textAlign = "center";
	ctx.fillText("toumarc.8246@gmail.com", 160, 185);
	ctx.fillText("Site - Code inComplete", 160, 255);
	ctx.fillText("Site - OpenGameArt", 160, 315);
	ctx.fillStyle = 'rgba(20, 100, 20, 1)';
	ctx.fillRect(190, 350, 100, 40);
	ctx.lineWidth = 2;
	ctx.strokeStyle = "white";
	ctx.strokeRect(190, 350, 100, 40);
	ctx.fillStyle = "rgb(250, 250, 250)";
	ctx.font = "bold 24px Helvetica";
	ctx.textBaseline = "top";
	ctx.textAlign = "center";
	ctx.fillText("Voltar", 240, 360);
	//ctx.font = "normal 12px Helvetica";
	//ctx.textBaseline = "top";
	//ctx.textAlign = "center";
	//ctx.fillText("codeincomplete.com/posts/2010/javascript_tetris/", 160, 235);
	ctx.restore();
}// fim função drawGameover
