window.onload = function(){

	if(!window.requestAnimationFrame){// http://paulirish.com/2011/requestanimationframe-for-smart-animating/
		window.requestAnimationFrame = window.webkitRequestAnimationFrame || 
		window.mozRequestAnimationFrame || window.oRequestAnimationFrame || 
		window.msRequestAnimationFrame ||
		function(callback, element){
			window.setTimeout(callback, 1000 / 60);
		};// fim function
	}// fim if
	
	//-------------------------------------------------------------------------
	// Canvas
	//-------------------------------------------------------------------------
	/* var canvas = get('canvas'), 
	ctx = canvas.getContext('2d'), 
	ucanvas = get('upcoming'), 
	uctx = ucanvas.getContext('2d'); */
	//var divTetris = get('tetris');
	//var upcoming = get('canvasUp');
	var w = window;
	var canvas = document.createElement("canvas");
	canvas.setAttribute("id", "canvas");
	canvas.width = 320;
	canvas.height = 480;
	var ctx = canvas.getContext("2d");
	document.body.appendChild(canvas);
	var proporcao = parseInt(canvas.style.width)/320;
	/* var ucanvas = document.createElement("canvas");
	ucanvas.setAttribute("id", "upcoming");
	ucanvas.setAttribute("width", 80);
	ucanvas.setAttribute("height", 80);
	var uctx = ucanvas.getContext("2d");
	document.body.appendChild(ucanvas); */
	loadImages(["black_texture.jpg", "background_pieces.jpg", 
	"gameover_bkg.jpg", "texture.jpg", "arrow2.png", "down.png", 
	"right.png", "left.png", "blocks.png"], run);// fim loadImages

	//-------------------------------------------------------------------------
	// GAME LOOP
	//-------------------------------------------------------------------------
	function run(){
		//showStats();
		// initialize FPS counter
		addEvents();// attach keydown and resize events
		var last = now = timestamp();
		function frame(){
			now = timestamp();
			update(Math.min(1, (now - last)/1000.0));
			// using requestAnimationFrame have to be able to handle large delta's caused when it 'hibernates' in a background or non-visible tab
			draw();
			//stats.update();
			last = now;
			requestAnimationFrame(frame, canvas);
		}// fim função frame
		redimensionarTela(canvas, w);
		//resize();// setup all our sizing information
		reset();// reset the per-game variables
		frame();// start the first frame
	}// fim função run

	//function showStats() {
	//	stats.domElement.id = 'stats';
	//	get('menu').appendChild(stats.domElement);
	//}
	
	function addEvents(){
		//evita seleção
		document.onselectstar = function(){return false;};
		// evita click botão direito do mouse
		document.oncontextmenu = function(){return false;};
		
		document.addEventListener("keydown", keydown, false);
		//window.addEventListener("touchstart", function(e){touch(e, STATE);}, false);
		window.addEventListener("click", checkTouch, false);
		window.addEventListener("touchstart", checkTouch, false);
		//window.addEventListener("touchcancel", function(e){e.preventDefault();}, false);
		//window.addEventListener("touchmove", function(e){e.preventDefault();}, false);
		//window.addEventListener("touchend", function(e){
			//Evita comportamento padrão
			//e.preventDefault();
			//toqueNaTela.x = 0;
			//toqueNaTela.y = 0;
		//}, false ); // FIM addEventListener
		//window.addEventListener('resize', resize, false);
		window.addEventListener("resize", function(){redimensionarTela(canvas, w);}, false);
	}// fim função addEvents

	function draw(){
		ctx.clearRect(0, 0, 320, 480);
		switch(STATE){
			case "splash":
				splashScreen(ctx);
				break;
			case "main":
				ctx.save();
				ctx.lineWidth = 1;
				//ctx.translate(0.5, 0.5);
				ctx.drawImage(ASSETS[0]/*nome_da_imagem*/, 
					0, 	0, /*posição que vai pegar dentro da imagem*/
					626, 626, /*tamanho original da imagem*/
					0, 	0, /*posição (x, y) a começar a desenhar*/
					320, 480/*posição final(x, y) para terminar de desenhar*/
				);// fim drawImage
				// for crisp 1px black lines
				drawCourt(ctx);
				drawNext(ctx);
				drawScore(ctx, /*html, */vscore);
				drawRows(ctx);
				drawLevel(ctx);
				drawRotateButtom(ctx);
				drawRightButtom(ctx);
				drawLeftButtom(ctx);
				drawDownButtom(ctx);
				ctx.restore();
				break;
			case "creditos":
				creditsScreen(ctx);
				break;
			case "gameover":
				gameOverScreen(ctx);
				break;
		}// fim switch
		
	}// fim funçao draw
	
	/* == Executando o Jogo == */
	run();
	/* ====================== */
	
};// fim window.onload