var DIR = {
	UP : 0,
	RIGHT : 1,
	DOWN : 2,
	LEFT : 3,
	MIN : 0,
	MAX : 3
}, nx = 10, // width of tetris court (in blocks)
ny = 20, // height of tetris court (in blocks)
nu = 5;// width/height of upcoming preview (in blocks)

function handle(action){
	switch(action){
	case DIR.LEFT:
		move(DIR.LEFT);
		break;
	case DIR.RIGHT:
		move(DIR.RIGHT);
		break;
	case DIR.UP:
		rotate();
		break;
	case DIR.DOWN:
		drop();
		break;
	}// fim switch
}// fim função handle

function random(min, max){
	return (min + (Math.random() * (max - min)));
}// fim função random

function randomChoice(choices) {
	return choices[Math.round(random(0, choices.length - 1))];
}// fim função nrandomChoice

//-------------------------------------------------------------------------
// tetris pieces
//
// blocks: each element represents a rotation of the piece (0, 90, 180, 270)
//         each element is a 16 bit integer where the 16 bits represent
//         a 4x4 set of blocks, e.g. j.blocks[0] = 0x44C0
//
//             0100 = 0x4 << 3 = 0x4000
//             0100 = 0x4 << 2 = 0x0400
//             1100 = 0xC << 1 = 0x00C0
//             0000 = 0x0 << 0 = 0x0000
//                               ------
//                               0x44C0
//
//-------------------------------------------------------------------------

var i = {
	size : 4,
	blocks : [0x0F00, 0x2222, 0x00F0, 0x4444],
	color : 'cyan',
	pos :{x: 0, y: 0}
};// fim peca i
var j = {
	size : 3,
	blocks : [0x44C0, 0x8E00, 0x6440, 0x0E20],
	color : 'blue',
	pos :{x: 32, y: 0}
};// fim peca j
var l = {
	size : 3,
	blocks : [0x4460, 0x0E80, 0xC440, 0x2E00],
	color : 'orange',
	pos :{x: 64, y: 0}
};// fim peca l
var o = {
	size : 2,
	blocks : [0xCC00, 0xCC00, 0xCC00, 0xCC00],
	color : 'yellow',
	pos :{x: 96, y: 0}
};// fim peca o
var s = {
	size : 3,
	blocks : [0x06C0, 0x8C40, 0x6C00, 0x4620],
	color : 'green',
	pos :{x: 128, y: 0}
};// fim peca s
var t = {
	size : 3,
	blocks : [0x0E40, 0x4C40, 0x4E00, 0x4640],
	color : 'purple',
	pos :{x: 160, y: 0}
};// fim peca t
var z = {
	size : 3,
	blocks : [0x0C60, 0x4C80, 0xC600, 0x2640],
	color : 'red',
	pos :{x: 192, y: 0}
};// fim peca z

//-----------------------------------------------------
// check if a piece can fit into a position in the grid
//-----------------------------------------------------
function occupied(type, x, y, dir){
	var result = false;
	eachblock(type, x, y, dir, function(x, y){
		if ((x < 0) || (x >= nx) || (y < 0) || (y >= ny) || getBlock(x, y))
			result = true;
	});// fim eachblock
	return result;
}// fim função occupied

function unoccupied(type, x, y, dir){
	return !occupied(type, x, y, dir);
}//fim função unoccupied

//-----------------------------------------
// start with 4 instances of each piece and
// pick randomly until the 'bag is empty'
//-----------------------------------------
var pieces = [];
function randomPiece(){
	if(pieces.length == 0){
		pieces = [i, i, i, i, j, j, j, j, l, l, l, l, o, o, o, o, s, s, s, s, t, t, t, t, z, z, z, z];
	}// fim if
	var type = pieces.splice(random(0, pieces.length-1), 1)[0];
	return{
		type : type,
		dir : DIR.UP,
		x : Math.round(random(0, nx - type.size)),
		y : 0
	};//fim obj
}// fim função randomPiece

