var KEY = {
		ESC : 27,
		SPACE : 32,
		LEFT : 37,
		UP : 38,
		RIGHT : 39,
		DOWN : 40
	},
	STATE = "splash",
	LEVEL, // nível atual
	vLEVEL, // nível mostrado atualmente
	playing, // true|false - game is in progress
	actions, // queue of user actions (inputs)
	dt, // time since starting this game
	rows, // number of completed rows in the current game
	score, // the current score
	vscore, // the currently displayed score (it catches up to score in small chunks - like a spinning slot machine)
	step, // how long before current piece drops by 1 row
	speed = {
		/* start : 0.6,
		decrement : 0.005,
		min : 0.1 */
		start : 5.0, 
		decrement : 0.050,
		min : 2.5
	};// how long before piece drops by 1 row (seconds)
var ASSETS = new Array();// array de imagens

function get(id){
	return document.getElementById(id);
}// fim função get

//function hide(id){
//	get(id).style.visibility = 'hidden';
//}// fim função hide

//function show(id){
//	get(id).style.visibility = null;
//}// fim função show

//function html(id, html) {
	//get(id).innerHTML = html;
//}// fim função html

function timestamp(){
	return new Date().getTime();
}// fim função timestamp

function setVisualScore(n){
	vscore = n || score;
	invalidateScore();
}// fim função setVisualScore

function setScore(n){
	score = n;
	setVisualScore(n);
}// fim função setScore

function addScore(n){
	score = score + n;
}// fim função addScore

function clearScore(){
	setScore(0);
}// fim função clearScore

function setVisualLevel(n){
	vLEVEL = n || level;
	invalidateLevel();
}// fim função setVisualLevel

function setLevel(n){
	LEVEL = n;
	setVisualLevel(n);
}// fim função setLevel

function addLevel(n){
	LEVEL = LEVEL + n;
}// fim função addLevel

function clearLevel(){
	setLevel(0);
}// fim função clearLevel

function clearRows(){
	setRows(0);
}// fim função clearRows

function setRows(n){
	rows = n;
	step = Math.max(speed.min, speed.start - (speed.decrement*rows));
	invalidateRows();
}// fi  função setRows

function addRows(n){
	setRows(rows + n);
}// fim função addRows

function clearActions(){
	actions = [];
}// fim função clearActions

function reset(){
	dt = 0;
	clearActions();
	clearBlocks();
	clearRows();
	clearScore();
	setCurrentPiece(next);
	setNextPiece();
}// fim função reset

function play(){
	//hide('start');
	STATE = "main";
	reset();
	playing = true;
}// fim função play

function lose(){
	STATE = "gameover";
	//show('start');
	setVisualScore();
	playing = false;
}// fim função lose

function update(idt){
	if(playing){
		if(vscore < score){
			setVisualScore(vscore + 1);
		}// fim if(vscore)
		handle(actions.shift());
		dt = dt + idt;
		if(dt > step){
			dt = dt - step;
			drop();
		}// fim if(dt)
	}// fim if (playing)
}// fim função update

function redimensionarTela(canvas, w){
	var larguraParaAltura = 320 / 480;// dividir do tamanho maior pelo menor
	var novaLargura = window.innerWidth;// área interna da janela
	var novaAltura = window.innerHeight;// área interna da janela
	var novaLarguraParaAltura = novaLargura / novaAltura;
	// Se a tela for maior que 480 x 320
	if (novaLarguraParaAltura > larguraParaAltura) {
		// Ajusta a partir da largura da tela
		novaLargura = novaAltura * larguraParaAltura;
		canvas.style.width = novaLargura+'px';
		canvas.style.height = novaAltura+'px';
		// Se a tela for menor que 480 x 320
	} else{
		// Ajusta a partir da altura da tela
		novaAltura = novaLargura / larguraParaAltura;
		canvas.style.width = novaLargura+'px';
		canvas.style.height = novaAltura+'px';
	}// fim if else
	canvas.style.width = novaLargura + "px";
	// canvas.style.height = novaAltura + "px";
	dx = (canvas.width-120)/nx;
	// pixel size of a single tetris block
	dy = (canvas.height-50)/ny;
	// (ditto)
	invalidate();
	invalidateNext();
}// FIM redimensionarTela

/* function resize(event){
	canvas.width = canvas.clientWidth;
	// set canvas logical size equal to its physical size
	canvas.height = canvas.clientHeight;
	// (ditto)
	//ucanvas.width = ucanvas.clientWidth;
	//ucanvas.height = ucanvas.clientHeight;
	dx = (canvas.width-120) / nx;
	// pixel size of a single tetris block
	dy = (canvas.height-50) / ny;
	// (ditto)
	invalidate();
	invalidateNext();
}// fim função resize */

function loadImages(images, onComplete/*imagens, callback a ser chamado qd tuda tiver pronto*/){
	var loaded = 0;
	function onLoad() {
		loaded++;
		if (loaded == images.length) {
			onComplete();
		}// fim if
	}// fim função
	for (var i = 0; i < images.length; i++) {
		var img = new Image();
		img.addEventListener("load", onLoad);
		img.src = "src/img/" + images[i];
		ASSETS.push(img);
	}// fim for
}// fim função loadImages



