function reset() {
	$('#weight_input').val("");
	$('#num_drinks').val("");
	$('#drinking_period').val("");
	$('#result_panel').html("Result");
}

function calculateBac() {
	var weight = $('#weight_input').val();
	var weightUnit = $('#weight_unit').val();
	var numDrinks = $('#num_drinks').val();
	var drinkingPeriod = $('#drinking_period').val();
	var gender = $('#gender_select').val();

	var hasWeight = (weight != null && weight != "") ? true : false;
	var hasNumDrinks = (numDrinks != null && numDrinks != "") ? true : false;
	var hasDrinkingPeriod = (drinkingPeriod != null && drinkingPeriod != "") ? true : false;

	weight = parseFloat(weight);
	numDrinks = parseFloat(numDrinks);
	drinkingPeriod = parseFloat(drinkingPeriod);

	if(hasNumDrinks && hasWeight && hasDrinkingPeriod) {
		var ebac = "";
		var BW = 0.58;
		var MR = 0.015;

		if(gender == 1) {
			BW = 0.49;
			MR = 0.017;	
		}

		if(weightUnit == 1) {
			weight = weight * 0.453592;
		}

		ebac = (0.806 * numDrinks * 1.2) / (BW * weight) - (MR * drinkingPeriod);
		
		
		$('#result_panel').html((Math.max(0, ebac)).toFixed(4) + "%");
	}
}

$(function() {

	$('#weight_input').keyup(function() {
		calculateBac();
	});

	$('#num_drinks').keyup(function() {
		calculateBac();
	});

	$('#drinking_period').keyup(function() {
		calculateBac();
	});

	$('#gender_select').change(function() {
		calculateBac();
	});

	$('#action_clear').click(function() {
		reset();
	});
});