function stars(a,b)
{
	var c,twoPI,i;
	w=a.getAttribute('width');
	h=a.getAttribute('height');
	c=a.getContext('2d');
	twoPI=Math.PI*2;
	c.fillStyle="hsla(0,100%,100%,1)";
	i=0;
	while (i<b)
	{
		c.beginPath();
		c.arc(Math.random()*w,Math.random()*h,Math.random()*0.75,0,twoPI,true);
		c.closePath();
		c.fill();
		i+=1;
	}
}

function clouds(a,x,y,r,c)
{
	var b,d,e;
	b=[-1,1];
	d=0;
	e=r;
	while (d<e)
	{
		//sub cloud coords
		var x1,y1,ylim; 
		x1=((Math.random()*2*r-r));
		ylim=Math.sqrt(r*r-x1*x1);
		y1=(Math.random()*2*ylim-ylim);
		x1=x1*b[~~(Math.random()*2)]+x;
		y1=y1*b[~~(Math.random()*2)]+y;
		//draw
		subClouds(a,x1,y1,~~(r/3),c);
		d+=1;
	}
}

function subClouds(a,x,y,r,c)
{
	var a=a.getContext('2d');
	var twoPI=2*Math.PI;
	var grad=a.createRadialGradient(x,y,1,x,y,r);
	grad.addColorStop(0,"hsla("+c+",100%,50%,0.5)");
	grad.addColorStop(1,"hsla("+c+",100%,50%,0)");
	a.fillStyle=grad;
	a.beginPath();
	a.arc(x,y,(r*2),0,twoPI,true);
	a.closePath();
	a.fill();
}

function circles(x,y,r,c)
{
	var a,b,d,e;
	a=q('canvas')[0].getContext('2d');
	b=[-1,1];
	d=0;
	e=~~((r*r)/2);
	while (d<e)
	{
		//particle coords
		var x1,y1,ylim; 
		x1=((Math.random()*2*r-r));
		ylim=Math.sqrt(r*r-x1*x1);
		y1=(Math.random()*2*ylim-ylim);
		x1=x1*b[~~(Math.random()*2)]+x;
		y1=y1*b[~~(Math.random()*2)]+y;
		//draw
		a.fillStyle='hsla('+c+',100%,50%,'+(1-(length([[x,y],[x1,y1]])/r))+')';
		a.fillRect(x1,y1,1,1);
		d+=1;
	}
}