
function slider(a)
{
	//speed level
	a.setAttribute('data-v',a.value);
}

function toggle(a)
{
	//toggle on & off
	var b=[1,0];
	a.setAttribute('data-v',b[a.getAttribute('data-v')]);
}
function memory()
{
	//check if storage version is current, if not update to correct format
	mymemory=new String(localStorage.version);
	if (mymemory.indexOf('.')==-1)
	{
		c=0;
		d=90;
		saveData=[];
		while(c<d)
		{
			saveData.push([0,0]);
			c++;
		}
		localStorage.version='1.20';
		localStorage.bloqueItData=JSON.stringify(saveData);
	}
	else if ((mymemory=='1.00'))
	{
		c=0;
		t1=localStorage.stars.split(',');
		t2=localStorage.scores.split(',');
		d=t1.length;
		saveData=[];
		f=0;
		g=0;
		while (c<d)
		{
			f=new Number(t1[c]);
			g=new Number(t2[c]);
			saveData.push([f,g]);
			c++;	
		}
		c=0;
		while(c<9)
		{
			saveData.push([0,0]);
			c++;
		}
		localStorage.version='1.20';
		localStorage.bloqueItData=JSON.stringify(saveData);

	}
	
	else if (mymemory=='1.10')
	{
		c=0;
		t1=localStorage.stars.split(',');
		t2=localStorage.scores.split(',');
		d=t1.length;
		saveData=[];
		f=0;
		g=0;
		while (c<d)
		{
			f=new Number(t1[c]);
			g=new Number(t2[c]);
			saveData.push([f,g]);
			c++;	
		}
		localStorage.version='1.20';
		localStorage.bloqueItData=JSON.stringify(saveData);
	}	
	//read save data
	saveData=JSON.parse(localStorage.bloqueItData);
	c=0;
	d=saveData.length;
	e=q('ul li');
	f=0;
	g=0;
	while (c<d)
	{
		e[c].setAttribute('data-s',saveData[c][0]);
		f=new Number(saveData[c][1]);
		g+=f;
		c++;
	}
	q('footer')[0].innerHTML=g;
}
//name from shapewriter's atomic keyboard, keyboard controls
function atomic(e){var keynum=e.which;if (keynum==37){move(-22);}else if (keynum==39){move(22);}}
//keyboard stop
function release(){move(0);}

//adjusting canvases
function adjCanvases()
{
	var w,h,u;
	w=window.innerWidth;
	h=window.innerHeight;
	if ((w/h)<1.5)
	{
		//tall
		u=(~~(w/30));
		w=(u*30);
		h=(u*20);
	}
	
	else if ((w/h)>1.5)
	{
		//wide
		u=(~~(h/20));
		w=(u*30);
		h=(u*20);
	}
	
	else
	{
		u=(~~(h/20));
	}
	unit=u;
	uW=w;
	uH=h;
	a=q('canvas');
	b=0;
	while(b<3)
	{
		a[b].setAttribute('width',w);
		a[b].setAttribute('height',h);
		b++;	
	}
}

//startup function
window.onload=go();
function go()
{
	//globals
	graph=[];
	dif=3;
	fps=null;
	life=1;
	cb=q('#cb')[0].getContext('2d');
	cl=q('#cl')[0].getContext('2d');
	cp=q('#cp')[0].getContext('2d');
	px=new Number();
	cw=new Number();
	speed=new Number();
	mode=0;
	hPI=new Number(Math.PI/2);
	memory();
	adjCanvases();
}

//player constructor
function Player(x,y,size,h,v,state)
{
	this.x=x;
	this.y=y;
	this.size=size;
	this.h=h;
	this.v=v;
	this.state;
	//random direction on start
	this.rand=rand;
	function rand()
	{
		var rand=new Number(Math.floor(Math.random()*385)+288);
		tempNum=new Number(((rand-(px+Math.floor(cw/2)))/cw)*hPI);
		this.h=Math.round(speed*(Math.sin(rand)));
		this.v=Math.round(Math.abs(speed*Math.cos(rand))*-1);

		if (this.h<2)
		{
			if (this.h<0){this.h=-Math.floor(speed/6);}
			else{this.h=Math.floor(speed/6);}
			this.v=-speed;
		}

		else if (this.v>=(-(speed*0.15)))
		{
			this.v=-(speed*0.2);
			if (this.h<0){this.h=-(speed*0.8);}
			else{this.h=(speed*0.8);}
		}
	}
	//bounce off of ufo
	this.bounce=bounce;
	function bounce()
	{
		tempNum=new Number(((p1.x-(px+Math.floor(cw/2)))/cw)*hPI);
		this.h=Math.round(speed*(Math.sin(tempNum)));
		this.v=Math.round(Math.abs(speed*Math.cos(tempNum))*-1);

		if (this.h==0)
		{
			this.h=speed*0.1;
			if (Math.round(Math.random())==0){this.h*=-1;}
		}

		else if (this.v>=(-(speed*0.15)))
		{
			this.v=-(speed*0.2);
		}
	}
	//meteor mode
	this.norm=norm;
	function norm(){this.color='#ffffff';this.state='NORM';}
	//coment mode
	this.burn=burn;
	function burn(){this.color='#ff9900';this.state='BURN';}
	//horizontal bounce
	this.bounceH=bounceH;
	function bounceH(){this.h=(this.h*-1);}
	//vertical bounce
	this.bounceV=bounceV;
	function bounceV(){this.v=(this.v*-1);}
}
//menu controls
function menu(a,b)
{
	var c,d,e,f,g;
	c=b.getAttribute('class');	
	d=q('section:not([hidden]');
	e=d.length;
	f=0;
	while (f<e)
	{
		hide(d[f]);
		f++;	
	}
	g=q('.back')[0];
	if (g!=null)
	{
		g.removeAttribute('class');	
	}
	if (c==null)
	{
		//sub menu
		b.setAttribute('class','back');
		show(q('section.'+a)[0]);
	}
	else
	{
		//main menu
		show(q('section.main')[0]);
	}
}
//generate background
function generate(a)
{	
	var a,b,c,w,h;
	w=a.getAttribute('width');
	h=a.getAttribute('height');
	b=250;
	c=0;
	e=a.getContext('2d');
	e.fillRect(0,0,w,h);
	stars(a,w);
	while (c<b)
	{
		clouds(a,(~~(Math.random()*w)+1),(~~(Math.random()*h)+1),unit,(~~(Math.random()*361)));
		c+=1;
	}
}

//select level
function level(a)
{
	var a,b,c,d,e,f,g,h,i,j,k,l,aw,ah;
	//check if player has unlocked the level
	if ((a.getAttribute('data-s')>0)||(a.previousSibling==null)||(a.previousSibling.getAttribute('data-s')>0))
	{
		//retrieve level data from image
		b=a.getAttribute('style').replace('background-image:url(','').replace(');','');
		c=0;d=a.parentElement.childNodes;e=d.length;
		//determine level index
		while (c<e)
		{
			if (a==d[c])
			{
				break;
			}
			else
			{
				c++;
			}
		}
		lvl=c+1;
		//show game menu
		hide(q('article.menu')[0]);
		show(q('article.game')[0]);
		//calculate ball speed
		dif=new Number(q('input[type="range"]')[0].value);
		sc=0;speed=(dif*~~(unit/5));
		//reset life
		if (life==-1){life=0;}
		//reset score
		q('article i')[0].innerHTML=0;
		//reset canvases
		aw=q('canvas')[0].getAttribute('width');
		ah=q('canvas')[0].getAttribute('height');
		u=(aw/30);
		cb.clearRect(0,0,aw,ah);cl.clearRect(0,0,aw,ah);cp.clearRect(0,0,aw,ah);
		//setup player
		p1=new Player(~~(aw/2),~~(ah*0.85),~~(ah*0.0125),0,0,'NORM');p1.rand();p1.norm();
		px=~~(ah/2);m=0;bxl=0;bxr=aw;byu=0;cw=new Number(~~(ah/2));
		//powerup, block, & boundry variables
		ux=[];uy=[];ua=[];bx=[];by=[];ppx=[p1.x,p1.x,p1.x];ppy=[p1.y,p1.y,p1.y];BLX=[];
		//image resources
		paddle=document.createElement('img');paddle.src='images/game/ship.svg';
		bgl=[[~~(Math.random()*(uW/2)),~~(Math.random()*(uH/2)),1],[~~(Math.random()*(uW/2)),~~(Math.random()*(uH/2)),0.75],[~~(Math.random()*(uW/2)),~~(Math.random()*(uH/2)),0.5],[~~(Math.random()*(uW/2)),~~(Math.random()*(uH/2)),0.25]];
		extra=document.createElement('img');extra.src='data:image/png;base64,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';
		//extract block data from level image
		cr=document.createElement('canvas');cr.width='30';cr.height='16';
		g=document.createElement('img');g.width=30;g.height=16;g.src=b;
		crc=cr.getContext('2d');crc.drawImage(g,0,0);
		h=crc.getImageData(0,0,30,16);
		i=0;
		ts='';
		//get block coords, draw & style block
		lb=~~(u/5);
		lb2=lb*2;
		bb=u-lb;
		bb2=u-lb2;
		while (i<1920)
		{   
		    if (h.data[i+3]!=0)
			{
				var x,y;x=u*~~((i/4)-(30*~~(i/120)));y=u*~~(i/120);bx.push(x);by.push(y);BLX.push(x+','+y);
	    		cl.globalAlpha=1;cl.fillStyle='rgb('+h.data[i]+','+h.data[i+1]+','+h.data[i+2]+')';cl.fillRect(x,y,u,u);
		    	cl.beginPath();cl.moveTo(u+x,y);cl.lineTo(x,y);cl.lineTo(x,u+y);cl.lineTo(lb+x,bb+y);cl.lineTo(lb+x,lb+y);cl.lineTo(bb+x,lb+y);cl.lineTo(u+x,y);cl.globalAlpha=0.3;cl.fillStyle='#ffffff';cl.fill();
				cl.beginPath();cl.moveTo(x,u+y);cl.lineTo(u+x,u+y);cl.lineTo(u+x,y);cl.lineTo(bb+x,lb+y);cl.lineTo(bb+x,bb+y);cl.lineTo(lb+x,bb+y);cl.lineTo(x,u+y);cl.globalAlpha=0.2;cl.fillStyle='#000000';cl.fill();
			}
			i+=4;
		}
		//determine max score
		maxSc=new Number(bx.length*dif);pow=~~(Math.random()*bx.length);
		cl.beginPath();cl.moveTo(lb+bx[pow],bb+by[pow]);cl.lineTo(lb+bx[pow],bb2+by[pow]);cl.lineTo(bb2+bx[pow],lb+by[pow]);cl.lineTo(bb+bx[pow],lb+by[pow]);cl.globalAlpha=0.3;cl.fillStyle='#ffffff';cl.fill();
		cl.globalAlpha=0.2;cl.beginPath();cl.moveTo(lb+bx[pow],bb+by[pow]);cl.lineTo(lb2+bx[pow],bb+by[pow]);cl.lineTo(bb+bx[pow],lb2+by[pow]);cl.lineTo(bb+bx[pow],lb+by[pow]);cl.fillStyle='#000000';cl.fill();cl.globalAlpha=1;
		//determine if classic mode is on
		l=q('[value="Classic"]')[0].getAttribute('data-v');
		if (l==1){life=0; }
		else{life=1; }
		//if yes add power ups
		if (life==0)
		{
			ua=[];j=[];
			k=0;l=bx.length;i=0;
			while (i<l)
			{
				j[i]=i;
				i++;
			}
			i=0;
			while (i<dif)
			{
				k=~~(Math.random()*j.length);
				ua.push(k);
				j.splice(k,1);
				i++;
			}
		}
		//start game
		animate();
	}
	
	else if (a.previousSibling.getAttribute('data-s')==0)
	{
		alert('You must complete the level before this one to play it.');
	}
}
//move ufo
function move(a){m=a; }

//snaps ball to coordinate plane, checks 1-4 possible squares the ball can be, compares to a tile's top left corner coords
//more efficent than looping through all of the tile coordinates & checking their boundries
function tileBounce()
{
	var Lb,Rb,Gr,tl,bl,br,tr,sum,c;
	//ball bounce
	//snap to grid
	
	Xb=p1.x+p1.h;
	Yb=p1.y+p1.v;
	Lb=[((Xb-p1.size)-((Xb-p1.size)%unit)),((Yb-p1.size)-((Yb-p1.size)%unit))];//directional bounds
	Rb=[((Xb+p1.size)+(unit-((Xb+p1.size)%unit))),((Yb+p1.size)+(unit-((Yb+p1.size)%unit)))];
	
	Gr=[1,1];//grid range
	if (Lb[0]!=(Rb[0]-unit)){Gr[0]=0; }//2 Horizontal
	if (Lb[1]!=(Rb[1]-unit)){Gr[1]=0; }//2 Vertical
	cp.strokeStyle='#ffcc00';
	cp.lineWidth=10;
	cp.beginPath(Lb[0],Lb[1]);
	cp.moveTo(Rb[0],Rb[1]);
	cp.stroke();
	tl=react(Lb);bl=0;br=0;tr=0;//interpret results
	//four tiles
	if (Gr[0]==Gr[1])
	{
		if (Gr[0]==0)
		{
			tr=react([Lb[0]+unit,Lb[1]]);
			bl=react([Lb[0],Lb[1]+unit]);
			br=react([Lb[0]+unit,Lb[1]+unit]);
		}
	}
	else
	{
		if (Gr[0]==0)
		{
			//2 horizontal
			tr=react([Lb[0]+unit,Lb[1]]);
		}
		else
		{
			//2 vertical
			bl==react([Lb[0],Lb[1]+unit]);
		}
	}
	sum=tl+tr+br+bl;
	//determines how ball should bounce
	if ((sum>0)&&(p1.state=='NORM'))
	{
		if (sum==3){p1.bounceH();p1.bounceV();}//diagonal
		else if (sum==2)
		{
			if (((tl==1)&&(tr==1))||((bl==1)&&(br==1)))
			{
				p1.bounceV();
			}
			
			else if (((tl==1)&&(bl==1))||((tr==1)&&(br==1)))
			{
				p1.bounceH();
			}
			else
			{
				p1.bounceH();
				p1.bounceV();
			}
		}
		else if (sum==1)
		{
			if (tl==1){c=Lb;}
			else if (tr==1){c=[Lb[0]+unit,Lb[1]];}
			else if (br==1){c=[Lb[0]+unit,Lb[1]+unit];}
			else{c=[Lb[0],Lb[1]+unit];}
			
			if ((p1.y>c[1])&&(p1.y<(c[1]+unit)))
			{
				p1.bounceH();
			}
			
			else
			{
				p1.bounceV();	
			}
		}
	}
}
//checks if a tile exists where the ball is
function react(a)
{	
	var b,c,d,e,f;
	//search blocks for a match
	b=BLX.indexOf(a.toString());
	if (b>-1)
	{
		//clear block & bounce
		c=BLX[b].split(',');
		c[0]=parseInt(c[0],10);
		c[1]=parseInt(c[1],10);
		cl.clearRect((c[0]+1),(c[1]+1),unit-2,unit-2);
		//comet
		if (pow==b)
		{
			p1.state='BURN';
			pow=-1;
		}
		
		else if (pow>b)
		{
			pow-=1;
		}
		//boosts
		d=ua.indexOf(b);
		if (d!=-1)
		{
			ux.push(c[0]);
			uy.push(c[1]);
			ua.splice(d,1);
		}
		else
		{
			e=0;
			f=ua.length;
			while(e<f)
			{
				if (ua[e]>b)
				{
					ua[e]-=1;	
				}
				e++;	
			}
		}
		BLX.splice(b,1);
		bx.splice(b,1);
		by.splice(b,1);
		sc+=dif;
		return 1;
	}
	
	else
	{
		return 0;
	}
}
//checks if ball should bounce off of walls	
function wallBounce()
{
	pHp=new Number((p1.x+p1.size)+p1.h);
	pVp=new Number((p1.y+p1.size)+p1.v);
	if (((p1.y-p1.size)+p1.v)<=byu){p1.bounceV();}
	else if (pVp>=uH)
	{
		if (life==0){life=new Number(-1);death();}
		else
		{
			p1.bounceV();p1.norm();sc=Math.floor(sc/2);
		}
	}
	else if ((pVp>=(~~(uH*.9)))&&(pVp<=(~~(uH*.95)))&&(p1.x>=(px))&&((p1.x<=(px+(cw+(unit*2)))))){if (p1.v>0){p1.bounce();} }
	if (((p1.x-p1.size+p1.h)<bxl)||((p1.x+p1.size+p1.h)>bxr))
	{
		p1.bounceH();
	}
}
//animation function
function animate()
{
	//clear canvases
	cp.clearRect(0,0,uW,uH);cb.clearRect(0,0,uW,uH);
	//bounce ball
	tileBounce();
	wallBounce();
	//move
	//walls
	if ((bx.indexOf(bxl)==-1)&&(ux.indexOf(bxl)==-1)&&((p1.x>(bxl+p1.size+unit)))){bxl+=1; }
	if ((bx.indexOf((bxr-unit))==-1)&&(ux.indexOf(bxr-unit)==-1)&&((p1.x<(bxr-p1.size-unit)))){bxr-=1; }
	if ((by.indexOf(byu)==-1)&&((p1.y>(byu+p1.size+unit)))){byu+=1; }
	//paddle
	if (cw>=96)
	{
		tn=new Number(Math.floor((bxr-bxl)*0.3));
		px+=((cw-tn)/2);
		cw=new Number(tn);
	}
	if ((px+m>=0)&&(((px+cw)+m)<=uW)){px+=m;}
	else if ((m<1)&&((px)>0)){px-=(px);}
	else if ((m>1)&&((uW-(px+cw))>0)){px+=(uW-(px+cw));}
	//ball
	p1.x+=p1.h;p1.y+=p1.v;
	//draw
	//background
	cb.globalAlpha=1;
	cb.fillRect(0,0,uW,uH);
	bgl[0][2]-=0.01;
	bgl[1][2]-=0.01;
	bgl[2][2]-=0.01;
	bgl[3][2]-=0.01;
	if (bgl[3][2]<=0)
	{
		bgl.pop();
		bgl.unshift([~~(Math.random()*(uW/2)),~~(Math.random()*(uH/2)),1]);
	}
	i=0;
	for (i=0;i<4;i++)
	{
		var h=bgl[i];
		bsc=2-h[2];
		cb.globalAlpha=h[2];
		cb.drawImage(background,h[0],h[1],~~(uH/2),~~(uH/4),0-(((uW*bsc)-uW)/2),0-(((uH*bsc)-uH)/2),uW*bsc,uH*bsc);
	}
	//paddle
	cp.drawImage(paddle,px,~~(uH*.9),cw,~~(unit/2));
	//ball
	ppx.unshift(p1.x);ppx.pop();
	ppy.unshift(p1.y);ppy.pop();
	if (p1.state!='NORM')
	{
		cp.strokeStyle='rgba(0,255,255,0.5)';
		cp.lineCap='round';
		u2=~~(unit/2);
		cp.lineWidth=u2;
		cp.beginPath();
		cp.moveTo(p1.x,p1.y);
		cp.lineTo(ppx[0],ppy[0]);
		cp.lineTo(ppx[1],ppy[1]);
		cp.lineTo(ppx[2],ppy[2]);
		cp.stroke();
	}
	cp.fillStyle='#ffffff';
	cp.strokeStyle='#000000';
	cp.lineWidth=1;
	cp.beginPath();
	cp.arc(p1.x,p1.y,p1.size,0,Math.PI*2,true);
	cp.closePath();
	cp.fill();
	cp.stroke();
	//walls
	cp.strokeStyle='rgba(0,255,255,0.6)';
	cp.lineCap='round';
	cp.lineWidth=~~(unit/2);
	u4=~~(unit/4);
	cp.beginPath();
	cp.moveTo(bxl-u4,uH);
	cp.lineTo(bxl-u4,byu-u4);
	cp.lineTo(bxr+u4,byu-u4);
	cp.lineTo(bxr+u4,uH);
	cp.stroke();
	cp.strokeStyle='#ffcc00';
	cp.lineWidth=~~(unit*0.1875);
	cp.beginPath();
	cp.arc(bxl-u4,byu-u4,u4,0,Math.PI*2,true);
	cp.closePath();
	cp.stroke();
	cp.beginPath();
	cp.arc(bxr+u4,byu-u4,u4,0,Math.PI*2,true);
	cp.closePath();
	cp.stroke();
	//boosts
	var i=0;for (i=0;i<=(ux.length-1);i++)
	{
		uy[i]=(uy[i]+2);
		if(uy>=uH){ux.splice(i,1);uy.splice(i,1);}
		else if(((ux[i]>=px)&&(ux[i]<=(px+cw))||((ux[i]+unit)>=px)&&(ux[i]+unit<=(px+cw)))&&((uy[i]+unit)>=~~(uH*.9)))
		{
			sc+=dif*5;ux.splice(i,1);uy.splice(i,1);
			if (i==ux.length)
			{
				if(uy>=uH){ux.splice(i,1);uy.splice(i,1);}
				else if(((ux[i]>=px)&&(ux[i]<=(px+cw))||((ux[i]+unit)>=px)&&(ux[i]+unit<=(px+cw)))&&((uy[i]+unit)>=~~(uH*.9))){sc+=dif*5;ux.splice(i,1);uy.splice(i,1);}
				else
				{
					cp.drawImage(extra,ux[i],uy[i]);
				}
			}
		}
		else
		{
			cp.drawImage(extra,ux[i],uy[i]);
		}
	}
	//end
	q('article i')[0].innerHTML=sc;
	if ((BLX.length==0)&&(ux.length==0)){victory();}
	else if (life==-1){death();}
	else{fps=setTimeout('animate()',1000/30);}
}
function pause()
{
	clearTimeout(fps);
	show(q('.pause')[0]);
}

function resume()
{
	hide(q('.pause')[0]);
	animate();
}

function restart()
{
	hide(q('.pause')[0]);
	hide(q('.death')[0]);
	level(q('section li:nth-of-type('+lvl+')')[0]);
}

function quit()
{
	hide(q('.game')[0]);
	hide(q('.pause')[0]);
	hide(q('.death')[0]);
	hide(q('.victory')[0]);
	show(q('.menu')[0]);
}

function death()
{
	clearTimeout(fps);
	show(q('.death')[0]);
}

function next()
{
	if (lvl<90)
	{
		level(q('section li:nth-of-type('+(lvl+1)+')')[0]);	
	}
	
	else
	{
		quit();
		menu('info');
	}
	hide(q('.victory')[0]);
}
function victory()
{
	var a,b,c,d;
	a=(~~((sc/maxSc)*2)+1)+(3*(dif-1));
	b=saveData[lvl-1];
	c='';
	q('#stars')[0].setAttribute('data-s',a);

	if (sc>b[1])
	{
		c+='High Score! ';
		b[0]=a;
		d=new Number(q('footer')[0].innerHTML);
		d-=b[1];
		b[1]=sc;
		d+=b[1];
		q('footer')[0].innerHTML=d;
		q('section li:nth-of-type('+lvl+')')[0].setAttribute('data-s',b[0]);
		save();
	}
	c+=sc;
	q('#myscore')[0].innerHTML=c;
	q('.victory')[0].removeAttribute('hidden');
}
	
function save()
{
	localStorage.bloqueItData=JSON.stringify(saveData);
}

function reset()
{
	var a=confirm("Are you sure you want to reset this Game? If you reset your game your progress will NOT be able to be recovered.");
	if (a==true)
	{
		localStorage.clear();
		memory();
	}
}

function rateMe()
{
    var nav,url;
	nav=new String(navigator.userAgent);
	
    if (nav.search(/Android/i)!=-1)
    {
		url='http://play.google.com/store/apps/details?id=com.sharkshore.bloqueit';
    }
    else if (nav.search(/Mac|iPhone|iPod|iPad/i)!=-1)
    {
		url='https://itunes.apple.com/us/app/bloque-it/id561326697?ls=1&mt=8&at=10l9IT&ct=rateMe';
    }
	else if (nav.search(/Firefox/i)!=-1)
	{
		url='https://marketplace.firefox.com/app/bloque-it';	
	}
    else
    {
    	url='http://sharkshore.com?app=BloqueIt';
    }

	window.open(url,'_blank');
}