//var  gLoop;

function Tetris(id) {
    var self = this;
    
    self.area = null; //new Area(self, id, 12, 20);
    self.puzzle = null;//new Puzzle(self, self.area);
    
    self.start = function() {
        document.onkeydown = function (e){
            if(!e) e = window.event;
            
            if(e.keyCode == 37){// stinga
                self.left();
            }
            if(e.keyCode == 38){ // sus
                self.up();
            }
            if(e.keyCode == 39){ // dreapta
                self.right();
            }
            if(e.keyCode == 40){ // jos
                self.down();
            }
        }
        
        self.reset();
        self.area = new Area(self, id, 12, 15);
        self.puzzle = new Puzzle(self, self.area);
        if (self.puzzle.mayPlace()) {
            
//            alert("Plasez o figura.");
            
            self.puzzle.place();
        } else {
            self.gameOver();
        }
    }
    
    self.reset = function() {
        if (self.puzzle) {
            self.puzzle.destroy();
            self.puzzle = null;
        }
        if (self.area) {
            self.area.destroy();
            self.area = null;
        }
    }
    
    self.gameOver = function() {
        self.puzzle.stop();
    }
    
    self.up = function() {
        if (self.puzzle && self.puzzle.isRunning() && !self.puzzle.isStopped()) {
            if (self.puzzle.mayRotate()) {
//                alert("up")
                self.puzzle.rotate();
            }
        }
    }
    self.down = function() {
//        alert(self.puzzle.isRunning())
        if (self.puzzle && self.puzzle.isRunning() && !self.puzzle.isStopped()) {
//            alert("down---")
            if (self.puzzle.mayMoveDown()) {
//                alert("down")
                self.puzzle.moveDown();
            }
        }
    }
    self.left = function() {
        if (self.puzzle && self.puzzle.isRunning() && !self.puzzle.isStopped()) {
            if (self.puzzle.mayMoveLeft()) {
                self.puzzle.moveLeft();
            }
        }
    }
    self.right = function() {
        if (self.puzzle && self.puzzle.isRunning() && !self.puzzle.isStopped()) {
            if (self.puzzle.mayMoveRight()) {
                self.puzzle.moveRight();
            }
        }
    }
    
    
    self.setScore = function(i) {
        self.score = i;
        var scoreLabel = document.getElementById("tetrisScoreLabel");
        var newScore = document.createTextNode("Score: " +i);
        scoreLabel.appendChild(newScore);
    };
}

function Area(tetris, id, x, y) {
    var self = this;
    
    self.tetris = tetris;
    self.el = document.getElementById(id);
    
    self.board = [];
    self.x = x;
    self.y = y;
    
    self.unit = 25;

    // creaza tabela
    for (var i = 0; i < self.y; i++) {
        self.board.push([]);
        for (var j = 0; j < self.x; j++) {
            self.board[i].push(0);
        }
    }
    
    self.destroy = function() {
        for (var y = 0; y < self.board.length; y++) {
            for (var x = 0; x < self.board[y].length; x++) {
                if (self.board[y][x]) {
                    self.el.removeChild(self.board[y][x]);
                    self.board[y][x] = 0;
                }
            }
        }
    }
    self.removeFullLines = function() {
        var lines = 0;
        for (var y = self.y - 1; y > 0; y--) {
            if (self.isLineFull(y)) {
                self.removeLine(y);
                lines++;
                y++;
            }
        }
        return lines;
    }
    self.isLineFull = function(y) {
        for (var x = 0; x < self.x; x++) {
            if (!self.board[y][x]) { return false; }
        }
        return true;
    }
    self.removeLine = function(y) {
        for (var x = 0; x < self.x; x++) {
            self.el.removeChild(self.board[y][x]);
            self.board[y][x] = 0;
        }
        y--;
        for (; y > 0; y--) {
            for (var x = 0; x < self.x; x++) {
                if (self.board[y][x]) {
                    var el = self.board[y][x];
                    el.style.top = el.offsetTop + self.unit + "px";
                    self.board[y+1][x] = el;
                    self.board[y][x] = 0;
                }
            }
        }
    }
    self.getBlock = function(y, x) {
        if (y < 0) { return 0; }
        if (y < self.y && x < self.x) {
            return self.board[y][x];
        } else {
            throw "Area.getBlock("+y+", "+x+") failed";
        }
    }
    self.addElement = function(el) {
//        alert(el)
        var x = parseInt(el.offsetLeft / self.unit);
        var y = parseInt(el.offsetTop / self.unit);
        if (y >= 0 && y < self.y && x >= 0 && x < self.x) {
            self.board[y][x] = el;
        } else {
            // not always an error ..
        }
    }
}

function Puzzle(tetris, area) {
    var self = this;
    
    self.tetris = tetris;
    self.area = area;
    
    self.x = 0;
    self.y = 0;
    
    self.type = 0; //0..6
    self.nextType = Math.floor(Math.random() * 6);
    self.speed = 100;
    self.position = 0;
    
    self.running = null;
    self.stopped = null;
    
    self.board = [];
    self.elements = [];
    self.nextElements = [];
    
    self.fallDownID = null;
    self.forceMoveDownID = null;
    
    
    self.puzzles = [
        [
            [0,0,1],
            [1,1,1],
            [0,0,0]
        ],
        [
            [1,0,0],
            [1,1,1],
            [0,0,0]
        ],
        [
            [0,1,1],
            [1,1,0],
            [0,0,0]
        ],
        [
            [1,1,0],
            [0,1,1],
            [0,0,0]
        ],
        [
            [0,1,0],
            [1,1,1],
            [0,0,0]
        ],
        [
            [1,1],
            [1,1]
        ],
        [
            [0,0,0,0],
            [1,1,1,1],
            [0,0,0,0],
            [0,0,0,0]
        ]
    ];
    
    self.reset = function() {
        if (self.fallDownID) {
            clearTimeout(self.fallDownID);
        }
        if (self.forceMoveDownID) {
            clearTimeout(self.forceMoveDownID);
        }
        self.type = self.nextType;
        self.nextType = Math.floor(Math.random() * (self.puzzles.length));
        self.position = 0;
        self.speed = 100;
        self.board = [];
        self.elements = [];
        for (var i = 0; i < self.nextElements.length; i++) {
            document.getElementById("tetris-nextpuzzle").removeChild(self.nextElements[i]);
        }
        self.nextElements = [];
        self.x = null;
        self.y = null;
    }
    self.reset();
    
    self.isRunning = function() {
        return self.running;
    }
    self.isStopped = function() {
        return self.stopped;
    }
    
    self.getX = function() {
        return self.x;
    }
    self.getY = function() {
        return self.y;
    }
    
    self.mayPlace = function() {
        var puzzle = self.puzzles[self.type];
        var areaStartX = parseInt((self.area.x - puzzle[0].length) / 2);
        var areaStartY = 1;
        var lineFound = false;
        var lines = 0;
        for (var y = puzzle.length - 1; y >= 0; y--) {
            for (var x = 0; x < puzzle[y].length; x++) {
                if (puzzle[y][x]) {
                    lineFound = true;
                    if (self.area.getBlock(areaStartY, areaStartX + x)) { return false; }
                }
            }
            if (lineFound) {
                lines++;
            }
            if (areaStartY - lines < 0) {
                break;
            }
        }
        return true;
    }
    self.place = function() {
        // init
        var puzzle = self.puzzles[self.type];
        var areaStartX = parseInt((self.area.x - puzzle[0].length) / 2);
        var areaStartY = 1;
        var lineFound = false;
        var lines = 0;
        self.x = areaStartX;
        self.y = 1;
        self.board = self.createEmptyPuzzle(puzzle.length, puzzle[0].length);
        // create puzzle
        for (var y = puzzle.length - 1; y >= 0; y--) {
            for (var x = 0; x < puzzle[y].length; x++) {
                if (puzzle[y][x]) {
                    lineFound = true;
                    var el = document.createElement("div");
                    el.className = "block";
                    el.style.left = (areaStartX + x) * self.area.unit + "px";
                    el.style.top = (areaStartY - lines) * self.area.unit + "px";
                    self.area.el.appendChild(el);
                    self.board[y][x] = el;
                    self.elements.push(el);
                }
            }
            if (lines) {
                self.y--;
            }
            if (lineFound) {
                lines++;
            }
        }
        self.running = true;
        self.fallDownID = setTimeout(self.fallDown, self.speed);
//         next puzzle
        var nextPuzzle = self.puzzles[self.nextType];
        for (var y = 0; y < nextPuzzle.length; y++) {
            for (var x = 0; x < nextPuzzle[y].length; x++) {
                if (nextPuzzle[y][x]) {
                    var el = document.createElement("div");
                    el.className = "block";
                    el.style.left = (x * self.area.unit) + "px";
                    el.style.top = (y * self.area.unit) + "px";
                    document.getElementById("tetris-nextpuzzle").appendChild(el);
                    self.nextElements.push(el);
                }
            }
        }
    }
    
    self.destroy = function() {
        for (var i = 0; i < self.elements.length; i++) {
            self.area.el.removeChild(self.elements[i]);
        }
        self.elements = [];
        self.board = [];
        self.reset();
    }
    self.createEmptyPuzzle = function(y, x) {
        var puzzle = [];
        for (var y2 = 0; y2 < y; y2++) {
            puzzle.push([]);
            for (var x2 = 0; x2 < x; x2++) {
                puzzle[y2].push(0);
            }
        }
        return puzzle;
    }
    
    self.fallDown = function() {
        
//        alert("ma deplasez in jos cu viteza: " + self.speed + " " + self.y);
        
        
        if (self.isRunning()) {
            if (self.mayMoveDown()) {
                self.moveDown();
                self.fallDownID = setTimeout(self.fallDown, self.speed);
            } else {
                // move blocks into area board
                for (var i = 0; i < self.elements.length; i++) {
                    self.area.addElement(self.elements[i]);
                }
                
                var lines = self.area.removeFullLines();
                
                //reset score
                
                // reset puzzle
                self.reset();
                if (self.mayPlace()) {
                    self.place();
                } else {
                    self.tetris.gameOver();
                }
            }
        }
    }
    self.stop = function() {
        self.running = false;
    }
    
    self.mayRotate = function() {
        for (var y = 0; y < self.board.length; y++) {
            for (var x = 0; x < self.board[y].length; x++) {
                if (self.board[y][x]) {
                    var newY = self.getY() + self.board.length - 1 - x;
                    var newX = self.getX() + y;
                    if (newY >= self.area.y) { return false; }
                    if (newX < 0) { return false; }
                    if (newX >= self.area.x) { return false; }
                    if (self.area.getBlock(newY, newX)) { return false; }
                }
            }
        }
        return true;
    }
    self.rotate = function() {
        var puzzle = self.createEmptyPuzzle(self.board.length, self.board[0].length);
        for (var y = 0; y < self.board.length; y++) {
            for (var x = 0; x < self.board[y].length; x++) {
                if (self.board[y][x]) {
                    var newY = puzzle.length - 1 - x;
                    var newX = y;
                    var el = self.board[y][x];
                    var moveY = newY - y;
                    var moveX = newX - x;
                    el.style.left = el.offsetLeft + (moveX * self.area.unit) + "px";
                    el.style.top = el.offsetTop + (moveY * self.area.unit) + "px";
                    puzzle[newY][newX] = el;
                }
            }
        }
        self.board = puzzle;
    }
    
    self.mayMoveDown = function() {
        for (var y = 0; y < self.board.length; y++) {
            for (var x = 0; x < self.board[y].length; x++) {
                if (self.board[y][x]) {
                    if (self.getY() + 1 >= self.area.y) { self.stopped = true; return false; }
                    if (self.area.getBlock(self.getY() + 1, self.getX() + x)) { self.stopped = true; return false; }
                }
            }
        }
        return true;
    }
    self.moveDown = function() {
        alert("down")
        for (var i = 0; i < self.elements.length; i++) {
//            self.elements[i].style.top = self.elements[i].offsetTop + self.area.unit + "px";
        }
        self.y++;
    }
    
    self.mayMoveLeft = function() {
        for (var y = 0; y < self.board.length; y++) {
            for (var x = 0; x < self.board[y].length; x++) {
                if (self.board[y][x]) {
                    if (self.getX() + x - 1 < 0) { return false; }
                    if (self.area.getBlock(self.getY() + y, self.getX() + x - 1)) { return false; }
                }
            }
        }
        return true;
    }
    self.moveLeft = function() {
        for (var i = 0; i < self.elements.length; i++) {
            self.elements[i].style.left = self.elements[i].offsetLeft - self.area.unit + "px";
        }
        self.x--;
    }
    
    self.mayMoveRight = function() {
        for (var y = 0; y < self.board.length; y++) {
            for (var x = 0; x < self.board[y].length; x++) {
                if (self.board[y][x]) {
                    if (self.getX() + x + 1 >= self.area.x) { return false; }
                    if (self.area.getBlock(self.getY() + y, self.getX() + x + 1)) { return false; }
                }
            }
        }
        return true;
    }
    self.moveRight = function() {
        for (var i = 0; i < self.elements.length; i++) {
            self.elements[i].style.left = self.elements[i].offsetLeft + self.area.unit + "px";
        }
        self.x++;
    }
}

//
//
//
//
//
//var GameLoop = function(){
//    gLoop = setTimeout(GameLoop, 1000 / 50);
//}
//
//GameLoop();
