function reset() {
	$('#height_input').val("");
	$('#weight_input').val("");
	$('#feet_input').val("");
	$('#inch_input').val("");
	$('#result_panel').html("Result");
	$('#result_unit').html("normal weight");
}

function calculateBmi() {
	var heightUnit = $('#height_unit').val();
	var weightUnit = $('#weight_unit').val();

	var hasHeight = false;
	var height = 0;

	if(heightUnit == 1) { // ft/inch
		var feet = $('#feet_input').val();
		var inch = $('#inch_input').val();
		hasHeight = (feet != null && feet != "") ? true : false;

		if(hasHeight) {
			inch = (inch != null && inch != "") ? inch : 0;
			height = inch * 0.0254 + feet * 0.3048;
		}
	} else { // m
		height = $('#height_input').val();
		hasHeight = (height != null && height != "") ? true : false;
		height = parseFloat(height) / 100;
	}

	var weight = $('#weight_input').val();
	var hasWeight = (weight != null && weight != "") ? true : false;

	weight = parseFloat(weight);

	if(hasHeight && hasWeight) {	

		if(weightUnit == 1) {
			weight = weight * 0.453592;
		}

		var bmi = weight / Math.pow(height, 2);
		$('#result_panel').html(bmi.toFixed(2));

		if(bmi <= 15) {
			$('#result_unit').html("very severely underweight");
		} else if(bmi <= 16) {
			$('#result_unit').html("severely underweight");
		} else if(bmi <= 18.5) {
			$('#result_unit').html("underweight");
		} else if(bmi <= 25) {
			$('#result_unit').html("normal weight");
		} else if(bmi <= 30) {
			$('#result_unit').html("overweight");
		} else if(bmi <= 35) {
			$('#result_unit').html("Moderately obese");
		} else if(bmi <= 40) {
			$('#result_unit').html("Severely obese");
		} else {
			$('#result_unit').html("very severely obese");
		}
	}
}


$(function() {
	$('#action_clear').click(function() {
		reset();
	});

	$('#height_input').keyup(function() {
		calculateBmi();
	});

	$('#feet_input').keyup(function() {
		calculateBmi();
	});

	$('#inch_input').keyup(function() {
		calculateBmi();
	});

	$('#weight_input').keyup(function() {
		calculateBmi();
	});

	$('#height_unit').change(function() {
		if($(this).val() == 1) {
			$('.cm_panel').hide();
			$('.feet_panel').show();
		} else {
			$('.cm_panel').show();
			$('.feet_panel').hide();
		}

		calculateBmi();
	});

	$('#weight_unit').change(function() {
		calculateBmi();
	});
});