function reset() {
	$('#height_input').val("");
	$('#weight_input').val("");
	$('#feet_input').val("");
	$('#inch_input').val("");
	$('#age_input').val("");
	$('#result_panel').html("Result");
	$('#result_unit').html("average");
}

function calculateBodyFatRatio() {
	var heightUnit = $('#height_unit').val();
	var weightUnit = $('#weight_unit').val();
	var age = $('#age_input').val();
	var gender = $('#gender_select').val();

	var hasAge = (age != null && age != "") ? true : false;
	var hasGender = (gender != null && gender != "") ? true : false;

	var hasHeight = false;
	var height = 0;

	if(heightUnit == 1) { // ft/inch
		var feet = $('#feet_input').val();
		var inch = $('#inch_input').val();
		hasHeight = (feet != null && feet != "") ? true : false;

		if(hasHeight) {
			inch = (inch != null && inch != "") ? inch : 0;
			height = inch * 0.0254 + feet * 0.3048;
		}
	} else { // m
		height = $('#height_input').val();
		hasHeight = (height != null && height != "") ? true : false;
		height = parseFloat(height) / 100;
	}

	var weight = $('#weight_input').val();
	var hasWeight = (weight != null && weight != "") ? true : false;

	weight = parseFloat(weight);

	if(hasHeight && hasWeight && hasGender && hasAge) {	

		if(weightUnit == 1) {
			weight = weight * 0.453592;
		}

		var bmi = weight / Math.pow(height, 2);

		var bodyFatRatio = 0;

		if(age <= 15) {
			bodyFatRatio = (1.51 * bmi) - (0.7 * age) - (3.6 * gender) + 1.4;
		} else {
			bodyFatRatio = (1.20 * bmi) + (0.23 * age) - (10.8 * gender) - 5.4;
		}

		$('#result_panel').html(bodyFatRatio.toFixed(2));

		if(gender == 1) {
			if(bodyFatRatio <= 13) {
				$('#result_unit').html("Athletes");
			} else if(bodyFatRatio <= 17) {
				$('#result_unit').html("Fitness");
			} else if(bodyFatRatio <= 24) {
				$('#result_unit').html("average");
			} else {
				$('#result_unit').html(" obese");
			}
		} else {
			if(bodyFatRatio <= 20) {
				$('#result_unit').html("Ath;etes");
			} else if(bodyFatRatio <= 24) {
				$('#result_unit').html("Fitness");
			} else if(bodyFatRatio <= 31) {
				$('#result_unit').html("average");
			} else {
				$('#result_unit').html(" obese");
			}
		}
	}
}


$(function() {
	$('#action_clear').click(function() {
		reset();
	});

	$('#height_input').keyup(function() {
		calculateBodyFatRatio();
	});

	$('#feet_input').keyup(function() {
		calculateBodyFatRatio();
	});

	$('#inch_input').keyup(function() {
		calculateBodyFatRatio();
	});

	$('#weight_input').keyup(function() {
		calculateBodyFatRatio();
	});

	$('#height_unit').change(function() {
		if($(this).val() == 1) {
			$('.cm_panel').hide();
			$('.feet_panel').show();
		} else {
			$('.cm_panel').show();
			$('.feet_panel').hide();
		}

		calculateBodyFatRatio();
	});

	$('#weight_unit').change(function() {
		calculateBodyFatRatio();
	});

	$('#age_input').keyup(function() {
		calculateBodyFatRatio();
	});

	$('#gender_select').change(function() {
		calculateBodyFatRatio();
	});
});