if(!my.boletus.lgdata)my.boletus.lgdata={};
if(!my.boletus.lgdata.en)my.boletus.lgdata.en={};
my.boletus.lgdata.en.mushroom=[{"id": "Bola-de-neu", "latinname":"Agaricus arvensis", "name":"Agaricus arvensis", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus arvensis</span></span>, commonly known as the <span class=\"mushroomName\">horse mushroom</span>, is a mushroom of the genus <span class=\"foreignLanguage\">Agaricus</span>.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus arvensis</span></span>, commonly known as the <span class=\"mushroomName\">horse mushroom</span>, is a mushroom of the genus <span class=\"foreignLanguage\">Agaricus</span>.</p></div><div><h3>Taxonomy</h3><p>It was described as <span class=\"foreignLanguage\">Agaricus arvensis</span> by Jacob Christian Schaeffer in 1762, and given numerous binomial descriptions since. Its generic name <span class=\"mushroomName\">arvensis</span> means 'of the field'.</p></div><div><h3>Description</h3><p>The cap is similar to that of <span class=\"foreignLanguage\">Agaricus campestris</span> (the field mushroom). The gills are white at first (when this fungus is most often confused with deadly <span class=\"foreignLanguage\">Amanita</span> genus). They later pass through grey and brown to become dull chocolate. There is a large spreading ring, white above but sometimes with yellowish scales underneath. Viewed from below, on a closed-cap specimen, the twin-layered ring has a well-developed 'cogwheel' pattern around the stipe. This is the lower part of the double ring.  The odor is described as like anise. It belongs to a group of <span class=\"foreignLanguage\">Agaricus</span> which tend to stain yellow on bruising.</p></div><div><h3>=Similar species=</h3><ul><li><span class=\"foreignLanguage\">Agaricus osecanus</span> is rare, and is without the aniseed smell. and North America.</li></ul><p>Frequently found near stables, as well as in meadows, it may form fairy rings; the mushroom is often found growing with nettles (a plant that also likes nutrient-rich soil).  It is sometimes found associated with spruce.</p></ul></div><div><h3>Conservation</h3><p>This mushroom is considered common and widespread, and is not a conservation concern.</p></div><div><h3>Edibility</h3><p>Much prized by farmers and gypsies for generations, the horse mushroom is regarded as one of the most delicious edible fungi, although the fruitbodies of this and other yellow-staining <span class=\"foreignLanguage\">Agaricus</span> species often have a build-up of heavy metals, such as cadmium and copper.</p></div>", "photos":[{"mushroomid":"Bola-de-neu","img":"wiki\/bola-de-neu1.jpg"},{"mushroomid":"Bola-de-neu","img":"wiki\/bola-de-neu3.jpg"},{"mushroomid":"Bola-de-neu","img":"wiki\/bola-de-neu4.jpg"},{"mushroomid":"Bola-de-neu","img":"wiki\/bola-de-neu5.jpg"},{"mushroomid":"Bola-de-neu","img":"wiki\/bola-de-neu6.jpg"},{"mushroomid":"Bola-de-neu","img":"wiki\/bola-de-neu7.jpg"},{"mushroomid":"Bola-de-neu","img":"wiki\/bola-de-neu8.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Xampinyo", "latinname":"Agaricus bisporus", "name":"Agaricus bisporus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus bisporus</span></span> is an edible basidiomycete mushroom native to grasslands in Europe and North America. It has two color states while immature—white and brown—both of which have various names. When mature, the same mushroom has yet another popular name. ", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus bisporus</span></span> is an edible basidiomycete mushroom native to grasslands in Europe and North America. It has two color states while immature—white and brown—both of which have various names. When mature, the same mushroom has yet another popular name. </p><p>When immature and <span class=\"foreignLanguage\">white</span>—this mushroom may be known as <span class=\"mushroomName\">common mushroom</span>, <span class=\"mushroomName\">button mushroom</span>, <span class=\"mushroomName\">white mushroom</span>, <span class=\"mushroomName\">cultivated mushroom</span>, <span class=\"mushroomName\">table mushroom</span>, and <span class=\"mushroomName\">champignon mushroom</span>. When immature and <span class=\"foreignLanguage\">brown</span>—this mushroom may be known variously as <span class=\"mushroomName\">Swiss brown mushroom</span>, <span class=\"mushroomName\">Roman brown mushroom</span>, <span class=\"mushroomName\">Italian brown</span>, <span class=\"mushroomName\">Italian mushroom</span>, <span class=\"mushroomName\">cremini</span> or <span class=\"mushroomName\">crimini mushroom</span>, <span class=\"mushroomName\">brown cap mushroom</span>, or <span class=\"mushroomName\">chestnut mushroom</span>. </p><p>When mature, the same mushroom is known as <span class=\"mushroomName\">Portobello mushroom</span>. </p><p><span class=\"foreignLanguage\">Agaricus bisporus</span> is cultivated in more than seventy countries, In 1938, it was promoted to species status and renamed <span class=\"foreignLanguage\">Psalliota bispora</span>. The specific epithet <span class=\"foreignLanguage\">bispora</span> distinguishes the two-spored basidia from four-spored varieties.</p><p>Among English speakers, <span class=\"foreignLanguage\">Agaricus bisporus</span> is known by many names. A young specimen with a closed cap and either pale white or light brown flesh is known as a <span class=\"mushroomName\">button mushroom</span> or <span class=\"mushroomName\">white mushroom</span>. In strains with darker flesh, the immature mushroom is variously marketed as a <span class=\"mushroomName\">cremini mushroom</span>, <span class=\"mushroomName\">baby portobello</span>, <span class=\"mushroomName\">baby bella</span>, <span class=\"mushroomName\">mini bella</span>, <span class=\"mushroomName\">portabellini</span>, <span class=\"mushroomName\">Roman mushroom</span>, <span class=\"mushroomName\">Italian mushroom</span>, or <span class=\"mushroomName\">brown mushroom</span>. At this stage of maturation, the cap also may begin to open slightly. In maturity, the mushroom is called a <span class=\"mushroomName\">portobello</span>. but the first of these spellings is the most common.</p></div><div><h3>Description</h3><p>The pileus or cap of the original wild species is a pale grey-brown in color, with broad, flat scales on a paler background and fading toward the margins. It is first hemispherical in shape before flattening out with maturity, and 5–10&nbsp;cm (2–4&nbsp;in) in diameter. The narrow, crowded gills are free and initially pink, then red-brown and finally a dark brown with a whitish edge from the cheilocystidia. The cylindrical stipe is up to 6&nbsp;cm (2⅓ in) tall by 1–2&nbsp;cm wide and bears a thick and narrow ring, which may be streaked on the upper side. The firm flesh is white although stains a pale pinkish-red on bruising.</p></div><div><h3>=Similar species=</h3><p>The common mushroom could be confused with young specimens of the deadly poisonous destroying angel (<span class=\"foreignLanguage\">Amanita</span> sp.), but the latter may be distinguished by their volva or cup at the base of the mushroom and pure white gills (as opposed to pinkish or brown of <span class=\"foreignLanguage\">Agaricus bisporus</span>). Thus it is always important to clear away debris and examine the base of such similar mushrooms, as well as cutting open young specimens to check the gills. Furthermore, the destroying angel grows in mossy woods and lives symbiotically with spruce.</p><p>A more common and less dangerous mistake is to confuse <span class=\"foreignLanguage\">Agaricus bisporus</span> with <span class=\"foreignLanguage\">Agaricus xanthodermus</span>, an inedible mushroom found worldwide in grassy areas. <span class=\"foreignLanguage\">Agaricus xanthodermus</span> has an odor reminiscent of phenol; its flesh turns yellow when bruised. This fungus causes nausea and vomiting in some people.</p><p>The poisonous European species, <span class=\"foreignLanguage\">Entoloma sinuatum</span>, has a passing resemblance as well, but has yellowish gills turning pink and it lacks a ring.</p></div><div><h3>Cultivation history</h3><p>The earliest description of the commercial cultivation of <span class=\"foreignLanguage\">Agaricus bisporus</span> was made by French botanist Joseph Pitton de Tournefort in 1707. In 1893, sterilized, or pure culture, spawn was discovered and produced by the Pasteur Institute in Paris, for cultivation on composted horse manure. Similar to the commercial development history of the navel orange and Red Delicious apple, cultures were grown from the mutant individuals, and most of the cream-colored store mushrooms marketed today are products of this 1926 chance natural mutation.</p><p><span class=\"foreignLanguage\">Agaricus bisporus</span> is now cultivated in at least seventy countries throughout the world.</p></div><div><h3>Vitamin D</h3><p>While <span class=\"foreignLanguage\">Agaricus bisporus</span> only contains 16 IU of vitamin D as ergocalciferol (vitamin D2), since it also contains high amounts of ergosterol, after temporary exposure to UV light the ergocalciferol contents increase. conjugated linoleic acid, Protocatechuic acid and pyrocatechol also are found in <span class=\"foreignLanguage\">A. bisporus</span>. A 2009 case control study of 2,018 women correlated a large decrease of the incidence of breast cancer in women who consumed mushrooms. Women in the study who consumed fresh mushrooms daily were 64% less likely to develop breast cancer than the control group, and additionally, those who combined a mushroom diet with regular green tea consumption reduced their risk of breast cancer by nearly 90%.</p><p>A phytochemical (2-aminophenoxazine-3-one) in white button mushrooms was shown to have aromatase inhibitor properties in vitro.</p><p>The table mushroom also has been shown to possess possible immune system enhancing properties. An <span class=\"foreignLanguage\">in vitro</span> study demonstrated that the mushroom enhanced dendritic cell function.</p></div><div><h3>Mycochemical research</h3><p>Some 1990 studies have revealed that compounds in raw <span class=\"foreignLanguage\">A. bisporus</span>—along with some other edible mushrooms—contain hydrazine derivatives, including agaritine and gyromitrin, that have been evaluated for carcinogenic activity. In preliminary research during the 1980s, administration of uncooked mushrooms to mice induced a significant increase in the number of bone, stomach, and lung tumours, however, research also has noted that when cooked, these compounds were reduced significantly, and in fact, may provide anti-carcinogenic activity by stimulating apoptosis.</p></div>", "photos":[{"mushroomid":"Xampinyo","img":"wiki\/xampinyo10.jpg"},{"mushroomid":"Xampinyo","img":"wiki\/xampinyo2.jpg"},{"mushroomid":"Xampinyo","img":"wiki\/xampinyo3.jpg"},{"mushroomid":"Xampinyo","img":"wiki\/xampinyo4.jpg"},{"mushroomid":"Xampinyo","img":"wiki\/xampinyo5.jpg"},{"mushroomid":"Xampinyo","img":"wiki\/xampinyo6.jpg"},{"mushroomid":"Xampinyo","img":"wiki\/xampinyo7.jpg"},{"mushroomid":"Xampinyo","img":"wiki\/xampinyo8.jpg"},{"mushroomid":"Xampinyo","img":"wiki\/xampinyo9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Camperol_dels_carrers", "latinname":"Agaricus bitorquis", "name":"Agaricus bitorquis", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus bitorquis</span></span> is an edible white mushroom of the genus <span class=\"foreignLanguage\">Agaricus</span>, similar to the common button mushroom that is sold commercially. The name supersedes <span class=\"foreignLanguage\">Agaricus rodmani</span>. It is also commonly known as torq, the banded agaric, spring agaric, or <span class=\"mushroomName\">pavement mushroom</span>, as it has been recorded pushing up paving slabs.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus bitorquis</span></span> is an edible white mushroom of the genus <span class=\"foreignLanguage\">Agaricus</span>, similar to the common button mushroom that is sold commercially. The name supersedes <span class=\"foreignLanguage\">Agaricus rodmani</span>. It is also commonly known as torq, the banded agaric, spring agaric, or <span class=\"mushroomName\">pavement mushroom</span>, as it has been recorded pushing up paving slabs.</p></div><div><h3>Taxonomy</h3><p>The specific epithet <span class=\"foreignLanguage\">bitorquis</span> is Latin \"having two collars\", and refers to the two rings resulting from detachment of the annulus from both the top and bottom of the stipe.</p></div><div><h3>Description</h3><p>The cap is dry, smooth, and white (but staining yellowish in age), and measures 4 to 15&nbsp;cm in diameter, convex to flat;  often with dirt on the cap.</p><p>The gills are free, very narrow, close, light pink color when young, becoming dark reddish-brown as the spores mature. The spore print is chocolate brown. The stipe is 3 – 11&nbsp;cm long, 2 – 4&nbsp;cm thick, cylindrical to clavate (club-shaped), equal to enlarged at the base, stout, white, smooth, with a membranous veil and thick white mycelial sheathing near the base. The flesh is solid and firm, with a mild odor. It is often confused with <span class=\"foreignLanguage\">Agaricus bernardii</span>; however, that mushroom has a salty odor.</p></div><div><h3>=Microscopic details=</h3><p>Basidiospores are elliptical in shape, smooth, and with dimensions of 5–7 x 4–5.5&nbsp;µm. Basidia are 20–25 x 6.5–8.5&nbsp;µm, usually four-spored, but often with two-spored basidia present. Cystidia are present and numerous.</p></div><div><h3>Distribution and habitat</h3><p><span class=\"foreignLanguage\">Agaricus bitorquis</span> may be found growing solitary or in small groups in gardens, and at roadsides, often where salt is applied to combat ice in winter. Pushing through asphalt and slabs, it is subterranean, and often matures underground. It is occasional throughout North America, Nutritional analysis has shown this species to contain 18 amino acids, including all of the essential ones.</p></div><div><h3>Cultivation</h3><p>First cultivated commercially in 1968, <span class=\"foreignLanguage\">A.&nbsp;bitorquis</span> has several growth characteristics that have piqued the interest of mushroom cultivators looking for an alternative to the standard button mushroom, <span class=\"foreignLanguage\">A.&nbsp;bisporus</span>. For example, <span class=\"foreignLanguage\">A.&nbsp;bitorquis</span> is more resistant to various viral diseases, can grow at higher temperatures and CO<sub>2</sub> concentrations, and has better resistance to bruising. Furthermore, high temperature-resistant strains have recently been developed which may help cultivators overcome problems associated with cooling production rooms during hot summer months.</p></div>", "photos":[{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers10.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers11.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers12.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers13.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers14.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers15.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers16.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers17.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers4.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers5.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers6.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers7.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers8.jpg"},{"mushroomid":"Camperol_dels_carrers","img":"wiki\/camperol.dels.carrers9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Xampinyo_silvestre", "latinname":"Agaricus campestris", "name":"Agaricus campestris", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus campestris</span></span> is commonly known as the <span class=\"mushroomName\">field mushroom</span> or, in North America, <span class=\"mushroomName\">meadow mushroom</span>. It is a widely eaten gilled mushroom closely related to the cultivated button mushroom <span class=\"foreignLanguage\">Agaricus bisporus</span>.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus campestris</span></span> is commonly known as the <span class=\"mushroomName\">field mushroom</span> or, in North America, <span class=\"mushroomName\">meadow mushroom</span>. It is a widely eaten gilled mushroom closely related to the cultivated button mushroom <span class=\"foreignLanguage\">Agaricus bisporus</span>.</p></div><div><h3>Taxonomy</h3><p>This species was originally noted and named in 1753 by Carolus Linnaeus as <span class=\"foreignLanguage\">Agaricus campestris</span>. It was placed in the genus <span class=\"foreignLanguage\">Psalliota</span> by Lucien Quelet in 1872. Some variants have been isolated over the years, a few of which now have species status, for example, <span class=\"foreignLanguage\">Agaricus bernardii</span> Quel. (1878), <span class=\"foreignLanguage\">Agaricus bisporus</span> (J.E. Lange) Imbach (1946), <span class=\"foreignLanguage\">Agaricus bitorquis</span> (Quel.) Sacc. (1887), <span class=\"foreignLanguage\">Agaricus cappellianus</span> Hlavacek (1987), and <span class=\"foreignLanguage\">Agaricus silvicola</span> (Vittad.) Peck (1872). <br/>Some were so similar they did not warrant even variant status, others have retained it e.g. <span class=\"foreignLanguage\">Agaricus campestris var. equestris</span>  (F.H. Moller) Pilat (1951) is still valid, and presumably favors pasture where horses have been kept. <span class=\"foreignLanguage\">Agaricus campestris var isabellinus</span> (F.H. Moller) Pilat (1951), and <span class=\"foreignLanguage\">Agaricus campestris var.radicatus</span>, are possibly still valid too.<br/>The specific epithet <span class=\"foreignLanguage\">campestris</span> is derived from the Latin <span class=\"foreignLanguage\">campus</span> \"field\".</p></div><div><h3>Description</h3><p>The cap is white, may have fine scales, and is  in diameter; it is first hemispherical in shape before flattening out with maturity. The gills are initially pink, then red-brown and finally a dark brown, as is the spore print. The  tall stipe is predominantly white and bears a single thin ring. or solitary. Owing to the demise of horse-drawn vehicles, and the subsequent decrease in the number of horses on pasture, the old '<span class=\"mushroomName\">white outs</span>' of years gone by are becoming rare events.</p><p>Culinary uses of the meadow mushroom include eating it sauteed or fried, in sauces, or even sliced raw and included in salads.  In flavor and texture, this mushroom is almost identical to the white button mushroom available in grocery stores in the United States.  Be sure to rinse well to dislodge any sand, and also watch out for small, white larvae which tunnel through the stems and caps.  Among the similar species mentioned above, there have been cases (in fact the most common cause of fatal fungus poisoning in France) where the deadly toxic destroying angel (<span class=\"foreignLanguage\">Amanita bisporigera</span>) has been consumed by individuals who mistook it for this species. The edibility of specimens collected from lawns is uncertain because of possible contamination with pesticides or other chemicals.</p></div><div><h3>Other uses</h3><p>Research into fungal dressings for the treatment of ulcers, and bed sores, using fungal mycelial filaments, is ongoing. In the past, slices of <span class=\"foreignLanguage\">A. campestris</span> were applied to scalds, and burns in parts of Scotland.</p></div>", "photos":[{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre10.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre11.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre12.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre13.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre14.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre15.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre16.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre17.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre18.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre2.jpg"},{"mushroomid":"Xampinyo_silvestre","img":"wiki\/xampinyo.silvestre7.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Agaricus_impudicus", "latinname":"Agaricus impudicus", "name":"Agaricus impudicus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus impudicus</span></span>, is a mushroom of the genus <span class=\"foreignLanguage\">Agaricus</span>, a familiar genus with many edible species.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus impudicus</span></span>, is a mushroom of the genus <span class=\"foreignLanguage\">Agaricus</span>, a familiar genus with many edible species.</p></div><div><h3>Appearance</h3><p>As with all <span class=\"foreignLanguage\">Agaricus</span> species, gills are free, colour progresses with age from pale-pink to a chocolate color, and spores are dark brown. The stipe has a clear annulus (ring).</p><p>Cap 4&ndash;15&nbsp;cm wide, and appears brownish due to numerous brownish scales on a white background. The stipe is white, 6&ndash;12&nbsp;cm tall and 0.8&ndash;2&nbsp;cm thick, cylindrical and wider towards the bottom, or ending in a bulb.</p><p>It is distinguished from similar forest-growing <span class=\"foreignLanguage\">Agaricus</span> mushrooms in that it does not bruise yellowish or reddish when cut and the widening stipe. Taste is mild and the mushroom is edible.</p></div><div><h3>Habitat</h3><p>Known to occur in Western and Southern Europe and New Zealand, this uncommon mushroom is found in deciduous or coniferous forest in autumn.</p></div><div><h3>Taxonomy</h3><p>This species is known under a number of synonyms, all these refer to the same species:</p><ul><li><span class=\"foreignLanguage\">Agaricus brunnoleus</span> (J. Lange) Pilát</li><li><span class=\"foreignLanguage\">Agaricus koelerionensis</span> (Bon) Bon 1980</li><li><span class=\"foreignLanguage\">Agaricus reae</span> Bon 1981</li><li><span class=\"foreignLanguage\">Agaricus variegans</span> F.H. Møller 1952</li><li><span class=\"foreignLanguage\">Agaricus variegatus</span> (F.H. Møller) Pil�t 1951</li><li><span class=\"foreignLanguage\">Psalliota impudica</span> Rea 1932</li><li><span class=\"foreignLanguage\">Psalliota variegata</span> F.H. Møller 1950</li><li><span class=\"foreignLanguage\">Psalliota variegata</span> var. <span class=\"foreignLanguage\">koelerionis</span> Bon 1972</li></ul></div>", "photos":[{"mushroomid":"Agaricus_impudicus","img":"wiki\/agaricus.impudicus2.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Rubiol_gros_descates_brunes", "latinname":"Agaricus perrarus", "name":"Agaricus perrarus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus augustus</span></span>, known commonly as <span class=\"mushroomName\">the prince</span>, is a basidiomycete fungus of the genus <span class=\"foreignLanguage\">Agaricus</span>.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus augustus</span></span>, known commonly as <span class=\"mushroomName\">the prince</span>, is a basidiomycete fungus of the genus <span class=\"foreignLanguage\">Agaricus</span>.</p></div><div><h3>Taxonomy</h3><p>According to Heinemann's (1978) popular division of <span class=\"foreignLanguage\">Agaricus</span>, <span class=\"foreignLanguage\">A. augustus</span> belongs to section <span class=\"foreignLanguage\">Arvenses</span>. Moreover, there have been attempts to recognise distinct varieties, namely <span class=\"foreignLanguage\">A. augustus</span> var. <span class=\"foreignLanguage\">augustus</span> Fr., and <span class=\"foreignLanguage\">A. augustus</span> var. <span class=\"foreignLanguage\">perrarus</span> (Schulzer) Bon & Cappelli. The specific epithet <span class=\"foreignLanguage\">augustus</span> is a Latin adjective meaning noble.</p></div><div><h3>Description</h3><p>The fruiting bodies of <span class=\"foreignLanguage\">Agaricus augustus</span> are large and distinctive agarics. The cap shape is hemispherical during the so-called button stage, and then expands, becoming convex and finally flat, with a diameter of up to 22&nbsp;cm. The cap cuticle is dry, and densely covered with concentrically arranged, brown-coloured scales on a white to yellow background.</p><p>The flesh is thick, firm and white and may discolour yellow when bruised. The gills are crowded and pallid at first, and turn pink then dark brown with maturity. The gills are not attached to the stem — they are free. Immature specimens bear a delicate white partial veil with darker-coloured warts, extending from the stem to the cap periphery.</p><p>The stem is clavate up to 20&nbsp;cm tall, and 4&nbsp;cm thick. In mature specimens, the partial veil is torn and left behind as a pendulous ring adorning the stem. Above the ring, the stem is white to yellow and smooth. Below, it is covered with numerous small scales. Its flesh is thick, white and sometimes has a narrow central hollow. The stem base extends deeply into the substrate.</p><p>The mushroom's odour is strong and nutty, of anise or almonds, which can be associated with the presence of benzaldehyde and benzyl alcohol.</p><p>A species initially reported from North America, <span class=\"foreignLanguage\">A. subrufescens</span> closely resembles <span class=\"foreignLanguage\">A. augustus</span> in appearance. However, <span class=\"foreignLanguage\">A. subrufescens</span> produces smaller spores, sized 6–7.5 by 4–5&nbsp;µm.</p></div><div><h3>=Chemical tests=</h3><p><span class=\"foreignLanguage\">Agaricus augustus</span> shows a red positive Schaeffer's test reaction. The cap cuticle turns yellow when a 10% potassium hydroxide solution is applied. In Europe, <span class=\"foreignLanguage\">A. augustus</span> fruits in late summer and autumn. and is collected widely for consumption in Eurasia, the USA, Canada and some parts of Mexico. <span class=\"foreignLanguage\">A. augustus</span> has been implicated in specifically bioaccumulating the metal cadmium, with a quantity of 2.44&nbsp;mg per kilogram of fresh weight as recorded in one Swiss study.</p></div>", "photos":[{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes10.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes11.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes12.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes13.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes14.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes15.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes16.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes17.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes18.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes19.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes2.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes20.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes21.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes22.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes3.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes5.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes6.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes7.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes8.jpg"},{"mushroomid":"Rubiol_gros_descates_brunes","img":"wiki\/rubiol.gros.descates.brunes9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Bola-de-neu_de_bosc", "latinname":"Agaricus silvicola", "name":"Agaricus silvicola", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus silvicola</span></span>, also known as the <span class=\"mushroomName\">Wood Mushroom</span> is a species of Agaricus mushroom related to the button mushroom.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus silvicola</span></span>, also known as the <span class=\"mushroomName\">Wood Mushroom</span> is a species of Agaricus mushroom related to the button mushroom.</p></div><div><h3>Taxonomy</h3><p>Originally described as the variety <span class=\"foreignLanguage\">Agaricus campestris</span> var. <span class=\"foreignLanguage\">silvicola</span> by Carlo Vittadini in 1832, it was promoted to distinct species status by Charles Horton Peck in 1873. It looks fairly similar to a young death cap, it is believed by some mycologists. Appearing in the autumn, it is rarely seen in huge numbers, usually just a few, or solitary. It is suspected to have caused an allergic reaction in a few people in North America.</p></div><div><h3>Similar species</h3><ul><li><span class=\"foreignLanguage\">Agaricus osecanus</span></li><li><span class=\"foreignLanguage\">Agaricus xanthodermus</span> – the yellow stainer</li><li><span class=\"foreignLanguage\">Agaricus arvensis</span> – the horse mushroom</li><li><span class=\"foreignLanguage\">Agaricus campestris</span> – the field mushroom</li></ul></div>", "photos":[{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc1.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc10.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc11.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc12.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc13.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc14.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc15.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc16.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc2.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc3.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc4.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc5.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc7.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc8.jpg"},{"mushroomid":"Bola-de-neu_de_bosc","img":"wiki\/bola-de-neu.de.bosc9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Bola-de-neu_pudent", "latinname":"Agaricus xanthodermus", "name":"Agaricus xanthodermus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus xanthodermus</span></span>, commonly known as the <span class=\"mushroomName\">yellow-staining mushroom</span> or simply the <span class=\"mushroomName\">yellow-stainer</span>, is a mushroom of the", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Agaricus xanthodermus</span></span>, commonly known as the <span class=\"mushroomName\">yellow-staining mushroom</span> or simply the <span class=\"mushroomName\">yellow-stainer</span>, is a mushroom of the</p><p>genus <span class=\"foreignLanguage\">Agaricus</span>, which displays a strong yellow colouration at the base of the stem when cut.  It is poisonous for most people, causing gastrointestinal upset,  but can be eaten by some without apparent negative effect.</p></div><div><h3>Taxonomy</h3><p>This species was first officially defined under the name <span class=\"foreignLanguage\">Agaricus xanthodermus</span> in 1876 by Léon Gaston Genevier, in a letter published in the bulletin of the French Botanical Society.  Genevier described the <span class=\"foreignLanguage\">Agaricus</span> mushrooms commonly eaten (perhaps sometimes inadvisedly) in the region of Nantes, and attempted to clarify the distinctions between them.  He proposed a detailed reclassification into 5 species, including this new one.  Apparently up until that time, these yellow-staining mushrooms were considered to be just varieties of other species which are edible: <span class=\"foreignLanguage\">A. arvensis</span>, <span class=\"foreignLanguage\">[http://www.indexfungorum.org/Names/NamesRecord.asp?RecordID=508604 A. edulis]</span>, and <span class=\"foreignLanguage\">A. silvicola</span>.</p><p>The epithet <span class=\"foreignLanguage\">xanthodermus</span> is derived from the Ancient Greek words for \"yellow\" and \"skin\", which were then given a Latin adjective ending.  This is the official name, but the form <span class=\"foreignLanguage\">Agaricus xanthoderma</span> is also often seen.  In the latter name, <span class=\"foreignLanguage\">-derma</span> \"skin\" is a neuter noun which does not have to agree in gender with <span class=\"foreignLanguage\">Agaricus</span>, and so this form is legal according to the rules of botanical nomenclature.</p></div><div><h3>Description</h3><p>The cap is generally 6–10&nbsp;cm (2.4–4&nbsp;in) in diameter, though can reach 15&nbsp;cm (6&nbsp;in). It is initially convex, with some young specimens having a squarish shape, though flattening with age. It is whitish, with light brown tints towards the centre. The cap is dry and smooth, but can be scaly when old. The gills of this mushroom progress from pale-pink to a chocolate color. The spore print is brown. Its white stipe is bulbous with a skirt-like ring. Microscopically, the cheilocystidia are club-shaped.  The spores are 6-7×3-4&nbsp;µm.</p><p>The main identifying feature is an immediate bright yellow colouration on cutting through the base of the stem, or scraping the flesh; later,  the affected area fades to a dull brown.  Numerous edible <span class=\"foreignLanguage\">Agaricus</span> species, such as <span class=\"foreignLanguage\">A. augustus</span>, <span class=\"foreignLanguage\">A. arvensis</span> and <span class=\"foreignLanguage\">A. silvicola</span>, turn yellow to a greater or lesser extent, but they do not display such an intense reaction.</p><p><span class=\"foreignLanguage\">Agaricus xanthodermus</span> has an unpleasant characteristic smell, which is phenolic, reminiscent of ink or carbolic soap.  The smell is especially strong at the base of the stem.</p></div><div><h3>Distribution and habitat</h3><p>This mushroom is very common and widely distributed in North America, Europe, West Asia including eastern Anatolia and Iran, North Africa, and southern Africa.  It has been introduced into Australia. It occurs in woods, lawns, gardens and hedgerows in autumn. This is a saprobic species.</p></div><div><h3>Poisonous character</h3><p>It appears that some people can eat this mushroom without ill effects, but it can cause serious gastric problems. It is indigestible and gives rise to symptoms of  sweating, flushing, and severe stomach cramps.</p><p>Of those who gather <span class=\"foreignLanguage\">Agaricus</span>-style mushrooms, about 50% of the cases of poisoning are from this species. On cooking, the smell becomes very noticeable, and this may deter people from eating it inadvertently.</p></div><div><h3>Related species</h3><p><span class=\"foreignLanguage\">A. xanthodermus</span> belongs to a group of related species  (the \"Xanthodermatei\") which likewise discolour bright yellow and have a phenolic smell.  They include <span class=\"foreignLanguage\">A. praeclaresquamosus</span> (formerly <span class=\"foreignLanguage\">A. placomyces</span>) which has dark grey scales, <span class=\"foreignLanguage\">A. moelleri</span>, and <span class=\"foreignLanguage\">A. pilatianus</span>, which does not have a bulbous stem.</p></div>", "photos":[{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent10.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent11.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent12.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent13.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent14.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent15.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent16.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent17.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent18.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent2.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent3.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent4.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent5.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent6.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent7.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent8.jpg"},{"mushroomid":"Bola-de-neu_pudent","img":"wiki\/bola-de-neu.pudent9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Cogoma_groga", "latinname":"Amanita citrina", "name":"Amanita citrina", "names":"Known as the <span class=\"mushroomName\">false death cap</span>, or <span class=\"mushroomName\">Citron Amanita</span>, <span class=\"foreignLanguage\"><span class=\"mushroomName\">Amanita citrina</span></span> (previously also known as <span class=\"foreignLanguage\">Amanita mappa</span>), is a basidiomycotic mushroom, one of many in the genus <span class=\"foreignLanguage\">Amanita</span>. It grows in silicate soil in the summer and autumn months. It bears a pale yellow or sometimes white cap, with white stem, ring and volva. Though it is not highly poisonous, its similarity to the lethal death cap (<span class=\"foreignLanguage\">Amanita phalloides</span>) precludes its use in cooking.", "description":"<div><p>Known as the <span class=\"mushroomName\">false death cap</span>, or <span class=\"mushroomName\">Citron Amanita</span>, <span class=\"foreignLanguage\"><span class=\"mushroomName\">Amanita citrina</span></span> (previously also known as <span class=\"foreignLanguage\">Amanita mappa</span>), is a basidiomycotic mushroom, one of many in the genus <span class=\"foreignLanguage\">Amanita</span>. It grows in silicate soil in the summer and autumn months. It bears a pale yellow or sometimes white cap, with white stem, ring and volva. Though it is not highly poisonous, its similarity to the lethal death cap (<span class=\"foreignLanguage\">Amanita phalloides</span>) precludes its use in cooking.</p></div><div><h3>Description</h3><p>This mushroom has a fleshy pale yellow, or sometimes white, cap from 4–10&nbsp;cm (1.5–4&nbsp;in) across, covered in irregular patches. The gills and flesh are white. There is a large volva at the base of the 6–8&nbsp;cm (2.5–3&nbsp;in) tall stem, which has a clear ring. This mushroom is not eaten, having a smell of rapeseed or potato. It is often confused with the  related death cap mushroom <span class=\"foreignLanguage\">(Amanita phalloides)</span>, hence the name.</p></div><div><h3>Distribution and habitat</h3><p>The false death cap is found in deciduous and coniferous woodlands in Autumn in Europe. It is also found in North American oak and pine forests.</p></div><div><h3>Toxicity</h3><p>Scientific tests in the University of Cambridge have shown that this mushroom contains the alpha-amanitin toxin. However, the amounts of this toxin were found to be very small and would not cause any adverse effects unless the mushroom was ingested in very large amounts.  The biggest danger with this species is its marked similarity to the death cap, which is reason enough to avoid it, even though it is edible.</p></div>", "photos":[{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga1.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga14.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga15.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga18.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga19.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga2.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga20.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga21.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga22.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga23.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga24.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga25.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga26.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga27.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga28.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga29.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga3.jpg"},{"mushroomid":"Cogoma_groga","img":"wiki\/cogoma.groga8.jpg"}], "attributes":[{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring and volva", "attributeId":"vel", "img":"Ring_and_volva_stipe_icon.png", "name":"ring and volva"}]},{"id": "Amanita_ocreata", "latinname":"Amanita ocreata", "name":"Amanita ocreata", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Amanita ocreata</span></span>, commonly known as the <span class=\"mushroomName\">death angel</span>, <span class=\"mushroomName\">destroying angel</span>, <span class=\"mushroomName\">angel of death</span> or more precisely <span class=\"mushroomName\">Western North American destroying angel</span>, is a deadly poisonous basidiomycete fungus, one of many in the genus <span class=\"foreignLanguage\">Amanita</span>. Occurring in the Pacific Northwest and California floristic provinces of North America, <span class=\"foreignLanguage\">A. ocreata</span> associates with oak trees. The large fruiting bodies (the mushrooms) generally appear in spring; the cap may be white or ochre and often develops a brownish centre, while the stipe, ring, gill and volva are all white.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Amanita ocreata</span></span>, commonly known as the <span class=\"mushroomName\">death angel</span>, <span class=\"mushroomName\">destroying angel</span>, <span class=\"mushroomName\">angel of death</span> or more precisely <span class=\"mushroomName\">Western North American destroying angel</span>, is a deadly poisonous basidiomycete fungus, one of many in the genus <span class=\"foreignLanguage\">Amanita</span>. Occurring in the Pacific Northwest and California floristic provinces of North America, <span class=\"foreignLanguage\">A. ocreata</span> associates with oak trees. The large fruiting bodies (the mushrooms) generally appear in spring; the cap may be white or ochre and often develops a brownish centre, while the stipe, ring, gill and volva are all white.</p><p><span class=\"foreignLanguage\">Amanita ocreata</span> resemble several edible species commonly consumed by humans, increasing the risk of accidental poisoning. Mature fruiting bodies can be confused with the edible <span class=\"foreignLanguage\">A. velosa</span>, <span class=\"foreignLanguage\">A. lanei</span> or <span class=\"foreignLanguage\">Volvariella speciosa</span>, while immature specimens may be difficult to distinguish from edible <span class=\"foreignLanguage\">Agaricus</span> mushrooms or puffballs. Similar in toxicity to the death cap (<span class=\"foreignLanguage\">A. phalloides</span>) and destroying angels of Europe (<span class=\"foreignLanguage\">A. virosa</span>) and eastern North America (<span class=\"foreignLanguage\">A. bisporigera</span>), it is a potentially deadly fungus responsible for a number of poisonings in California. The specific epithet is derived from the Latin <span class=\"foreignLanguage\">ocrěātus</span> 'wearing greaves' from <span class=\"foreignLanguage\">ocrea</span> 'greave', The edible <span class=\"foreignLanguage\">Amanita lanei</span> lacks a ring and is more likely to have veil patches remaining on its cap, which is generally darker. <span class=\"foreignLanguage\">Volvariella speciosa</span> has pink spores and no ring or volva. from Washington south through California to Baja California in Mexico. It forms ectomycorrhizal relationships and is found in association with coast live oak (<span class=\"foreignLanguage\">Quercus agrifolia</span>), as well as hazel (<span class=\"foreignLanguage\">Corylus</span> spp.). There is some evidence it may be the most toxic of all the North American phalloideae, as a higher proportion of people consuming it had organ damage and 40% perished.</p><p>Amatoxins consist of at least eight compounds with a similar structure, that of eight amino-acid rings; The liver is the principal organ affected, as it is the first organ encountered after absorption by the gastrointestinal tract, though other organs, especially the kidneys, are susceptible to the toxins.</p><p>The phallotoxins consist of at least seven compounds, all of which have seven similar peptide rings. Although they are highly toxic to liver cells, Renal failure (either secondary to severe hepatitis or caused by direct toxic renal damage</p></div><div><h3>=Treatment=</h3><p>Consumption of <span class=\"foreignLanguage\">A. ocreata</span> is a medical emergency that requires hospitalization. There are four main categories of therapy for poisoning: preliminary medical care, supportive measures, specific treatments, and liver transplantation. Supportive measures are directed towards treating the dehydration which results from fluid loss during the gastrointestinal phase of intoxication and correction of metabolic acidosis, hypoglycemia, electrolyte imbalances, and impaired coagulation. There is some evidence that intravenous silibinin, an extract from the blessed milk thistle (<span class=\"foreignLanguage\">Silybum marianum</span>), may be beneficial in reducing the effects of amatoxins, preventing their uptake by hepatocytes, thereby protecting undamaged hepatic tissue. In patients developing liver failure, a liver transplant is often the only option to prevent death. Liver transplants have become a well-established option in amatoxin poisoning. However, a follow-up study has shown that most survivors recover completely without any sequelae if treated within 36&nbsp;hours of mushroom ingestion.</p></div><div><h3>=Cited text=</h3><ul><li></li></ul></div>", "photos":[{"mushroomid":"Amanita_ocreata","img":"wiki\/amanita.ocreata1.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "deadly", "attributeId":"comestibilitat", "img":"comestibilitat_mortal.png", "name":"deadly"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring and volva", "attributeId":"vel", "img":"Ring_and_volva_stipe_icon.png", "name":"ring and volva"}]},{"id": "Farinera", "latinname":"Amanita ovoidea", "name":"Amanita ovoidea", "names":"The <span class=\"mushroomName\">European white egg</span> (<span class=\"foreignLanguage\"><span class=\"mushroomName\">Amanita ovoidea</span></span>), <span class=\"mushroomName\">Bearded Amanita</span> or <span class=\"mushroomName\">European Egg Amidella</span>, is a species of mushroom of the genus <span class=\"foreignLanguage\">Amanita</span> in the family <span class=\"foreignLanguage\">Amanitaceae</span>. It is a white-colored fungus tinged with cream. Native to Europe, it is found on plain land like grass or roads in mainly southern part of Europe. The species was first introduced in 1833 by Pierre Bulliard, a French physician and botanist, and Lucien Quélet, a French mycologist and naturalist.", "description":"<div><p>The <span class=\"mushroomName\">European white egg</span> (<span class=\"foreignLanguage\"><span class=\"mushroomName\">Amanita ovoidea</span></span>), <span class=\"mushroomName\">Bearded Amanita</span> or <span class=\"mushroomName\">European Egg Amidella</span>, is a species of mushroom of the genus <span class=\"foreignLanguage\">Amanita</span> in the family <span class=\"foreignLanguage\">Amanitaceae</span>. It is a white-colored fungus tinged with cream. Native to Europe, it is found on plain land like grass or roads in mainly southern part of Europe. The species was first introduced in 1833 by Pierre Bulliard, a French physician and botanist, and Lucien Quélet, a French mycologist and naturalist.</p></div><div><h3>Description</h3><p>The color of the mushroom is white to cream. The size is over 15 centimeters. The cap is 10 to 12 centimeters, smooth, fleshy, sticky, and convex to shield shaped. The color of the spores are white, cream, or yellowish. The stipe is thick, cylindrical, powdery, has a ring, and a has a volva. The lamellae are thick, rounded, broad and are attached to the stipe. The volva is large, tall, and fleshy. The mushroom is symbiotic. The gills are free and crowded. The spores are broadly elliptical and amyloid. The spore print is white.</p></div><div><h3>Distribution and status</h3><p><span class=\"foreignLanguage\">A. ovoidea</span> is found in coniferous forests, deciduous forests (notably under oaks), coastal regions, roadsides and grassy areas.</p><p>The species is in danger due to habitat loss, which is being caused by selective logging, human settlements and natural causes like acid rains, soil pollution. In southern France, some people were inflicted with acute renal insufficiency because they accidentally ate <span class=\"foreignLanguage\">A. proxima</span>, thinking it was this species. Other sources however, describe the mushroom as delicious. The conclusions were that the mushrooms were very healthy and should be eaten to fulfill nutritional needs.</p></div>", "photos":[{"mushroomid":"Farinera","img":"wiki\/farinera1.jpg"},{"mushroomid":"Farinera","img":"wiki\/farinera2.jpg"},{"mushroomid":"Farinera","img":"wiki\/farinera5.jpg"},{"mushroomid":"Farinera","img":"wiki\/farinera6.jpg"},{"mushroomid":"Farinera","img":"wiki\/farinera7.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "caution", "attributeId":"comestibilitat", "img":"comestibilitat_reserves.png", "name":"caution"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring and volva", "attributeId":"vel", "img":"Ring_and_volva_stipe_icon.png", "name":"ring and volva"}]},{"id": "Pixaca", "latinname":"Amanita pantherina", "name":"Amanita pantherina var. pantherina", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Amanita pantherina var. pantherina</span></span>, also known as the <span class=\"mushroomName\">panther cap</span> and <span class=\"mushroomName\">false blusher</span> due to its similarity to the true blusher <span class=\"foreignLanguage\">(Amanita rubescens)</span>, is a species of fungus found in Europe and Western Asia.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Amanita pantherina var. pantherina</span></span>, also known as the <span class=\"mushroomName\">panther cap</span> and <span class=\"mushroomName\">false blusher</span> due to its similarity to the true blusher <span class=\"foreignLanguage\">(Amanita rubescens)</span>, is a species of fungus found in Europe and Western Asia.</p></div><div><h3>Description</h3><ul><li><span class=\"mushroomName\">Cap</span>:  4 –  11&nbsp;cm wide, hemispheric at first, then  to plano-convex, deep brown to hazel-brown to pale ochraceous brown, densely distributed warts that are pure white to sordid cream, minutely verruculose, floccose, easily removable. Viscid when wet, with a short striate margin. The flesh is white, unchanging when injured.</li><li><span class=\"mushroomName\">Gills</span>: free, close to crowded, white becoming greyish, truncate.</li><li><span class=\"mushroomName\">Spores</span>: white in deposit, broadly ellipsoid to ellipsoid to elongate, infrequently globose. 8 —  12  ×  5.5 —  8 µm.</li><li><span class=\"mushroomName\">Stipe</span>: 5 –  14&nbsp;cm long × .6 –  2&nbsp;cm wide, subcyclindric, somewhat narrowing upward, white, becoming slightly tannish in age, stuffed then hollow, finely floccose becoming smooth above the ring, and with small appressed squamules or creamy floccose material below. The volva is white, becoming grey with age, forming one or sometimes two narrow hoop-like rings just above the bulbous base. The flesh is white, unchanging when injured.</li><li><span class=\"mushroomName\">Odour</span>: Unpleasant or like raw potatoes</li><li><span class=\"mushroomName\">Microscopic features</span>: Spores are 8-14 x 6-10 µm, smooth, elliptical and inamyloid.</li></ul><p>Other than the brownish cap with white warts, distinguishing features of <span class=\"foreignLanguage\">Amanita pantherina</span> include the collar-like roll of volval tissue at the top of the basal bulb, and the elliptical, inamyloid spores.</p></ul></div><div><h3>Habitat and distribution</h3><p>The panther cap is an uncommon mushroom, found in both deciduous, especially beech and, less frequently, coniferous woodland and rarely meadows throughout Europe, western Asia in late summer and autumn.</p><p>It is an ectomycorrhizal fungus, living in root symbiosis with a tree, deriving photosynthesised nutrients from it and providing soil nutrients in return.</p></div><div><h3>Biochemistry</h3><p><span class=\"foreignLanguage\">Amanita pantherina</span> contains the psychoactive compound muscimol, but is used as an entheogen much less often than the related <span class=\"foreignLanguage\">Amanita muscaria</span> because of the potentially dangerously higher levels of muscimol found in the mushroom.</p></div>", "photos":[{"mushroomid":"Pixaca","img":"wiki\/pixaca10.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca11.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca12.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca13.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca14.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca16.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca17.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca18.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca19.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca2.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca20.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca21.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca22.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca23.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca24.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca25.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca26.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca27.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca28.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca29.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca3.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca30.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca4.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca5.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca6.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca7.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca8.jpg"},{"mushroomid":"Pixaca","img":"wiki\/pixaca9.jpg"}], "attributes":[{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris", "attributeId":"color_peu", "img":"peu_gris.svg.png", "name":"gray"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring and volva", "attributeId":"vel", "img":"Ring_and_volva_stipe_icon.png", "name":"ring and volva"}]},{"id": "Sureny_fosc", "latinname":"Boletus aereus", "name":"Boletus aereus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus aereus</span></span> is a bolete, an edible mushroom frequently consumed in the Basque Country, Navarre, France and Italy. It is commonly known as <span class=\"mushroomName\">ontto beltza</span> in Basque, <span class=\"mushroomName\">porcino nero</span> in Italian, and <span class=\"mushroomName\">tête de nègre</span> (negro’s head) in French. As a member of the Boletaceae family, this mushroom has tubes and pores, instead of gills beneath its cap.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus aereus</span></span> is a bolete, an edible mushroom frequently consumed in the Basque Country, Navarre, France and Italy. It is commonly known as <span class=\"mushroomName\">ontto beltza</span> in Basque, <span class=\"mushroomName\">porcino nero</span> in Italian, and <span class=\"mushroomName\">tête de nègre</span> (negro’s head) in French. As a member of the Boletaceae family, this mushroom has tubes and pores, instead of gills beneath its cap.</p></div><div><h3>Taxonomy</h3><p>This species is classified in <span class=\"foreignLanguage\">Boletus</span> section <span class=\"foreignLanguage\">Boletus</span>, alongside its close relatives which include <span class=\"foreignLanguage\">Boletus edulis</span> and <span class=\"foreignLanguage\">Boletus pinophilus</span>. In 2008, a taxonomic revision of western North American populations initially thought to represent <span class=\"foreignLanguage\">Boletus aereus</span>, formally established them as a separate species, <span class=\"foreignLanguage\">Boletus regineus</span>.</p></div><div><h3>Description</h3><p>The height of this boletus is 15&ndash;25&nbsp;cm, broad at maturity; specimens of 40&nbsp;cm have been found in some cases. The cap is dark brown and the ringless stalk is 6&ndash;15&nbsp;cm high, usually shorter than the cap diameter. The pores are greyish white when young, then become yellow.</p></div><div><h3>Edibility</h3><p>It is well known in southern Europe for its culinary qualities, and is appreciated by some even above <span class=\"foreignLanguage\">Boletus edulis</span>. The similar Boletus regineus (the <span class=\"mushroomName\">Queen bolete</span>) is widely collected by both amateur and commercial collectors in California.</p></div>", "photos":[{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc10.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc13.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc14.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc15.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc16.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc17.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc18.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc2.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc3.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc4.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc5.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc6.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc7.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc8.jpg"},{"mushroomid":"Sureny_fosc","img":"wiki\/sureny.fosc9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro", "attributeId":"color_peu", "img":"peu_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_peu", "img":"peu_marro_clar.svg.png", "name":"light brown"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Cep_destiu", "latinname":"Boletus aestivalis", "name":"Boletus reticulatus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus reticulatus</span></span> (formerly known as <span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus aestivalis</span></span> (Paulet) Fr.), and commonly referred to as the <span class=\"mushroomName\">summer cep</span> is a basidiomycete fungus of the genus <span class=\"foreignLanguage\">Boletus</span>. It occurs in deciduous forests of Europe  where it forms a symbiotic mycorrhizal relationship with species of oak (<span class=\"foreignLanguage\">Quercus</span>). The fungus produces fruiting bodies in the summer months which are edible and popularly collected.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus reticulatus</span></span> (formerly known as <span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus aestivalis</span></span> (Paulet) Fr.), and commonly referred to as the <span class=\"mushroomName\">summer cep</span> is a basidiomycete fungus of the genus <span class=\"foreignLanguage\">Boletus</span>. It occurs in deciduous forests of Europe  where it forms a symbiotic mycorrhizal relationship with species of oak (<span class=\"foreignLanguage\">Quercus</span>). The fungus produces fruiting bodies in the summer months which are edible and popularly collected.</p><p>It was formally described by Jacob Christian Schäffer in 1774, which took precedence over <span class=\"foreignLanguage\">B. aestivalis</span> as described by Paulet in 1793.</p></div><div><h3>Description</h3><p>The summer cep's fruiting body is a mushroom with a swollen bulbous stem, and large convex cap. The cap is more or less round and usually up to 20(40) centimetres in diameter. It bears a velvety brown, rust to chocolate cuticle which when dry often cracks to reveal the white flesh underneath, giving the appearance of a net.</p><p>The darker, more uniform shade and the velvety feel of the cap are a key feature distinguishing this species as is the vagueness or total absence of a white edge to the cap margin as seen in <span class=\"foreignLanguage\">Boletus edulis</span>. The tubes and pores of the hymenium are initially white, darkening with age to pale yellow and finally brown. The stipe is central (up to 16(30)&nbsp;cm in height) and has a strongly marked reticulated pattern with a variable white to brown colour.</p><p>The flesh is white and thick and remains firm if yellowish as the mushroom ages, and is often attacked by insect larvae. Its odour is pleasant.</p><p>The summer cep is found in woods throughout Europe, after hot and humid weather, from the start of summer until the end of autumn. It is particularly common in the south and west of France.</p></div><div><h3>Edibility</h3><p>The summer cep, like most ceps, is edible and useful in cooking. However, its flesh is somewhat less firm than other ceps.</p></div><div><h3>Notes</h3><ul><li>This article contains translations from the French Wikipedia article.</li></div>", "photos":[{"mushroomid":"Cep_destiu","img":"wiki\/cep.destiu1.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Mataparent_radicant", "latinname":"Boletus albidus", "name":"Boletus radicans", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus radicans</span></span>, also known as the <span class=\"mushroomName\">rooting bolete</span> or <span class=\"mushroomName\">whitish bolete</span>, is a large, rare ectomycorrhizal fungus found in Europe under deciduous trees in summer and autumn. It has a pale buff or white cap, yellow pores and a stout stem, and stains blue when bruised or cut. It is bitter and inedible.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus radicans</span></span>, also known as the <span class=\"mushroomName\">rooting bolete</span> or <span class=\"mushroomName\">whitish bolete</span>, is a large, rare ectomycorrhizal fungus found in Europe under deciduous trees in summer and autumn. It has a pale buff or white cap, yellow pores and a stout stem, and stains blue when bruised or cut. It is bitter and inedible.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Boletus radicans</span> was first described by the pioneering South African-born mycologist Christian Hendrik Persoon in 1801. Its specific epithet is derived from the Latin <span class=\"foreignLanguage\">radic-</span> 'root'. <span class=\"foreignLanguage\">Boletus albidus</span> is a later synonym.</p></div><div><h3>Description</h3><p>The cap diameter ranges from 7.5&ndash;30&nbsp;cm (3&ndash;10&nbsp;in) across, and is usually dirty white or buff. Sometimes reminiscent of a large stone from a distance. Downy at first, but cracking at the centre later. Measuring 5&ndash;8&nbsp;cm (2&ndash;3¼&nbsp;in) tall by 3&ndash;4&nbsp;cm (1¼&ndash;1⅔&nbsp;in) wide, the stipe is usually (but not always) swollen, with a rooting base. The apex being bright lemon yellow, and fading below. There is a light straw coloured, sometimes absent reticulation at the top. The flesh is pale yellow, turning white in the cap, and pale blue in the stem when cut. The pores are lemon yellow, small and round, and bruise blue. The spore print is olivaceous walnut-brown.</p></div><div><h3>Distribution and habitat</h3><p>Appearing in summer and autumn, <span class=\"foreignLanguage\">Boletus radicans</span> grows with <span class=\"foreignLanguage\">Quercus</span> and <span class=\"foreignLanguage\">Fagus</span> species (Oak and Beech), and is sometimes found in fairly large numbers. Not too fussy, the species grows on both chalk and more acidic soils in southern England and is present elsewhere in Europe.</p></div><div><h3>Edibility</h3><p>The mushroom is not edible due to its bitterness. A study in 2012 on mushroom poisoning in Swtizerland by Katharina M. Schenk-Jaeger et al., (published in the European Journal of Internal Medicine 23 (2012) e85–e91) found Boletus radicans to be toxic as it caused several cases of severe poisoning.</p></div>", "photos":[{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant10.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant11.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant12.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant13.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant14.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant15.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant16.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant17.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant2.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant4.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant5.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant6.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant7.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant8.jpg"},{"mushroomid":"Mataparent_radicant","img":"wiki\/mataparent.radicant9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "groc", "attributeId":"color_peu", "img":"peu_groc.svg.png", "name":"yellow"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Mataparent_amarg", "latinname":"Boletus calopus", "name":"Boletus calopus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus calopus</span></span>, commonly known as the <span class=\"mushroomName\">bitter beech bolete</span> or <span class=\"mushroomName\">scarlet-stemmed bolete</span>,  is a fungus of the bolete family, found in Asia, Northern Europe and North America. Appearing in coniferous and deciduous woodland in summer and autumn, the stout fruit bodies are attractively coloured, with a beige to olive cap up to 15&nbsp;cm (6&nbsp;in) across, yellow pores, and a reddish stipe up to  long and  wide. The pale yellow flesh stains blue when broken or bruised.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus calopus</span></span>, commonly known as the <span class=\"mushroomName\">bitter beech bolete</span> or <span class=\"mushroomName\">scarlet-stemmed bolete</span>,  is a fungus of the bolete family, found in Asia, Northern Europe and North America. Appearing in coniferous and deciduous woodland in summer and autumn, the stout fruit bodies are attractively coloured, with a beige to olive cap up to 15&nbsp;cm (6&nbsp;in) across, yellow pores, and a reddish stipe up to  long and  wide. The pale yellow flesh stains blue when broken or bruised.</p><p>Christian Persoon first described <span class=\"foreignLanguage\">Boletus calopus</span> in 1801. Modern molecular phylogenetics shows that it is only distantly related to the type species of <span class=\"foreignLanguage\">Boletus</span> and will most likely be placed in a new genus after further study. <span class=\"foreignLanguage\">Boletus calopus</span> is not edible, rendered unpalatable by its intensely bitter taste, which does not disappear with cooking. Its red stipe distinguishes it from edible species such as <span class=\"foreignLanguage\">Boletus edulis</span>.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Boletus calopus</span> was originally published under the name <span class=\"foreignLanguage\">Boletus olivaceus</span> by Jacob Christian Schäffer in 1774, but this name is unavailable for use as it was later sanctioned for another species. Johann Friedrich Gmelin's 1792 synonym <span class=\"foreignLanguage\">Boletus lapidum</span> is also illegitimate. Christian Hendrik Persoon described the mushroom in 1801; its specific name is derived from the Greek <span class=\"foreignLanguage\">καλος/kalos</span> (\"pretty\") and <span class=\"foreignLanguage\">πους/pous</span> (\"foot\"), referring to its brightly coloured stipe. The German name, <span class=\"foreignLanguage\">Schönfußröhrling</span> or \"pretty-foot bolete\", is a literal translation. Alternate common names are scarlet-stemmed bolete and bitter beech bolete.</p><p>Other synonyms include binomials resulting from generic transfers to <span class=\"foreignLanguage\">Dictyopus</span> by Lucien Quélet in 1886, and <span class=\"foreignLanguage\">Tubiporus</span> by René Maire in 1937. <span class=\"foreignLanguage\">Boletus frustosus</span>, originally published as a distinct species by Wally Snell and Esther Dick in 1941, was later described as a variety of <span class=\"foreignLanguage\">B.&nbsp;calopus</span> by Orson K. Miller and Roy Watling in 1968. Estadès and Lannoy described the variety <span class=\"foreignLanguage\">ruforubraporus</span> and the form <span class=\"foreignLanguage\">ereticulatus</span> from Europe in 2001.</p><p>In his 1986 infrageneric classification of the genus <span class=\"foreignLanguage\">Boletus</span>, Rolf Singer placed <span class=\"foreignLanguage\">B.&nbsp;calopus</span> as the type species of the section <span class=\"foreignLanguage\">Calopodes</span>, which includes species characterised by having a whitish to yellowish flesh, bitter taste, and a blue staining reaction in the tube walls. Other species in section <span class=\"foreignLanguage\">Calopodes</span> include <span class=\"foreignLanguage\">B.&nbsp;radicans</span>, <span class=\"foreignLanguage\">B.&nbsp;inedulis</span>, <span class=\"foreignLanguage\">B.&nbsp;peckii</span>, and <span class=\"foreignLanguage\">B.&nbsp;pallidus</span>. Genetic analysis published in 2013 shows that <span class=\"foreignLanguage\">B.&nbsp;calopus</span> and many (but not all) red-pored boletes are part of a <span class=\"foreignLanguage\">dupainii</span> clade (named for <span class=\"foreignLanguage\">B.&nbsp;dupainii</span>), well-removed from the core group of the type species <span class=\"foreignLanguage\">B.&nbsp;edulis</span> and relatives within the Boletineae. This indicates that it needs to be placed in a new genus.</p></div><div><h3>Description</h3><p>Up to 15&nbsp;cm (6&nbsp;in) or rarely 20&nbsp;cm (8&nbsp;in) in diameter, the cap is beige to olive and initially almost globular before opening out to a hemispherical and then convex shape. The surface of the cap is smooth or has minute hairs, and sometimes develops cracks with age. The cap cuticle hangs over the cap margin. The pore surface is initially pale yellow before deepening to an olive-yellow in maturity, and quickly turns blue when it is injured. The pores, numbering one or two per millimetre, are circular when young but become more angular as the mushroom ages. The tubes are up to  deep.</p><p>The attractively coloured stipe is typically yellow above to pink-red below, with a straw-coloured network (reticulation) near the top or over the upper half; occasionally the entire stipe is reddish. It measures  long by  thick, and is either fairly equal in width throughout, or thicker towards the base. Sometimes, the reddish stipe colour of mature mushrooms or harvested specimens that are a few days old disappears completely, and is replaced with ochre-brown tones. The pale yellow flesh stains blue when broken, the discolouration spreading out from the damaged area. Its smell can be strong, and has been likened to ink. The spore print is olive to olive-brown. Spores are smooth and elliptical, measuring 13–19 by 5–6&nbsp;µm. The basidia (spore-bearing cells) are club-shaped, four-spored, and measure 30–38 by 9–12&nbsp;µm. The cystidia are club-shaped to spindle-shaped, hyaline, and measure 25–40 by 10–15&nbsp;µm.</p><p>Variety <span class=\"foreignLanguage\">frustosus</span> is morphologically similar to the main type, but its cap becomes areolate (marked out into small areas by cracks and crevices) in maturity. Its spores are slightly smaller too, measuring 11–15 by 4–5.5&nbsp;µm. In the European form <span class=\"foreignLanguage\">ereticulatus</span>, the reticulations on the upper stipe are replaced with fine reddish granules, while the variety <span class=\"foreignLanguage\">ruforubraporus</span> has pinkish-red pores.</p></div><div><h3>Similar species</h3><p>The overall colouration of <span class=\"foreignLanguage\">Boletus calopus</span>, with its pale cap, yellow pores and red stipe, is not shared with any other bolete. Large pale specimens resemble <span class=\"foreignLanguage\">Boletus luridus</span>, and the cap of <span class=\"foreignLanguage\">B.&nbsp;satanas</span> is a similar colour but this species has red pores. Fruit bodies in poor condition could be confused with <span class=\"foreignLanguage\">Xerocomellus chrysenteron</span> but the stipes of this species are not reticulated. Edible species such as <span class=\"foreignLanguage\">B.&nbsp;edulis</span> lack a red stipe. It closely resembles the similarly inedible <span class=\"foreignLanguage\">B.&nbsp;radicans</span>, which lacks the redness on the stipe. Like <span class=\"foreignLanguage\">B.&nbsp;calopus</span>, the western North American species <span class=\"foreignLanguage\">B.&nbsp;rubripes</span> also has a bitter taste, similarly coloured cap, and yellowish pores that bruise blue, but it lacks reticulation on its reddish stipe. Found in northwestern North America, <span class=\"foreignLanguage\">B.&nbsp;coniferarum</span> lacks reddish or pinkish colouration in its yellow reticulate stipe, and has a darker, olive-grey to deep brown cap.</p><p>Two eastern North American species, <span class=\"foreignLanguage\">B.&nbsp;inedulis</span> and <span class=\"foreignLanguage\">B.&nbsp;roseipes</span>, also have an appearance similar to <span class=\"foreignLanguage\">B.&nbsp;calopus</span>. <span class=\"foreignLanguage\">B.&nbsp;inedulis</span> produces smaller fruit bodies with a white to greyish-white cap, while <span class=\"foreignLanguage\">B.&nbsp;roseipes</span> associates solely with hemlock. <span class=\"foreignLanguage\">B.&nbsp;firmus</span>, found in the eastern United States, eastern Canada, and Costa Rica, has a pallid cap colour, reddish stipe, and bitter taste, but unlike <span class=\"foreignLanguage\">B.&nbsp;calopus</span>, has red pores and lacks stipe reticulation. <span class=\"foreignLanguage\">B.&nbsp;panniformis</span>, a Japanese species described as new to science in 2013, bears a resemblance to <span class=\"foreignLanguage\">B.&nbsp;calopus</span>, but can be distinguished by its rough cap surface, or microscopically by the amyloid-staining cells in the flesh of the cap, and morphologically distinct cystidia on the stipe.</p></div><div><h3>Distribution and habitat</h3><p>An ectomycorrhizal species, <span class=\"foreignLanguage\">Boletus calopus</span> grows in coniferous and deciduous woodland, often at higher altitudes, especially under beech and oak. Fruit bodies occur singly or in large groups. The species grows on chalky ground from July to December, in Northern Europe, and North America's Pacific Northwest and Michigan. In North America, its range extends south to Mexico. Variety <span class=\"foreignLanguage\">frustosus</span> is known from California and the Rocky Mountains of Idaho. In 1968, after comparing European and North American collections, Miller and Watling suggested that the typical form of <span class=\"foreignLanguage\">B.&nbsp;calopus</span> does not occur in the United States. Similar comparisons by other authors have led them to the opposite conclusion, and the species has since been included in several North American field guides. The bolete has been recorded from the Black Sea region in Turkey, from under <span class=\"foreignLanguage\">Populus ciliata</span> and <span class=\"foreignLanguage\">Abies pindrow</span> in Rawalpindi and Nathia Gali in Pakistan, Yunnan Province in China, Korea, and Taiwan.</p></div><div><h3>Toxicity</h3><p>Although it is an attractive-looking bolete, <span class=\"foreignLanguage\">Boletus calopus</span> is not considered edible on account of its very bitter taste, which does not disappear upon cooking. There are, however, reports of it being eaten in far eastern Russia as well as in Ukraine. The bitter taste is largely due to the compounds calopin and a δ-lactone derivative, <span class=\"foreignLanguage\">O</span>-acetylcyclocalopin&nbsp;A. These compounds contains a structural motif known as a 3-methylcatechol unit, which is rare in natural products. A total synthesis of calopin was reported in 2003.</p><p>The pulvinic acid derivatives atromentic acid, variegatic acid, and xerocomic acid are present in <span class=\"foreignLanguage\">B.&nbsp;calopus</span> mushrooms. These compounds inhibit cytochrome P450—major enzymes involved in drug metabolism and bioactivation.  Other compounds found in the fruit bodies include calopin&nbsp;B, and the novel sesquiterpenoid compounds cyclopinol and boletunones&nbsp;A and B. The latter two highly oxygenated compounds have significant free-radical scavenging activity <span class=\"foreignLanguage\">in vitro</span>. The compounds 3-octanone (47.0% of total volatile  compounds), 3-octanol (27.0%), 1-octen-3-ol (15.0%), and limonene (3.6%) are the predominant volatile components that give the fruit body its odour.</p></div>", "photos":[{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg10.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg11.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg12.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg13.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg14.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg15.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg16.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg2.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg20.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg21.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg22.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg3.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg4.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg5.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg6.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg7.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg8.jpg"},{"mushroomid":"Mataparent_amarg","img":"wiki\/mataparent.amarg9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "rosa", "attributeId":"color_peu", "img":"peu_rosa.svg.png", "name":"pink"},{"valueId": "vermell", "attributeId":"color_peu", "img":"peu_vermell.svg.png", "name":"red"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Cep_bolet", "latinname":"Boletus edulis", "name":"Boletus edulis", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus edulis</span></span>, commonly known as the <span class=\"mushroomName\">porcini</span> (as well as <span class=\"mushroomName\">penny bun</span>, <span class=\"mushroomName\">porcino</span> or <span class=\"mushroomName\">cep</span>), is a basidiomycete fungus, and the type species of the genus <span class=\"foreignLanguage\">Boletus</span>. Widely distributed in the Northern Hemisphere across Europe, Asia, and North America, it does not occur naturally in the Southern Hemisphere, although it has been introduced to southern Africa, Australia and New Zealand. Several closely related European mushrooms formerly thought to be varieties or forms of <span class=\"foreignLanguage\">B.&nbsp;edulis</span> have been shown using molecular phylogenetic analysis to be distinct species, and others previously classed as separate species are  with this species. The western North American species commonly known as the California king bolete (<span class=\"foreignLanguage\">Boletus edulis</span> var. <span class=\"foreignLanguage\">grandedulis</span>) is a large, darker-colored variant first formally identified in 2007.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus edulis</span></span>, commonly known as the <span class=\"mushroomName\">porcini</span> (as well as <span class=\"mushroomName\">penny bun</span>, <span class=\"mushroomName\">porcino</span> or <span class=\"mushroomName\">cep</span>), is a basidiomycete fungus, and the type species of the genus <span class=\"foreignLanguage\">Boletus</span>. Widely distributed in the Northern Hemisphere across Europe, Asia, and North America, it does not occur naturally in the Southern Hemisphere, although it has been introduced to southern Africa, Australia and New Zealand. Several closely related European mushrooms formerly thought to be varieties or forms of <span class=\"foreignLanguage\">B.&nbsp;edulis</span> have been shown using molecular phylogenetic analysis to be distinct species, and others previously classed as separate species are  with this species. The western North American species commonly known as the California king bolete (<span class=\"foreignLanguage\">Boletus edulis</span> var. <span class=\"foreignLanguage\">grandedulis</span>) is a large, darker-colored variant first formally identified in 2007.</p><p>The fungus grows in deciduous and coniferous forests and tree plantations, forming symbiotic ectomycorrhizal associations with living trees by enveloping the tree's underground roots with sheaths of fungal tissue. The fungus produces spore-bearing fruit bodies above ground in summer and autumn. The fruit body has a large brown cap which on occasion can reach  in diameter and  in weight. Like other boletes, it has tubes extending downward from the underside of the cap, rather than gills; spores escape at maturity through the tube openings, or pores. The pore surface of the <span class=\"foreignLanguage\">B.&nbsp;edulis</span> fruit body is whitish when young, but ages to a greenish-yellow. The stout stipe, or stem, is white or yellowish in colour, up to 25&nbsp;cm (10&nbsp;in) tall and  thick, and partially covered with a raised network pattern, or .</p><p>Prized as an ingredient in various foods, <span class=\"foreignLanguage\">B.&nbsp;edulis</span> is an edible mushroom held in high regard in many cuisines, and is commonly prepared and eaten in soups, pasta, or risotto. The mushroom is low in fat and digestible carbohydrates, and high in protein, vitamins, minerals and dietary fiber. Although it is sold commercially, it is very difficult to cultivate.  Available fresh in autumn in Central, Southern and Northern Europe, it is most often dried, packaged and distributed worldwide. Keeping its flavor after drying, it is then reconstituted and used in cooking. <span class=\"foreignLanguage\">B.&nbsp;edulis</span> is one of the few fungi sold pickled. The fungus also produces a variety of organic compounds with a diverse spectrum of biological activity, including the steroid derivative ergosterol, a sugar binding protein, antiviral compounds, antioxidants, and phytochelatins, which give the organism resistance to toxic heavy metals.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Boletus edulis</span> was first described in 1782 by the French botanist Pierre Bulliard and still bears its original name. Hence, the name no longer requires the ratification of Fries' authority. Early alternate names include <span class=\"foreignLanguage\">Boletus solidus</span> by English naturalist James Sowerby in 1809, and Gray's <span class=\"foreignLanguage\">Leccinum edule</span>.</p><p><span class=\"foreignLanguage\">B. edulis</span> is the type species of the genus <span class=\"foreignLanguage\">Boletus</span>. In Rolf Singer's classification of the Agaricales mushrooms, it is also the type species of section <span class=\"foreignLanguage\">Boletus</span>, a grouping of about 30 related boletes united by a number of characteristics: a mild-tasting, white flesh that does not change colour when exposed to air; a smooth to distinctly raised, netted pattern over at least the uppermost portion of the stem; a yellow-brown or olive-brown spore print; white tubes that later become yellowish then greenish, which initially appear to be stuffed with cotton; and cystidia that are not strongly coloured. Molecular analysis published in 1997 established that the bolete mushrooms are all derived from a common ancestor, and established the Boletales as an order separate from the Agaricales. Ultimately, this last word derives from <span class=\"foreignLanguage\">bōlos</span>/βῶλος \"lump\", \"clod\", and, metaphorically, \"mushroom\". is often identified as the much prized <span class=\"foreignLanguage\">Amanita caesarea</span>.</p></div><div><h3>=Common names=</h3><p>Common names for <span class=\"foreignLanguage\">B. edulis</span> vary by region. The standard Italian name <span class=\"foreignLanguage\">porcino</span> means \"piglet\" in Italian, and echoes the term <span class=\"foreignLanguage\">suilli</span>, literally \"hog mushrooms\", used by the Ancient Romans, and still surviving in Southern Italian words for this mushroom. The derivation has been ascribed to the resemblance of young fruit bodies to piglets, or to the fondness pigs have for eating them. It is also known as \"king bolete\". In Austria, it is called <span class=\"foreignLanguage\">Herrenpilz</span>, the \"gentlemen's mushroom\", Another Spanish name, <span class=\"foreignLanguage\">rodellon</span>, means \"small round boulder\", while the Dutch name <span class=\"foreignLanguage\">eekhoorntjesbrood</span> means \"squirrel's bread\". ultimately from the Latin <span class=\"foreignLanguage\">cippus</span> \"stake\". The French-born King Charles XIV John popularised <span class=\"foreignLanguage\">B.&nbsp;edulis</span> in Sweden after 1818, It is known as <span class=\"foreignLanguage\">hed tab tao</span>  in Thai. In youth, the pores are white and appear as if stuffed with cotton (which are actually mycelia); as they age, they change colour to yellow and later to brown. The spore print is olive brown. The flesh of the fruit body is white, thick and firm when young, but becomes somewhat spongy with age. When bruised or cut, it either does not change colour, or turns a very light brown or light red. A similarly sized specimen found in Poland in 2013 made international news.</p><p><span class=\"foreignLanguage\">B. edulis</span> is considered one of the safest wild mushrooms to pick for the table, as no poisonous species closely resemble it. <span class=\"foreignLanguage\">B.&nbsp;edulis</span> has pleurocystidia (cystidia located on the face of a pore) that are thin-walled, roughly spindle-shaped to ventricose, and measure 30–45 by 7–10&nbsp;µm; the \"stuffed\" feature of the hymenium is caused by cheilocystidia — cells found on the edges of the pores. other taxa formerly believed to be unique species or subspecies, such as <span class=\"foreignLanguage\">B.&nbsp;betulicola</span>, <span class=\"foreignLanguage\">B.&nbsp;chippewaensis</span>, <span class=\"foreignLanguage\">B.&nbsp;persoonii</span>, <span class=\"foreignLanguage\">B.&nbsp;quercicola</span> and <span class=\"foreignLanguage\">B.&nbsp;venturii</span>, are now known to be part of a <span class=\"foreignLanguage\">B.&nbsp;edulis</span> species complex with a wide morphological, ecological and geographic range, and that the genetic variability in this complex is low. It is lighter in colour than <span class=\"foreignLanguage\">B.&nbsp;edulis</span>, having a cream-coloured cap with pink tones; The California king bolete (<span class=\"foreignLanguage\">Boletus edulis var. grandedulis</span>) can reach massive proportions, and is distinguished from <span class=\"foreignLanguage\">B.&nbsp;edulis</span> by a mature pore surface that is brown to slightly reddish. The cap colour appears to be affected by the amount of light received during its development, and may range from white in young specimens grown under thick canopy, to dark-brown, red-brown or yellow brown in those specimens receiving more light. The spring king bolete (<span class=\"foreignLanguage\">Boletus rex-veris</span>), formerly considered a variety of <span class=\"foreignLanguage\">B.&nbsp;edulis</span> or <span class=\"foreignLanguage\">B.&nbsp;pinophilus</span>, is found throughout western North America. In contrast to <span class=\"foreignLanguage\">B.&nbsp;edulis</span>, <span class=\"foreignLanguage\">B.&nbsp;rex-veris</span> tends to fruit in clusters, and, as its common name suggests, appears in the spring. In northwestern Spain, they are common in scrublands dominated by the rock rose species <span class=\"foreignLanguage\">Cistus ladanifer</span> and <span class=\"foreignLanguage\">Halimium lasianthum</span>. It is well known from the Borgotaro area of Parma, Italy, and has PGI status there. The European distribution extends north to Scandinavia and south to southern Italy and Morocco. as well as in the Indian forests of Arunachal Pradesh.</p></div><div><h3>=Non-native introductions=</h3><p><span class=\"foreignLanguage\">Boletus edulis</span> grows in some areas where it is not believed to be indigenous. It is often found underneath oak and silver birch in Hagley Park in central Christchurch, New Zealand, where it is likely to have been introduced, It has been growing plentifully in association with pine forests in the southern KwaZulu-Natal Midlands in South Africa for more than 50 years and is believed to have been introduced with the import of pine trees. It also grows in pine plantations in neighboring Zimbabwe. A 2004 field study indicated that fruit body production is enhanced by an open and sunny wood habitat, removal of the litter layer on the forest floor appeared to have a negative effect on fruit body production, but previous studies reported contradictory results. A Lithuanian study conducted in 2001 concluded that the maximal daily growth rate of the cap (about 21&nbsp;mm or 0.8&nbsp;in) occurred when the relative air humidity was the greatest, and the fruit bodies ceased growing when the air humidity dropped below 40%. Factors most likely to inhibit the appearance of fruit bodies included prolonged drought, inadequate air and soil humidity, sudden decreases of night air temperatures, and the appearance of the first frost.</p></div><div><h3>=Mycorrhizal associations=</h3><p><span class=\"foreignLanguage\">Boletus edulis</span> is mycorrhizal—it is in a mutualistic relationship with the roots of plants (hosts), in which the fungus exchanges nitrogen and other nutrients extracted from the environment for fixed carbon from the host. Other benefits for the plant are evident: in the case of the Chinese Chestnut, the formation of mycorrhizae with <span class=\"foreignLanguage\">B.&nbsp;edulis</span> increases the ability of plant seedlings to resist water stress, and increases leaf succulence, leaf area, and water-holding ability.  The ectomycorrhizal fungi are then able to exchange nutrients with the plant, effectively expanding the root system of the host plant to the furthest reaches of the symbiont fungi. Mexican weeping pine, Coast Douglas-fir, and Virginia pine.</p><p>The mushroom has been noted to commonly co-occur with <span class=\"foreignLanguage\">Amanita muscaria</span> or <span class=\"foreignLanguage\">A.&nbsp;rubescens</span>, although it is unclear whether this is due to a biological association between the species, or because of similarities in growing season, habitat, and ecological requirements. A 2007 field study revealed little correlation between the abundance of fruit bodies and presence of its mycelia below ground, even when soil samples were taken from directly beneath the mushroom; the study concluded \"Factors triggering formation of mycorrhizae and fructification of porcini appear to be too complex to be simply explained on the basis of the amount of fungal mycelia in the soil.\" Phytochelatins are chelating agents, capable of forming multiple bonds with the metal; in this state, the metal cannot normally react with other elements or ions and is stored in a detoxified form in the mushroom tissue.</p></div><div><h3>=Pests and predators=</h3><p>The fruit bodies of <span class=\"foreignLanguage\">B.&nbsp;edulis</span> can be infected by the parasitic mould-like fungus <span class=\"foreignLanguage\">Hypomyces chrysospermus</span>, known as the bolete eater, which manifests itself as a white, yellow, or reddish-brown cottony layer over the surface of the mushroom. The mushroom is also used as a food source by several species of mushroom flies, An unidentified species of virus was reported to have infected specimens found in the Netherlands and in Italy; fruit bodies affected by the virus had relatively thick stems and small or no caps, leading to the name \"little-cap disease\".</p><p><span class=\"foreignLanguage\">Boletus edulis</span> is a food source for animals such as the banana slug <span class=\"foreignLanguage\">(Ariolimax columbianus)</span>, the Red Squirrel,</p></div><div><h3>Culinary uses</h3><p><span class=\"foreignLanguage\">Boletus edulis</span>, as its name implies, is an edible mushroom. Italian chef and restaurateur Antonio Carluccio has described it as representing \"the wild mushroom <span class=\"foreignLanguage\">par excellence</span>\", and hails it as the most rewarding of all fungi in the kitchen for its taste and versatility. The term <span class=\"foreignLanguage\">suilli</span> was also thought to encompass the related <span class=\"foreignLanguage\">Leccinum scabrum</span>. Caution should be exercised when collecting specimens from potentially polluted or contaminated sites, as several studies have shown that the fruit bodies can bioaccumulate toxic heavy metals like mercury, caesium and polonium. Bioaccumulated metals or radioactive fission decay products are like chemical signatures: chemical and radiochemical analysis can be used to identify the origin of imported specimens,</p><p>Porcini are sold fresh in markets in summer and autumn in Central and Southern Europe, and dried or canned at other times of the year, and distributed worldwide to countries where they are not otherwise found. Porcini risotto is a traditional Italian autumn dish. Porcini are a feature of many cuisines, including Provençal, They are used in soups and consumed blanched in salads in Thailand.</p></div><div><h3>=Dried=</h3><p><span class=\"foreignLanguage\">Boletus edulis</span> is well suited to drying—its flavour intensifies, it is easily reconstituted, and its resulting texture is pleasant. Reconstitution is done by soaking in hot, but not boiling, water for about twenty minutes; the water used is infused with the mushroom aroma and it too can be used in subsequent cooking. Dried porcini have more protein than most other commonly consumed vegetables apart from soybeans. However, some of this content is indigestible, though digestibility is improved with cooking. Another method is drying in an oven at  for two to three hours, then increasing the temperature to  until crisp or brittle. The drying process is known to induce the formation of various volatile substances that contribute to the mushroom's aroma. Chemical analysis has shown that the odour of the dried mushroom is a complex mixture of 53 volatile compounds. In autumn, the price of porcini in the Northern Hemisphere typically ranges between $20 and $80&nbsp;dollars per kilogram, although in New York in 1997, the scarcity of fruit bodies elevated the wholesale price to over $200 per kilogram.</p><p>After the fall of the Iron Curtain and the economic and political barriers that followed, central and eastern European countries with local mushroom harvesting traditions, such as Albania, Bulgaria, Macedonia, Romania, Serbia and Slovenia, developed into exporters of porcini, concentrating primarily on the Italian market. Unfortunately, a lack of control has led to heavy exploitation of the mushroom resource. The results of some studies suggest that unknown components of the soil microflora might be required for <span class=\"foreignLanguage\">B.&nbsp;edulis</span> to successfully establish a mycorrhizal relationship with the host plant. although reported values tend to differ somewhat as moisture content can be affected by environmental temperature and relative humidity during growth and storage, as well as the relative amount of water that may be produced as a result of normal metabolic processes during storage.</p><p>A comparative study of the amino acid composition of eleven Portuguese wild edible mushroom species showed <span class=\"foreignLanguage\">Boletus edulis</span> to have the highest total amino acid content, about 2.3&nbsp;g per 100&nbsp;g of dried mushroom. This total includes a full complement of 20 essential and nonessential amino acids.</p><p>Reported values of the composition and concentrations of trace metals and minerals in <span class=\"foreignLanguage\">Boletus edulis</span> tend to differ considerably, as the mushroom bioaccumulates different elements to varying degrees, and the element concentration in the fruit bodies is often a reflection of the element concentration of the soils from which they were picked. however, the bioavailability of mushroom-derived selenium is low.</p></div><div><h3>Bioactive compounds</h3><p><span class=\"foreignLanguage\">Boletus edulis</span> fruit bodies contain about 500&nbsp;mg of ergosterol per 100&nbsp;g of dried mushroom.</p><p>The mushroom also contains a sugar-binding protein, or lectin, that has affinity for the sugars xylose and melibiose. The lectin is mitogenic—that is, it can stimulate cells to begin the process of cell division, resulting in mitosis. Further, the lectin has antiviral properties: it inhibits the human immunodeficiency virus enzyme reverse transcriptase. and tobacco mosaic virus grown in culture.</p><p>The fruit bodies have a high antioxidative capacity, due probably to a combination of various organic acids (such as oxalic, citric, malic, succinic and fumaric acids), tocopherols, phenolic compounds Furthermore, fruit bodies were determined to have 528&nbsp;mg of the antioxidant compound ergothioneine per kilogram of fresh mushroom; this value was the highest among many food items tested in one study. but later investigations in the United States did not support this.</p></div><div><h3>=Cited texts=</h3><ul><li></li></ul></div>", "photos":[{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)10.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)11.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)12.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)13.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)14.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)15.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)16.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)17.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)18.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)19.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)2.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)20.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)21.jpeg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)22.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)23.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)25.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)26.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)27.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)28.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)29.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)3.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)30.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)31.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)32.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)33.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)34.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)35.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)36.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)37.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)38.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)39.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)4.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)40.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)41.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)42.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)43.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)44.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)45.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)46.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)47.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)48.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)49.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)5.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)50.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)51.jpeg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)52.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)53.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)54.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)56.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)57.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)58.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)59.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)6.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)60.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)61.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)62.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)63.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)64.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)65.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)66.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)67.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)68.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)69.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)7.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)70.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)71.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)72.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)73.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)74.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)75.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)8.jpg"},{"mushroomid":"Cep_bolet","img":"wiki\/cep.(bolet)9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Mataparent_de_cama_roja", "latinname":"Boletus erythropus", "name":"Boletus luridiformis", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus luridiformis</span></span>, formerly known as <span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus erythropus</span></span>, is a fungus of the bolete family, all of which produce mushrooms with tubes and pores beneath their caps. It is found in Northern Europe and North America, and is commonly known as the <span class=\"mushroomName\">dotted stem bolete</span>. Although edible when cooked, it can cause gastric upset when raw and can be confused where the two species coincide with the poisonous <span class=\"foreignLanguage\">Boletus satanas</span>, which has a paler cap.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus luridiformis</span></span>, formerly known as <span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus erythropus</span></span>, is a fungus of the bolete family, all of which produce mushrooms with tubes and pores beneath their caps. It is found in Northern Europe and North America, and is commonly known as the <span class=\"mushroomName\">dotted stem bolete</span>. Although edible when cooked, it can cause gastric upset when raw and can be confused where the two species coincide with the poisonous <span class=\"foreignLanguage\">Boletus satanas</span>, which has a paler cap.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Boletus luridiformis</span> was originally described by Christian Hendrik Persoon in 1796 as <span class=\"foreignLanguage\">Boletus erythropus</span> - a name since reduced to synonymy -  referring to its red coloured stalk. Its French name, bolet à pied rouge or 'red-foot bolete' is a literal translation.</p><p>Genetic analysis published in 2013 shows that <span class=\"foreignLanguage\">B. luridiformis</span> and many (but not all) red-pored boletes are part of a <span class=\"foreignLanguage\">dupainii</span> clade (named for <span class=\"foreignLanguage\">Boletus dupainii</span>), well-removed from the core group of <span class=\"foreignLanguage\">Boletus edulis</span> and relatives within the Boletineae. This indicates that it will most likely be placed in a new genus. It seems to prefer acid soils.</p></div><div><h3>Toxicity</h3><p>Mild tasting, <span class=\"foreignLanguage\">Boletus luridiformis</span> is edible after cooking, though caution is advised as it resembles other less edible blue-staining boletes, and should thus be avoided by novice mushroom hunters. </p></div>", "photos":[{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja1.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja10.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja11.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja12.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja13.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja14.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja15.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja16.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja18.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja19.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja2.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja20.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja21.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja3.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja4.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja5.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja6.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja7.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja8.jpg"},{"mushroomid":"Mataparent_de_cama_roja","img":"wiki\/mataparent.de.cama.roja9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "rosa", "attributeId":"color_peu", "img":"peu_rosa.svg.png", "name":"pink"},{"valueId": "vermell", "attributeId":"color_peu", "img":"peu_vermell.svg.png", "name":"red"},{"valueId": "caution", "attributeId":"comestibilitat", "img":"comestibilitat_reserves.png", "name":"caution"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Mataparent_de_cama_amb_olor_de_tinta", "latinname":"Boletus impolitus", "name":"Boletus impolitus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus impolitus</span></span>, is a basidiomycete fungus of the Boletaceae family, that has tubes and pores instead of gills. These pores can be seen under the cap as tiny holes. It is edible, but rare, and should not be picked for the table. It grows beneath <span class=\"foreignLanguage\">Quercus</span> (oak) trees. It is commonly called the <span class=\"mushroomName\">iodine bolete</span>, because of its smell when cut.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus impolitus</span></span>, is a basidiomycete fungus of the Boletaceae family, that has tubes and pores instead of gills. These pores can be seen under the cap as tiny holes. It is edible, but rare, and should not be picked for the table. It grows beneath <span class=\"foreignLanguage\">Quercus</span> (oak) trees. It is commonly called the <span class=\"mushroomName\">iodine bolete</span>, because of its smell when cut.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Impolitus</span> is Latin, meaning \"unpolished\", \"matt\", \"unsmoothed\", or \"unfinished\", and may be a reference to the hammered look of some specimens. It was first described by Elias Magnus Fries, an eminent mycologist of the 19th century.</p></div><div><h3>Description</h3><p>The cap is at first hemispherical, but flattens with age, and is sometimes upturned when mature. It is pale brown,light tan, or tawny, often with a pale grey hoariness initially. The <span class=\"mushroomName\">pores</span> and <span class=\"mushroomName\">tubes</span> are pale yellow, with the <span class=\"mushroomName\">pores</span> being small and round, and they do 'not'  bruise blue. The <span class=\"mushroomName\">flesh</span> is pale yellow, and remains the same colour when cut. It is soft and has a sour smell somewhat like iodine in the base. The spore print is olivaceous walnut-brown.</p></div><div><h3>=Similar species=</h3><ul><li><span class=\"foreignLanguage\">Boletus radicans</span> is very similar, and can also be found with oak. It has a whiter cap, but its pores bruise blue when damaged. It is inedible.</li><li>The bitter and inedible <span class=\"foreignLanguage\">B. calopus</span> has a well-defined network (reticulation), and is redder on the lower part of its stem.</li></ul></div><div><h3>Distribution and habitat</h3><p>This species is mycorrhizal with oak (<span class=\"foreignLanguage\">Quercus</span>), and occasional in Southern England. In mainland Europe it is found with oaks and hornbeams (<span class=\"foreignLanguage\">Carpinus</span>) on chalky soils, and has been found under pines (<span class=\"foreignLanguage\">Pinus</span>) . In Southern England it can appear in two or three flushes from June till September, depending on weather conditions.</p></div><div><h3>Edibility</h3><p><span class=\"foreignLanguage\">Boletus impolitus</span> is typically considered inedible.  Some report it as mild, but should be left in the interests of conservation.</p></div>", "photos":[{"mushroomid":"Mataparent_de_cama_amb_olor_de_tinta","img":"wiki\/mataparent.de.cama.amb.olor.de.tinta1.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "groc", "attributeId":"color_capell", "img":"capell_groc.svg.png", "name":"yellow"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "groc", "attributeId":"color_peu", "img":"peu_groc.svg.png", "name":"yellow"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Boletus_pinicola", "latinname":"Boletus pinophilus", "name":"Boletus pinophilus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus pinophilus</span></span>, commonly known as the <span class=\"mushroomName\">pine bolete</span> or <span class=\"mushroomName\">pinewood king bolete</span>, is a basidiomycete fungus of the genus <span class=\"foreignLanguage\">Boletus</span> found throughout Europe. The large, edible fruiting bodies known as mushrooms appear under pine trees, generally in summer and autumn. It has a matte brown to maroon-coloured cap and its stem is often large and swollen, and the overall colour may have an orange-red tinge. As with other boletes, the size of the fruiting body is variable. <span class=\"foreignLanguage\">Boletus pinophilus</span> is edible, and may be preserved and cooked.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus pinophilus</span></span>, commonly known as the <span class=\"mushroomName\">pine bolete</span> or <span class=\"mushroomName\">pinewood king bolete</span>, is a basidiomycete fungus of the genus <span class=\"foreignLanguage\">Boletus</span> found throughout Europe. The large, edible fruiting bodies known as mushrooms appear under pine trees, generally in summer and autumn. It has a matte brown to maroon-coloured cap and its stem is often large and swollen, and the overall colour may have an orange-red tinge. As with other boletes, the size of the fruiting body is variable. <span class=\"foreignLanguage\">Boletus pinophilus</span> is edible, and may be preserved and cooked.</p><p>For many years, <span class=\"foreignLanguage\">Boletus pinophilus</span> was considered a subspecies or form of the porcini mushroom <span class=\"foreignLanguage\">B.&nbsp;edulis</span>. In 2008, <span class=\"foreignLanguage\">B.&nbsp;pinophilus</span> in western North America were reclassified as a new species, <span class=\"foreignLanguage\">Boletus rex-veris</span>.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Boletus pinophilus</span> was for many years considered a variety of <span class=\"foreignLanguage\">Boletus edulis</span>, and before that as <span class=\"foreignLanguage\">Boletus pinicola</span>. This species, while no longer treated as a variety of <span class=\"foreignLanguage\">B.&nbsp;edulis</span>, is classified in <span class=\"foreignLanguage\">Boletus</span> section <span class=\"foreignLanguage\">Boletus</span>, and hence, as a close relative of <span class=\"foreignLanguage\">B.&nbsp;edulis</span>. and Ancient Greek <span class=\"foreignLanguage\">philus</span> \"loving\". and the pinewood king bolete.</p><p>In 2008, a taxonomic revision of western North American populations of this species was published, formally establishing it as a distinct species, <span class=\"foreignLanguage\">Boletus rex-veris</span>.  Phylogenetic analysis has shown <span class=\"foreignLanguage\">B.&nbsp;pinophilus</span> as a member of a clade, or closely related group, with the North American species <span class=\"foreignLanguage\">B.&nbsp;subcaerulescens</span>, <span class=\"foreignLanguage\">Gastroboletus subalpinus</span>, <span class=\"foreignLanguage\">B.&nbsp;regineus</span>, <span class=\"foreignLanguage\">B.&nbsp;fibrillosus</span>, and <span class=\"foreignLanguage\">B.&nbsp;rex-veris</span>.</p></div><div><h3>Distribution and habitat</h3><p>In Europe, <span class=\"foreignLanguage\">Boletus pinophilus</span> is found in Britain, It is sold commercially in Finland. preferring the poor, acidic, and sandy soils associated with coniferous forests. It appears to favour <span class=\"foreignLanguage\">Pinus</span>, while the form of the mushroom occurring in association with <span class=\"foreignLanguage\">Abies</span> and <span class=\"foreignLanguage\">Picea</span> has been labeled <span class=\"foreignLanguage\">Boletus pinophilus</span> var. <span class=\"foreignLanguage\">fuscoruber</span>.</p></div><div><h3>Edibility</h3><p>The <span class=\"foreignLanguage\">Boletus pinophilus</span> is edible, and may be used fresh, preserved, dried and cooked in a manner similar to that of other edible boletes.</p><p><span class=\"foreignLanguage\">Boletus pinophilus</span> is known to be a bioaccumulator of the heavy metal mercury. To reduce exposure, authorities recommend avoiding mushrooms from polluted areas such as those near mines, smelters, roadways, incinerators and disposal sites. Furthermore, pores should be removed as they contain the highest concentrations of pollutants.</p></div>", "photos":[{"mushroomid":"Boletus_pinicola","img":"wiki\/boletus.pinicola2.jpg"},{"mushroomid":"Boletus_pinicola","img":"wiki\/boletus.pinicola5.jpg"},{"mushroomid":"Boletus_pinicola","img":"wiki\/boletus.pinicola6.jpg"},{"mushroomid":"Boletus_pinicola","img":"wiki\/boletus.pinicola7.jpg"},{"mushroomid":"Boletus_pinicola","img":"wiki\/boletus.pinicola8.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Mataparent_de_cama_bleda-rave", "latinname":"Boletus queletii", "name":"Boletus queletii", "names":"<span class=\"mushroomName\">Boletus queletii</span> otherwise known as  the <span class=\"mushroomName\">deceiving bolete</span>, is an uncommon, edible mushroom in the genus Boletus. It can be found in deciduous forest, at lower altitudes, mostly under beech.", "description":"<div><p><span class=\"mushroomName\">Boletus queletii</span> otherwise known as  the <span class=\"mushroomName\">deceiving bolete</span>, is an uncommon, edible mushroom in the genus Boletus. It can be found in deciduous forest, at lower altitudes, mostly under beech.</p></div><div><h3>Description</h3><p>The cap is hemispherical, latter flattening out, appearing olive to reddish-brown, rarely also dark red. The flesh is yellow, turning blue when cut. The pores are yellow with olive spores. The stem is smooth and golden yellow. The flesh has a slightly acrid taste.</p></div>", "photos":[{"mushroomid":"Mataparent_de_cama_bleda-rave","img":"wiki\/mataparent.de.cama.bleda-rave2.jpg"},{"mushroomid":"Mataparent_de_cama_bleda-rave","img":"wiki\/mataparent.de.cama.bleda-rave3.jpg"},{"mushroomid":"Mataparent_de_cama_bleda-rave","img":"wiki\/mataparent.de.cama.bleda-rave4.jpg"},{"mushroomid":"Mataparent_de_cama_bleda-rave","img":"wiki\/mataparent.de.cama.bleda-rave5.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "groc", "attributeId":"color_peu", "img":"peu_groc.svg.png", "name":"yellow"},{"valueId": "caution", "attributeId":"comestibilitat", "img":"comestibilitat_reserves.png", "name":"caution"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Mataparent", "latinname":"Boletus satanas", "name":"Boletus satanas", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus satanas</span></span>, commonly known as the <span class=\"mushroomName\">Devil's bolete</span> or <span class=\"mushroomName\">Satan's mushroom</span>, is a basidiomycete fungus of the bolete family. Found on chalky soil in mixed woodlands in the southern, warmer regions of Europe and North America, it is generally regarded as a poisonous mushroom, with predominantly gastrointestinal symptoms of nausea and violent vomiting occurring if eaten raw or fried. However, reports of poisoning are rare due to its odd appearance and at times putrid smell minimising casual experimentation. There are reports of its traditional consumption in the former Czechoslovakia, Italy and San Francisco Bay Area after thorough cooking (frying does not remove the toxin).", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Boletus satanas</span></span>, commonly known as the <span class=\"mushroomName\">Devil's bolete</span> or <span class=\"mushroomName\">Satan's mushroom</span>, is a basidiomycete fungus of the bolete family. Found on chalky soil in mixed woodlands in the southern, warmer regions of Europe and North America, it is generally regarded as a poisonous mushroom, with predominantly gastrointestinal symptoms of nausea and violent vomiting occurring if eaten raw or fried. However, reports of poisoning are rare due to its odd appearance and at times putrid smell minimising casual experimentation. There are reports of its traditional consumption in the former Czechoslovakia, Italy and San Francisco Bay Area after thorough cooking (frying does not remove the toxin).</p><p>The squat, brightly coloured fruiting bodies are large and imposing, with a pale dull-coloured velvety cap up to  wide, blood red pores and bulbous red-patterned stalk. The flesh turns blue when cut or bruised. There is a smell of carrion, more noticeable with age. It is the largest bolete growing in Europe.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Boletus satanas</span> was described by German mycologist Harald Othmar Lenz in 1831, who gave it its sinister name,  <span class=\"foreignLanguage\">satanas</span> 'of Satan', derived from Hebrew via Ancient Greek, American mycologist Harry D. Thiers concluded that material from North America matches the species description, although some authorities have questioned this.</p><p>Both it and <span class=\"foreignLanguage\">Boletus luridus</span> are known as <span class=\"foreignLanguage\">ayimantari</span> 'bear mushroom' in Eastern Turkey.</p></div><div><h3>=Similar species=</h3><p>The Devil's bolete can be confused with other boletes such as:</p><ul><li><span class=\"foreignLanguage\">B. erythropus</span></li><li><span class=\"foreignLanguage\">B. calopus</span></li><li><span class=\"foreignLanguage\">B. luridus</span></li><li><span class=\"foreignLanguage\">B. rhodoxanthus</span></li><li><span class=\"foreignLanguage\">B. legaliae</span> (= <span class=\"foreignLanguage\">B. splendidus</span>)</li><li><span class=\"foreignLanguage\">B. torosus</span></li></ul></div><div><h3>Distribution and habitat</h3><p>The Devil's bolete is found in the entire temperate zone, but in Europe it definitely occurs more in southern regions. It is only found in the south of England. as well as the Bar'am Forest in the Upper Galilee in northern Israel. It has been recorded from coastal areas of California, with a possible record from the southeastern US, and could feasibly occur in the Pacific Northwest.</p><p>Muscarine has been isolated from fruiting bodies, but the quantities are believed to be far too small to account for its toxic effects. Bolesatine is a protein synthesis inhibitor, and, when given to mice, causes hepatic blood stasis and thrombosis.</p></div>", "photos":[{"mushroomid":"Mataparent","img":"wiki\/mataparent2.jpg"},{"mushroomid":"Mataparent","img":"wiki\/mataparent4.jpg"},{"mushroomid":"Mataparent","img":"wiki\/mataparent5.jpg"},{"mushroomid":"Mataparent","img":"wiki\/mataparent6.jpg"},{"mushroomid":"Mataparent","img":"wiki\/mataparent7.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "vermell", "attributeId":"color_peu", "img":"peu_vermell.svg.png", "name":"red"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Conocybe", "latinname":"Conocybe", "name":"Conocybe", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Conocybe</span></span> is a genus of mushrooms with <span class=\"foreignLanguage\">Conocybe tenera</span> as the type species and at least 243 other species. There are at least 50 different species in North America. ", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Conocybe</span></span> is a genus of mushrooms with <span class=\"foreignLanguage\">Conocybe tenera</span> as the type species and at least 243 other species. There are at least 50 different species in North America. </p><p>Most have a long, thin fragile stipe and are delicate, growing in grasslands on dead moss, dead grass, sand dunes, decayed wood, and dung. <span class=\"foreignLanguage\">Conocybe</span> species generally prefer fertile soils in lawns and pastures and are found worldwide. Conocybes are sometimes called dunce caps or cone heads  due to their conical or bell-shaped caps.  Species of <span class=\"foreignLanguage\">Conocybe</span> that have a well-developed partial veil are placed in the subgenus <span class=\"foreignLanguage\">Pholiotina</span>.   Similar to <span class=\"foreignLanguage\">Galerina</span>, a <span class=\"foreignLanguage\">Conocybe</span> species can be distinguished microscopically by its cellular cap cuticle, which is filamentous (thread-like) in <span class=\"foreignLanguage\">Galerina</span>.  It is easy to confuse <span class=\"foreignLanguage\">Conocybe</span> species for <span class=\"foreignLanguage\">Galerina</span> unless the microscopic nature of the cap cuticle is examined.  Conocybes have cap cuticles resembling cobblestones.  Conocybes can also be mistaken for species of <span class=\"foreignLanguage\">Bolbitius</span>. </p><p>Four species of <span class=\"foreignLanguage\">Conocybe</span> that are known to contain the hallucinogenic compounds psilocin and psilocybin are <span class=\"foreignLanguage\">C.&nbsp;kuehneriana</span>, <span class=\"foreignLanguage\">C.&nbsp;siligineoides</span>, <span class=\"foreignLanguage\">C.&nbsp;cyanopus</span>, and <span class=\"foreignLanguage\">C.&nbsp;smithii</span>. <span class=\"foreignLanguage\">Conocybe siligineoide</span> was used for shamanic purposes by the Mazatecs of Oaxaca.</p><p><span class=\"foreignLanguage\">Conocybe filaris</span> is a common lawn mushroom that contains the same deadly toxins as the death cap.</p><p><span class=\"foreignLanguage\">Conocybe</span> comes from the Greek <span class=\"foreignLanguage\">cono</span> meaning <span class=\"foreignLanguage\">cone</span> and <span class=\"foreignLanguage\">cybe</span> meaning <span class=\"foreignLanguage\">head</span>.</p></div><div><h3>Selected species</h3><ul><li><span class=\"foreignLanguage\">Conocybe apala</span> (very common)</li><li><span class=\"foreignLanguage\">Conocybe cyanopus</span> (psychoactive)</li><li><span class=\"foreignLanguage\">Conocybe elegans</span></li><li><span class=\"foreignLanguage\">Conocybe filaris</span> (deadly)</li><li><span class=\"foreignLanguage\">Conocybe kuehneriana</span> (psychoactive)</li><li><span class=\"foreignLanguage\">Conocybe reticulata</span></li><li><span class=\"foreignLanguage\">Conocybe rickenii</span></li><li><span class=\"foreignLanguage\">Conocybe siligineoides</span> (psychoactive)</li><li><span class=\"foreignLanguage\">Conocybe smithii</span> (psychoactive)</li><li><span class=\"foreignLanguage\">Conocybe tenera</span> (type species)</li><li><span class=\"foreignLanguage\">Conocybe volviradicata</span></li></ul></div>", "photos":[{"mushroomid":"Conocybe","img":"wiki\/conocybe1.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe10.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe11.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe12.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe13.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe14.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe15.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe16.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe2.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe3.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe4.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe5.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe6.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe7.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe8.jpg"},{"mushroomid":"Conocybe","img":"wiki\/conocybe9.jpg"}], "attributes":[{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "marro_clar", "attributeId":"color_peu", "img":"peu_marro_clar.svg.png", "name":"light brown"}]},{"id": "Coprinus_picaceus", "latinname":"Coprinopsis picacea", "name":"Coprinopsis picacea", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Coprinopsis picacea</span></span> is a species of fungus in the Psathyrellaceae. It is commonly called <span class=\"mushroomName\">Magpie Fungus</span>. It is native to Britain. It was first described in 1785 by French mycologist Jean Baptiste François Pierre Bulliard in 1785 as <span class=\"foreignLanguage\">Agaricus picaceus</span>.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Coprinopsis picacea</span></span> is a species of fungus in the Psathyrellaceae. It is commonly called <span class=\"mushroomName\">Magpie Fungus</span>. It is native to Britain. It was first described in 1785 by French mycologist Jean Baptiste François Pierre Bulliard in 1785 as <span class=\"foreignLanguage\">Agaricus picaceus</span>.</p><p>This poisonous species can sometimes be confused with the edible <span class=\"foreignLanguage\">Coprinus comatus</span>.</p></div>", "photos":[{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus10.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus11.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus12.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus13.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus14.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus15.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus16.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus17.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus18.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus19.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus2.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus20.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus21.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus22.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus3.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus4.jpeg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus5.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus6.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus7.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus8.jpg"},{"mushroomid":"Coprinus_picaceus","img":"wiki\/coprinus.picaceus9.jpg"}], "attributes":[{"valueId": "conical", "attributeId":"capell", "img":"Conical_cap_icon.svg.png", "name":"conical"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "negre", "attributeId":"color_capell", "img":"capell_negre.svg.png", "name":"black"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Bolet_de_tinta", "latinname":"Coprinus comatus", "name":"Coprinus comatus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Coprinus comatus</span></span>, the <span class=\"mushroomName\">shaggy ink cap</span>, <span class=\"mushroomName\">lawyer's wig</span>, or <span class=\"mushroomName\">shaggy mane</span>, is a common fungus often seen growing on lawns, along gravel roads and waste areas. The young fruit bodies first appear as white cylinders emerging from the ground, then the bell-shaped caps open out. The caps are white, and covered with scales—this is the origin of the common names of the fungus. The gills beneath the cap are white, then pink, then turn black and secrete a black liquid filled with spores (hence the “ink cap” name). This mushroom is unusual because it will turn black and dissolve itself in a matter of hours after being picked or depositing spores.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Coprinus comatus</span></span>, the <span class=\"mushroomName\">shaggy ink cap</span>, <span class=\"mushroomName\">lawyer's wig</span>, or <span class=\"mushroomName\">shaggy mane</span>, is a common fungus often seen growing on lawns, along gravel roads and waste areas. The young fruit bodies first appear as white cylinders emerging from the ground, then the bell-shaped caps open out. The caps are white, and covered with scales—this is the origin of the common names of the fungus. The gills beneath the cap are white, then pink, then turn black and secrete a black liquid filled with spores (hence the “ink cap” name). This mushroom is unusual because it will turn black and dissolve itself in a matter of hours after being picked or depositing spores.</p><p>When young it is an excellent edible mushroom provided that it is eaten soon after being collected (it keeps very badly because of the autodigestion of its gills and cap). If long-term storage is desired, microwaving, sauteing or simmering until limp will allow the mushrooms to be stored in a refrigerator for several days or frozen.   Processing must be done whether for eating or storage within four to six hours of harvest to prevent undesirable changes to the mushroom. The species is cultivated in China as food. The mushroom can sometimes be confused with the Magpie fungus which is poisonous.</p></div><div><h3>Taxonomy</h3><p>The shaggy ink cap was first described by Danish naturalist Otto Friedrich Müller in 1780 as <span class=\"foreignLanguage\">Agaricus comatus</span>, before being given its current binomial name in 1797 by Christiaan Hendrik Persoon. Its specific name derives from <span class=\"foreignLanguage\">coma</span>, or \"hair\", hence <span class=\"foreignLanguage\">comatus</span>, \"hairy\" or \"shaggy\". <span class=\"foreignLanguage\">Coprinus comatus</span> is the best known of the true <span class=\"foreignLanguage\">Coprinus</span>.</p></div><div><h3>Description</h3><p>The shaggy ink cap is easily recognizable from its almost cylindical cap which initially covers most of its stem. The cap is mostly white with shaggy scales, which are more pale brown at the apex. The free gills change rapidly from white to pink, then to black. It is deliquescent. The stipe has a loose ring and measures  high by  diameter. Microscopically it lacks pleurocystidia. The spore print is black-brown and the spores  measure 10–13 by 6.5–8&nbsp;µm. The flesh is white and the taste mild.</p><p><span class=\"foreignLanguage\">Coprinus comatus</span> is a nematophagous fungus capable of killing and digesting the nematode species <span class=\"foreignLanguage\">Panagrellus redivivus</span> and <span class=\"foreignLanguage\">Meloidogyne arenaria</span>.</p></div><div><h3>Edibility</h3><p>The young mushrooms, before the gills start to turn black, are edible. The taste is mild; cooking produces a large quantity of liquid.  It can sometimes be used in mushroom soup with parasol mushroom.  Large quantities of microwaved-then-frozen shaggy manes are delicious when used as the liquid component of risotto, replacing the usual chicken stock.</p><p>The agent responsible for unpleasant symptoms when consumed with alcohol, coprine, which is found in <span class=\"foreignLanguage\">Coprinopsis atramentaria</span>, has not been isolated from <span class=\"foreignLanguage\">C.&nbsp;comatus</span>.</p></div>", "photos":[{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta10.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta12.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta13.jpeg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta14.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta15.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta16.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta17.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta18.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta19.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta2.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta20.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta21.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta22.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta23.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta24.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta25.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta26.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta27.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta28.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta29.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta3.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta30.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta31.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta32.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta33.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta34.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta35.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta38.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta39.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta4.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta40.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta5.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta6.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta7.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta8.jpg"},{"mushroomid":"Bolet_de_tinta","img":"wiki\/bolet.de.tinta9.jpg"}], "attributes":[{"valueId": "conical", "attributeId":"capell", "img":"Conical_cap_icon.svg.png", "name":"conical"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Cortinari_rutilant", "latinname":"Cortinarius orellanus", "name":"lethal webcaps", "names":"The <span class=\"mushroomName\">Lethal webcaps</span>, two species in the genus <span class=\"foreignLanguage\">Cortinarius</span>, are two of the world's most poisonous mushrooms. The species are the <span class=\"mushroomName\">Deadly webcap</span> (<span class=\"foreignLanguage\">Cortinarius rubellus</span>, formerly also known as <span class=\"foreignLanguage\">C. speciosissimus</span>) and the <span class=\"mushroomName\">Fool's webcap</span>, <span class=\"foreignLanguage\">C. orellanus</span>.", "description":"<div><p>The <span class=\"mushroomName\">Lethal webcaps</span>, two species in the genus <span class=\"foreignLanguage\">Cortinarius</span>, are two of the world's most poisonous mushrooms. The species are the <span class=\"mushroomName\">Deadly webcap</span> (<span class=\"foreignLanguage\">Cortinarius rubellus</span>, formerly also known as <span class=\"foreignLanguage\">C. speciosissimus</span>) and the <span class=\"mushroomName\">Fool's webcap</span>, <span class=\"foreignLanguage\">C. orellanus</span>.</p><p>The mushrooms' characteristics are quite common, making them difficult to identify, which often leads to fatal poisonings. Young examples of the species often have a veil between the cap of the mushroom and the stem. This veil looks like a cobweb, hence the name. The veil however partially or completely disappears in older specimens. Some other characteristics for each of the mushrooms are given below.</p></div><div><h3>=Deadly webcap <span class=\"foreignLanguage\">(Cortinarius rubellus)</span>=</h3><p><span class=\"foreignLanguage\">Spore color</span>: Rusty brown to orange<br/></p><p><span class=\"foreignLanguage\">Cap</span>: 3&ndash;7&nbsp;cm rusty brown to orange. Often has a steeper and darker colored elevation at the top of the cap, but this varies greatly from specimen to specimen<br/></p><p><span class=\"foreignLanguage\">Gills</span>: Wide gaps between the gills which can be, but are not necessarily, connected to the stem<br/></p><p><span class=\"foreignLanguage\">Location</span>: Rare, but common in temperate parts of northern Europe. Has been encountered as far north as Finnish Lapland.<br/></p><p><span class=\"foreignLanguage\">Habitat</span>: Pine woods with acidic soil<br/></p><p><span class=\"foreignLanguage\">Other details</span>: Young specimens contain a pale web between the cap and the stem. Sometimes parts of this web can be seen as a yellow ring on the stem or at the edge of the cap. The fruiting body of the mushroom blossoms from mid-summer to late autumn.</p></div><div><h3>=Fool's webcap <span class=\"foreignLanguage\">(Cortinarius orellanus)</span>=</h3><p><span class=\"foreignLanguage\">Spore color</span>: Rusty brown to orange<br/></p><p><span class=\"foreignLanguage\">Cap</span>: 3–8.5&nbsp;cm, concave<br/></p><p><span class=\"foreignLanguage\">Gills</span>: Similar to those of the deadly webcap<br/></p><p><span class=\"foreignLanguage\">Location</span>: Common throughout Europe, rare in the northern parts of Europe. Has been observed as far north as southern Norway<br/></p><p><span class=\"foreignLanguage\">Habitat</span>: In forests, around trees where the soil is alkaline or acidic<br/></p><p><span class=\"foreignLanguage\">Other details</span>: Young specimens of the Fool's webcap also contain a web between the cap and the stem that partially or completely disappears as the specimen ages.</p></div><div><h3>Toxicity</h3><p>Both of these mushrooms can be confused with each other and many incidents of mushroom poisoning have occurred where inexperienced mushroom hunters have confused these mushrooms with edible mushrooms, such as the chanterelle, or hallucinogenic mushrooms. and Cortinarin A,B,C. A characteristic of orellanin poisoning is the long latency; the first symptoms usually don't appear until 2–3 days after ingestion and can in some cases take as long as 3 weeks. The first symptoms of orellanin poisoning are similar to the common flu (nausea, vomiting, stomach pains, headaches, etc.). These symptoms are followed by early stages of renal failure (immense thirst, frequent urination, pain on and around the kidneys), and eventually decreased or nonexistent urine output and other symptoms of renal failure occur. If left untreated, death will follow. There is no known antidote against orellanin poisoning, but early hospitalization and treatment can sometimes prevent serious injuries and usually prevent death. If you suspect orellanin poisoning, acting on it quickly can save your life.</p><p>Several more mushrooms in the <span class=\"foreignLanguage\">Cortinarius</span> genus are suspected to contain orellanin or other deadly toxins. Among them are <span class=\"foreignLanguage\">Cortinarius callisteus</span> and <span class=\"foreignLanguage\">Cortinarius limonius</span>.</p></div><div><h3>=Notable poisonings=</h3><p>Nicholas Evans, author of <span class=\"foreignLanguage\">The Horse Whisperer</span>, his wife Charlotte Gordon Cumming, and two other relatives were accidentally poisoned in September 2008 after consuming <span class=\"foreignLanguage\">Cortinarius rubellus</span> and/or <span class=\"foreignLanguage\">Cortinarius speciosissimus</span> that they gathered on holiday.</p></div>", "photos":[{"mushroomid":"Cortinari_rutilant","img":"wiki\/cortinari.rutilant1.jpg"},{"mushroomid":"Cortinari_rutilant","img":"wiki\/cortinari.rutilant3.jpg"},{"mushroomid":"Cortinari_rutilant","img":"wiki\/cortinari.rutilant4.jpg"}], "attributes":[{"valueId": "umbonate", "attributeId":"capell", "img":"Umbonate_cap_icon.svg.png", "name":"umbonate"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "marro_clar", "attributeId":"color_peu", "img":"peu_marro_clar.svg.png", "name":"light brown"},{"valueId": "deadly", "attributeId":"comestibilitat", "img":"comestibilitat_mortal.png", "name":"deadly"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "cortina", "attributeId":"vel", "img":"Cortina_stipe_icon.png", "name":"cortina"}]},{"id": "Cortinari_gros", "latinname":"Cortinarius praestans", "name":"Cortinarius praestans", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Cortinarius praestans</span></span>, also known as the <span class=\"mushroomName\">goliath webcap</span>, is a basidiomycete mushroom of the genus <span class=\"foreignLanguage\">Cortinarius</span>. The mushroom has orangish-yellow caps that reach up to  in diameter, and thick club-shaped stems up to  long. The edible mushroom is found in Europe.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Cortinarius praestans</span></span>, also known as the <span class=\"mushroomName\">goliath webcap</span>, is a basidiomycete mushroom of the genus <span class=\"foreignLanguage\">Cortinarius</span>. The mushroom has orangish-yellow caps that reach up to  in diameter, and thick club-shaped stems up to  long. The edible mushroom is found in Europe.</p></div><div><h3>Taxonomy</h3><p>The species was first described as <span class=\"foreignLanguage\">Agaricus praestans</span> by the French botanist François Simon Cordier in 1870. It is commonly known as the \"goliath webcap\".</p></div><div><h3>Description</h3><p>Mature caps are convex, usually grooved at the rolled-in margins, and typically reach diameters between . The surface color of the cap is chestnut or chocolate-brown with violet-copper tint. It has a light covering of surface fibrils and veil remnants that may appear as if pressed against the surface, or like small scales. The gills are whitish with an amethyst tint then later creamy clay- to rust-colored. They are crowded closely together, and have edges that are usually wavy and scalloped. The stem is  long and  thick, solid, and thickened at the base in an  bulb that is roughly club-shaped to . The stem surface is covered with silky fibrils, and is whitish-violet when very young, later losing the violet tones. The surface becomes fibrillosely floccose or whitish at the base and violet at the top, later becoming covered with the violet to whitish silky cortina (a cobwebby partial veil). The flesh is thick, whitish, and has a mild taste and no odor. The mushroom is considered a good edible species.</p><p>The spore print is ochre-rust colored. The spores are fusiformly lemon-shaped, densely covered with small \"warts\", and measure 15–17 by 8–10&nbsp;μm. The edges of the gills have cystidiate hairs 4–6&nbsp;μm wide, protruding 20-40&nbsp;μm, and degenerate sterile basidia 10–11&nbsp;μm wide protruding 10–12&nbsp;μm. The typical basidia measure 30–35 by 12–13&nbsp;μm.</p></div><div><h3>Distribution and habitat</h3><p>The fruit bodies of the fungus grow in deciduous forests, mainly on calcareous soils. It is common in western Europe, particularly England and France. It was one of 35 mushrooms to gain legal protection in Hungary in 2005, making it a fineable offense to pick them.</p></div>", "photos":[{"mushroomid":"Cortinari_gros","img":"wiki\/cortinari.gros1.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Cortinarius_trivialis", "latinname":"Cortinarius trivialis", "name":"Cortinarius trivialis", "names":"", "description":"<div> <span class=\"foreignLanguage\"> Cortinarius trivialis </span> <span Latin class=\"foreignLanguage\"> curtain </span>: curtain, Latin trivialis <span class=\"foreignLanguage\"> </span>: vulgar, common mushroom is not edible, which can be confused with llenega black, although it can be easily differentiated by the color of their plates, which are gray blue or purple to pale copies young and tan at least units, instead of white, as the black llenega. It also distinguishes the plates, which in this mushroom are adnate or slightly decurrent, when the black wild mushrooms are clearly decurrent. This mushroom is edible. </P> </div>", "photos":[{"mushroomid":"Cortinarius_trivialis","img":"wiki\/cortinarius.trivialis1.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "verdMarro", "attributeId":"color_capell", "img":"capell_verdMarro.svg.png", "name":"green-brown"},{"valueId": "gris", "attributeId":"color_peu", "img":"peu_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_peu", "img":"peu_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "marro", "attributeId":"color_peu", "img":"peu_marro.svg.png", "name":"brown"},{"valueId": "verdMarro", "attributeId":"color_peu", "img":"peu_verdMarro.svg.png", "name":"green-brown"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "cortina", "attributeId":"vel", "img":"Cortina_stipe_icon.png", "name":"cortina"}]},{"id": "Galerina", "latinname":"Galerina", "name":"Galerina", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Galerina</span></span> is a genus of small brown-spored saprobic mushrooms, with over 300 species found throughout the world, from the far north to remote Macquarie Island in the Southern Ocean. Species are typically small and hygrophanous, with a slender and brittle stem. They are often found growing on wood, and when on the ground have a preference for mossy habitats. This group is most noted for toxic species which are occasionally confused with hallucinogenic species of <span class=\"foreignLanguage\">Psilocybe</span>.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Galerina</span></span> is a genus of small brown-spored saprobic mushrooms, with over 300 species found throughout the world, from the far north to remote Macquarie Island in the Southern Ocean. Species are typically small and hygrophanous, with a slender and brittle stem. They are often found growing on wood, and when on the ground have a preference for mossy habitats. This group is most noted for toxic species which are occasionally confused with hallucinogenic species of <span class=\"foreignLanguage\">Psilocybe</span>.</p><p><span class=\"foreignLanguage\">Galerina</span> means <span class=\"foreignLanguage\">helmet-like</span>.</p></div><div><h3>Taxonomic definition</h3><p>The genus <span class=\"foreignLanguage\">Galerina</span> is defined as small mushrooms of  stature, that is, roughly similar in form to <span class=\"foreignLanguage\">Mycena</span> species: a small conical to bell-shaped cap, and gills attached to a long and slender cartilaginous stem.  Species have a pileipellis that is a cutis, and ornamented spores that are brown in deposit, where the spore ornamentation comes from an extra spore covering.</p></div><div><h3>Description</h3><p><span class=\"foreignLanguage\">Galerina</span> fruiting bodies are typically small, undistinguished mushrooms with a typical \"little brown mushroom\" morphology and a yellow-brown, light brown to cinnamon-brown spore print. The pileus is typically glabrous and often hygrophanous, and a cortina-type veil is present in young specimens of roughly half of recognized species, though it sometimes disappears as the mushroom ages in many of these species. Microscopically, they are highly variable as well, though most species have spores that are ornamented, lack a germ pore, and have a plage. Many species also have characteristic  cystidia. However, there are many exceptions, and many species of <span class=\"foreignLanguage\">Galerina</span> lack one or more of these microscopic characteristics. Ecologically, all <span class=\"foreignLanguage\">Galerina</span> are saprobic, growing in habitats like rotting wood or in moss. confirms the affinity of <span class=\"foreignLanguage\">Phaeogalera</span> and the non-psilocybin <span class=\"foreignLanguage\">Psilocybe</span>.</p></div><div><h3>Phylogenetics</h3><p><span class=\"foreignLanguage\">Galerina</span> has recently been found to be polyphyletic, The great diversity of  found in <span class=\"foreignLanguage\">Galerina</span> is probably due to the polyphyly of the genus.</p></div><div><h3>Chemistry and toxicology</h3><p>Many (though not all) <span class=\"foreignLanguage\">Galerina</span> contain alpha-amanitin and other amatoxins. Fruiting bodies with little psilocin (such as Psilocybe Semilanceata, with high psilocybin and low psilocin content) will stain weakly if at all, while sporocarps with a high psilocin content will stain strongly blue. Only one rare <span class=\"foreignLanguage\">Galerina</span> has blue-staining tissue, though in some cases the flesh will blacken when handled, and this may be misinterpreted as a bluing reaction.</p></div><div><h3>Notable species</h3><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Galerina vittiformis</span></span> is the type species of the genus <span class=\"foreignLanguage\">Galerina</span>.  This species is common in beds of damp moss (along with many other species of <span class=\"foreignLanguage\">Galerina</span>).  There are a number of variations of this species that have been named over the years:  var. <span class=\"foreignLanguage\">vittiformis f. vittiformis</span> is a 2-spored species; var. <span class=\"foreignLanguage\">vittiformis f. tetrasporis</span> is a 4-spored form; var. <span class=\"foreignLanguage\">pachyspora</span> has been collected on Macquarie Island. found throughout the temperate regions of the world, in habitats as diverse as forests and urban parklands, wherever rotting wood is found. DNA studies</p><p>Several <span class=\"foreignLanguage\">Galerina</span> species are listed by the US Forest Service as \"species of special concern\" in the Northwest Forest Plan. These species are considered indicator species for old growth coniferous forest in the Pacific Northwest: <span class=\"foreignLanguage\">Galerina atkinsonia</span>, <span class=\"foreignLanguage\">Galerina cerina</span>, <span class=\"foreignLanguage\">Galerina heterocystis</span>,</p></div><div><h3>In popular culture</h3><p>In The Borgias, Galarina mushrooms were used as poison.</p></div><div><h3>Further reading</h3><ul><li></li><li></li><li></li><li>Smith AH, Singer R. (1964). [http://www.hti.umich.edu:80/cgi/t/text/text-idx?c=fung1tc;cc=fung1tc;view=toc;idno=AGK0805.0001.001 <span class=\"foreignLanguage\">A monograph of the genus</span> Galerina <span class=\"foreignLanguage\">Earle</span>]. New York: Hafner Publishing Co. 384 p. (Full text available through link)</li></ul></div>", "photos":[{"mushroomid":"Galerina","img":"wiki\/galerina1.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "rosa", "attributeId":"color_capell", "img":"capell_rosa.svg.png", "name":"pink"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "deadly", "attributeId":"comestibilitat", "img":"comestibilitat_mortal.png", "name":"deadly"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Orella_de_llebre_blanca", "latinname":"Helvella crispa", "name":"Helvella crispa", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Helvella crispa</span></span>, also known as the <span class=\"mushroomName\">white saddle</span>, <span class=\"mushroomName\">elfin saddle</span> or <span class=\"mushroomName\">common helvel</span>, is an ascomycete fungus of the Helvellaceae family. The mushroom is readily identified by its irregularly shaped whitish cap, fluted stem, and fuzzy undersurfaces. It is found in eastern North America and in Europe, near deciduous trees in summer and autumn.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Helvella crispa</span></span>, also known as the <span class=\"mushroomName\">white saddle</span>, <span class=\"mushroomName\">elfin saddle</span> or <span class=\"mushroomName\">common helvel</span>, is an ascomycete fungus of the Helvellaceae family. The mushroom is readily identified by its irregularly shaped whitish cap, fluted stem, and fuzzy undersurfaces. It is found in eastern North America and in Europe, near deciduous trees in summer and autumn.</p></div><div><h3>Etymology</h3><p>The fungus was originally described as <span class=\"foreignLanguage\">Phallus crispus</span> by the naturalist Giovanni Antonio Scopoli in 1772.</p></div><div><h3>Description</h3><p><span class=\"foreignLanguage\">Helvella crispa</span> is creamy white in colour, 6–13&nbsp;cm (2½–5&nbsp;in) in length, with a cap 2–5&nbsp;cm (1–2&nbsp;in) in diameter. It is striking due to its irregularly-shaped lobes on the cap, but with a robust creamy-white base (2–8×1–2.5&nbsp;cm in size). Its flesh is thin and brittle. The stem is 3–10&nbsp;cm (1¼–4&nbsp;in) long, white or pinkish in colour and ornately ribbed. It gives off a pleasant aroma, but is not edible raw. The spore print is white, the oval spores average 19 x 11.5&nbsp;μm.</p><p>It is found in China, Europe and eastern North America, though is replaced by the related <span class=\"foreignLanguage\">Helvella lacunosa</span> in western parts.</p></div>", "photos":[{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca10.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca11.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca12.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca13.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca14.png"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca15.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca16.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca17.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca18.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca19.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca2.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca20.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca21.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca22.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca23.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca24.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca25.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca26.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca27.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca28.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca29.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca3.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca4.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca5.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca6.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca7.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca8.jpg"},{"mushroomid":"Orella_de_llebre_blanca","img":"wiki\/orella.de.llebre.blanca9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "smooth", "attributeId":"himeni", "img":"Smooth_icon.png", "name":"smooth"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Moraga_elastica", "latinname":"Helvella elastica", "name":"Helvella elastica", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Helvella elastica</span></span>, commonly known as the <span class=\"mushroomName\">flexible Helvella</span>, or the <span class=\"mushroomName\">elastic saddle</span>, is a species of fungi in the Helvellaceae family, Pezizales order. It is found in Asia, Europe, and North America. It has a roughly saddle-shaped yellow-brown cap atop a whitish stipe, and grows on soil in woods. Another colloquial name is the <span class=\"mushroomName\">brown elfin saddle</span>.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Helvella elastica</span></span>, commonly known as the <span class=\"mushroomName\">flexible Helvella</span>, or the <span class=\"mushroomName\">elastic saddle</span>, is a species of fungi in the Helvellaceae family, Pezizales order. It is found in Asia, Europe, and North America. It has a roughly saddle-shaped yellow-brown cap atop a whitish stipe, and grows on soil in woods. Another colloquial name is the <span class=\"mushroomName\">brown elfin saddle</span>.</p></div><div><h3>Description</h3><p>The fruit body of the fungus is grayish or olive-brown, saddle- or mitral-shaped (i.e., resembling a double mitre) and is attached only to the top of the stipe; it may be up to  wide. The stipe is white, solid or filled with loosely stuffed hyphae, has a smooth surface, and is up to  long by  thick. The flesh of <span class=\"foreignLanguage\">H.&nbsp;elastica</span> is brittle and thin. The odor and taste of this mushroom are not distinctive.</p></div><div><h3>=Microscopic characteristics=</h3><p>The spores are oblong to elliptical in shape, translucent (hyaline), contain one central oil drop (<span class=\"foreignLanguage\">guttulate</span>), and have dimensions of 18–22 by 10–14&nbsp;µm; young spores have coarse surface warts, while older ones are smooth. The spore-bearing cells, the asci, are 260 by 17–19&nbsp;µm. The paraphyses (sterile cells interspersed between the asci) are club-shaped, filled with oil drops, sometimes branched, and are 6–10&nbsp;µm at the apex.</p></div><div><h3>=Edibility=</h3><p>Consumption of this fungus is not recommended as similar species in the Helvellaceae family contain the toxin gyromitrin.</p></div><div><h3>Habitat and distribution</h3><p>This fungus is typically found fruiting singly, scattered, or clustered together on the ground or on wood in coniferous and deciduous woods. It has been found in Europe, North America (in \"western states and provinces\"), Japan, and China.</p></div><div><h3>Similar species</h3><p>The closely related fungus <span class=\"foreignLanguage\">Helvella albipes</span> has a thicker stipe and a two- to four-lobed cap. Another similar species, <span class=\"foreignLanguage\">H.&nbsp;latispora</span>, has cap edges that are curled upward, rather than inward as in <span class=\"foreignLanguage\">H.&nbsp;elastica</span>.</p></div><div><h3>Fibrinolytic activity</h3><p>A 2005 Korean study investigated the ability of extracts from 67 different mushroom species to perform fibrinolysis, the process of breaking down blood clots caused by the protein fibrin. <span class=\"foreignLanguage\">H.&nbsp;elastica</span> was one of seven species that had this ability; the activity of the extract was 60% of that of plasmin, the positive control used in the experiment.</p></div>", "photos":[{"mushroomid":"Moraga_elastica","img":"wiki\/moraga.elastica1.jpg"},{"mushroomid":"Moraga_elastica","img":"wiki\/moraga.elastica2.jpg"},{"mushroomid":"Moraga_elastica","img":"wiki\/moraga.elastica3.jpg"},{"mushroomid":"Moraga_elastica","img":"wiki\/moraga.elastica5.jpg"},{"mushroomid":"Moraga_elastica","img":"wiki\/moraga.elastica6.jpg"},{"mushroomid":"Moraga_elastica","img":"wiki\/moraga.elastica7.jpg"},{"mushroomid":"Moraga_elastica","img":"wiki\/moraga.elastica8.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "caution", "attributeId":"comestibilitat", "img":"comestibilitat_reserves.png", "name":"caution"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "smooth", "attributeId":"himeni", "img":"Smooth_icon.png", "name":"smooth"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Orella_de_llebre_negra", "latinname":"Helvella lacunosa", "name":"Helvella lacunosa", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Helvella lacunosa</span></span>, also known as the <span class=\"mushroomName\">slate grey saddle</span> or <span class=\"mushroomName\">fluted black elfin saddle</span>,  is an ascomycete fungus of the Helvellaceae family. It is probably the most common <span class=\"foreignLanguage\"><span class=\"mushroomName\">Helvella</span></span> species. <span class=\"foreignLanguage\">H.&nbsp;sulcata</span>; once separated, because of certain differences in the lobe structure is now dropped, or just a synonym. It was not possible to draw a clear distinction between the two. Occasionally white capped forms are found. They may be distinguished from the creamy-white coloured <span class=\"foreignLanguage\">Helvella crispa</span> by the latter's furry cap undersurface and inrolled margins when young. and China.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Helvella lacunosa</span></span>, also known as the <span class=\"mushroomName\">slate grey saddle</span> or <span class=\"mushroomName\">fluted black elfin saddle</span>,  is an ascomycete fungus of the Helvellaceae family. It is probably the most common <span class=\"foreignLanguage\"><span class=\"mushroomName\">Helvella</span></span> species. <span class=\"foreignLanguage\">H.&nbsp;sulcata</span>; once separated, because of certain differences in the lobe structure is now dropped, or just a synonym. It was not possible to draw a clear distinction between the two. Occasionally white capped forms are found. They may be distinguished from the creamy-white coloured <span class=\"foreignLanguage\">Helvella crispa</span> by the latter's furry cap undersurface and inrolled margins when young. and China.</p><p>Some specimens have a white moldy appearance, having been colonised by the parasitic Ascomycete fungus <span class=\"foreignLanguage\">Hypomyces cervinigenus</span>. yet this genus is now regarded with suspicion due to the presence of toxic compounds in several related species. It has been reported to cause gastrointestinal symptoms when eaten raw.</p></div>", "photos":[{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra10.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra11.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra12.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra13.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra14.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra15.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra16.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra17.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra2.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra3.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra4.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra5.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra6.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra7.jpg"},{"mushroomid":"Orella_de_llebre_negra","img":"wiki\/orella.de.llebre.negra8.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris", "attributeId":"color_peu", "img":"peu_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris_fosc", "attributeId":"color_peu", "img":"peu_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "smooth", "attributeId":"himeni", "img":"Smooth_icon.png", "name":"smooth"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pixeconill", "latinname":"Hygrocybe conica", "name":"Hygrocybe conica", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Hygrocybe conica</span></span>, commonly known as the <span class=\"mushroomName\">witch's hat</span>, <span class=\"mushroomName\">conical wax cap</span> or <span class=\"mushroomName\">conical slimy cap</span>, is a colourful member of the genus <span class=\"foreignLanguage\">Hygrocybe</span> (the waxcaps), found across northern Europe and North America. Originally described as <span class=\"foreignLanguage\">Hygrophorus conicus</span>, it may actually be a complex of closely related and similar species.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Hygrocybe conica</span></span>, commonly known as the <span class=\"mushroomName\">witch's hat</span>, <span class=\"mushroomName\">conical wax cap</span> or <span class=\"mushroomName\">conical slimy cap</span>, is a colourful member of the genus <span class=\"foreignLanguage\">Hygrocybe</span> (the waxcaps), found across northern Europe and North America. Originally described as <span class=\"foreignLanguage\">Hygrophorus conicus</span>, it may actually be a complex of closely related and similar species.</p></div><div><h3>Description</h3><p>The witch's hat is a small mushroom, with a convex to conical yellow-orange to red cap 2 to 5&nbsp;cm (¾-2&nbsp;inches) in diameter, though very occasionally larger specimens up to 8 or 9&nbsp;cm (3½ in) diameter are found. Bruises black.</p></div><div><h3>Distribution and habitat</h3><p>The witch's hat is widely distributed in grasslands and conifer woodlands across North America, Europe and Asia, as well as Australia and New Zealand, being found in summer and autumn. It is likely that what is currently termed <span class=\"foreignLanguage\">Hygrocybe conica</span> is actually a complex of closely related species, some of which are suspected of being poisonous.</p></div><div><h3>Edibility</h3><p>The edibility or otherwise of <span class=\"foreignLanguage\">Hygrocybe conica</span> is unclear. Its small size and being coated in a sticky substance render it of limited palatability anyway, however there is a report of poisoning from China in the early part of the 20th century which was allegedly from this species.</p></div>", "photos":[{"mushroomid":"Pixeconill","img":"wiki\/pixeconill10.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill11.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill12.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill13.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill14.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill15.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill16.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill19.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill2.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill20.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill21.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill22.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill23.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill24.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill25.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill26.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill27.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill3.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill4.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill5.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill6.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill7.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill8.jpg"},{"mushroomid":"Pixeconill","img":"wiki\/pixeconill9.jpg"}], "attributes":[{"valueId": "conical", "attributeId":"capell", "img":"Conical_cap_icon.svg.png", "name":"conical"},{"valueId": "groc", "attributeId":"color_capell", "img":"capell_groc.svg.png", "name":"yellow"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "groc", "attributeId":"color_peu", "img":"peu_groc.svg.png", "name":"yellow"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "verdMarro", "attributeId":"color_peu", "img":"peu_verdMarro.svg.png", "name":"green-brown"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Mocosa_blanca", "latinname":"Hygrophorus eburneus", "name":"Hygrophorus eburneus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Hygrophorus eburneus</span></span>, commonly known as the <span class=\"mushroomName\">ivory waxy cap</span> or the <span class=\"mushroomName\">cowboy's handkerchief</span>, is a species of edible mushroom in the waxgill family of fungi. It is widespread in Europe and North America, and has also been collected in northern Africa. The fruit bodies are medium-sized, pure white, and when wet are covered in a layer of slime thick enough to make the mushroom difficult to pick up. The gills are broadly attached to the stem or running down it; as the family name suggests, they feel waxy when rubbed between the fingers. Like all <span class=\"foreignLanguage\">Hygrophorus</span> species, the fungus is mycorrhizal—a symbiotic association whereby the underground fungal mycelia penetrate and exchange nutrients with tree roots. They are common in a variety of forest types, where they grow on the ground in thickets or grassy areas. <span class=\"foreignLanguage\">Hygrophorus eburneus</span> is the type species of the genus <span class=\"foreignLanguage\">Hygrophorus</span>. A number of biologically active chemicals have been purified from the fruit bodies of the fungus, including fatty acids with bactericidal and fungicidal activity.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Hygrophorus eburneus</span></span>, commonly known as the <span class=\"mushroomName\">ivory waxy cap</span> or the <span class=\"mushroomName\">cowboy's handkerchief</span>, is a species of edible mushroom in the waxgill family of fungi. It is widespread in Europe and North America, and has also been collected in northern Africa. The fruit bodies are medium-sized, pure white, and when wet are covered in a layer of slime thick enough to make the mushroom difficult to pick up. The gills are broadly attached to the stem or running down it; as the family name suggests, they feel waxy when rubbed between the fingers. Like all <span class=\"foreignLanguage\">Hygrophorus</span> species, the fungus is mycorrhizal—a symbiotic association whereby the underground fungal mycelia penetrate and exchange nutrients with tree roots. They are common in a variety of forest types, where they grow on the ground in thickets or grassy areas. <span class=\"foreignLanguage\">Hygrophorus eburneus</span> is the type species of the genus <span class=\"foreignLanguage\">Hygrophorus</span>. A number of biologically active chemicals have been purified from the fruit bodies of the fungus, including fatty acids with bactericidal and fungicidal activity.</p></div><div><h3>Taxonomy</h3><p>The species was first named as <span class=\"foreignLanguage\">Agaricus eburneus</span> by French botanist Jean Bulliard in 1783.</p><p>The mushroom is commonly known as the \"ivory waxy cap\",</p></div><div><h3>=Microscopic characteristics=</h3><p>When they are viewed in mass, such as with a spore print, the spores appear white. Observing with a light microscope reveals additional details: spores are , smooth, and measure 6–8 by 3.5–5&nbsp;µm. They are pale yellow in Melzer's reagent. The basidia (spore-bearing cells) are 42–52 by 608&nbsp;µm, and four-spored. There are no  or . The gill tissue is made of branching hyphae about 7–12&nbsp;µm wide. The cap cuticle is made of gelatinous, narrow (3–6&nbsp;µm) hyphae which are repent (bent over) but typically with some erect free ends. Clamp connections are present in the hyphae. <span class=\"foreignLanguage\">Hygrophorus cossus</span>, which typically grows with <span class=\"foreignLanguage\">Quercus</span> species, differs in its pale pinkish-buff cap and gills, and has a distinct sour odor; also, <span class=\"foreignLanguage\">H.&nbsp;cossus</span> does not have a potassium hydroxide reaction on the stem as does <span class=\"foreignLanguage\">H.&nbsp;eburneus</span>.</p></div><div><h3>Habitat and distribution</h3><p>The fruit bodies of <span class=\"foreignLanguage\">H.&nbsp;eburneus</span> grow on the soil, mostly in coniferous woods, thickets and grassy areas. The fungus prefers soil that is moist, mesic, loamy and calcareous.</p><p>The fungus is widely distributed in North America. It is also found in Europe (Poland and Portugal), Israel and North Africa.</p></div><div><h3>Bioactive compounds</h3><p>Several fatty acids with bactericidal and fungicidal activity have been isolated and identified from the fruit bodies of  <span class=\"foreignLanguage\">H.&nbsp;eburneus</span>. The bioactive fatty acids are built upon a chemical structure called γ-oxocrotonate. The following gamma-oxocrotonate derivatives have been identified from the mushroom: (2<span class=\"foreignLanguage\">E</span>,9<span class=\"foreignLanguage\">E</span>)-4-oxooctadeca-2,9,17-trienoic acid, (2<span class=\"foreignLanguage\">E</span>,11<span class=\"foreignLanguage\">Z</span>)-4-oxooctadeca-2,11,17-trienoic acid, (<span class=\"foreignLanguage\">E</span>)-4-oxohexadeca-2,15-dienoic acid, (<span class=\"foreignLanguage\">E</span>)-4-oxooctadeca-2,17-dienoic acid, (2<span class=\"foreignLanguage\">E</span>,9<span class=\"foreignLanguage\">E</span>)-4-oxooctadeca-2,9-dienoic acid, (2<span class=\"foreignLanguage\">E</span>,11<span class=\"foreignLanguage\">Z</span>)-4-oxooctadeca-2,11-dienoic acid, (<span class=\"foreignLanguage\">E</span>)-4-oxohexadec-2-enoic acid, and (<span class=\"foreignLanguage\">E</span>)-4-oxooctadec-2-enoic acid. The compound (<span class=\"foreignLanguage\">E</span>)-4-oxohexadec-2-enoic acid has been investigated for potential use as a fungicide against the oomycete species <span class=\"foreignLanguage\">Phytophthora infestans</span>, a causal agent of potato and tomato late blight disease.</p><p>Additional secondary metabolites discovered in <span class=\"foreignLanguage\">H.&nbsp;eburneus</span> include the ceramide compound named <span class=\"foreignLanguage\">hygrophamide</span> ((2<span class=\"foreignLanguage\">S</span>,3<span class=\"foreignLanguage\">R</span>,4<span class=\"foreignLanguage\">R</span>,2’<span class=\"foreignLanguage\">R</span>)-2-(2’-hydroxy-9’<span class=\"foreignLanguage\">Z</span>-ene-tetracosanoylamino)-octadecane-1,3,4-triol), and the β-carboline alkaloids known as <span class=\"foreignLanguage\">harmane</span> and <span class=\"foreignLanguage\">norharmane</span>. The report of discovery of the latter two compounds in 2008 represents their first known occurrence in fungal fruit bodies.</p></div><div><h3>=Literature cited=</h3><ul><li></li><li></li></ul></div>", "photos":[{"mushroomid":"Mocosa_blanca","img":"wiki\/mocosa.blanca1.jpg"},{"mushroomid":"Mocosa_blanca","img":"wiki\/mocosa.blanca5.jpg"},{"mushroomid":"Mocosa_blanca","img":"wiki\/mocosa.blanca6.jpg"},{"mushroomid":"Mocosa_blanca","img":"wiki\/mocosa.blanca7.jpg"},{"mushroomid":"Mocosa_blanca","img":"wiki\/mocosa.blanca8.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Llenega_negra", "latinname":"Hygrophorus latitabundus", "name":"Hygrophorus latitabundus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Hygrophorus latitabundus</span></span> is a species of fungus in the genus <span class=\"foreignLanguage\">Hygrophorus</span>. It is distributed in European pine forests, and has a preference for calcareous soils. It fruits in autumn, producing large, edible mushrooms with slimy caps and stems.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Hygrophorus latitabundus</span></span> is a species of fungus in the genus <span class=\"foreignLanguage\">Hygrophorus</span>. It is distributed in European pine forests, and has a preference for calcareous soils. It fruits in autumn, producing large, edible mushrooms with slimy caps and stems.</p></div><div><h3>Description</h3><p><span class=\"foreignLanguage\">Hygrophorus latitabundus</span> fruiting bodies are large agarics. The cap is convex and slightly umbonate, coloured grey, brown and olivaceous with a darker, brownish centre. It is characteristically covered by a glutinous layer of slime, especially in wet weather conditions. The margin is inrolled. The cap diameter can reach 15&nbsp;cm, and as it matures, it flattens out. The white gills are thick, distant and have an adnate to weakly decurrent attachment to the stem. </p><p>The white stem is tall, fusiform, thick and robust. It is ornamented by numerous whitish flakes which are covered in a thick layer of slime. The flakes have a tendency to become brown. The flakes and slime extend from the base of the stem to the level of the margin, where they stop abruptly, creating a ring-like zone. Above this, the stem is white and visibly thinner. The stem is up to 15&nbsp;cm tall and 2–4&nbsp;cm thick.</p><p>The white flesh is thick and firm, with a fungal smell and pleasant taste. An identification aid is the chemical reaction of the stem flesh when exposed to ammonia solution. In this species, it turns orange-rust and then brown in the base and yellow-ochre at the top.</p></div><div><h3>Edibility</h3><p><span class=\"foreignLanguage\">Hygrophorus latitabundus</span> is reported to be a good, edible fungus.</p><p>Its distribution encompasses southern and central Europe, including Austria, Germany, France, Italy, Slovenia and Spain. It is also known to occur in the Republic of Macedonia, Greece and Turkey.</p></div><div><h3>Similar species</h3><p>Among the many species of the genus <span class=\"foreignLanguage\">Hygrophorus</span>, there are some which can be mistaken for <span class=\"foreignLanguage\">Hygrophorus latitabundus</span>. </p><ul><li>The fruiting body of <span class=\"foreignLanguage\">H. persoonii</span> has a similar appearance, but the species is found only in deciduous forests with oak (<span class=\"foreignLanguage\">Quercus</span>) and beech (<span class=\"foreignLanguage\">Fagus</span>). Its flesh turns greenish with ammonia solution.</li><li><span class=\"foreignLanguage\">H. olivaceoalbus</span> is a less robust species which often bears a dark, rough-banded stem ornamentation, and occurs with spruce (<span class=\"foreignLanguage\">Picea</span>), frequently in moss. Its stem flesh discolours to orange-red with ammonia solution.</li></ul></div>", "photos":[{"mushroomid":"Llenega_negra","img":"wiki\/llenega.negra1.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Hygrophorus_marzuolus", "latinname":"Hygrophorus marzuolus", "name":"Hygrophorus marzuolus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Hygrophorus marzuolus</span></span>, commonly known as the <span class=\"mushroomName\">March mushroom</span>, is a species of fungus in the family Hygrophoraceae. It is known from Asia, Europe, and North America, where it grows on the ground in mixed forests at high elevations.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Hygrophorus marzuolus</span></span>, commonly known as the <span class=\"mushroomName\">March mushroom</span>, is a species of fungus in the family Hygrophoraceae. It is known from Asia, Europe, and North America, where it grows on the ground in mixed forests at high elevations.</p></div><div><h3>Taxonomy</h3><p>The species was originally described by Elias Magnus Fries in 1821 as <span class=\"foreignLanguage\">Agaricus marzuolus</span>, and transferred to  <span class=\"foreignLanguage\">Hygrophorus</span> in 1893 by Giacomo Bresadola. It is commonly known as the \"March mushroom\".</p></div><div><h3>Description</h3><p>The fruit bodies have caps that are broadly convex, measuring  in diameter. Their surfaces are smooth and sticky, with a pale greyish-brown center and darker brown to blackish-grey margin. The distantly spaced, broad gills have an adnate to adnexed attachment to the stipe, and two tiers of intervening lamellulae (short gills). The gills are initially white before turning gray to bluish-gray in age. The whitish stipe measures  long by  thick, and is either equal in width throughout or tapers slightly towards the base. The stipe is smooth except for a few tufts of hairs near the top. Immediately underneath the cap cuticle, the flesh of the cap is water-soaked; elsewhere in the cap, it is gray-tinted with a sheen, while in the stipe it is dull white. It lacks any appreciable odor or taste. It is considered edible in Europe, where it is prized in some regions.</p><p>The thin-walled, elliptical spores measure 6.5–8.5 by 4.5–5&nbsp;µm. The basidia (spore-bearing cells) are narrowly club-shaped, four-spored, and measure 42–55 by 5.4–8.1&nbsp;µm.</p></div><div><h3>Habitat and distribution</h3><p><span class=\"foreignLanguage\">Hygrophorus marzuolus</span> is a mycorrhizal fungus. Associations have been noted with the trees <span class=\"foreignLanguage\">Abies alba</span>, and sometimes with <span class=\"foreignLanguage\">Picea excelsa</span> and <span class=\"foreignLanguage\">Pinus sylvestris</span>. Fruit bodies grow singly to scattered or sometimes in clusters on the forest floor in duff or in moss. It fruits under conifers, often fir and Englemann spruce, typically at high elevations. A snowbank mushroom, it is associated with melting snow, and fruiting is initiated under snowbanks. The fungus has been recorded from the mountains of Idaho, Montana, Oregon, Washington, northern Arizona, and northern California. The European distribution extends from the French Pyrenees to the region of Prague. In Asia, it has been reported from Pakistan.</p></div>", "photos":[{"mushroomid":"Hygrophorus_marzuolus","img":"wiki\/hygrophorus.marzuolus2.jpg"},{"mushroomid":"Hygrophorus_marzuolus","img":"wiki\/hygrophorus.marzuolus3.jpg"},{"mushroomid":"Hygrophorus_marzuolus","img":"wiki\/hygrophorus.marzuolus4.jpg"},{"mushroomid":"Hygrophorus_marzuolus","img":"wiki\/hygrophorus.marzuolus5.jpg"},{"mushroomid":"Hygrophorus_marzuolus","img":"wiki\/hygrophorus.marzuolus6.jpg"},{"mushroomid":"Hygrophorus_marzuolus","img":"wiki\/hygrophorus.marzuolus7.jpg"},{"mushroomid":"Hygrophorus_marzuolus","img":"wiki\/hygrophorus.marzuolus8.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "subdecurrent", "attributeId":"lamina", "img":"Subdecurrent_gills_icon2.svg.png", "name":"subdecurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Carlet_bolet", "latinname":"Hygrophorus russula", "name":"Hygrophorus russula", "names":"", "description":"<div> <p> <span class=\"mushroomName\"> carlet </span> or <span class=\"mushroomName\"> Escarlet </span> (<span class=\"foreignLanguage\"> Hygrophorus Russula </span> Greek <span class=\"foreignLanguage\"> higrós </span>: wet phorós: bearer, from Latin <span class=\"foreignLanguage\"> Russian </span>: Pink) is an edible mushroom of the order Agaricales . </p> </span> <h3> Description </h3> <p> cuticle, which is partially separable, is smooth and slightly listed, slimy in wet weather, pink and red spotted vinous is darker in the center. Contrasts with the more white gills and stem. Abundant and compact meat, fibrous foot, soft and sweet-smelling, sometimes a little bitter. </P> </span> <h3> Habitat </h3> <p> grows in oaks and beech, in all types of soils, with preference for basic and neutral. Bears fruit in autumn, usually spotted in children, who are called Escarlet. This mushroom late being his first choice in November. </P> </span> <h3> Food </h3> <p> usually eat after being harvested, but remains in salt or brine for later use. Can also be served in a double boiler or in vinegar. By removing the cuticle, as amarganteja, it improves quality. It's a good food, cooked it better to accompany him alone to eat because the meat absorbs all the nice flavors of the dish. </P> </div>", "photos":[{"mushroomid":"Carlet_bolet","img":"wiki\/carlet.(bolet)2.jpg"},{"mushroomid":"Carlet_bolet","img":"wiki\/carlet.(bolet)6.jpg"},{"mushroomid":"Carlet_bolet","img":"wiki\/carlet.(bolet)7.jpg"},{"mushroomid":"Carlet_bolet","img":"wiki\/carlet.(bolet)8.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "rosa", "attributeId":"color_capell", "img":"capell_rosa.svg.png", "name":"pink"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "rosa", "attributeId":"color_peu", "img":"peu_rosa.svg.png", "name":"pink"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Lleterola_de_llet_groga", "latinname":"Lactarius chrysorrheus", "name":"Lactarius chrysorrheus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius chrysorrheus</span></span> (sometimes spelt <span class=\"foreignLanguage\">Lactarius chrysorheus</span>) is a  member of the <span class=\"foreignLanguage\">Lactarius</span> genus, whose many members are commonly known as Milkcaps. It has recently been given the English (common) name of the <span class=\"mushroomName\">Yellowdrop Milkcap</span>. It is pale salmon in color, poisonous, and grows in symbiosis with oak trees.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius chrysorrheus</span></span> (sometimes spelt <span class=\"foreignLanguage\">Lactarius chrysorheus</span>) is a  member of the <span class=\"foreignLanguage\">Lactarius</span> genus, whose many members are commonly known as Milkcaps. It has recently been given the English (common) name of the <span class=\"mushroomName\">Yellowdrop Milkcap</span>. It is pale salmon in color, poisonous, and grows in symbiosis with oak trees.</p></div><div><h3>Taxonomy</h3><p>First described by the Swedish father of modern mycology Elias Magnus Fries. The specific epithet is derived from the Ancient Greek words <span class=\"foreignLanguage\">chryso-</span> \"golden\", and <span class=\"foreignLanguage\">rheos</span> \"stream\".</p></div><div><h3>Description</h3><p>The cap is  in diameter. It is pale salmon, or rosy, with darker markings arranged in rough rings, or bands.  At first it is convex, but later flattens, and eventually has a small central depression. It is often somewhat lobed at the edge, and is smooth, with a hairless margin. The whitish to pale buff stipe  sometimes has a pink flush on the lower half. It is hollow, cylindrical, or with a slightly swollen base.  The gills are decurrent, crowded, and have a pinkish buff tinge, giving a spore print that is creamy white, with a slight salmon tinge. They are quite closely spaced initially. The flesh is white and tastes hot, but is coloured by the copious amounts of milk exuded. This milk is initially white, but when exposed to the air turns bright sulphur yellow in five to fifteen seconds. None of these can be found in Britain; <span class=\"foreignLanguage\">Lactarius decipiens</span> is on the [http://www.basidiochecklist.info/Names.asp British checklist], but is smaller than <span class=\"foreignLanguage\">L. chrysorrheus</span>, and grows with Hornbeam.</p></div><div><h3>Distribution and habitat</h3><p><span class=\"foreignLanguage\">Lactarius chrysorrheus</span> appears in summer and autumn. It is frequent in the northern temperate zones, Europe, North America, and also North Africa. It is mycorrhizal with oak trees in Britain. Consumption of the several species of poisonous milkcaps results in predominantly acute gastrointestinal symptoms which can be severe.</p></div>", "photos":[{"mushroomid":"Lleterola_de_llet_groga","img":"wiki\/lleterola.de.llet.groga10.jpg"},{"mushroomid":"Lleterola_de_llet_groga","img":"wiki\/lleterola.de.llet.groga2.jpg"},{"mushroomid":"Lleterola_de_llet_groga","img":"wiki\/lleterola.de.llet.groga3.jpg"},{"mushroomid":"Lleterola_de_llet_groga","img":"wiki\/lleterola.de.llet.groga4.jpg"},{"mushroomid":"Lleterola_de_llet_groga","img":"wiki\/lleterola.de.llet.groga5.jpg"},{"mushroomid":"Lleterola_de_llet_groga","img":"wiki\/lleterola.de.llet.groga8.jpg"},{"mushroomid":"Lleterola_de_llet_groga","img":"wiki\/lleterola.de.llet.groga9.jpg"}], "attributes":[{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pebras_lleter_de_riberada", "latinname":"Lactarius controversus", "name":"Lactarius controversus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius controversus</span></span> is a large funnel-capped fungus within the genus <span class=\"foreignLanguage\">Lactarius</span>, which are collectively known as 'milk caps'. They all exude milky drops (lactate) from the flesh and gills when damaged. It has no common English name.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius controversus</span></span> is a large funnel-capped fungus within the genus <span class=\"foreignLanguage\">Lactarius</span>, which are collectively known as 'milk caps'. They all exude milky drops (lactate) from the flesh and gills when damaged. It has no common English name.</p></div><div><h3>Taxonomy</h3><p>Accredited to Christian Hendrik Persoon, one of the fathers of mycology.</p></div><div><h3>Description</h3><p>It is distinguishable mainly by its pinkish-buff gills and rosy markings on the upper cap surface, often arranged in concentric rings. Like other fungi in the genus, it has crumbly, rather than fibrous, flesh, and when this is broken the fungus exudes a white milky liquid. Mature specimens are funnel-shaped, with decurrent gills and a concave cap. It has firm, tough flesh, and a stipe which is shorter than the fruitbody is wide. The spore print is creamy-pink in colour.</p><p>A similar species the Fleecy Milk-cap <span class=\"foreignLanguage\">Lactarius vellereus</span>, lacks the pinkish gills, and 'rosy' cap markings.</p></div><div><h3>Distribution and habitat</h3><p>It is found in Britain, and Europe, and usually grows with species of Salix (Goat willow or Creeping willow) on heaths and moors.It is uncommon.</p></div><div><h3>Edibility</h3><p>This mushroom is inedible due to its very acrid taste, and is probably best avoided.</p></div>", "photos":[{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada1.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada10.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada11.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada12.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada13.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada14.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada2.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada3.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada4.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada8.jpg"},{"mushroomid":"Pebras_lleter_de_riberada","img":"wiki\/pebras.lleter.de.riberada9.jpg"}], "attributes":[{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pinetell", "latinname":"Lactarius deliciosus", "name":"Lactarius deliciosus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius deliciosus</span></span>, commonly known as the <span class=\"mushroomName\">Saffron milk cap</span>, <span class=\"mushroomName\">Red pine mushroom</span>, is one of the best known members of the large milk-cap genus <span class=\"foreignLanguage\">Lactarius</span> in the order Russulales. It is found in Europe and has been accidentally introduced to other countries under conifers and can be found growing in pine plantations. Michael Kuo, primary founder of the MushroomExpert website, cites Belgian mycologist Jorinde Nuytinck who determined that the mushroom is a \"genetically, morphologically, and ecologically distinct European species that does not occur in North America\".", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius deliciosus</span></span>, commonly known as the <span class=\"mushroomName\">Saffron milk cap</span>, <span class=\"mushroomName\">Red pine mushroom</span>, is one of the best known members of the large milk-cap genus <span class=\"foreignLanguage\">Lactarius</span> in the order Russulales. It is found in Europe and has been accidentally introduced to other countries under conifers and can be found growing in pine plantations. Michael Kuo, primary founder of the MushroomExpert website, cites Belgian mycologist Jorinde Nuytinck who determined that the mushroom is a \"genetically, morphologically, and ecologically distinct European species that does not occur in North America\".</p><p>A fresco in the Roman town of Herculaneum appears to depict <span class=\"foreignLanguage\">Lactarius deliciosus</span> and is one of the earliest pieces of art to illustrate a fungus.</p></div><div><h3>Taxonomy</h3><p>This was known to Linnaeus who officially described it in Volume Two of his <span class=\"foreignLanguage\">Species Plantarum</span> in 1753, giving it the name <span class=\"foreignLanguage\">Agaricus deliciosus</span>, the specific epithet deriving from Latin <span class=\"foreignLanguage\">deliciosus</span> meaning \"tasty\". The Swedish taxonomist allegedly gave the species its epithet after smelling it and presuming it tasted as good as a Mediterranean milk cap highly regarded for its flavor. Dutch mycologist Christian Hendrik Persoon added the varietal epithet <span class=\"foreignLanguage\">lactifluus</span> in 1801, before English mycologist Samuel Frederick Gray placed it in its current genus <span class=\"foreignLanguage\">Lactarius</span> in 1821 in his <span class=\"foreignLanguage\">The Natural Arrangement of British Plants</span>.</p><p>It is commonly known as saffron milk-cap, red pine mushroom, or simply pine mushroom in English. Its Catalan name is <span class=\"foreignLanguage\">rovelló</span> (pl. <span class=\"foreignLanguage\">rovellons</span>) while its Castilian name varies (níscalo, mízcalo...). An alternate North American name is orange latex milky. Both this and <span class=\"foreignLanguage\">Lactarius deterrimus</span> are known as Çam melkisi or Çintar in Turkey.</p><p>In the Girona area, this type of mushroom is called a <span class=\"foreignLanguage\">pinatell</span> (in Catalan) because it is collected near wild pine trees; they are typically harvested in October following the late August rain. Due to its scarcity it commands high prices.</p><p>It is known as Rascovi in Romania and it can be found in the Northern area in autumn season.</p></div><div><h3>Description</h3><p><span class=\"foreignLanguage\">Lactarius deliciosus</span> has a carrot orange cap which is convex to vase shaped, inrolled when young, 4 to 14&nbsp;cm (1.5–7&nbsp;in) across, often with darker orange lines in the form of concentric circles.  The cap is sticky and viscid when wet, but is often dry. It has crowded decurrent gills and a squat orange stipe which is often hollow, 3 to 8&nbsp;cm (1–3&nbsp;in) long and 1 to 2&nbsp;cm (0.4–0.8&nbsp;in) thick. This mushroom stains a deep green color when handled. When fresh, the mushroom exudes an orange-red latex or \"milk\" that does not change color.</p><p>In North America, this mushroom is often confused with <span class=\"foreignLanguage\">Lactarius rubrilacteus</span> which stains blue, exudes a red latex, and is also edible.</p></div><div><h3>Distribution and habitat</h3><p><span class=\"foreignLanguage\">Lactarius deliciosus</span> grows under the acidic soil of conifers and forms a mycorrhizal relationship with its host tree. It is native to the southern Pyrenees where it grows under Mediterranean pines. Both this fungus and <span class=\"foreignLanguage\">L. deterrimus</span> are collected and sold in the İzmir Province of southwestern Turkey, and the Antalya Province of the south coast.</p><p>It has been introduced to Chile, Australia and New Zealand, where it grows in <span class=\"foreignLanguage\">Pinus radiata</span> plantations. Popular places for collecting this mushroom, especially among the Polish community, are around Macedon in Victoria, and in the Oberon area in New South Wales, Australia, where they can grow to the size of a dinner plate. Many people of Italian, Polish, Ukrainian and other eastern European ancestry in the states of Victoria and New South Wales, Australia travel to collect these mushrooms after autumn rainfall around Easter time. In Cyprus it is found in the pine forests where many people \"hunt\" them with vigour. It is considered one of the local delicacies.</p><p><span class=\"foreignLanguage\">Lactarius deliciosus</span> is very popular in Russian cuisine. Siberian pine forests are a habitat of this type of mushrooms. The mushrooms are being collected in August to early October. As methods of food conservation, they are traditionally salted and pickled. Many people prefer them fried.</p></div><div><h3>Edibility</h3><p><span class=\"foreignLanguage\">Lactarius deliciosus</span> is a widely collected mushroom in the Southern Pyrenees and Majorca and used in Spanish Cuisine. One recipe recommends they should be lightly washed, fried whole cap down in olive oil with a small amount of garlic and served drenched in raw olive oil and parsley. The same recipe advised that butter should never be used when cooking this mushroom.</p><p>Further north and east it is a feature of Provençal cuisine.</p><p>They are also collected in Poland, where they are traditionally served fried in butter, with cream, or marinated.</p><p>In Russian cuisine these mushrooms are prepared with pickling and then eaten with sour cream.</p><p>They are also well known in Cyprus, where they are usually cooked on charcoal and marinated with olive oil and lemon, or fried with onions with red wine.</p><p>In some older guides, the saffron milk cap is considered an excellent mushroom, having 'a crisp texture'. In fact, when naming the mushroom (<span class=\"foreignLanguage\">deliciosus</span> = delicious), the mycologist had mistaken the mushroom with <span class=\"foreignLanguage\">Lactarius sanguifluus</span>, which is an excellent, pleasantly crunchy mushroom. Today, most mycologists hold <span class=\"foreignLanguage\">Lactarius sanguifluus</span> in higher esteem than its pretender, <span class=\"foreignLanguage\">Lactarius deliciosus</span>.</p></div><div><h3>=Cited texts=</h3><ul><li></li><li></li></ul></div>", "photos":[{"mushroomid":"Pinetell","img":"wiki\/pinetell10.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell11.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell12.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell15.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell16.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell17.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell18.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell19.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell2.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell20.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell3.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell4.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell5.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell7.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell8.jpg"},{"mushroomid":"Pinetell","img":"wiki\/pinetell9.jpg"}], "attributes":[{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "vermell", "attributeId":"color_peu", "img":"peu_vermell.svg.png", "name":"red"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Lactarius_obscuratus", "latinname":"Lactarius obscuratus", "name":"Lactarius obscuratus", "names":"", "description":"<div> <span class=\"foreignLanguage\"> <span class=\"mushroomName\"> Lactarius obscuratus </span> </span> is a mushroom belonging to the family of russulàcies. </p> </span> <h3> Description </h3> <ul> <li> hat measuring 1 to 2 cm in diameter. In young specimens have a rounded look, more or less flattened, often with an umbo or central bulge. In aging, the center becomes depressed, so it takes on a funnel. Usually, the umbo remains, though often absent or not obvious. The surface of the hat is a brown color that's brown to reddish orange, shades paler towards the margin and the center olivacis. It is smooth, without ornamentation except the margin, which is usually grooved. </Li> <li> layers are dense, thick, cream-colored flesh and stretch a little leg. The lamellar cells are abundant. The edge is full and the same color as the rest of the film. </Li> <li> leg as 1-2 x 0.2 to 0.4 cm and is cylindrical, full color paler the hat and finely floured (pruïnosa of fibrils in losa), especially towards the top. </li> <li> Ionian is whitish. Spores measuring 6-8 x 5.5 to 6.5 microns, are broadly ellipsoid, warts large, sparse, which may or ridges to form a lattice breached. The basidis are tetraspòrics. </Li> <li> The meat is thin, creamy orange, odorless and slightly bitter taste mild. The latex is very abundant, watery, white, unchanging, soft. (Austria, Denmark, Estonia, Finland, the French, Germany, Italy, such as Lombardy, Ireland, Luxembourg, Norway, Poland, Slovenia, Spain, including the Montseny-Sweden , Switzerland and the UK), America (Canada, United States, among others, Washington, Mexico and Ecuador), Pakistan (such as Gilgit-Baltistan) and Japan. </li> </ul> </span> <h3> edibility </h3> <p> species is not edible. </p> </div>", "photos":[{"mushroomid":"Lactarius_obscuratus","img":"wiki\/lactarius.obscuratus1.jpg"}], "attributes":[{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "marro_clar", "attributeId":"color_peu", "img":"peu_marro_clar.svg.png", "name":"light brown"}]},{"id": "Pebras_lleter", "latinname":"Lactarius piperatus", "name":"Lactarius piperatus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius piperatus</span></span>, commonly known as the <span class=\"mushroomName\">peppery milk-cap</span> is a semi-edible basidiomycete fungus of the genus <span class=\"foreignLanguage\">Lactarius</span>. Despite being edible, it is not recommended due to its poor taste, though can be used as seasoning when dried. The fruiting body is a creamy-white mushroom which is funnel-shaped when mature, with exceptionally crowded gills. It bleeds a whitish peppery-tasting milk when cut. Widely distributed across Europe and eastern North America, <span class=\"foreignLanguage\">Lactarius piperatus</span> has been accidentally introduced to Australia. Mycorrhizal, it forms a symbiotic relationship with various species of deciduous tree, including beech, and hazel, and fruiting bodies are found on the forest floor in deciduous woodland.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius piperatus</span></span>, commonly known as the <span class=\"mushroomName\">peppery milk-cap</span> is a semi-edible basidiomycete fungus of the genus <span class=\"foreignLanguage\">Lactarius</span>. Despite being edible, it is not recommended due to its poor taste, though can be used as seasoning when dried. The fruiting body is a creamy-white mushroom which is funnel-shaped when mature, with exceptionally crowded gills. It bleeds a whitish peppery-tasting milk when cut. Widely distributed across Europe and eastern North America, <span class=\"foreignLanguage\">Lactarius piperatus</span> has been accidentally introduced to Australia. Mycorrhizal, it forms a symbiotic relationship with various species of deciduous tree, including beech, and hazel, and fruiting bodies are found on the forest floor in deciduous woodland.</p></div><div><h3>Taxonomy</h3><p>The species was one of the many species named by Linnaeus who officially described it in Volume Two of his <span class=\"foreignLanguage\">Species Plantarum</span> in 1753 as <span class=\"foreignLanguage\">Agaricus piperatus</span>, the specific epithet deriving from the Latin adjective <span class=\"foreignLanguage\">piperatus</span> meaning \"peppery\".</p><p>It is currently the type species of the genus <span class=\"foreignLanguage\">Lactarius</span>, however in the complex relationship between <span class=\"foreignLanguage\">Lactarius</span> and <span class=\"foreignLanguage\">Russula</span> it is somewhat isolated from many other milk-cap species as it is in fact more closely related to many species of <span class=\"foreignLanguage\">Russula</span> than to most other milk-caps, and there has been discussion for the type to be redesignated in the likely break-up of the milk-cap genus. peppery Lactarius, white peppery milk-cap, or other similar names.</p></div><div><h3>Description</h3><p><span class=\"foreignLanguage\">L. piperatus</span> has a cap that varies from 6&ndash;16&nbsp;cm (2.4&ndash;6.4 &nbsp;in) across and is convex with a widely funnel-shaped center. The cap is creamy-white in colour, glabrous and not glossy; its surface may become cracked in dry locales. 3&ndash;7&nbsp;cm (1.4&ndash;2.8&nbsp;in) long by 2&ndash;3&nbsp;cm (0.8-1.2&nbsp;in) thick and is cylindrical, sometimes tapering towards the base. It has a white spore print with , elliptic or amyloid spores which are ornamented, as with <span class=\"foreignLanguage\">L. vellereus</span>. The spores measure from 6.5&ndash;9.5 by 5&ndash;8&nbsp;μm, and have tiny warts. Variants of <span class=\"foreignLanguage\">L. piperatus</span> include <span class=\"foreignLanguage\">L. piperatus</span> var. <span class=\"foreignLanguage\">glaucescens</span>, sometimes known as <span class=\"foreignLanguage\">L. glaucescens</span>, which is differentiated by its milk, which dries a greenish colour. and eastern and central North America east of Minnesota. It is found on the floor in deciduous woodland, particularly beech, and can be found throughout summer and autumn and into early winter. It is sometimes found growing together with <span class=\"foreignLanguage\">Russula cyanoxantha</span>. where it would be picked in dry seasons when other edible species were less available. <span class=\"foreignLanguage\">L. piperatus</span> var. <span class=\"foreignLanguage\">glaucescens</span> has been reported to be poisonous,</p><p><span class=\"foreignLanguage\">L. piperatus</span> forms part of an unusual and highly regarded dish in North America, being one of species several colonised by the lobster mushroom <span class=\"foreignLanguage\">Hypomyces lactifluorum</span>. This results in an orange-pink crusty outer-skin which improves the taste. It is also a common source of food among red squirrels. In the 19th century, it was also used as a folk cure for tuberculosis, though it had no effect.</p></div>", "photos":[{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter10.jpg"},{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter11.jpg"},{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter2.jpg"},{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter3.jpg"},{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter4.jpg"},{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter6.jpg"},{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter7.jpg"},{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter8.jpg"},{"mushroomid":"Pebras_lleter","img":"wiki\/pebras.lleter9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Lleterola_verda", "latinname":"Lactarius pyrogalus", "name":"Lactarius pyrogalus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius pyrogalus</span></span>, commonly known as the  <span class=\"mushroomName\">fire-milk Lactarius</span>, is a species of inedible mushroom in genus <span class=\"foreignLanguage\">Lactarius</span>. It is greyish in colour and differentiated from other grey <span class=\"foreignLanguage\">Lactarius</span> by its widely spaced, yellow gills. It is found on the forest floor in mixed woodland, especially at the base of hazel trees.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius pyrogalus</span></span>, commonly known as the  <span class=\"mushroomName\">fire-milk Lactarius</span>, is a species of inedible mushroom in genus <span class=\"foreignLanguage\">Lactarius</span>. It is greyish in colour and differentiated from other grey <span class=\"foreignLanguage\">Lactarius</span> by its widely spaced, yellow gills. It is found on the forest floor in mixed woodland, especially at the base of hazel trees.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Lactarius pyrogalus</span> was first described by French mycologist Pierre Bulliard as <span class=\"foreignLanguage\">Agaricus pyrogalus</span> in 1792, before being given its current binomial name by Swedish mycologist Elias Magnus Fries in 1838. Its specific epithet is derived from the Ancient Greek roots <span class=\"foreignLanguage\">pyro-</span> \"fire\" and <span class=\"foreignLanguage\">gala</span> \"milk\". with pink and purple tinges not unknown. The stem is between 4 and 6&nbsp;cm, and between 7 and 15&nbsp;mm thick, generally cylindrical but sometimes slightly swollen at the base. It is particularly common in hazel woodland managed for coppice.</p></div>", "photos":[{"mushroomid":"Lleterola_verda","img":"wiki\/lleterola.verda1.jpg"}], "attributes":[{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro", "attributeId":"color_peu", "img":"peu_marro.svg.png", "name":"brown"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Lactarius_quieticolor", "latinname":"Lactarius quieticolor", "name":"Lactarius quieticolor", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius quieticolor</span></span> is a member of the large milk-cap genus <span class=\"foreignLanguage\">Lactarius</span> in the order Russulales. It was first described scientifically by French mycologist Henri Romagnesi in 1958.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius quieticolor</span></span> is a member of the large milk-cap genus <span class=\"foreignLanguage\">Lactarius</span> in the order Russulales. It was first described scientifically by French mycologist Henri Romagnesi in 1958.</p></div>", "photos":[{"mushroomid":"Lactarius_quieticolor","img":"wiki\/lactarius.quieticolor1.jpg"},{"mushroomid":"Lactarius_quieticolor","img":"wiki\/lactarius.quieticolor2.jpg"},{"mushroomid":"Lactarius_quieticolor","img":"wiki\/lactarius.quieticolor3.jpg"},{"mushroomid":"Lactarius_quieticolor","img":"wiki\/lactarius.quieticolor4.jpg"}], "attributes":[{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"}]},{"id": "Pinetell_davet", "latinname":"Lactarius salmoneus", "name":"Lactarius salmoneus", "names":"", "description":"<div> <p> <span class=\"mushroomName\"> Pinetell fir </span> (<span class=\"foreignLanguage\"> Lactarius salmonicolor </span>) is a species of mushroom in the family of russulàcies. </p> </span> <h3> Description </h3> <ul> <li> hat is between 7 and 13 cm in diameter, from the beginning, has a convex shape, while in mature flattened and shows a central depression. For the duration of the margin appears clearly curved inward (Involute). Its surface is shiny, glabrous, with a weak zonation (darker concentric bands) and orange to pink-orange color, a feature reflected in the specific epithet. </Li> <li> plates are arranged in a very dense subhoritzontal and are the same color as the hat or even a little paler (orange hue of light) and turn greenish in color as they age. </li> < li> The leg is cylindrical, measuring 4-7 x 1-2 cm, color is paler than the cap, often with numerous whitish orange Fossett (escrobícules). </li> <li> Meat is dense, compact, light orange and exude a latex uncommon orange flashing. The smell is sweet, and the flavor has a slight bitter aftertaste. </Li> <li> spores measure 9 to 11.5 x 6 to 7.5 microns, are ellipsoidal, without germ pore, amyloid (s dye in the presence of reactive iodine) and adorned with a subreticle. </li> </ul> </span> <h3> Habitat and geographical </h3> <p> Bears fruit especially the subalpine ( between 1,300 and 1,800 m) in acid soils only under fir (Abies alba <span class=\"foreignLanguage\"> </span>), though sometimes also been found associated with <span class = \"foreignLanguage\"> Picea </span> class=\"foreignLanguage\"> spp. </span> <span class=\"foreignLanguage\"> Taxus </span> - in Europe (Andorra, England, including the counties Kent and West Sussex, Scotland, Belgium, the French, Germany, Italy, Norway, Poland, Romania, Slovakia, Slovenia, Spain-like, Alt Urgell, Senior Ribagorça Pallars jussà the culd the border, and the Aran Valley-Sweden and Switzerland), Morocco, Turkey and America (USA, Mexico, Guatemala and Belize). </P> </span> <h3> edibility </h3> <p> edible, although the lower quality saffron as it is quite bland and mediocre. </P> </span> <h3> risk of confusion with other species </h3> <p> basidioma color of salmon, habitat where fruits as well as orange latex immutable facilitate very correctly identify Pinetell fir. However, this fungus belongs to the group of mushrooms, which have a color and exude a latex of a wide range of orange or reddish tones, which makes them quite similar. Thus, it could be confused with Lactarius <span class=\"foreignLanguage\"> sanguifluus </span> <span class=\"foreignLanguage\"> Lactarius vinosus </span> species that exude a latex vinous color, hue can also be observed in his hat and sheets; <span class=\"foreignLanguage\"> Lactarius semisanguifluus </span>, which initially has orange latex, then red and finally vinous; <span class=\"foreignLanguage\"> Lactarius quieticolor </span>, whose hat orange brown and finally becomes all green, and <span class=\"foreignLanguage\"> Lactarius deliciosus </span>, which is reddish patch of green with orange latex Carrot immutable. </p> </div>", "photos":[{"mushroomid":"Pinetell_davet","img":"wiki\/pinetell.davet2.jpg"},{"mushroomid":"Pinetell_davet","img":"wiki\/pinetell.davet4.jpg"},{"mushroomid":"Pinetell_davet","img":"wiki\/pinetell.davet5.jpg"},{"mushroomid":"Pinetell_davet","img":"wiki\/pinetell.davet6.jpg"},{"mushroomid":"Pinetell_davet","img":"wiki\/pinetell.davet7.jpg"},{"mushroomid":"Pinetell_davet","img":"wiki\/pinetell.davet8.jpg"},{"mushroomid":"Pinetell_davet","img":"wiki\/pinetell.davet9.jpg"}], "attributes":[{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Rovello", "latinname":"Lactarius sanguifluus", "name":"Lactarius sanguifluus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius sanguifluus</span></span>, commonly known as the <span class=\"mushroomName\">bloody milk cap</span>, is a species of fungus in the family Russulaceae. First described from France in 1811, the species was given its current name by Elias Fries in 1838 when he transferred it to <span class=\"foreignLanguage\">Lactarius</span>. Found in Asia, Mediterranean Africa, and Europe, fruit bodies (mushrooms) grow scattered or in groups on the ground under conifers, especially Douglas fir. When bruised or cut, the fruit bodies ooze a blood-red to purple latex that turns greenish upon exposure to air. The caps are orangish to reddish-brown, and become funnel-shaped with age. The gills are pinkish. Different forms have been described from Italy, but these are not universally accepted as distinct. <span class=\"foreignLanguage\">L.&nbsp;sanguifluus</span> mushrooms are edible, and sold in rural markets of Europe and Asia. Fruit bodies grown in polluted soil, including roadsides subject to heavy traffic, can bioaccumulate toxic heavy metals. Several sterols and pigment have been isolated and identified from the mushrooms.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius sanguifluus</span></span>, commonly known as the <span class=\"mushroomName\">bloody milk cap</span>, is a species of fungus in the family Russulaceae. First described from France in 1811, the species was given its current name by Elias Fries in 1838 when he transferred it to <span class=\"foreignLanguage\">Lactarius</span>. Found in Asia, Mediterranean Africa, and Europe, fruit bodies (mushrooms) grow scattered or in groups on the ground under conifers, especially Douglas fir. When bruised or cut, the fruit bodies ooze a blood-red to purple latex that turns greenish upon exposure to air. The caps are orangish to reddish-brown, and become funnel-shaped with age. The gills are pinkish. Different forms have been described from Italy, but these are not universally accepted as distinct. <span class=\"foreignLanguage\">L.&nbsp;sanguifluus</span> mushrooms are edible, and sold in rural markets of Europe and Asia. Fruit bodies grown in polluted soil, including roadsides subject to heavy traffic, can bioaccumulate toxic heavy metals. Several sterols and pigment have been isolated and identified from the mushrooms.</p></div><div><h3>Taxonomy</h3><p>The fungus was first described by French mycologist  Jean-Jacques Paulet as <span class=\"foreignLanguage\">Hypophyllum sanguifluum</span> in 1811. Later authors did not agree with the delimitation of these forms as distinct taxa, suggesting that the alternations in appearance represent normal morphological variations brought about by differences in age, and environmental factors such as levels of sunlight and humidity. The specific epithet <span class=\"foreignLanguage\">sanguifluus</span> is derived from the Latin words <span class=\"foreignLanguage\">sanguis</span> (\"blood\") and <span class=\"foreignLanguage\">fluus</span> (\"flowing\").</p><p>The spores are roughly spherical to ellipsoidal, measuring 7.9–9.5 by 8.0–8.8&nbsp;µm. They feature surface ornamentations up to 0.8&nbsp;µm high and an almost complete reticulum comprising broad, rounded ridges. The basidia (spore-bearing cells) are somewhat cylindrical, four-spored, and measure 50–70 by 9–11&nbsp;µm. The cap cuticle is an ixocutis (made of gelatinous hyphae that run parallel to the cap surface) up to 60&nbsp;µm thick, with hyphae that are 2–6&nbsp;wide that are usually branched and interwoven. Another potential lookalike, <span class=\"foreignLanguage\">L.&nbsp;semisanguifluus</span>, has a characteristic orange latex that turns wine-red in 5–10 minutes after exposure to air. Compared to <span class=\"foreignLanguage\">L.&nbsp;sanguifluus</span>, the fruit bodies of <span class=\"foreignLanguage\">L.&nbsp;semisanguifluus</span> are smaller, have tinges of violet in the cap, and develop a greenish discolouration with age.</p></div><div><h3>Habitat and distribution</h3><p>An ectomycorrhizal species, <span class=\"foreignLanguage\">Lactarius sanguifluus</span> fruit bodies grow on the ground in association with pine trees on calcareous soils. <span class=\"foreignLanguage\">L.&nbsp;sanguifluus</span> is widely distributed in Himachal Pradesh in India, where it has been noted to grow in mixed coniferous forests, usually under the fern <span class=\"foreignLanguage\">Onychium contiguum</span>. Greece, In Africa, the species has been collected in Morocco; Turkey, and Yunnan Province, China.  In India, young specimens are consumed along with <span class=\"foreignLanguage\">L.&nbsp;deliciosus</span>; some consider <span class=\"foreignLanguage\">L.&nbsp;sanguifluus</span> to have a better flavor than its more well-known relative.</p><p>Fruit bodies can bioaccumulate heavy metals, including toxic ones, from polluted soil. For this reason, consuming mushrooms harvested from potentially contaminated sites—such as near roadsides subject to heavy traffic—is not recommended. In a Turkish study of various edible mushroom species collected from lawns, near roads, and the inner parts of forests, the fruit bodies of <span class=\"foreignLanguage\">L.&nbsp;sanguifluus</span> were determined to have accumulated high levels of zinc, manganese, nickel, cobalt, cadmium, and lead.</p></div><div><h3>Bioactive compounds</h3><p><span class=\"foreignLanguage\">Lactarius sanguifluus</span> contains a mixture of sterols. The predominant sterol is ergosterol (56.6% of total sterols), with lesser amounts of ergosterol derivatives, including ergost-7-en-3β-ol, ergosta-7,22-dien-3β-ol, and ergosta-5,7-dien-3β-ol.</p><p>The latex contains sesquiterpene pigments with guaiane skeletons; these include the compounds given the common names lactaroviolin and sangol. Some of these chemicals are thought to undergo enzymatic conversions when the fruit body becomes injured. Fruit body extracts have been shown to have some antimicrobial activity against Gram-positive and Gram-negative bacteria.</p></div><div><h3>=Cited literature=</h3><ul><li></li><li></li><li></li></ul></div>", "photos":[{"mushroomid":"Rovello","img":"wiki\/rovello1.jpg"},{"mushroomid":"Rovello","img":"wiki\/rovello2.jpg"},{"mushroomid":"Rovello","img":"wiki\/rovello4.jpg"},{"mushroomid":"Rovello","img":"wiki\/rovello5.jpg"},{"mushroomid":"Rovello","img":"wiki\/rovello6.jpg"},{"mushroomid":"Rovello","img":"wiki\/rovello7.jpg"},{"mushroomid":"Rovello","img":"wiki\/rovello8.jpg"}], "attributes":[{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "vermell", "attributeId":"color_peu", "img":"peu_vermell.svg.png", "name":"red"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pinetell_bord", "latinname":"Lactarius scrobiculatus", "name":"Lactarius scrobiculatus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius scrobiculatus</span></span> is a basidiomycete fungus, belonging to the genus Lactarius, whose members are called \"milk caps.\" Taxonomy places this species into subgenus Piperites, section Zonarii, subsection Scrobiculati.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius scrobiculatus</span></span> is a basidiomycete fungus, belonging to the genus Lactarius, whose members are called \"milk caps.\" Taxonomy places this species into subgenus Piperites, section Zonarii, subsection Scrobiculati.</p><p>The distinctive fruiting bodies of this large fungus are locally common in forests throughout Europe and North America. It is regarded as inedible by some authors, but it is nevertheless eaten in parts of Europe.</p></div><div><h3>Description</h3><p><span class=\"foreignLanguage\">Lactarius scrobiculatus</span> produces large agaricoid fruiting bodies which arise from soil. The cap has an eye-catching orange to yellow coloration and is covered with small scales arranged in indistinctive concentric rings. The surface is wet, glossy and slimy especially in wet weather. The cap may be wide, with a large diameter (about 15&nbsp;cm in mature specimens), but with a depressed centre and slightly inrolled margin. The gills are crowded and coloured cream to yellow, with darker patches being present sometimes. When cut, the gills bleed copious amounts of a white to cream milk (latex), which soon darkens to yellow. The stem, in relation to the cap, is quite short and stubby. The surface is cap-coloured but the presence of small pits, filled with fluid, is a key identifying feature. The stem is hollow. The spores are coloured creamy with an elliptical-globular shape. It doesn't have any discernible smell.</p><p>There are several recognised varieties, including var. <span class=\"foreignLanguage\">canadensis</span>. var. <span class=\"foreignLanguage\">montanus</span> and var. <span class=\"foreignLanguage\">pubescens</span>. It occurs primarily in coniferous and birch forests. Consuming it irritates the gastrointestinal tract, causing symptoms of gastrointestinal syndrome. Careful preparation seeks to neutralise the acrid taste. This usually involves a process of boiling, during which the water is discarded. Further cooking and pickling may not eliminate the possibility of distressing symptoms.</p></div>", "photos":[{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord10.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord11.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord2.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord3.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord4.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord5.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord6.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord7.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord8.jpg"},{"mushroomid":"Pinetell_bord","img":"wiki\/pinetell.bord9.jpg"}], "attributes":[{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "groc", "attributeId":"color_capell", "img":"capell_groc.svg.png", "name":"yellow"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "groc", "attributeId":"color_peu", "img":"peu_groc.svg.png", "name":"yellow"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Lleterol_de_bedoll", "latinname":"Lactarius torminosus", "name":"Lactarius torminosus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius torminosus</span></span>, commonly known as the <span class=\"mushroomName\">woolly milkcap</span> or the <span class=\"mushroomName\">bearded milkcap</span>, is a large agaric fungus. A common and widely distributed species, it is found in North Africa, northern Asia, Europe, and North America. It was first described scientifically by Jacob Christian Schäffer in 1774 as an <span class=\"foreignLanguage\">Agaricus</span>, and later transferred to the genus <span class=\"foreignLanguage\">Lactarius</span> in 1821 by Samuel Frederick Gray. A variety, <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> var. <span class=\"foreignLanguage\">nordmanensis</span>, is known from the United States, Canada, and Switzerland. <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> officially became the type species of <span class=\"foreignLanguage\">Lactarius</span> in 2011 after molecular studies prompted the taxonomic reshuffling of species between several Russulaceae genera.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius torminosus</span></span>, commonly known as the <span class=\"mushroomName\">woolly milkcap</span> or the <span class=\"mushroomName\">bearded milkcap</span>, is a large agaric fungus. A common and widely distributed species, it is found in North Africa, northern Asia, Europe, and North America. It was first described scientifically by Jacob Christian Schäffer in 1774 as an <span class=\"foreignLanguage\">Agaricus</span>, and later transferred to the genus <span class=\"foreignLanguage\">Lactarius</span> in 1821 by Samuel Frederick Gray. A variety, <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> var. <span class=\"foreignLanguage\">nordmanensis</span>, is known from the United States, Canada, and Switzerland. <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> officially became the type species of <span class=\"foreignLanguage\">Lactarius</span> in 2011 after molecular studies prompted the taxonomic reshuffling of species between several Russulaceae genera.</p><p>A mycorrhizal species, <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> associates with various trees, most commonly birch, and its fruit bodies (mushrooms) grow on the ground singly or in groups in mixed forests. The caps of <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> mushrooms are convex with a central depression, and attain a diameter of up to . A blend of pink and ochre hues, the cap sometimes has concentric zones of alternating lighter and darker shades. The edge of the cap is rolled inward, and shaggy when young. On the underside of the cap are narrow flesh-colored gills that are crowded closely together. The cylindrical stem is a pale flesh color with a delicately downy surface and brittle flesh; it is up to  long and  thick. When cut or injured, the fruit bodies ooze a bitter white latex that does not change color upon exposure to air. The variety <span class=\"foreignLanguage\">nordmanensis</span>, in contrast, has latex that changes from white to yellow. <span class=\"foreignLanguage\">Lactarius torminosus</span> can be distinguished from similar species like <span class=\"foreignLanguage\">L.&nbsp;pubescens</span> or <span class=\"foreignLanguage\">L.&nbsp;villosus</span> by differences in morphology and coloration, or by microscopic characteristics like spore shape and size.</p><p>Although it is valued for its peppery flavor and eaten after suitable preparation in Russia and Finland, the species is highly irritating to the digestive system when eaten raw. The toxins, also responsible for the strongly bitter or acrid taste, are destroyed by cooking. Studies have identified several chemicals present in the mushrooms, including ergosterol and derivatives thereof, and the pungent-tasting velleral.</p></div><div><h3>Taxonomy and phylogeny</h3><p>German naturalist Jacob Christian Schäffer was the first to describe the species, placing it in <span class=\"foreignLanguage\">Agaricus</span> in 1774. A 2004 phylogenetic analysis of European <span class=\"foreignLanguage\">Lactarius</span> species concluded that <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> falls into a group that includes <span class=\"foreignLanguage\">L.&nbsp;torminosulus</span>, and that these two species are closely related to a group that includes <span class=\"foreignLanguage\">L.&nbsp;tesquorum</span>, <span class=\"foreignLanguage\">L.&nbsp;scoticus</span>, and <span class=\"foreignLanguage\">L.&nbsp;pubescens</span>.</p><p>The fruit body formation of <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> is pileostipitocarpic. In this type of development, the hymenium forms early on the underside of the cap and upper stem of the mushroom primordium. As the cap enlarges, the margin, made of flaring filamentous hyphae that grow outward and downward, tends to curve inward, eventually forming a flap of tissue roughly parallel to the stem surface. As further development takes place, these hyphae make contact with and adhere to the hymenial surface of the stem, covering basidia and macrocystidia (very long cystidia) already present. The junction between the two tissues produces a cavity that provides some temporary protection to the basidia, although they are already fertile when the cap margin starts to grow. The holotype specimen of <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> var. <span class=\"foreignLanguage\">nordmanensis</span> was collected by Smith in 1956 near Nordman, Idaho. <span class=\"foreignLanguage\">L.&nbsp;subtorminosus</span> was named for its similarity to <span class=\"foreignLanguage\">L.&nbsp;torminosus</span>. It can be distinguished by its mild-tasting latex and smaller, roughly spherical spores measuring 5.5–7 by 5.5–6.5&nbsp;μm.</p></div><div><h3>Edibility and toxicity</h3><p>The intensely peppery taste of the raw mushroom can blister the tongue if sampled in excess. Some authors have reported the species as outright poisonous, or causing \"mild to fatal gastroenteritis\". In a 1930 publication, Hans Steidle reported that although the mushroom was not toxic to \"unicellular and cold-blooded organisms\" when ingested, the liquid extract and the pressed juice of the fruit bodies, when injected under the skin of a frog, resulted in disturbed breathing, paralysis, and eventually death. Symptoms that are typically experienced after consuming raw mushrooms include nausea, vomiting, and severe diarrhea that starts about one hour after ingestion. This combination can lead to dehydration, muscle spasms, and circulatory collapse. The gastroenteritis will usually resolve without treatment in a couple of days.</p><p>Despite these reports of toxicity, <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> mushrooms are prepared in Finland, Russia, and other northern and eastern European countries by parboiling, soaking in brine for several days, or pickling, after which it is valued for its peppery taste. In Norway, it is roasted and added to coffee. Mushrooms are harvested for commercial sale in Finland. The nutrient composition of Finnish specimens has been analyzed and found to contain the following components (as a percentage of dry weight): protein, 17.2%; phosphorus, 0.46%; calcium, 0.12%; magnesium, 0.088%; potassium, 2.97%; sodium 0.011%.</p></div><div><h3>Chemistry</h3><p>The compound thought to be responsible for the toxicity of raw <span class=\"foreignLanguage\">L.&nbsp;torminosus</span> is the pungent-tasting  velleral present at a concentration of 0.16&nbsp;mg/g mushroom. Velleral is a breakdown product of stearyl-velutinal. Broken lactifers—specialized hyphal cells that produce the mushroom's latex—leak the precursor chemicals whose breakdown products act as the defensive agents toxic to humans, effectively deterring certain vertebrates that might consume the mushroom. The lactarane-type sesquiterpene lactone 15-hydroxyblennin&nbsp;A is one of several sesquiterpenes produced by the species. Other lactaranes are found in various <span class=\"foreignLanguage\">Lactarius</span> species, such as blennin&nbsp;A in <span class=\"foreignLanguage\">L.&nbsp;deliciosus</span> and <span class=\"foreignLanguage\">L.&nbsp;blennius</span>, and lactarorufin&nbsp;N in <span class=\"foreignLanguage\">Lactarius rufus</span>. Fungal sesquiterpenes are commonly produced as toxins to defend against predation, and as a result some have chemical properties that may have applications in medicinal chemistry.</p><p>Fruit bodies of <span class=\"foreignLanguage\">Lactarius torminosus</span> contain a number of sterols, of which ergosterol (a component of fungal cell walls) is the most predominant at 60.5% of all sterols, followed by its derivatives and ergosta-5/7-dien-3-ol (17.0%), ergost-7-en-3-ol (13.7%) and ergosta-7-22-dien-3-ol (8.3%). Researchers have identified 28 volatile compounds that contribute to the odor of the mushroom. Many of these are alcohols and carbonyl compounds with eight carbon atoms; the predominant volatile compound (about 90%) is 1-octen-3-one, an odorant common in mushrooms.</p></div><div><h3>Ecology and distribution</h3><p><span class=\"foreignLanguage\">Lactarius torminosus</span> is a mycorrhizal species, and as such plays an important role in facilitating nutrient and water uptake by trees. It grows in association with birch (<span class=\"foreignLanguage\">Betula</span>) and hemlock (<span class=\"foreignLanguage\">Tsuga</span>) in mixed forests. It is also known to grow in urban settings when birch trees are nearby. A field study in Scotland concluded that the species is more likely to be present in older than in younger birch woodlands. Fruit bodies grow on the ground, scattered or grouped together. They are a component of the diet of the red squirrel, and serve as breeding sites for some fungus-feeding flies in the Drosophilidae and Mycetophilidae families. <span class=\"foreignLanguage\">Lactarius torminosus</span> mushrooms may be parasitized by the mold <span class=\"foreignLanguage\">Hypomyces lithuanicus</span>, which produces a cream-ochre to cinnamon-colored granular or velvety growth of mycelium on the surfaces of the gills and causes them to be deformed.</p><p>The species is found in northern temperate and boreal climates, penetrating sometimes into subarctic regions. It has been recorded from North Africa, northern Asia, Europe, and is common in North America, where it sometimes grows with aspen (<span class=\"foreignLanguage\">Populus</span> species). The North American distribution extends north into the Yukon and Alaska and south to Mexico.</p></div><div><h3>Cited texts</h3><ul><li></li><li></li></ul></div>", "photos":[{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll10.jpg"},{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll2.jpg"},{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll3.jpg"},{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll4.jpg"},{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll5.jpg"},{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll6.jpg"},{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll7.jpg"},{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll8.jpg"},{"mushroomid":"Lleterol_de_bedoll","img":"wiki\/lleterol.de.bedoll9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "caution", "attributeId":"comestibilitat", "img":"comestibilitat_reserves.png", "name":"caution"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pebrassa_vellutada", "latinname":"Lactarius vellereus", "name":"Lactarius vellereus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius vellereus</span></span>, commonly known as the <span class=\"mushroomName\">fleecy milk-cap</span>, is a very large fungus in the milk-cap genus <span class=\"foreignLanguage\">Lactarius</span>. It is one of the two most common milk-caps found with beech trees, with the other being <span class=\"foreignLanguage\">L.&nbsp;subdulcis</span>.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius vellereus</span></span>, commonly known as the <span class=\"mushroomName\">fleecy milk-cap</span>, is a very large fungus in the milk-cap genus <span class=\"foreignLanguage\">Lactarius</span>. It is one of the two most common milk-caps found with beech trees, with the other being <span class=\"foreignLanguage\">L.&nbsp;subdulcis</span>.</p></div><div><h3>Description</h3><p>Like other mushrooms in the <span class=\"foreignLanguage\">Lactarius</span> genus, the <span class=\"foreignLanguage\">L.&nbsp;vellereus</span> fruit body has crumbly, rather than fibrous, flesh, and when this is broken the fungus exudes a milky latex. The mature caps are white to cream, funnel-shaped, and up to  in diameter. It has firm flesh, and a stipe which is shorter than the fruit body is wide. The gills are fairly distant (quite far apart), decurrent, and narrow, and have brown specks from the drying milk.</p><p>It is similar in appearance to <span class=\"foreignLanguage\">Lactarius controversus</span> Pers., distinguishable mainly by its white gills and lack of rosy markings on the upper cap. <span class=\"foreignLanguage\">Lactarius bertillonii</span> (Z.Schaef.) Bon. is similar, but has hotter milk.</p></div><div><h3>Edibility</h3><p>The milk tastes mild on its own, but hot when tasted with the flesh. It is considered inedible because of its peppery taste.</p></div>", "photos":[{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada1.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada12.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada13.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada14.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada15.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada16.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada17.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada18.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada3.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada4.jpeg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada5.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada6.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada7.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada8.jpg"},{"mushroomid":"Pebrassa_vellutada","img":"wiki\/pebrassa.vellutada9.jpg"}], "attributes":[{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Lleterola_roja", "latinname":"Lactarius volemus", "name":"Lactarius volemus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius volemus</span></span> is a species of fungus in the family Russulaceae. It is widely distributed in the northern hemisphere, in temperate regions of Europe, North America and Asia as well as some subtropical and tropical regions of Central America and Asia. A mycorrhizal fungus, its fruit bodies grow on the ground at the base of various species of trees from summer to autumn, either individually or in groups. It is valued as an edible mushroom, and is sold in markets in Asia. Several other <span class=\"foreignLanguage\">Lactarius</span> mushrooms resemble <span class=\"foreignLanguage\">L.&nbsp;volemus</span>, such as the closely related edible species <span class=\"foreignLanguage\">L.&nbsp;corrugis</span>, but these can be distinguished by differences in distribution, visible morphology, and microscopic characteristics. <span class=\"foreignLanguage\">L.&nbsp;volemus</span> produces a white spore print and has roughly spherical spores about 7–8&nbsp;micrometres in diameter.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Lactarius volemus</span></span> is a species of fungus in the family Russulaceae. It is widely distributed in the northern hemisphere, in temperate regions of Europe, North America and Asia as well as some subtropical and tropical regions of Central America and Asia. A mycorrhizal fungus, its fruit bodies grow on the ground at the base of various species of trees from summer to autumn, either individually or in groups. It is valued as an edible mushroom, and is sold in markets in Asia. Several other <span class=\"foreignLanguage\">Lactarius</span> mushrooms resemble <span class=\"foreignLanguage\">L.&nbsp;volemus</span>, such as the closely related edible species <span class=\"foreignLanguage\">L.&nbsp;corrugis</span>, but these can be distinguished by differences in distribution, visible morphology, and microscopic characteristics. <span class=\"foreignLanguage\">L.&nbsp;volemus</span> produces a white spore print and has roughly spherical spores about 7–8&nbsp;micrometres in diameter.</p><p>The colour of the <span class=\"foreignLanguage\">L.&nbsp;volemus</span> mushroom varies from apricot to tawny, and the cap may be up to 11&nbsp;cm (&nbsp;in) wide. The pale golden yellow gills on the underside of the cap are closely spaced and sometimes forked. One of the mushroom's most distinctive features is the large amount of latex (\"milk\") that it exudes when the gills are damaged, leading to the common names <span class=\"mushroomName\">weeping milk cap</span> and <span class=\"mushroomName\">voluminous-latex milky</span>. It also has a distinctive fishy smell, which does not affect the taste. The fruit bodies have been chemically analysed and found to contain several sterols related to ergosterol, some of which are unique to this species. The mushroom also contains a natural rubber that has been chemically characterized. Phylogenetic analysis suggests that <span class=\"foreignLanguage\">Lactarius volemus</span> represents several species or subspecies, rather than a single taxon.</p></div><div><h3>Taxonomy and naming</h3><p>The first mention of <span class=\"foreignLanguage\">Lactarius volemus</span> in the scientific literature was in  Carl Linnaeus's 1753 <span class=\"foreignLanguage\">Species Plantarum</span>, under the name <span class=\"foreignLanguage\">Agaricus lactifluus</span>.</p></div><div><h3>Phylogeny</h3><p>{{cladogram|align=left|title=</p><p>|clade=</p><p>{{clade</p><p>|style=font-size:75%;line-height:75%</p><p>|label1=</p><p>|1={{clade</p><p>    |1={{clade</p><p>        |1={{clade</p><p>            |1={{clade</p><p>               |1={{clade</p><p>                  |1=</p><p>                   |2=</p><p>                   |3=</p><p>            }}</p><p>        |2=<span class=\"foreignLanguage\">L. hygrophoroides</span></p><p>        }}</p><p>    |2=<span class=\"foreignLanguage\">L. piperatus</span></p><p>    }}</p><p>|2=</p><p>}}</p><p>}}}}</p><p>|caption=Phylogeny of <span class=\"foreignLanguage\">Lactarius</span> section <span class=\"foreignLanguage\">Dulces</span>  based on large subunit rDNA sequences. <span class=\"foreignLanguage\">L.&nbsp;volemus</span> and <span class=\"foreignLanguage\">L.&nbsp;corrugis</span> specimens are distinguished based on differences in colour or distribution: A-1, velvet type; A-2 red type; A-3, Chinese type; B-1, red type; B-2, common type; C-1, common in Japan; C-2, yellow type.</p><p>}}</p><p><span class=\"foreignLanguage\">Lactarius volemus</span> is the type species of the section <span class=\"foreignLanguage\">Dulces</span> in subgenus <span class=\"foreignLanguage\">Lactifluus</span>. This grouping includes species with a dry cap, abundant latex, and a white or pale cream spore print.</p><p>The variety <span class=\"foreignLanguage\">Lactarius volemus</span> var. <span class=\"foreignLanguage\">flavus</span> was described by Alexander H. Smith and Lexemuel Ray Hesler in their 1979 monograph of North American <span class=\"foreignLanguage\">Lactarius</span> species. <span class=\"foreignLanguage\">L.&nbsp;volemus</span> forms ectomycorrhizae, mutually beneficial symbiotic associations with various tree species. In this association, the fungal hyphae grow around the root of the plant and between its cortical cells, but do not actually penetrate them. The hyphae extend outward into the soil, increasing the surface area for absorption to help the plant absorb nutrients from the soil. It is found growing at the base of both coniferous and broad-leaved trees, although it is more common in deciduous woods. It may also sometimes be found in peat moss beds. The fruit bodies, which appear between summer and autumn, are common. They can be found growing solitarily or in groups, and are more abundant in weather that is warm and humid.</p><p>Fruit bodies can be inhabited by species of limoniid flies, such as <span class=\"foreignLanguage\">Discobola marginata</span> or <span class=\"foreignLanguage\">Limonia yakushimensis</span>, as well as several species of fungi-dwelling mites. The flies are hosts for the mites in a symbiotic association known as <span class=\"foreignLanguage\">phoresis</span>, whereby the mites are mechanically carried by its host. Mites are small and unable to migrate the relatively long distances between mushrooms without assistance; the insect hosts, in comparison, are large and can transfer the mites between their preferred feeding habitats.</p><p><span class=\"foreignLanguage\">Lactarius volemus</span> is found in warm temperate regions and as well as some subtropical and tropical regions of the Northern Hemisphere. The fungus is widely distributed throughout Europe, although it is in decline in some countries, and has become rare enough in the Netherlands (and Flanders) to be considered locally extinct. In the Americas, the northern limit of its distribution reaches southern Canada east of the Great Plains, and the species extends south to the East Coast of the United States and Mexico, and beyond into Central America (Guatemala). It is also known from Asia, including China (Qinling Mountains, Guizhou Province, and Yunnan Province), Japan, India, Korea, Nepal, and Vietnam. Collections have also been made from the Middle East, including Iran and Turkey.</p></div><div><h3>=Cited text=</h3><ul><li></li></ul></div>", "photos":[{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja10.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja11.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja12.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja13.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja14.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja15.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja16.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja17.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja18.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja19.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja2.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja20.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja21.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja22.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja23.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja24.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja25.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja3.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja5.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja6.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja7.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja8.jpg"},{"mushroomid":"Lleterola_roja","img":"wiki\/lleterola.roja9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "groc", "attributeId":"color_capell", "img":"capell_groc.svg.png", "name":"yellow"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Esclata-sang_blanc", "latinname":"Lactarius zonarius", "name":"Lactarius zonarius", "names":"", "description":"<div> <p> The <span class=\"mushroomName\"> explodes white-blood </span> <span class=\"mushroomName\"> burst blood-board </span> <span class=\"mushroomName\"> burst blood-boiling </span> <span class=\"mushroomName\"> broke blood-oak </span> <span class=\"mushroomName\"> broke blood-milk </span> <span class = \"mushroomName\"> burst-blood lawyer </a> or <span class=\"mushroomName\"> Nightjar </span> (<span class=\"foreignLanguage\"> Lactarius zonarius </span>) is a species of mushroom belonging to the family russulàcies. </p> </span> <h3> Description </h3> <ul> <li> cap measure 5 to 11 cm in diameter, although the outset is pumped later flattened and has a clear central depression. The margin is often wavy. The surface is colored yellow to brown ocraci ocraci with the red or orange, shiny, naked (glabra) and zonada clear (ie, presents a drawing concentric bands of darker color). </Li> <li> The sheets go up to bed and often extend it a little walk (adnatodecurrents). They are quite numerous and dense cream colored pale cream ocraci. The edge is full and the same color. </Li> <li> leg is tough, robust, cylindrical, measuring 2 to 4.5 x 1-2 cm and are whitish, mature tone that appears smudged brunenc of yellow. </li> <li> Meat is compact, whitish exudate an abundant whitish latex and immutable. </li> <li> is acidulous smell and taste, good soft top, then turns a little spicy. </li> <li> sporadic color is pale cream. The spores are ellipsoidal in subglobosa, Warty, and measure 7 to 8.5 x 5.5 to 6 microns. The basidis are tetraspòrics. </Li> </ul> </span> <h3> Habitat and geographical </h3> <p> is a common species that grows between 300 and 1,500 m on basic soils (generally under-leaved, especially oaks, such as Quercus pyrenaica <span class=\"foreignLanguage\"> </span> - oak, among others, <span class=\"foreignLanguage\"> Quercus suber </span> - <span class=\"foreignLanguage\"> Castanea sativa </span>, etc.). fruits of summer and in autumn (from July to November) forming groups. (Austria, Denmark, Estonia, Finland, the French, Germany, Greece, Italy, such as Lombardy, Campania, Tuscany, etc. - Luxembourg, Norway, Romania, Bulgaria, Ukraine, Slovenia, the Czech Macedonia, Croatia, Spain, such as Andalusia, Spain, Sweden, Switzerland and the UK), Morocco, America (Canada, the United States and Costa Rica) and Japan. Catalan Countries is present in Mallorca, Menorca, the Guillerias the Park Moixeró etc.. </P> </span> <h3> edibility </h3> <p> edible only after 'scald it, although it is advisable consumption. </P> </span> <h3> risk of confusion with other species </h3> <p> be confused with Lactarius <span class=\"foreignLanguage\"> acerrimus </span> (which has leg slightly eccentric, latex and very spicy basidis bispòrics) <span class=\"foreignLanguage\"> Lactarius evosmus </span> (paler and with a scent reminiscent of apples) and <span class = \"foreignLanguage\"> Lactarius bresadolanus </span> (with an orange coloration). </P> </div>", "photos":[{"mushroomid":"Esclata-sang_blanc","img":"wiki\/esclata-sang.blanc4.jpg"},{"mushroomid":"Esclata-sang_blanc","img":"wiki\/esclata-sang.blanc5.jpg"}], "attributes":[{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"}]},{"id": "Pampeta", "latinname":"Lepista inversa", "name":"Lepista inversa", "names":"", "description":"<div> <p> <span class=\"mushroomName\"> pampeta </​​span> (<span class=\"foreignLanguage\"> Lepista reverse </span> <span Greek class=\"foreignLanguage\"> lepasté </span >-width glass ceramics reminiscent of a mushroom-shaped, and the Latin opposite <span class=\"foreignLanguage\"> </span>-inverted-. scientific name makes clear reference to the hat over long incurved , looking down) is one of the most common mushrooms in autumn leaves, without many demands, and groups everywhere. </p> </span> <h3> Morphology </h3> <p>> His hat, a funnel-shaped and very sharp with rolled edge, for 3 to 10 cm wide. It is reddish brown or ocher orange slices and carried under very decurrent cream, which is easily separated from the flesh of the cap if it is with your fingers. </P> The foot is rather thin, ivory, and bottom door always too cottony, mycelial remains that many laps hooked several leaves, which thus remain trapped at the base of the foot. </P> The meat is very thin, whitish. </P> </span> <h3> edibility </h3> <p> edible mushroom taste nice, not too strong, not long tradition, which can then be harvested that is not anything good. </p> </div>", "photos":[{"mushroomid":"Pampeta","img":"wiki\/pampeta1.jpg"}], "attributes":[{"valueId": "infundibuliform", "attributeId":"capell", "img":"Infundibuliform_cap_icon.svg.png", "name":"infundibuliform"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pimpinella_morada", "latinname":"Lepista nuda", "name":"Clitocybe nuda", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Clitocybe nuda</span></span> (also recognized as <span class=\"foreignLanguage\">Lepista nuda</span> and <span class=\"foreignLanguage\">Tricholoma nudum</span>, commonly known as the <span class=\"mushroomName\">wood blewit</span> or <span class=\"mushroomName\">blue stalk mushroom</span>), is an edible mushroom, found in both coniferous and deciduous woodlands. It is a fairly distinctive mushroom that is widely eaten, though there is some caution about edibility. Nevertheless it has been cultivated in Britain, the Netherlands and France.  The primary issue here is a debate about the correct type for the genus <span class=\"foreignLanguage\">Clitocybe</span>. Some, including Singer, take the type to be <span class=\"foreignLanguage\">C. gibba</span>. However, the majority of experts now take <span class=\"foreignLanguage\">C. nebularis</span> to be the type. If <span class=\"foreignLanguage\">C. nebularis</span> is taken to be the type, then <span class=\"foreignLanguage\">Lepista</span> becomes a deprecated synonym of <span class=\"foreignLanguage\">Clitocybe</span>, and <span class=\"foreignLanguage\">Clitocybe nuda</span> is the correct name for this species.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Clitocybe nuda</span></span> (also recognized as <span class=\"foreignLanguage\">Lepista nuda</span> and <span class=\"foreignLanguage\">Tricholoma nudum</span>, commonly known as the <span class=\"mushroomName\">wood blewit</span> or <span class=\"mushroomName\">blue stalk mushroom</span>), is an edible mushroom, found in both coniferous and deciduous woodlands. It is a fairly distinctive mushroom that is widely eaten, though there is some caution about edibility. Nevertheless it has been cultivated in Britain, the Netherlands and France.  The primary issue here is a debate about the correct type for the genus <span class=\"foreignLanguage\">Clitocybe</span>. Some, including Singer, take the type to be <span class=\"foreignLanguage\">C. gibba</span>. However, the majority of experts now take <span class=\"foreignLanguage\">C. nebularis</span> to be the type. If <span class=\"foreignLanguage\">C. nebularis</span> is taken to be the type, then <span class=\"foreignLanguage\">Lepista</span> becomes a deprecated synonym of <span class=\"foreignLanguage\">Clitocybe</span>, and <span class=\"foreignLanguage\">Clitocybe nuda</span> is the correct name for this species.</p></div><div><h3>Description</h3><p>This mushroom can range from lilac to purple-pink. Some North American specimens are duller and tend toward tan, but usually have purplish tones on the stem and gills. The gills are attached to the short, stout stem. Mature specimens have a darker color and flatter cap; younger ones are lighter with more convex caps. Wood blewits have a very distinctive odor, which has been likened by one author to that of frozen orange juice.</p><p>Wood blewits can be confused with certain purple <span class=\"foreignLanguage\">Cortinarius</span> species, including the uncommon <span class=\"foreignLanguage\">C. camphoratus</span>,<!-- cites para --></p></div><div><h3>Distribution and habitat</h3><p>The wood blewit is found in Europe and North America and is becoming more common in Australia, where it appears to have been introduced. It is a saprotrophic species, growing on decaying leaf litter.</p><p>Soil analysis of soil containing mycelium from a wood blewit fairy ring under Norway spruce (<span class=\"foreignLanguage\">Picea abies</span>) and Scots pine (<span class=\"foreignLanguage\">Pinus sylvestris</span>) in southeast Sweden yielded fourteen halogenated low molecular weight organic compounds, three of which were brominated and the others chlorinated. It is unclear whether these were metabolites or pollutants. Brominated compounds are unknown as metabolites from terrestrial fungi. They have a strong flavour, so they combine well with leeks or onions.</p><p>Wood blewits can be preserved in olive oil or white vinegar after blanching.</p><p>Cultivated wood blewits are said not to taste as good as wild wood blewits.</p></div>", "photos":[{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada10.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada11.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada12.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada14.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada15.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada16.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada17.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada18.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada19.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada2.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada20.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada21.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada22.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada23.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada24.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada25.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada3.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada4.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada5.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada6.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada7.jpg"},{"mushroomid":"Pimpinella_morada","img":"wiki\/pimpinella.morada9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "umbonate", "attributeId":"capell", "img":"Umbonate_cap_icon.svg.png", "name":"umbonate"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "rosa", "attributeId":"color_capell", "img":"capell_rosa.svg.png", "name":"pink"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "rosa", "attributeId":"color_peu", "img":"peu_rosa.svg.png", "name":"pink"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "emarginate", "attributeId":"lamina", "img":"Emarginate_gills_icon2.svg.png", "name":"emarginate"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Paloma", "latinname":"Macrolepiota procera", "name":"Macrolepiota procera", "names":"The <span class=\"mushroomName\">parasol mushroom</span> (<span class=\"foreignLanguage\">Macrolepiota procera</span>) is a basidiomycete fungus with a large, prominent fruiting body resembling a parasol. It is a fairly common species on well-drained soils. It is found solitary or in groups and fairy rings in pastures and occasionally in woodland. Globally, it is widespread in temperate regions.", "description":"<div><p>The <span class=\"mushroomName\">parasol mushroom</span> (<span class=\"foreignLanguage\">Macrolepiota procera</span>) is a basidiomycete fungus with a large, prominent fruiting body resembling a parasol. It is a fairly common species on well-drained soils. It is found solitary or in groups and fairy rings in pastures and occasionally in woodland. Globally, it is widespread in temperate regions.</p></div><div><h3>Description</h3><p>The height and cap diameter of a mature specimen may both reach 40&nbsp;cm, a size truly impressive for the fruiting body of an agaric. The stipe is relatively thin and reaches full height before the cap has expanded. The stipe is very fibrous in texture which renders it inedible. The surface is characteristically wrapped in a snakeskin-like pattern of scaly growths. The immature cap is compact and egg-shaped, with the cap margin around the stipe, sealing a chamber inside the cap. As it matures, the margin breaks off, leaving a fleshy, movable ring around the stipe. At full maturity, the cap is more or less flat, with a chocolate-brown umbo in the centre that is leathery to touch. Dark and cap-coloured flakes remain on the upper surface of the cap and can be removed easily. The gills are crowded, free, and white with a pale pink tinge sometimes present. The spore print is white. It has a pleasant nutty smell. When sliced, the white flesh may turn a pale pink.</p></div><div><h3>Uses</h3><p>It is a very sought after and popular fungus in Europe, due in part to its large size, seasonal frequency and versatility in the kitchen. </p><p>The parasol mushroom is difficult to mistake for any other, especially in regions like Europe where the poisonous look-alike <span class=\"foreignLanguage\">Chlorophyllum molybdites</span> does not occur. Nevertheless, as with picking any fungus for consumption, caution should be exercised at all times.</p><p>The parasol mushroom may not be eaten raw because it is slightly toxic. It is popular soaked in butter. </p><p>In central and eastern European countries this species of fungi is usually prepared similarly to a cutlet. It is usually run through egg and breadcrumbs and then fried on a pan with some oil or butter. Served with white bread, it makes a delicious meal of summer and early fall.</p><p>A savory Slovak recipe is to bake caps stuffed with ground pork, oregano, and garlic. Italians and Austrians also serve the young un-flattened caps stuffed with seasoned minced beef, baked in the same manner as stuffed peppers.</p></div><div><h3>Similar species</h3><p>Smaller but similar in appearance is the common shaggy parasol (<span class=\"foreignLanguage\">Chlorophyllum rhacodes</span>.) Its edibility is suspect as it causes mild sickness in some people, especially when eaten raw. One must learn to distinguish the two as their geographical ranges overlap.</p><p>Differences from the parasol mushroom include its smaller dimensions, pungent (fruity) and reddening flesh when cut, lack of patterns on its stipe, and very shaggy cap surface. </p><p><span class=\"foreignLanguage\">Macrolepiota mastoidea</span>, a European species, is yet another very large edible mushroom. Its dimensions are generally smaller than that of <span class=\"foreignLanguage\">M. procera</span> and the markings on its stipe less obvious. It is also much rarer.</p><p>Species of <span class=\"foreignLanguage\">Agaricus</span> have brown spores and the gills of mature specimens are never white.</p><p>There are a few poisonous species which can be mistaken for <span class=\"foreignLanguage\">M. procera</span>. </p><ul><li><span class=\"foreignLanguage\">Chlorophyllum molybdites</span>, a species that causes the largest number of annual mushroom poisonings in North America due to its close similarity. Faintly green gills and a pale green spore print give it away. Furthermore this mushroom lacks the aforementioned snakeskin pattern that is generally present on the parasol mushroom. Its range is reportedly expanding into Europe.</li><li><span class=\"foreignLanguage\">Leucocoprinus brunnea</span>, also found in North America, slowly turns brown when sliced.</li><li>White and immature species of <span class=\"foreignLanguage\">Amanita</span> are also a potential hazard. To be sure, one must only pick parasol mushrooms past their button stage. A general rule of thumb with the parasol mushroom as compared to amanita species is that the parasol mushroom has darker flakes on a lighter surface, whereas amanita species have the opposite, lighter flakes (if there are any) on a darker surface, such as the Panther cap.</li><li>The <span class=\"mushroomName\">Saffron Parasol</span> <span class=\"foreignLanguage\">Cystoderma amianthinum</span> is very much smaller, and not often eaten.</li><li><span class=\"foreignLanguage\">Lepiota brunneoincarnata</span> is a lepiota species known to have caused mortal intoxications in Spain.</li></ul></div><div><h3>Gallery</h3><p><center></p><p></center></p></div>", "photos":[{"mushroomid":"Paloma","img":"wiki\/paloma1.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma10.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma11.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma12.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma13.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma14.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma15.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma16.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma17.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma18.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma19.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma2.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma20.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma3.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma4.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma5.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma6.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma7.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma8.jpg"},{"mushroomid":"Paloma","img":"wiki\/paloma9.jpg"}], "attributes":[{"valueId": "umbonate", "attributeId":"capell", "img":"Umbonate_cap_icon.svg.png", "name":"umbonate"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris", "attributeId":"color_peu", "img":"peu_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Micena", "latinname":"Mycena", "name":"Mycena", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Mycena</span></span> is a large genus of small saprotrophic mushrooms that are rarely more than a few centimeters in width. They are characterized by a white spore print, a small conical or bell-shaped cap, and a thin fragile stem. Most are gray or brown, but a few species have brighter colors. Most have a translucent and striate cap, which rarely has an incurved margin. The gills are attached and usually have cystidia. Some species, like <span class=\"foreignLanguage\">Mycena haematopus</span>, exude a latex when the stem is broken, and many have the odor of bleach.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Mycena</span></span> is a large genus of small saprotrophic mushrooms that are rarely more than a few centimeters in width. They are characterized by a white spore print, a small conical or bell-shaped cap, and a thin fragile stem. Most are gray or brown, but a few species have brighter colors. Most have a translucent and striate cap, which rarely has an incurved margin. The gills are attached and usually have cystidia. Some species, like <span class=\"foreignLanguage\">Mycena haematopus</span>, exude a latex when the stem is broken, and many have the odor of bleach.</p><p><span class=\"foreignLanguage\">Mycenas</span> are hard to identify to species and some are distinguishable only by microscopic features such as the shape of the cystidia. Some species are edible, while others contain toxins, but the edibility of most is not known, as they are too small to be useful in cooking. <span class=\"foreignLanguage\">Mycena cyanorrhiza</span> stains blue and contains the hallucinogen psilocybin and <span class=\"foreignLanguage\">Mycena pura</span> contains the mycotoxin muscarine.</p><p>Over 33 species are known to be bioluminescent, creating a glow known as foxfire. These species are divided among 16 lineages, leading to evolutionary uncertainty in whether the luminescence developed once and was lost among many species, or evolved in parallel by several species. What, if any, benefit the fungus derives from the luminescence is uncertain.</p><p>Alexander Smith's 1947 <span class=\"foreignLanguage\">Mycena</span> monograph identified 232 species; the genus is now known to include about 500 species worldwide. Maas Geesteranus divided the genus into 38 sections in 1992, providing keys to each for all the species of the Northern Hemisphere. Many new species have been discovered since then, and four new sections have been proposed. Taxonomy is complex, as most sections are not truly homogeneous, and the keys fail for some species, especially those that satisfy some criteria for only part of their life cycle. Some sections contain only one species.</p><p>The name <span class=\"foreignLanguage\">Mycena</span> comes from the Ancient Greek ''<span class=\"foreignLanguage\">, meaning mushroom.</p></div><div><h3>Selected species</h3><ul><li></span>M. acicula<span class=\"foreignLanguage\"></li><li></span>M. adonis<span class=\"foreignLanguage\"></li><li></span>M. adscendens<span class=\"foreignLanguage\"></li><li></span>M. aetites<span class=\"foreignLanguage\"></li><li></span>M. alphitophora<span class=\"foreignLanguage\"></li><li></span>M. atkinsonii<span class=\"foreignLanguage\"></li><li></span>M. atkinsoniana<span class=\"foreignLanguage\"></li><li></span>M. aurantiomarginata<span class=\"foreignLanguage\"></li><li></span>M. austrofilopes<span class=\"foreignLanguage\"></li><li></span>M. austrororida<span class=\"foreignLanguage\"></li><li></span>M. arcangeliana<span class=\"foreignLanguage\"></li><li></span>M. asterina<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. atrata<span class=\"foreignLanguage\"></li><li></span>M. brunneospinosa<span class=\"foreignLanguage\"></li><li></span>M. californiensis<span class=\"foreignLanguage\"></li><li></span>M. capillaripes<span class=\"foreignLanguage\"></li><li></span>M. chlorophos<span class=\"foreignLanguage\"></li><li></span>M. cinerella<span class=\"foreignLanguage\"></li><li></span>M. citricolor<span class=\"foreignLanguage\"></li><li></span>M. citrinomarginata<span class=\"foreignLanguage\"></li><li></span>M. clariviolacea<span class=\"foreignLanguage\"></li><li></span>M. crocata<span class=\"foreignLanguage\"></li><li></span>M. cyanorrhiza<span class=\"foreignLanguage\"></li><li></span>M. cystidiosa<span class=\"foreignLanguage\"></li><li></span>M. daisyogunensis<span class=\"foreignLanguage\"></li><li></span>M. discobasis<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. domingensis<span class=\"foreignLanguage\"></li><li></span>M. epipterygia<span class=\"foreignLanguage\"></li><li></span>M. erubescens<span class=\"foreignLanguage\"></li><li></span>M. fera<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. flavescens<span class=\"foreignLanguage\"></li><li></span>M. flavoalba<span class=\"foreignLanguage\"></li><li></span>M. fonticola<span class=\"foreignLanguage\"></li><li></span>M. fuhreri<span class=\"foreignLanguage\"></li><li></span>M. fuscoaurantiaca<span class=\"foreignLanguage\"></li><li></span>M. galericulata<span class=\"foreignLanguage\"></li><li></span>M. galopus<span class=\"foreignLanguage\"></li><li></span>M. griseoviridis<span class=\"foreignLanguage\"></li><li></span>M. guldeniana<span class=\"foreignLanguage\"></li><li></span>M. haematopus<span class=\"foreignLanguage\"></li><li></span>M. illuminans<span class=\"foreignLanguage\"></li><li></span>M. inclinata<span class=\"foreignLanguage\"></li><li></span>M. interrupta<span class=\"foreignLanguage\"></li><li></span>M. intersecta<span class=\"foreignLanguage\"></li><li></span>M. kentingensis<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. kuurkacea<span class=\"foreignLanguage\"></li><li></span>M. lacrimans<span class=\"foreignLanguage\"></li><li></span>M. leaiana<span class=\"foreignLanguage\"></li><li></span>M. lacrimans<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. lanuginosa<span class=\"foreignLanguage\"></li><li></span>M. leptocephala<span class=\"foreignLanguage\"></li><li></span>M. lucentipes<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. luteopallens<span class=\"foreignLanguage\"></li><li></span>M. luxaeterna<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. luxarboricola<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. maculata<span class=\"foreignLanguage\"></li><li></span>M. manipularis<span class=\"foreignLanguage\"></li><li></span>M. marasmielloides<span class=\"foreignLanguage\"></li><li></span>M. metata<span class=\"foreignLanguage\"></li><li></span>M. minirubra<span class=\"foreignLanguage\"></li><li></span>M. multiplicata<span class=\"foreignLanguage\"></li><li></span>M. mustea<span class=\"foreignLanguage\"></li><li></span>M. nargan<span class=\"foreignLanguage\"></li><li></span>M. nidificata<span class=\"foreignLanguage\"></li><li></span>M. noctilucens<span class=\"foreignLanguage\"></li><li></span>M. olida<span class=\"foreignLanguage\"></li><li></span>M. olivaceomarginata<span class=\"foreignLanguage\"></li><li></span>M. oregonensis<span class=\"foreignLanguage\"></li><li></span>M. overholtsii<span class=\"foreignLanguage\"></li><li></span>M. pelianthina<span class=\"foreignLanguage\"></li><li></span>M. polygramma<span class=\"foreignLanguage\"></li><li></span>M. pseudostylobates<span class=\"foreignLanguage\"></li><li></span>M. pura<span class=\"foreignLanguage\"></li><li></span>M. pura<span class=\"foreignLanguage\"> complex</li><li></span>M. purpureofusca<span class=\"foreignLanguage\"></li><li></span>M. renati<span class=\"foreignLanguage\"></li><li></span>M. rorida<span class=\"foreignLanguage\"></li><li></span>M. rosea<span class=\"foreignLanguage\"></li><li></span>M. rosella<span class=\"foreignLanguage\"></li><li></span>M. sanguinolenta<span class=\"foreignLanguage\"></li><li></span>M. semivestipes<span class=\"foreignLanguage\"></li><li></span>M. singeri<span class=\"foreignLanguage\"> (Bioluminescent)</li><li></span>M. spinosissima<span class=\"foreignLanguage\"></li><li></span>M. stipata<span class=\"foreignLanguage\"></li><li></span>M. strobilinoides<span class=\"foreignLanguage\"></li><li></span>M. stylobates<span class=\"foreignLanguage\"></li><li></span>M. subcaerulea<span class=\"foreignLanguage\"></li><li></span>M. sublucens<span class=\"foreignLanguage\"></li><li></span>M. tenuispinosa<span class=\"foreignLanguage\"></li><li></span>M. tintinnabulum<span class=\"foreignLanguage\"></li><li></span>M. urania<span class=\"foreignLanguage\"></li><li></span>M. vinacea<span class=\"foreignLanguage\"></li><li></span>M. viscosa<span class=\"foreignLanguage\"></li><li></span>M. vitilis<span class=\"foreignLanguage\"></li><li></span>M. vulgaris<span class=\"foreignLanguage\"></li><li></span>M. zephirus<span class=\"foreignLanguage\"></li></ul></div><div><h3>Further reading</h3><ul><li>Smith, Alexander Hancett. </span>North American Species of <span class=\"foreignLanguage\">Mycena. Ann Arbor: Univ. of Michigan Press, 1947.</li></ul></div>", "photos":[{"mushroomid":"Micena","img":"wiki\/micena1.jpg"},{"mushroomid":"Micena","img":"wiki\/micena10.jpg"},{"mushroomid":"Micena","img":"wiki\/micena11.jpg"},{"mushroomid":"Micena","img":"wiki\/micena12.jpg"},{"mushroomid":"Micena","img":"wiki\/micena2.jpg"},{"mushroomid":"Micena","img":"wiki\/micena3.jpg"},{"mushroomid":"Micena","img":"wiki\/micena4.jpg"},{"mushroomid":"Micena","img":"wiki\/micena5.jpg"},{"mushroomid":"Micena","img":"wiki\/micena6.jpg"},{"mushroomid":"Micena","img":"wiki\/micena7.jpg"},{"mushroomid":"Micena","img":"wiki\/micena8.jpg"},{"mushroomid":"Micena","img":"wiki\/micena9.jpg"}], "attributes":[{"valueId": "conical", "attributeId":"capell", "img":"Conical_cap_icon.svg.png", "name":"conical"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris", "attributeId":"color_peu", "img":"peu_gris.svg.png", "name":"gray"},{"valueId": "marro", "attributeId":"color_peu", "img":"peu_marro.svg.png", "name":"brown"},{"valueId": "marro_clar", "attributeId":"color_peu", "img":"peu_marro_clar.svg.png", "name":"light brown"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Anel.laria", "latinname":"Panaeolus semiovatus var. semiovatus", "name":"Panaeolus semiovatus var. semiovatus", "names":"'''<span class=\"foreignLanguage\">Panaeolus semiovatus</span> var. <span class=\"foreignLanguage\">semiovatus</span>'<span class=\"foreignLanguage\">, also known as </span>Panaeolus semiovatus<span class=\"foreignLanguage\"> and </span>Anellaria separata<span class=\"foreignLanguage\">, is a medium-sized buff colored mushroom/toadstool that grows on horse dung, and has black spores.  While some guides list this species as edible, a few people experience gastric upset after consumption. Its common names are the <span class=\"mushroomName\">shiny mottlegill</span>, or <span class=\"mushroomName\">egghead mottlegill</span>.", "description":"<div><p>'''<span class=\"foreignLanguage\">Panaeolus semiovatus</span> var. <span class=\"foreignLanguage\">semiovatus</span>'<span class=\"foreignLanguage\">, also known as </span>Panaeolus semiovatus<span class=\"foreignLanguage\"> and </span>Anellaria separata<span class=\"foreignLanguage\">, is a medium-sized buff colored mushroom/toadstool that grows on horse dung, and has black spores.  While some guides list this species as edible, a few people experience gastric upset after consumption. Its common names are the <span class=\"mushroomName\">shiny mottlegill</span>, or <span class=\"mushroomName\">egghead mottlegill</span>.</p></div><div><h3>Description</h3><p>The cap is up to 8&nbsp;cm across, dark buff to white, parabolic to nearly convex in age. It is sticky when wet, and is often with wrinkles when dry.  The stem is 15&nbsp;cm by 20&nbsp;mm, solid and smooth, with an annulus (ring) that is white, but is often found blackened by falling spores. The gills are , being wider in the middle, and narrowing at both ends, they are brown to black. The flesh is white, or straw colored.</p><p>This is a buff, or whitish colored mushroom that grows in horse dung. It is widely distributed and is present in many temperate zones of the world.</p><p>The very similar </span>Panaeolus semiovatus var. phalaenarum<span class=\"foreignLanguage\"> (Fr.) Ew. Gerhardt. 1996 <span class=\"mushroomName\">syn.</span> </span>Panaeolus phalaenarum<span class=\"foreignLanguage\"> (Bull.) Quel. is more slender (cap 2-4cms), and lacks the ring.</p><p><br /><span class=\"mushroomName\">As seen below, this mushroom varies from white to dark buff in coloration.</span></p></div>", "photos":[{"mushroomid":"Anel.laria","img":"wiki\/anel.laria1.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "verdMarro", "attributeId":"color_capell", "img":"capell_verdMarro.svg.png", "name":"green-brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "", "attributeId":"", "img":"", "name":""},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"}]},{"id": "Ou_del_diable", "latinname":"Phallus impudicus", "name":"Phallus impudicus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Phallus impudicus</span></span>, known colloquially as the <span class=\"mushroomName\">common stinkhorn</span>, is a widespread fungus recognizable for its foul odor and its phallic shape when mature, the latter feature giving rise to several names in 17th-century England. It is a common mushroom in Europe and western North America, where it occurs in habitats rich in wood debris such as forests and mulched gardens. It appears from summer to late autumn. The fruiting structure is tall and white with a slimy, dark olive colored conical head. Known as the gleba, this material contains the spores, and is transported by insects which are attracted by the odor—described as resembling carrion. Despite its foul smell, it is not poisonous and immature mushrooms are consumed in parts of France and Germany.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Phallus impudicus</span></span>, known colloquially as the <span class=\"mushroomName\">common stinkhorn</span>, is a widespread fungus recognizable for its foul odor and its phallic shape when mature, the latter feature giving rise to several names in 17th-century England. It is a common mushroom in Europe and western North America, where it occurs in habitats rich in wood debris such as forests and mulched gardens. It appears from summer to late autumn. The fruiting structure is tall and white with a slimy, dark olive colored conical head. Known as the gleba, this material contains the spores, and is transported by insects which are attracted by the odor—described as resembling carrion. Despite its foul smell, it is not poisonous and immature mushrooms are consumed in parts of France and Germany.</p></div><div><h3>Taxonomy</h3><p>Botanist John Gerard called it the \"pricke mushroom\" or \"fungus virilis penis effigie\" in his <span class=\"foreignLanguage\">General Historie of Plants</span> of 1597, and John Parkinson referred to it as \"Hollanders workingtoole\" or \"phallus hollandicus\" in his <span class=\"foreignLanguage\">Theatrum botanicum</span> of 1640.</blockquote></p></div>", "photos":[{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable1.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable10.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable11.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable12.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable13.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable14.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable15.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable16.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable17.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable18.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable19.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable2.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable20.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable21.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable3.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable4.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable5.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable6.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable7.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable8.jpg"},{"mushroomid":"Ou_del_diable","img":"wiki\/ou.del.diable9.jpg"}], "attributes":[{"valueId": "conical", "attributeId":"capell", "img":"Conical_cap_icon.svg.png", "name":"conical"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "negre", "attributeId":"color_capell", "img":"capell_negre.svg.png", "name":"black"},{"valueId": "verdMarro", "attributeId":"color_capell", "img":"capell_verdMarro.svg.png", "name":"green-brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gleba", "attributeId":"himeni", "img":"Gleba_icon.png", "name":"gleba"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pluteus", "latinname":"Pluteus", "name":"Pluteus", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Pluteus</span></span> is a large genus of fungi with over 300 species.  They are wood rotting saprobes with pink spore prints and gills that are free from the stem.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Pluteus</span></span> is a large genus of fungi with over 300 species.  They are wood rotting saprobes with pink spore prints and gills that are free from the stem.</p><p><span class=\"foreignLanguage\">Pluteus</span> means <span class=\"foreignLanguage\">shed or penthouse</span>.</p></div><div><h3>Characteristics of the genus</h3><p>#These fungi grow on wood or wood remains.</p><p>#The spore powder is deep pink, soon giving a pink tint to the initially pale gills.</p><p>#The gills are free from the stipe.</p><p>#There is no volva or ring (exception: the rare recently reclassified North American species <span class=\"foreignLanguage\">P. mammillatus</span>, previously <span class=\"foreignLanguage\">Chamaeota sphaerospora</span>).</p><p>#Microscopically, they often have abundant, distinctive cystidia.  The spores are smooth and roughly egg-shaped.</p><p><span class=\"foreignLanguage\">Pluteus</span> is separated from <span class=\"foreignLanguage\">Volvariella</span> due to the lack of a volva, and from <span class=\"foreignLanguage\">Entoloma</span> by growing on wood and by microscopic features (<span class=\"foreignLanguage\">Entolomas</span> have angular spores).  </p></div><div><h3>Remarks on particular species</h3><p>Some of these mushrooms are edible including <span class=\"foreignLanguage\">P. petasatus</span> and <span class=\"foreignLanguage\">P. cervinus</span>, though most people rate their taste and consistency as average at best.  </p><p><span class=\"foreignLanguage\">Pluteus cervinus</span> is the best known species in Europe and North America.</p><p>Several species of this genus bruise blue and contain psilocybin  including <span class=\"foreignLanguage\">Pluteus brunneidiscus</span>, <span class=\"foreignLanguage\">Pluteus salicinus</span>, <span class=\"foreignLanguage\">Pluteus cyanopus</span>, <span class=\"foreignLanguage\">Pluteus glaucus</span>, <span class=\"foreignLanguage\">Pluteus nigroviridis</span>, <span class=\"foreignLanguage\">Pluteus phaeocyanopus</span> and <span class=\"foreignLanguage\">Pluteus villosus</span>. </p></div><div><h3>Further reading</h3><ul><li>[http://www.mushroomexpert.com/pluteus.html M. Kuo \"The Genus <span class=\"foreignLanguage\">Pluteus</span>\"]</li><li>[http://www.museocivico.rovereto.tn.it/UploadDocs/104_art09-Guzman%20&%20C.pdf G. Guzmán, J. W. Allen & J. Gartz, \"A Worldwide Geographical Distribution of the Neurotropic Fungi, an Analysis and Discussion\"]</li></div>", "photos":[{"mushroomid":"Pluteus","img":"wiki\/pluteus1.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus10.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus11.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus12.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus13.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus14.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus15.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus16.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus17.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus18.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus19.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus2.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus20.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus21.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus22.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus23.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus24.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus25.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus26.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus3.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus4.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus5.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus6.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus7.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus8.jpg"},{"mushroomid":"Pluteus","img":"wiki\/pluteus9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "groc", "attributeId":"color_capell", "img":"capell_groc.svg.png", "name":"yellow"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "groc", "attributeId":"color_peu", "img":"peu_groc.svg.png", "name":"yellow"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Russula_aeruginea", "latinname":"Russula aeruginea", "name":"Russula aeruginea", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula aeruginea</span></span>, also known as the <span class=\"mushroomName\">grass-green Russula</span>, the <span class=\"mushroomName\">tacky green Russula</span>, or the <span class=\"mushroomName\">green Russula</span>, is an inedible <span class=\"foreignLanguage\">Russula</span> mushroom. Widely distributed in northern temperate regions, it is usually found under birch, mostly in pine forests.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula aeruginea</span></span>, also known as the <span class=\"mushroomName\">grass-green Russula</span>, the <span class=\"mushroomName\">tacky green Russula</span>, or the <span class=\"mushroomName\">green Russula</span>, is an inedible <span class=\"foreignLanguage\">Russula</span> mushroom. Widely distributed in northern temperate regions, it is usually found under birch, mostly in pine forests.</p></div><div><h3>Taxonomy</h3><p>The species was first described in Elias Magnus Fries's 1863 work <span class=\"foreignLanguage\">Monographia Hymenomycetum Sueciae</span>. The specific epithet <span class=\"foreignLanguage\">aeruginea</span> is derived from the Latin <span class=\"foreignLanguage\">aeruginus</span>, referring to the tarnished color of copper. It is commonly known variously as the \"tacky green Russula\", the \"grass-green Russula\", or the \"green Russula\".</p></div><div><h3>Description</h3><p>The cap is flat when young, soon funnel shaped and weakly striped; somewhat sticky and shiny, pale green to light grey-green, more rarely olive green. It is often  in diameter. The closely spaced gills are pale cream when young, later becoming light yellow when the spores mature. The stipe is white, occasionally with rust-coloured spots at the base, often rather short with longitudinal furrows. It measures  long by  thick. The flesh is white, brittle and without scent, with a mild taste. <span class=\"foreignLanguage\">R.&nbsp;aeruginea</span> mushrooms are edible.</p><p>The spore print is cream-yellow. Spores are spherical to oval with ridges and warts on the surface, and measure 6–8 by 6–7&nbsp;μm.</p><p>Green specimens of the crab brittlegill, <span class=\"foreignLanguage\">Russula xerampelina</span>, can be mistaken for <span class=\"foreignLanguage\">R.&nbsp;aeruginea</span>. They can be readily distinguished in that specimens of <span class=\"foreignLanguage\">R.&nbsp;xerampelina</span> always smell of cooked shellfish, while specimens of <span class=\"foreignLanguage\">R.&nbsp;aeruginea</span> do not.</p></div><div><h3>Habitat and distribution</h3><p>The fruit bodies of <span class=\"foreignLanguage\">Russula aeruginea</span> grow on the ground in woods, in troops in leaf litter or in grass. It is ectomycorrhizal with birch, but also with found under conifers, particularly pine and spruce. It is widely distributed in northern temperate zones. Fruiting occurs from July to November in Europe, and in later summer to autumn in North America. The fungus is also found in East Africa.</p></div>", "photos":[{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea10.jpg"},{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea11.jpg"},{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea12.jpg"},{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea13.jpg"},{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea14.jpg"},{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea15.jpg"},{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea3.jpg"},{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea8.jpg"},{"mushroomid":"Russula_aeruginea","img":"wiki\/russula.aeruginea9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "groc", "attributeId":"color_capell", "img":"capell_groc.svg.png", "name":"yellow"},{"valueId": "verdMarro", "attributeId":"color_capell", "img":"capell_verdMarro.svg.png", "name":"green-brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "caution", "attributeId":"comestibilitat", "img":"comestibilitat_reserves.png", "name":"caution"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Cualbra_retgera", "latinname":"Russula aurea", "name":"Russula aurea", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula aurea</span></span>, commonly known as the <span class=\"mushroomName\">gilded brittlegill</span>, is an uncommon species of mushroom found in deciduous woodland in Europe in summer and early autumn. Unlike many red-capped members of the genus, it is edible and mild-tasting.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula aurea</span></span>, commonly known as the <span class=\"mushroomName\">gilded brittlegill</span>, is an uncommon species of mushroom found in deciduous woodland in Europe in summer and early autumn. Unlike many red-capped members of the genus, it is edible and mild-tasting.</p></div><div><h3>Taxonomy</h3><p>It was known for many years as <span class=\"foreignLanguage\">Russula aurata</span> originally published in 1801 as <span class=\"foreignLanguage\">Agaricus auratus</span> by the English naturalist William Withering, and placed by the father of mycology Elias Magnus Fries into the genus <span class=\"foreignLanguage\">Russula</span> in 1838. However, the binomial name <span class=\"foreignLanguage\">Russula aurea</span> had been coined by Christian Hendrik Persoon in 1796 and takes precedence. Both specific epithets are derived from the Latin <span class=\"foreignLanguage\">aurum</span> \"gold\", hence \"golden\".</p></div><div><h3>=Similar species=</h3><p>The overall yellow tone of <span class=\"foreignLanguage\">Russula aurea</span> distinguishes it from the peppery and inedible red-capped Russulas, such as the bloody brittlegill (<span class=\"foreignLanguage\">R.&nbsp;sanguinaria</span>), the sickener (<span class=\"foreignLanguage\">R.&nbsp;emetica</span>), and the beechwood sickener (<span class=\"foreignLanguage\">R.&nbsp;nobilis</span>).</p><p>It occurs under deciduous trees in summer and early autumn, in particular beech, oak and hazel.</p></div><div><h3>Edibility</h3><p>Unlike many other red-capped members of the genus, <span class=\"foreignLanguage\">Russula aurea</span> is mild-tasting and edible.</p></div>", "photos":[{"mushroomid":"Cualbra_retgera","img":"wiki\/cualbra.retgera1.jpg"},{"mushroomid":"Cualbra_retgera","img":"wiki\/cualbra.retgera4.jpg"},{"mushroomid":"Cualbra_retgera","img":"wiki\/cualbra.retgera5.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "rosa", "attributeId":"color_capell", "img":"capell_rosa.svg.png", "name":"pink"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Cualbra_morada", "latinname":"Russula cyanoxantha", "name":"Russula cyanoxantha", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula cyanoxantha</span></span>,  synonymous with <span class=\"mushroomName\">R. xyanoxantha</span>, commonly known as the <span class=\"mushroomName\">charcoal burner</span>, is a basidiomycete mushroom, distinguished from most other members of the <span class=\"foreignLanguage\">Russula</span> genus by the fact that its gills do not split, but are soft and flexible. It is one of the most common species of <span class=\"foreignLanguage\">Russula</span> in Europe.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula cyanoxantha</span></span>,  synonymous with <span class=\"mushroomName\">R. xyanoxantha</span>, commonly known as the <span class=\"mushroomName\">charcoal burner</span>, is a basidiomycete mushroom, distinguished from most other members of the <span class=\"foreignLanguage\">Russula</span> genus by the fact that its gills do not split, but are soft and flexible. It is one of the most common species of <span class=\"foreignLanguage\">Russula</span> in Europe.</p><p>It is an edible mushroom. It was designated \"Mushroom of the Year\" in 1997 by the German Association of Mycology.</p></div><div><h3>Description</h3><p>The most salient characteristic is the weak gills, which feel greasy to the touch, are flexible and do not break. The cap is 4–15&nbsp;cm (1.5–6&nbsp;in) wide, convex at first and later flattened, and greenish to bright brown (they vary considerably in color). The stipe is pure white, slightly convex underneath, up to 10&nbsp;cm in height and 1.5–2.5&nbsp;cm (0.5–1&nbsp;in) in diameter. The spores are pure white. The stipe will give a green reaction when rubbed with iron salts (Ferrous Sulphate). Most other (but not all) russula species give a salmon reaction. Coupled with the gill flexibility this is a good diagnostic clue to species level.</p></div><div><h3>Distribution and habitat</h3><p><span class=\"foreignLanguage\">Russula cyanoxantha</span> grows in slightly acidic, but nutrient-rich soil. Like all <span class=\"foreignLanguage\">Russulas</span>, it is a  mycorrhizal fungus. It is found most commonly in beech forests, and often in deciduous or mixed forests, appearing from May to November, with the highest concentration in July to September.</p></div><div><h3>Use</h3><p>Suitable for many kinds of preparation; the flesh is not as hard as that of many other edible Russulas. It has a mild, nutty taste.</p></div><div><h3>Similar species</h3><p>The cap of the grey-green Russula Russula grisea is more blue-grey but has violet or green hues with light cream gills. This fungus also grows in mixed forests, particularly under beech, and more rarely in coniferous forests.</p></div>", "photos":[{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada10.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada11.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada12.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada13.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada14.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada15.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada16.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada17.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada18.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada19.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada2.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada20.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada21.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada22.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada4.jpg"},{"mushroomid":"Cualbra_morada","img":"wiki\/cualbra.morada5.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pebras", "latinname":"Russula delica", "name":"Russula delica", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula delica</span></span> is a mushroom that goes by the common name of <span class=\"mushroomName\">milk-white brittlegill</span>, and is a  member of the <span class=\"foreignLanguage\">Russula</span> genus, all of which are collectively known as <span class=\"mushroomName\">brittlegills</span>.  It is mostly white, with brownish cap markings, and a short robust stem. It is edible, but poor in taste, and grows in mixed woods, in autumn. It can be confused with certain white <span class=\"foreignLanguage\">Lactarius</span> species.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula delica</span></span> is a mushroom that goes by the common name of <span class=\"mushroomName\">milk-white brittlegill</span>, and is a  member of the <span class=\"foreignLanguage\">Russula</span> genus, all of which are collectively known as <span class=\"mushroomName\">brittlegills</span>.  It is mostly white, with brownish cap markings, and a short robust stem. It is edible, but poor in taste, and grows in mixed woods, in autumn. It can be confused with certain white <span class=\"foreignLanguage\">Lactarius</span> species.</p></div><div><h3>Taxonomy</h3><p>First described by the Swedish mycologist Elias Magnus Fries in 1838, its specific epithet <span class=\"foreignLanguage\">delica</span> is Latin for \"weaned\". Gill spacing, and gill depth has also thrown many finds into doubt, in the past.</p><p>Mycologist John Burton Cleland collected a form he described in 1935 as <span class=\"foreignLanguage\">R.&nbsp;delica</span> from under eucalypts in the Mount Lofty Ranges in South Australia,</p></div><div><h3>Description</h3><p>The basidiocarps (fruiting bodies) of <span class=\"foreignLanguage\">Russula delica</span> seem loath to leave the soil, and are often found half buried. As a result, the caps often traps the surrounding leaf debris on their rough surfaces. The cap can be  in diameter. It is white, usually tinged with ochre or brown, with an inrolled margin, which usually remains white.  At first it is convex, but later flattens, and is often funnel shaped.  The firm, white stipe is short and stout, measuring 2–6 cm (0.8–2.4&nbsp;in) high and 2–4&nbsp;cm (0.8–1.6&nbsp;in) wide. The gills are decurrent, and are quite closely spaced initially. The spore print  is creamy white, and the warty oval spores measure 8–12 x 7–9&nbsp;μm. The flesh is white, and does not change colour on cutting. The flesh may smell faintly of fish or insects, and has a hot, bitter, tangy taste.</p></div><div><h3>Distribution and habitat</h3><p><span class=\"foreignLanguage\">Russula delica</span> is widespread in the northern temperate zones, including Britain, Europe, Asia. which is very similar, and is not on the British list. </p><p>A common mushroom, it appears in autumn in deciduous and coniferous woods, and forests.</p></div><div><h3>Edibility</h3><p>This mushroom is edible, but poor, having an unpleasant taste, leading some to classify it as inedible.</p></div>", "photos":[{"mushroomid":"Pebras","img":"wiki\/pebras1.jpg"},{"mushroomid":"Pebras","img":"wiki\/pebras10.jpg"},{"mushroomid":"Pebras","img":"wiki\/pebras11.jpg"},{"mushroomid":"Pebras","img":"wiki\/pebras2.jpg"},{"mushroomid":"Pebras","img":"wiki\/pebras5.jpg"},{"mushroomid":"Pebras","img":"wiki\/pebras6.jpg"},{"mushroomid":"Pebras","img":"wiki\/pebras7.jpg"},{"mushroomid":"Pebras","img":"wiki\/pebras8.jpg"},{"mushroomid":"Pebras","img":"wiki\/pebras9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Cualbra_pudent", "latinname":"Russula foetens", "name":"Russula foetens", "names":"<span class=\"mushroomName\">Russula foetens</span> commonly known as the <span class=\"mushroomName\">stinking russula</span> is an inedible, common Russula mushroom found in deciduous and coniferous forests.", "description":"<div><p><span class=\"mushroomName\">Russula foetens</span> commonly known as the <span class=\"mushroomName\">stinking russula</span> is an inedible, common Russula mushroom found in deciduous and coniferous forests.</p></div><div><h3>Description</h3><p>The cap is hemispherical and very slimy when young, soon convex, honey yellow to ochre brown and up to 10 cm (4 in) in diameter. The gills and spores are pale cream.</p><p>The strong stem is white or blotchy yellowish brown. The flesh has a strong acrid smell, when old has a fishy smell and bad taste.</p></div>", "photos":[{"mushroomid":"Cualbra_pudent","img":"wiki\/cualbra.pudent10.jpg"},{"mushroomid":"Cualbra_pudent","img":"wiki\/cualbra.pudent11.jpg"},{"mushroomid":"Cualbra_pudent","img":"wiki\/cualbra.pudent12.jpg"},{"mushroomid":"Cualbra_pudent","img":"wiki\/cualbra.pudent13.jpg"},{"mushroomid":"Cualbra_pudent","img":"wiki\/cualbra.pudent14.jpg"},{"mushroomid":"Cualbra_pudent","img":"wiki\/cualbra.pudent4.jpg"},{"mushroomid":"Cualbra_pudent","img":"wiki\/cualbra.pudent8.jpg"},{"mushroomid":"Cualbra_pudent","img":"wiki\/cualbra.pudent9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Escaldabec_fragil", "latinname":"Russula fragilis", "name":"Russula fragilis", "names":"The inedible wild mushroom <span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula fragilis</span></span>, which goes by the common name of the <span class=\"mushroomName\">fragile brittlegill</span>, is a  member of the <span class=\"foreignLanguage\">Russula</span> genus, whose members are commonly known as brittlegills.  It is a small, fragile, long stemmed, and variably coloured brittlegill, found in mixed forests, and woods in Europe, Asia, and North America.", "description":"<div><p>The inedible wild mushroom <span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula fragilis</span></span>, which goes by the common name of the <span class=\"mushroomName\">fragile brittlegill</span>, is a  member of the <span class=\"foreignLanguage\">Russula</span> genus, whose members are commonly known as brittlegills.  It is a small, fragile, long stemmed, and variably coloured brittlegill, found in mixed forests, and woods in Europe, Asia, and North America.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Russula fragilis</span> was first described as <span class=\"foreignLanguage\">Agaricus fragilis</span> by mycologist Christian Hendrik Persoon in 1801, and later placed in the <span class=\"foreignLanguage\">Russula</span> genus by Elias Magnus Fries in 1838.</p></div><div><h3>Description</h3><p>The cap is 2–5&nbsp;cm (0.8&ndash;2&nbsp;in) in diameter. It is very variable in colour, and can be dark purplish, with a dark, almost black centre, or may be various shades of olive-green, or violet-pink, or even pale yellow. The colour tends to fade quickly, and can become very pale.  At first the cap shape is convex, but it later flattens.  The cap skin peels to three quarters, and older specimens often have a furrowed margin. The fragile, white stipe is long for the size of the cap, and narrowly club-shaped. The gills are adnexed, and white giving a spore print of the same colour. They have distinctive nicks, or notches on their free edges, that can be seen under a hand lens, a very good diagnostic clue to species. The flesh is white and tastes very hot, with a fruity smell.</p></div><div><h3>Edibility</h3><p>This mushroom is inedible due to its very hot taste. Many hot tasting <span class=\"foreignLanguage\">Russula</span> species cause problems of a gastrointestinal nature when consumed, resulting in diarrhoea, and vomiting.</p></div>", "photos":[{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil10.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil11.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil12.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil2.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil3.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil4.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil6.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil7.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil8.jpg"},{"mushroomid":"Escaldabec_fragil","img":"wiki\/escaldabec.fragil9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "rosa", "attributeId":"color_capell", "img":"capell_rosa.svg.png", "name":"pink"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Palomi", "latinname":"Russula grisea", "name":"Russula grisea", "names":"", "description":"<div> <p> <span class=\"mushroomName\"> Palomar </span> (<span class=\"foreignLanguage\"> Russula grisea </span>) is a typical mushroom foothills. The locals also call the end of the Walnut (Segre East) and the beginning of Pallars. </P> It is usually in oak forests and oak. Does the color gray hat and flesh inside is white. The handle is white, thin and consistent. Is not gastronomic appreciated. </P> </div>", "photos":[{"mushroomid":"Palomi","img":"wiki\/palomi4.jpg"},{"mushroomid":"Palomi","img":"wiki\/palomi5.jpg"},{"mushroomid":"Palomi","img":"wiki\/palomi6.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Russula_heterophylla", "latinname":"Russula heterophylla", "name":"Russula heterophylla", "names":"The edible wild mushroom <span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula heterophylla</span></span>, that has lately been given the common name of the <span class=\"mushroomName\">greasy green brittlegill</span> Appearing with broad-leaved trees in summer to early autumn, it usually has a greenish coloration.", "description":"<div><p>The edible wild mushroom <span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula heterophylla</span></span>, that has lately been given the common name of the <span class=\"mushroomName\">greasy green brittlegill</span> Appearing with broad-leaved trees in summer to early autumn, it usually has a greenish coloration.</p></div><div><h3>Taxonomy</h3><p>Noted and described by the South African born mycologist Christian Hendrik Persoon as <span class=\"foreignLanguage\">Agaricus lividus</span> in 1801. It was placed in the <span class=\"foreignLanguage\">Russula</span> Genus by the Swedish mycologist, and botanist Elias Magnus Fries in 1838, with the epithet <span class=\"foreignLanguage\">heterophylla</span>. Despite many changes, by several mycologists over the years since then, it is this binomial that is [http://www.indexfungorum.org/Names/SynSpecies.asp?RecordID=193557 currently recognised], and is in use at present. </p><p>The variants <span class=\"foreignLanguage\">Russula heterophylla</span> var. <span class=\"foreignLanguage\">chlora</span> Gillet 1876, and <span class=\"foreignLanguage\">Russula heterophylla</span> var. <span class=\"foreignLanguage\">virginea</span> (Cooke and Massee) A.Pearson & Dennis, have been given species status as <span class=\"foreignLanguage\">Russula violeipes</span>, and <span class=\"foreignLanguage\">Russula virginea</span> respectively.</p></div><div><h3>Description</h3><p>The cap is  in diameter. It is known to vary in colour, and can be various shades of green, brown, or ochre. It is initially round, flattening with age, and laters develops a depression. The white stem is firm, browning, and gives a salmon reaction when rubbed with ferrous sulphate. The gills are adnexed, and white giving a spore print of the same colour. </p></div><div><h3>=Microscopic characteristics=</h3><p>The spores are the smallest in the genus, and are 5–7 by 4–6&nbsp;µm,  spherical to elliptical, or pear shaped; warts 0.2–0.6&nbsp;µm high, mostly isolated, but occasionally two or three joined together, or connected by a line.</p></div><div><h3>=Similar species=</h3><p>Green forms of <span class=\"foreignLanguage\">Russula cyanoxantha</span> can be distinguished, because they give a greenish reaction, or no reaction when rubbed with ferrous sulphate (iron salts), and have the flexible, 'greasy' feeling gills characteristic of that species.</p><p><span class=\"foreignLanguage\">Russula virescens</span> (Schaeff.) Fr.,  has a cracked or fragmented cap surface.</p><p><span class=\"foreignLanguage\">Russula aeruginea</span> Fr.,  grows with Birch.</p><p><span class=\"foreignLanguage\">Russula langei</span> Bon, also has a green reaction to ferrous sulphate, and smells like shellfish, with flesh that stains orange-brown.</p></div><div><h3>Distribution and habitat</h3><p><span class=\"foreignLanguage\">Russula heterophylla</span> appears in summer to early autumn, usually growing in small groups. It is occasional in Britain, Europe, and Scandinavia. It grows with several species of broad-leaved trees, on the roots of which it is ectomycorrhizal.</p></div><div><h3>Edibility</h3><p>This mushroom is edible and good, although care must be taken as it is very like the deadly <span class=\"foreignLanguage\">Amanita phalloides</span> (death cap) when young. It is also prone to slug attacks.</p></div>", "photos":[{"mushroomid":"Russula_heterophylla","img":"wiki\/russula.heterophylla2.jpg"},{"mushroomid":"Russula_heterophylla","img":"wiki\/russula.heterophylla3.jpg"},{"mushroomid":"Russula_heterophylla","img":"wiki\/russula.heterophylla4.jpg"},{"mushroomid":"Russula_heterophylla","img":"wiki\/russula.heterophylla5.jpg"},{"mushroomid":"Russula_heterophylla","img":"wiki\/russula.heterophylla6.jpg"},{"mushroomid":"Russula_heterophylla","img":"wiki\/russula.heterophylla7.jpg"},{"mushroomid":"Russula_heterophylla","img":"wiki\/russula.heterophylla8.jpg"},{"mushroomid":"Russula_heterophylla","img":"wiki\/russula.heterophylla9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "verdMarro", "attributeId":"color_capell", "img":"capell_verdMarro.svg.png", "name":"green-brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Carboner_ver", "latinname":"Russula nigricans", "name":"Russula nigricans", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula nigricans</span></span>, commonly known as the <span class=\"mushroomName\">blackening brittlegill</span> or <span class=\"mushroomName\">blackening russula</span>, is a gilled mushroom found in woodland in Europe. It gains both its common and scientific name from its propensity to turn black from cutting or bruising. It is edible but of indifferent quality.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula nigricans</span></span>, commonly known as the <span class=\"mushroomName\">blackening brittlegill</span> or <span class=\"mushroomName\">blackening russula</span>, is a gilled mushroom found in woodland in Europe. It gains both its common and scientific name from its propensity to turn black from cutting or bruising. It is edible but of indifferent quality.</p></div><div><h3>Taxonomy</h3><p>It is placed in the <span class=\"foreignLanguage\"><span class=\"mushroomName\">Compactae</span></span> group, subsection <span class=\"foreignLanguage\"><span class=\"mushroomName\">Nigricantinae</span></span>  by Bon.</p><p>Old specimens are sometimes parasitised by fungi of the genus <span class=\"foreignLanguage\">Asterophora</span> or <span class=\"foreignLanguage\">Nyctalis</span>, in particular the species <span class=\"foreignLanguage\">N.&nbsp;parasitica</span> and <span class=\"foreignLanguage\">N.&nbsp;asterophora</span> (the pick-a-back toadstool).</p></div><div><h3>Distribution and habitat</h3><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula nigricans</span></span> appears in late summer and autumn in both deciduous and coniferous woodland across Britain, Northern Europe, and at least the East Coast of North America. </p></div><div><h3>Edibility</h3><p>This mushroom is edible, but poor. The taste becomes hot over time.</p></div><div><h3>Similar species</h3><p><span class=\"foreignLanguage\">Russula anthracina</span> (Romagn.), also known as <span class=\"foreignLanguage\">R.&nbsp;albonigra</span> (Krombh.) Fries, has closer gills and is far less common. It lacks the red phase of colouration when the flesh is cut.</p></div>", "photos":[{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver10.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver11.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver2.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver3.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver4.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver5.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver6.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver7.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver8.jpg"},{"mushroomid":"Carboner_ver","img":"wiki\/carboner.ver9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "edible", "attributeId":"comestibilitat", "img":"comestibilitat_comestible.png", "name":"edible"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Russula_torulosa", "latinname":"Russula torulosa", "name":"Russula torulosa", "names":"", "description":"<div> <p> <span class=\"mushroomName\"> blue </span> <span class=\"mushroomName\"> blavets </span> <span class=\"mushroomName\"> red mushroom </span > <span class=\"mushroomName\"> mother-breaks blood </span> (<span class=\"foreignLanguage\"> Russula torulosa </span>) is a species of mushroom in the family of russulàcies. </p> </span> <h3> Description </h3> <ul> <li> hat measuring 5 to 8 cm in diameter. Is pumped from the beginning, and later sometimes slightly flattened with a smooth central bulge. The surface is shiny, but not sticky lubricated, or vinous red color with a purple hue olivàcia. </Li> <li> plates reach up to the leg and is dense, soft, pale cream color. The edge is full and the same color as the rest of the blade or bit clearer. </Li> <li> leg is robust, cylindrical, measuring 3-6 x 1.5-2.5 cm, is Solid color red and purple to violet. </li> <li> Meat is compact, dense, white with a greyish tone and crumbly consistency, as in other <span class=\"foreignLanguage\"> Russula </span>. </li> <li> smells reminiscent of apple and cut it tastes spicy. </li> <li> Ionian ocraci color is pale. The spores are ovoid in subglobosa without germ pores and amyloid, and are decorated with warts. Measured 7 to 8.5 x 5.5 to 7 microns. </Li> </ul> </span> <h3> Habitat and geographical </h3> <p> species often lives in 10 and 1,500 m in sandy soils under different pine species (such as white pine - Pinus halepensis <span class=\"foreignLanguage\"> </span> - and Scotch - <span class = \"foreignLanguage \"> Pinus nigra </span> -) and fruits from late summer to autumn (from August to November). (Andorra, Austria, Bulgaria, Croatia, Denmark, Slovakia, Estonia, Finland, Belgium, Flanders and Wallonia, the French, Italy, like, Umbria, Marche, Lazio, Lombardy, Calabria, Sardinia, etc. . - Luxembourg, Norway, the Netherlands, Portugal, Slovenia, Spain (Basque Country, including Navarre, the Natural Park Moixeró, Cabrera, Dragonera, Ibiza, Formentera, Mallorca, Menorca Extremadura, Andalusia, including the Sierra Nevada, etc.)., Sweden, England, Norfolk, Glamorganshire, Wales and Anglesey, and Morayshire, Scotland), North Africa (Morocco) and Asia (Mongolia ). </p> </span> <h3> chemical reactions </h3> <p> changes color or with ammonium hydroxide or with potassium, but with phenylalanine turns a terracotta color. </p> </span> <h3> edibility </h3> <p> mushroom inedible due to roentor of his flesh. </P> </span> <h3> risk of confusion with other species </h3> <p> be confused with <span class=\"foreignLanguage\"> Russula drimeia </span>, which it differs because it has bright yellow sheets. In addition, these react with ammonia, so that they become reddish pink. It also looks <span class=\"foreignLanguage\"> Russula queletii </span>, which separates it because it grows under spruce (Picea abies <span class=\"foreignLanguage\"> </span>) and so has hat and shades of green streaked margin suauament. </p> </div>", "photos":[{"mushroomid":"Russula_torulosa","img":"wiki\/russula.torulosa2.jpg"},{"mushroomid":"Russula_torulosa","img":"wiki\/russula.torulosa3.jpg"},{"mushroomid":"Russula_torulosa","img":"wiki\/russula.torulosa4.jpg"},{"mushroomid":"Russula_torulosa","img":"wiki\/russula.torulosa5.jpg"},{"mushroomid":"Russula_torulosa","img":"wiki\/russula.torulosa6.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "rosa", "attributeId":"color_capell", "img":"capell_rosa.svg.png", "name":"pink"},{"valueId": "rosa", "attributeId":"color_peu", "img":"peu_rosa.svg.png", "name":"pink"},{"valueId": "poisonous", "attributeId":"comestibilitat", "img":"comestibilitat_toxic.png", "name":"poisonous"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Llora_blanca", "latinname":"Russula virescens", "name":"Russula virescens", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula virescens</span></span> is a basidiomycete mushroom of the genus <span class=\"foreignLanguage\">Russula</span>, and is commonly known as the <span class=\"mushroomName\">green-cracking Russula</span>, the <span class=\"mushroomName\">quilted green Russula</span>, or the <span class=\"mushroomName\">green brittlegill</span>. It can be recognized by its distinctive pale green cap that measures up to  in diameter, the surface of which is covered with darker green angular patches. It has crowded white gills, and a firm, white stipe that is up to  tall and  thick. Considered to be one of the best edible mushrooms of the genus <span class=\"foreignLanguage\">Russula</span>, it is especially popular in Spain and China. With a taste that is described variously as mild, nutty, fruity, or sweet, it is cooked by grilling, frying, sautéeing, or eaten raw. Mushrooms are rich in carbohydrates and proteins, with a low fat content.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula virescens</span></span> is a basidiomycete mushroom of the genus <span class=\"foreignLanguage\">Russula</span>, and is commonly known as the <span class=\"mushroomName\">green-cracking Russula</span>, the <span class=\"mushroomName\">quilted green Russula</span>, or the <span class=\"mushroomName\">green brittlegill</span>. It can be recognized by its distinctive pale green cap that measures up to  in diameter, the surface of which is covered with darker green angular patches. It has crowded white gills, and a firm, white stipe that is up to  tall and  thick. Considered to be one of the best edible mushrooms of the genus <span class=\"foreignLanguage\">Russula</span>, it is especially popular in Spain and China. With a taste that is described variously as mild, nutty, fruity, or sweet, it is cooked by grilling, frying, sautéeing, or eaten raw. Mushrooms are rich in carbohydrates and proteins, with a low fat content.</p><p>The species was described as new to science in 1774 by Jacob Christian Schaeffer. Its distribution encompasses Asia, North Africa, Europe, and Central America. Its presence in North America has not been clarified, due to confusion with the similar species <span class=\"foreignLanguage\">Russula parvovirescens</span> and <span class=\"foreignLanguage\">R.&nbsp;crustosa</span>. <span class=\"foreignLanguage\">R.&nbsp;virescens</span> fruits singly or scattered on the ground in both deciduous and mixed forests, forming mycorrhizal associations with broadleaf trees such as oak, European beech, and aspen. In Asia, it associates with several species of tropical lowland rainforest trees of the family Dipterocarpaceae. The ribonuclease enzyme of <span class=\"foreignLanguage\">R.&nbsp;virescens</span> has been studied and shown to have a unique biochemistry compared to other edible mushrooms. Mushrooms contain biologically active polysaccharides, and a laccase enzyme that can break down several dyes used in the laboratory and in the textile industry.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Russula virescens</span> was first described by German polymath Jacob Christian Schaeffer in 1774 as <span class=\"foreignLanguage\">Agaricus virescens</span>. The species was subsequently transferred to the genus <span class=\"foreignLanguage\">Russula</span> by Elias Fries in 1836. According to the nomenclatural authority MycoBank, <span class=\"foreignLanguage\">Russula furcata</span> var. <span class=\"foreignLanguage\">aeruginosa</span> (published by Christian Hendrik Persoon in 1796) and <span class=\"foreignLanguage\">Agaricus caseosus</span> (published by Karl Friedrich Wilhelm Wallroth in 1883) are synonyms of <span class=\"foreignLanguage\">Russula virescens</span>. The variety <span class=\"foreignLanguage\">albidocitrina</span>, defined by Claude Casimir Gillet in 1876, is no longer considered to have independent taxonomic significance. According to Rolf Singer's 1986 classification of <span class=\"foreignLanguage\">Russula</span>, <span class=\"foreignLanguage\">R.&nbsp;virescens</span> is the type species of subsection <span class=\"foreignLanguage\">Virescentinae</span> in section <span class=\"foreignLanguage\">Rigidae</span>, a grouping of mushrooms characterized by a cap surface that breaks into patches of bran-like (furfuraceous) particles. In a molecular phylogenetic analysis of European <span class=\"foreignLanguage\">Russula</span>, <span class=\"foreignLanguage\">R.&nbsp;virescens</span> formed a clade with <span class=\"foreignLanguage\">R.&nbsp;mustelina</span>; these two species were sister to a clade containing <span class=\"foreignLanguage\">R.&nbsp;amoenicolor</span> and <span class=\"foreignLanguage\">R.&nbsp;violeipes</span>.</p><p>The specific epithet <span class=\"foreignLanguage\">virescens</span> is Latin for \"becoming green\". The characteristic pattern of the cap surface has earned the species common names such as the green-cracking Russula, the quilted green Russula, and the green brittlegill. In the mid-Atlantic United States, it is also known locally as the moldy Russula.</p></div><div><h3>Description</h3><p>Described by mushroom enthusiast Antonio Carluccio as \"not exactly nice to look at\", the cap is at first dome or barrel-shaped, becoming convex and flattened with age with a diameter of up to . The cap center is often depressed. The cuticle of the cap is green, most profoundly in the center, with patches of the same color dispersed radially around the center in an  pattern. The color of the cuticle is often of variable shade, ranging from gray to verdigris to grass-green. The extent of the patching of the cuticle is also variable, giving specimens with limited patches a resemblance to other green-capped species of <span class=\"foreignLanguage\">Russula</span>, such as <span class=\"foreignLanguage\">R.&nbsp;aeruginea</span>. The green patches of the cap lie on a white to pale green background. The cap, while frequently round, may also exhibit irregular lobes and cracks. The cap cuticle is thin, and can be readily peeled off the surface to a distance of about halfway towards the cap center.</p><p>The gills are white to cream colored, and fairly crowded together; they are mortly free from attachment to the stipe. Gills are interconnected at their bases by veins. The stipe is cylindrical, white, and of variable height, up to  tall and  wide; it is roughly the same thickness at both the top and the base. The top portion of the stipe may be farinose—covered with a white, mealy powder. It may turn slightly brown with age, or when it is injured or bruised from handling. Like other mushrooms in the Russulales, the flesh is brittle, owing to the sphaerocyst cytoarchitecture—cylindrical cells that contrast with the typical fibrous, filamentous hyphae present in other orders of the basidiomycota.</p><p>The spores of <span class=\"foreignLanguage\">R.&nbsp;virescens</span> are elliptical or ellipsoid with warts, translucent (hyaline), and produce a white, pale or pale yellow spore print; the spore dimensions are 6–9 by 5–7&nbsp;µm. A partial reticulum (net-like pattern of ridges) interconnects the warts. The spore-bearing cells, the basidia, are club-shaped and have dimensions of 24–33 by 6–7.5&nbsp;µm; they are colorless, and each hold from two to four spores. The pleurocystidia (cystidia on the gill face) are 40–85 by 6–8&nbsp;µm and end abruptly in a sharp point.</p></div><div><h3>= Similar species =</h3><p><span class=\"foreignLanguage\">Russula parvovirescens</span>, found in the eastern United States, can be distinguished from <span class=\"foreignLanguage\">R.&nbsp;virescens</span> by its smaller stature, with caps measuring  wide and stipe up to  long by  thick. Compared to <span class=\"foreignLanguage\">R.&nbsp;virescens</span>, it tends to be more bluish-green, the patches on its cap are larger, and it has a lined cap margin. Microscopically, the terminal cells in the cap cuticle of <span class=\"foreignLanguage\">R.&nbsp;parvovirescens</span> are more swollen than those of <span class=\"foreignLanguage\">R.&nbsp;virescens</span>, which has tapered and elongated terminal cells. Another green-capped <span class=\"foreignLanguage\">Russula</span> is <span class=\"foreignLanguage\">R.&nbsp;aeruginea</span>, but this species may be distinguished from <span class=\"foreignLanguage\">R.&nbsp;virescens</span> by its smaller size and smooth cap. Other green russulas with a smooth cap include <span class=\"foreignLanguage\">R.&nbsp;heterophylla</span> and <span class=\"foreignLanguage\">R.&nbsp;cyanoxantha</span> var. <span class=\"foreignLanguage\">peltereaui</span>. <span class=\"foreignLanguage\">Russula crustosa</span>, like <span class=\"foreignLanguage\">R.&nbsp;virescens</span>, also has an areolate cap, but the cap becomes sticky (viscid) when moist, and its color is more variable, as it may be reddish, yellowish, or brown. Also, the spore print of <span class=\"foreignLanguage\">R.&nbsp;crustosa</span> is a darker yellow than <span class=\"foreignLanguage\">R.&nbsp;virescens</span>. <span class=\"foreignLanguage\">R.&nbsp;redolens</span> has a cap that is \"drab-green to blue-green\", but unlike <span class=\"foreignLanguage\">R.&nbsp;virescens</span>, is smooth. <span class=\"foreignLanguage\">R.&nbsp;redolens</span> has an unpleasant taste and smells of parsley.</p></div><div><h3>Edibility</h3><p><span class=\"foreignLanguage\">Russula virescens</span> is an edible mushroom considered to be one of the best of the genus <span class=\"foreignLanguage\">Russula</span>, and is popular in Europe, particularly in Spain. In an 1875 work on the uses of fungi, English mycologist Mordecai Cubitt Cooke remarked about the mushroom that \"the peasants about Milan are in the habit of putting [it] over wood embers to toast, and eating [it] afterwards with a little salt.\" The mushroom is often sold as a dried product in Asia, and in China, it can be found in roadside markets. Its smell is not distinctive, but its taste has been described as mild, nutty, fruity, or even sweet. Old specimens may smell of herrings. Drying the mushrooms enhances the nutty flavor. Mushrooms can be sautéed (the green color disappears with cooking), and young specimens that are prepared this way have a potato taste that pairs well with shallots. They are also fried or grilled, or used raw in salads.  Young specimens are pale and can be hard to identify, but the characteristic pattern of older fruit bodies makes them hard to confuse with other species. When collecting <span class=\"foreignLanguage\">R.&nbsp;virescens</span> for consumption, caution is of vital importance to avoid confusion with the dangerously poisonous <span class=\"foreignLanguage\">Amanita phalloides</span> (known as the death cap), a mushroom that can be most easily identified by its volva and ring.<!-- cites previous three sentences --></p><p>The nutritional components of <span class=\"foreignLanguage\">R.&nbsp;virescens</span> mushrooms have been characterized. Fresh mushrooms contain about 92.5% moisture. A  sample of dried mushroom (100&nbsp;g&nbsp;dw) has 365 kcal (1527 kilojoules). Carbohydrates make up the bulk of the fruit bodies, comprising 62% of the dry weight; 11.1% of the carbohydrates are sugars, the large majority of which (10.9%) is mannitol. The total lipid, or crude fat, content makes up 1.85% of the dry matter of the mushroom. The proportion of fatty acids (expressed as a percentage of total fatty acids) are 28.78% saturated, 41.51% monounsaturated, and 29.71% polyunsaturated. The most prevalent fatty acids include: palmitic acid, 17.3% of total fatty acids; stearic acid, 7.16%; oleic acid, 40.27%; and linoleic acid, 29.18%. Several bioactive compounds are present in the mushroom. One hundred grams (dry weight) contains 49.3 micrograms (µg) of tocopherols (20.0&nbsp;µg alpha, 21.3&nbsp;µg beta, and 8.0&nbsp;µg gamma) and 0.19 milligrams (mg) of the carotenoid pigment lycopene. There are 4.46&nbsp;g of organic acids per 100&nbsp;g of dry mushrooms, including oxalic acid (0.78&nbsp;g), malic acid (2.71&nbsp;g), citric acid (0.55&nbsp;g), and fumaric acid (0.23&nbsp;g). Mushrooms have 22.6&nbsp;mg/100&nbsp;g&nbsp;dw of the phenolic compound 4-hydroxybenzoic acid, and 15.8&nbsp;mg/100&nbsp;g&nbsp;dw of cinnamic acid.</p></div><div><h3>Habitat and distribution</h3><p><span class=\"foreignLanguage\">Russula virescens</span> can be found fruiting on soil in both deciduous forests and mixed forests, forming ectomycorrhizal symbiotic relationships with a variety of trees, including oaks (<span class=\"foreignLanguage\">Quercus</span>), European beech (<span class=\"foreignLanguage\">Fagus sylvatica</span>), and aspen (<span class=\"foreignLanguage\">Populus tremula</span>). Preliminary investigations suggest that the fungus also associates with at least ten species of Dipterocarpaceae, an important tree family prevalent in the tropical lowland forests of Southeast Asia. Fruit bodies may appear singly or in groups, reappear in the same spots year after year, and are not common. In Europe, fruiting occurs mainly during the months of summer to early autumn. A Mexican study of the seasonal occurrence of several common mushroom species in subtropical forests in Xalapa showed that the fruiting period of <span class=\"foreignLanguage\">R.&nbsp;virescens</span> occurred in April, before the onset of the rainy season.</p><p>The distribution of <span class=\"foreignLanguage\">R.&nbsp;virescens</span> in North America is subject to debate, where a number of similar species such as <span class=\"foreignLanguage\">R.&nbsp;parvovirescens</span> and <span class=\"foreignLanguage\">R.&nbsp;crustosa</span> are also recognized. One author even suggests that <span class=\"foreignLanguage\">R.&nbsp;virescens</span> \"is strictly a European species\", citing Buyck and collaborators (2006), who say \"the <span class=\"foreignLanguage\">virescens</span>-<span class=\"foreignLanguage\">crustosa</span> group is much more complex than suspected and embraces at least a dozen taxa in the eastern US\". As in Europe, <span class=\"foreignLanguage\">Russula virescens</span> has a widespread distribution in Asia, having been recorded from India, Malaysia, Korea, the Philippines, Nepal, China, Thailand, and Vietnam. It is also found in North Africa and Central America.</p></div><div><h3>Chemistry</h3><p><span class=\"foreignLanguage\">Russula virescens</span> has a limited capacity to bioaccumulate the micronutrients iron, copper, and zinc from the soil.  The concentration of these trace metals is slightly higher in the caps than the stipes. A  meal of fresh mushroom caps would supply 16% of the recommended daily allowance (RDA) of copper for an adult male or female (ages 19–50); 16% or 7.3% of the RDA of iron for an adult male or female, respectively; and 16–22% of the adult RDA of zinc. The mushroom is a poor bioaccumulator of the toxic heavy metals arsenic, cadmium, lead, mercury, and nickel.</p><p>Biologically active mushroom polysaccharides have been a frequent research topic in recent decades due to their possible stimulatory effect on innate and cell-mediated immune responses, antitumor activities, and other activities. Immunostimulatory activity, antioxidant activity, cholesterol-lowering, and blood sugar-lowering effects have been detected in extracts of <span class=\"foreignLanguage\">R.&nbsp;virescens</span> fruit bodies, which are attributed to polysaccharides. A water-insoluble beta-glucan, RVS3-II, has been isolated from the fruit bodies. Sulfated derivatives of this compound have antitumor activities against sarcoma tumor cell lines. RVP, a water-soluble polysaccharide present in the mushroom, is made largely of galactomannan subunits and has antioxidant activity.</p><p>Ribonucleases (or RNases) are enzymes that catalyze the hydrolysis of ribonucleic acid (RNA), and collectively they play a critical role in many biological processes. A RNase from <span class=\"foreignLanguage\">R.&nbsp;virescens</span> was shown to be biochemically unique amongst seven edible mushroom species in several ways: it has a co-specificity towards cleaving RNA at poly A and poly C, compared to the monospecific RNases of the others; it can be adsorbed on chromatography columns containing DEAE–cellulose as the adsorbent; it has a pH optimum of 4.5, lower than all other species; and, it has a \"distinctly different\" N-terminal amino acid sequence. The mushroom contains a unique laccase enzyme that can break down several dyes used in the laboratory and in the textile industry, such as  bromothymol blue, eriochrome black T, malachite green, and reactive brilliant blue. Laccases are being used increasingly in the textile industry as environmental biocatalysts for the treatment of dye wastewater.</p></div>", "photos":[{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca10.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca11.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca12.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca13.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca14.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca3.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca4.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca5.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca7.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca8.jpg"},{"mushroomid":"Llora_blanca","img":"wiki\/llora.blanca9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "verdMarro", "attributeId":"color_capell", "img":"capell_verdMarro.svg.png", "name":"green-brown"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Crualga_vinosa", "latinname":"Russula xerampelina", "name":"Russula xerampelina", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula xerampelina</span></span>, also commonly known as the <span class=\"mushroomName\">crab brittlegill</span> or the <span class=\"mushroomName\">shrimp mushroom</span>, is a basidiomycete mushroom of the brittlegill genus <span class=\"foreignLanguage\">Russula</span>. Two subspecies are recognised. The fruiting bodies appear in coniferous woodlands in autumn in northern Europe and North America. Their caps are coloured various shades of wine-red, purple to green. Mild tasting and edible, it is one of the most highly regarded brittlegills for the table. It is also notable for smelling of shellfish or crab when fresh.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Russula xerampelina</span></span>, also commonly known as the <span class=\"mushroomName\">crab brittlegill</span> or the <span class=\"mushroomName\">shrimp mushroom</span>, is a basidiomycete mushroom of the brittlegill genus <span class=\"foreignLanguage\">Russula</span>. Two subspecies are recognised. The fruiting bodies appear in coniferous woodlands in autumn in northern Europe and North America. Their caps are coloured various shades of wine-red, purple to green. Mild tasting and edible, it is one of the most highly regarded brittlegills for the table. It is also notable for smelling of shellfish or crab when fresh.</p></div><div><h3>Taxonomy</h3><p><span class=\"foreignLanguage\">Russula xerampelina</span> was originally described in 1770 as <span class=\"foreignLanguage\">Agaricus xerampelina</span> from a collection in Bavaria by the German mycologist Jacob Christian Schaeffer, who noted the colour as <span class=\"foreignLanguage\">fusco-purpureus</span> or \"purple-brown\". It was later given its present binomial name by Swedish mycologist Elias Magnus Fries. Its specific epithet is taken from the Ancient Greek meaning \"colour of dried vine leaves\", <span class=\"foreignLanguage\">xeros</span> meaning \"dry\", and <span class=\"foreignLanguage\">ampělinos</span> or \"of the vine\". A former variety with a greenish cap, <span class=\"foreignLanguage\">R.&nbsp;xerampelina</span> var. <span class=\"foreignLanguage\">elaeodes</span>, is now classified as <span class=\"foreignLanguage\">R.&nbsp;clavipes</span>.</p><p>More reddish-capped forms could be confused with the sickener (<span class=\"foreignLanguage\">Russula emetica</span>), although the latter always has a white stipe and gills; greener-capped species may resemble the also edible <span class=\"foreignLanguage\">Russula aeruginea</span>. Appearing in the autumn, it grows solitary, or in groups with conifers, The young caps are said to be superb stuffed with any suitable ingredients, and are rarely maggoty.</p></div>", "photos":[{"mushroomid":"Crualga_vinosa","img":"wiki\/crualga.vinosa1.jpg"},{"mushroomid":"Crualga_vinosa","img":"wiki\/crualga.vinosa10.jpg"},{"mushroomid":"Crualga_vinosa","img":"wiki\/crualga.vinosa11.jpg"},{"mushroomid":"Crualga_vinosa","img":"wiki\/crualga.vinosa12.jpg"},{"mushroomid":"Crualga_vinosa","img":"wiki\/crualga.vinosa2.jpg"},{"mushroomid":"Crualga_vinosa","img":"wiki\/crualga.vinosa3.jpg"},{"mushroomid":"Crualga_vinosa","img":"wiki\/crualga.vinosa4.jpg"},{"mushroomid":"Crualga_vinosa","img":"wiki\/crualga.vinosa9.jpg"}], "attributes":[{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "choice", "attributeId":"comestibilitat", "img":"comestibilitat_excellent.png", "name":"choice"},{"valueId": "mycorrhizal", "attributeId":"ecologia", "img":"micorrizogen.png", "name":"mycorrhizal"},{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]},{"id": "Pota_de_cavall_bolet", "latinname":"Scleroderma verrucosum", "name":"Scleroderma verrucosum", "names":"<span class=\"foreignLanguage\"><span class=\"mushroomName\">Scleroderma verrucosum</span></span> is a basidiomycete fungus and a member of the genus <span class=\"foreignLanguage\">Scleroderma</span>, or \"earth balls\". First described scientifically in 1791, the species has a cosmopolitan distribution, and grows in the ground in nutrient-rich, sandy soils.", "description":"<div><p><span class=\"foreignLanguage\"><span class=\"mushroomName\">Scleroderma verrucosum</span></span> is a basidiomycete fungus and a member of the genus <span class=\"foreignLanguage\">Scleroderma</span>, or \"earth balls\". First described scientifically in 1791, the species has a cosmopolitan distribution, and grows in the ground in nutrient-rich, sandy soils.</p></div><div><h3>Taxonomy</h3><p>The species was first described by Pierre Bulliard in 1791 as <span class=\"foreignLanguage\">Lycoperdon verrucosum</span>.</p></div><div><h3>Habitat and distribution</h3><p><span class=\"foreignLanguage\">Scleroderma verrucosum</span> is a mycorrhizal species. Fruit bodies grow in the soil in nutrient-rich, sandy soil, often in deciduous forests. The species has been found in Africa, Asia (China and India), Australia, Europe, North America (including Hawaii), and South America.</p><p>The species was featured on a Paraguayan postage stamp in 1985.</p></div>", "photos":[{"mushroomid":"Pota_de_cavall_bolet","img":"wiki\/pota.de.cavall.(bolet)10.jpg"},{"mushroomid":"Pota_de_cavall_bolet","img":"wiki\/pota.de.cavall.(bolet)4.jpg"},{"mushroomid":"Pota_de_cavall_bolet","img":"wiki\/pota.de.cavall.(bolet)5.jpg"},{"mushroomid":"Pota_de_cavall_bolet","img":"wiki\/pota.de.cavall.(bolet)6.jpg"},{"mushroomid":"Pota_de_cavall_bolet","img":"wiki\/pota.de.cavall.(bolet)7.jpg"},{"mushroomid":"Pota_de_cavall_bolet","img":"wiki\/pota.de.cavall.(bolet)8.jpg"},{"mushroomid":"Pota_de_cavall_bolet","img":"wiki\/pota.de.cavall.(bolet)9.jpg"}], "attributes":[{"valueId": "no", "attributeId":"capell", "img":"No_cap_icon.svg.png", "name":"no"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "gris", "attributeId":"color_peu", "img":"peu_gris.svg.png", "name":"gray"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris_fosc", "attributeId":"color_peu", "img":"peu_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "inedible", "attributeId":"comestibilitat", "img":"comestibilitat_no_comestible.png", "name":"inedible"},{"valueId": "saprotrophic", "attributeId":"ecologia", "img":"saprofit.png", "name":"saprotrophic"},{"valueId": "smooth", "attributeId":"himeni", "img":"Smooth_icon.png", "name":"smooth"},{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"}]}];
my.boletus.lgdata.en.attribute=[{"id": "himeni", "name":"hymen", "description":"select the type of surface himenial", "help":"The hymen is the part that contains the mushroom spores.<ul><li><img src=\"resources/img/attributes/Gills_icon.png\" class=\"helpImage\"><span class=\"helpAttOption\">Gills</span> under the cap you can find gills</li><li><img src=\"resources/img/attributes/Pores_icon.png\" class=\"helpImage\"><span class=\"helpAttOption\">Pores</span> under the cap you can find a porose part</li><li><img src=\"resources/img/attributes/Ridges_icon.png\" class=\"helpImage\"><span class=\"helpAttOption\">Ridges</span> ridges are found under the cap</li><li><img src=\"resources/img/attributes/Teeth_icon.png\" class=\"helpImage\"><span class=\"helpAttOption\">Teeth</span> theeth are found under the cap</li><li><img src=\"resources/img/attributes/Gleba_icon.png\" class=\"helpImage\"><span class=\"helpAttOption\">Gleba</span> The mushroom contains the spores hidden inside</li><li><img src=\"resources/img/attributes/Smooth_icon.png\" class=\"helpImage\"><span class=\"helpAttOption\">Smooth</span> None of the previous are appreciated.</li></ul>", "values":[{"valueId": "gills", "attributeId":"himeni", "img":"Gills_icon.png", "name":"gills"},{"valueId": "pores", "attributeId":"himeni", "img":"Pores_icon.png", "name":"pores"},{"valueId": "smooth", "attributeId":"himeni", "img":"Smooth_icon.png", "name":"smooth"},{"valueId": "ridges", "attributeId":"himeni", "img":"Ridges_icon.png", "name":"ridges"},{"valueId": "teeth", "attributeId":"himeni", "img":"Teeth_icon.png", "name":"teeth"},{"valueId": "gleba", "attributeId":"himeni", "img":"Gleba_icon.png", "name":"gleba"}]},{"id": "capell", "name":"cap", "description":"select the cap shape", "help":"Make a vertical cut to the mushroom cap and indicate its shape", "values":[{"valueId": "campanulate", "attributeId":"capell", "img":"Campanulate_cap_icon.svg.png", "name":"campanulate"},{"valueId": "conical", "attributeId":"capell", "img":"Conical_cap_icon.svg.png", "name":"conical"},{"valueId": "convex", "attributeId":"capell", "img":"Convex_cap_icon.svg.png", "name":"convex"},{"valueId": "depressed", "attributeId":"capell", "img":"Depressed_cap_icon.svg.png", "name":"depressed"},{"valueId": "flat", "attributeId":"capell", "img":"Flat_cap_icon.svg.png", "name":"flat"},{"valueId": "infundibuliform", "attributeId":"capell", "img":"Infundibuliform_cap_icon.svg.png", "name":"infundibuliform"},{"valueId": "offset", "attributeId":"capell", "img":"Offset_cap_icon.svg.png", "name":"offset"},{"valueId": "ovate", "attributeId":"capell", "img":"Ovate_cap_icon.svg.png", "name":"ovate"},{"valueId": "umbillicate", "attributeId":"capell", "img":"Umbillicate_cap_icon.svg.png", "name":"umbilicate"},{"valueId": "umbonate", "attributeId":"capell", "img":"Umbonate_cap_icon.svg.png", "name":"umbonate"},{"valueId": "no", "attributeId":"capell", "img":"No_cap_icon.svg.png", "name":"no"}]},{"id": "color_capell", "name":"color of the cap", "description":"select the color of the cap", "help":"Specify the color of the top of the mushroom -cap-. If more than one color is found select the predominant one", "values":[{"valueId": "blanc", "attributeId":"color_capell", "img":"capell_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_capell", "img":"capell_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris", "attributeId":"color_capell", "img":"capell_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_capell", "img":"capell_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "negre", "attributeId":"color_capell", "img":"capell_negre.svg.png", "name":"black"},{"valueId": "marro_clar", "attributeId":"color_capell", "img":"capell_marro_clar.svg.png", "name":"light brown"},{"valueId": "marro", "attributeId":"color_capell", "img":"capell_marro.svg.png", "name":"brown"},{"valueId": "verdMarro", "attributeId":"color_capell", "img":"capell_verdMarro.svg.png", "name":"green-brown"},{"valueId": "rosa", "attributeId":"color_capell", "img":"capell_rosa.svg.png", "name":"pink"},{"valueId": "vermell", "attributeId":"color_capell", "img":"capell_vermell.svg.png", "name":"red"},{"valueId": "taronja", "attributeId":"color_capell", "img":"capell_taronja.svg.png", "name":"orange"},{"valueId": "groc", "attributeId":"color_capell", "img":"capell_groc.svg.png", "name":"yellow"}]},{"id": "color_peu", "name":"color of the foot", "description":"select the color of the foot", "help":"Specify the color of the bottom of the mushroom -foot-. If more than one color is found select the predominant one", "values":[{"valueId": "blanc", "attributeId":"color_peu", "img":"peu_blanc.svg.png", "name":"white"},{"valueId": "gris_clar", "attributeId":"color_peu", "img":"peu_gris_clar.svg.png", "name":"light gray"},{"valueId": "gris", "attributeId":"color_peu", "img":"peu_gris.svg.png", "name":"gray"},{"valueId": "gris_fosc", "attributeId":"color_peu", "img":"peu_gris_fosc.svg.png", "name":"dark gray"},{"valueId": "negre", "attributeId":"color_peu", "img":"peu_negre.svg.png", "name":"black"},{"valueId": "marro_clar", "attributeId":"color_peu", "img":"peu_marro_clar.svg.png", "name":"light brown"},{"valueId": "marro", "attributeId":"color_peu", "img":"peu_marro.svg.png", "name":"brown"},{"valueId": "verdMarro", "attributeId":"color_peu", "img":"peu_verdMarro.svg.png", "name":"green-brown"},{"valueId": "rosa", "attributeId":"color_peu", "img":"peu_rosa.svg.png", "name":"pink"},{"valueId": "vermell", "attributeId":"color_peu", "img":"peu_vermell.svg.png", "name":"red"},{"valueId": "taronja", "attributeId":"color_peu", "img":"peu_taronja.svg.png", "name":"orange"},{"valueId": "groc", "attributeId":"color_peu", "img":"peu_groc.svg.png", "name":"yellow"}]},{"id": "vel", "name":"veil", "description":"selects the presence and type of veil", "help":"Indicate whether the foot of the mushroom has a ring, a volva, or both things. In most cases where nothing is found select smooth.", "values":[{"valueId": "bare", "attributeId":"vel", "img":"Bare_stipe_icon.png", "name":"bare"},{"valueId": "ring", "attributeId":"vel", "img":"Ring_stipe_icon.png", "name":"ring"},{"valueId": "volva", "attributeId":"vel", "img":"Volva_stipe_icon.png", "name":"volva"},{"valueId": "ring and volva", "attributeId":"vel", "img":"Ring_and_volva_stipe_icon.png", "name":"ring and volva"},{"valueId": "cortina", "attributeId":"vel", "img":"Cortina_stipe_icon.png", "name":"cortina"}]},{"id": "lamina", "name":"sheet", "description":"select the shape of the bottom of the cap", "help":"Make a vertical cut the mushroom and indicate how are the gills attached to the foot", "values":[{"valueId": "free", "attributeId":"lamina", "img":"Free_gills_icon2.svg.png", "name":"free"},{"valueId": "adnexed", "attributeId":"lamina", "img":"Adnexed_gills_icon2.svg.png", "name":"adnexed"},{"valueId": "adnate", "attributeId":"lamina", "img":"Adnate_gills_icon2.svg.png", "name":"adnate"},{"valueId": "emarginate", "attributeId":"lamina", "img":"Emarginate_gills_icon2.svg.png", "name":"emarginate"},{"valueId": "seceding", "attributeId":"lamina", "img":"Seceding_gills_icon2.svg.png", "name":"seceding"},{"valueId": "sinuate", "attributeId":"lamina", "img":"Sinuate_gills_icon2.svg.png", "name":"sinuate"},{"valueId": "subdecurrent", "attributeId":"lamina", "img":"Subdecurrent_gills_icon2.svg.png", "name":"subdecurrent"},{"valueId": "decurrent", "attributeId":"lamina", "img":"Decurrent_gills_icon2.svg.png", "name":"decurrent"},{"valueId": "no", "attributeId":"lamina", "img":"No_gills_icon.svg.png", "name":"no"}]}];
my.boletus.lgdata.en.mushAttValue=[{"mushroomId":"Abro_de_bedoll","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Abro_de_bedoll","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Abro_de_bedoll","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Abro_vermell","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Abro_vermell","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Abro_vermell","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Agaricus_impudicus","attributeId":"capell","valueId":"convex"},{"mushroomId":"Agaricus_impudicus","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Agaricus_impudicus","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Agaricus_impudicus","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Agaricus_impudicus","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Agaricus_impudicus","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Agaricus_impudicus","attributeId":"lamina","valueId":"free"},{"mushroomId":"Agaricus_impudicus","attributeId":"vel","valueId":"ring"},{"mushroomId":"Amanita_ocreata","attributeId":"capell","valueId":"convex"},{"mushroomId":"Amanita_ocreata","attributeId":"capell","valueId":"flat"},{"mushroomId":"Amanita_ocreata","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Amanita_ocreata","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Amanita_ocreata","attributeId":"comestibilitat","valueId":"deadly"},{"mushroomId":"Amanita_ocreata","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Amanita_ocreata","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Amanita_ocreata","attributeId":"lamina","valueId":"free"},{"mushroomId":"Amanita_ocreata","attributeId":"vel","valueId":"ring and volva"},{"mushroomId":"Anel.laria","attributeId":"capell","valueId":"convex"},{"mushroomId":"Anel.laria","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Anel.laria","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Anel.laria","attributeId":"color_capell","valueId":"verdMarro"},{"mushroomId":"Anel.laria","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Anel.laria","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Anel.laria","attributeId":"comestibilitat","valueId":"unknown"},{"mushroomId":"Anel.laria","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Anel.laria","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Anel.laria","attributeId":"lamina","valueId":"adnexed"},{"mushroomId":"Anel.laria","attributeId":"vel","valueId":"ring"},{"mushroomId":"Arigany","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Arigany","attributeId":"color_capell","valueId":"negre"},{"mushroomId":"Arigany","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Auriana","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Auriana","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Auriana","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Auriana","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Bec_de_perdiu","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Bec_de_perdiu","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Bec_de_perdiu","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Bec_de_perdiu","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Bola-de-neu","attributeId":"capell","valueId":"convex"},{"mushroomId":"Bola-de-neu","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Bola-de-neu","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Bola-de-neu","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Bola-de-neu","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Bola-de-neu","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Bola-de-neu","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Bola-de-neu","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Bola-de-neu","attributeId":"lamina","valueId":"free"},{"mushroomId":"Bola-de-neu","attributeId":"vel","valueId":"ring"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"capell","valueId":"convex"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"capell","valueId":"flat"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"lamina","valueId":"free"},{"mushroomId":"Bola-de-neu_de_bosc","attributeId":"vel","valueId":"ring"},{"mushroomId":"Bola-de-neu_pudent","attributeId":"capell","valueId":"convex"},{"mushroomId":"Bola-de-neu_pudent","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Bola-de-neu_pudent","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Bola-de-neu_pudent","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Bola-de-neu_pudent","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Bola-de-neu_pudent","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Bola-de-neu_pudent","attributeId":"lamina","valueId":"free"},{"mushroomId":"Bola-de-neu_pudent","attributeId":"vel","valueId":"ring"},{"mushroomId":"Boletus_pinicola","attributeId":"capell","valueId":"convex"},{"mushroomId":"Boletus_pinicola","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Boletus_pinicola","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Boletus_pinicola","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Boletus_pinicola","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Boletus_pinicola","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Boletus_pinicola","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Boletus_pinicola","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Boletus_pinicola","attributeId":"vel","valueId":"bare"},{"mushroomId":"Bolet_de_greix","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Bolet_de_greix","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Bolet_de_pi","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Bolet_de_pi","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Bolet_de_pi","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Bolet_de_pi","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Bolet_de_soca_vellutat","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Bolet_de_soca_vellutat","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Bolet_de_soca_vellutat","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Bolet_de_soca_versicolor","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Bolet_de_soca_versicolor","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Bolet_de_soca_versicolor","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Bolet_de_soca_versicolor","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Bolet_de_soca_versicolor","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Bolet_de_soca_versicolor","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Bolet_de_soca_versicolor","attributeId":"color_peu","valueId":"gris_fosc"},{"mushroomId":"Bolet_de_soca_versicolor","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Bolet_de_tinta","attributeId":"capell","valueId":"conical"},{"mushroomId":"Bolet_de_tinta","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Bolet_de_tinta","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Bolet_de_tinta","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Bolet_de_tinta","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Bolet_de_tinta","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Bolet_de_tinta","attributeId":"lamina","valueId":"free"},{"mushroomId":"Bolet_de_tinta","attributeId":"vel","valueId":"ring"},{"mushroomId":"Bossa_truncada","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Bossa_truncada","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Bossa_truncada","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Bossa_truncada","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Bossa_truncada","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Bromosa","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Bromosa","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Bromosa","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cama-sec","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Cama-sec","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Cama-sec","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cama-sec","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Cama-sec_de_soca","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Cama-sec_de_soca","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Cama-sec_de_soca","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Cama-sec_de_soca","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cama-sec_de_soca","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Camagroc","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Camagroc","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Camagroc","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Camagroc","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Camperol_dels_carrers","attributeId":"capell","valueId":"convex"},{"mushroomId":"Camperol_dels_carrers","attributeId":"capell","valueId":"flat"},{"mushroomId":"Camperol_dels_carrers","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Camperol_dels_carrers","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Camperol_dels_carrers","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Camperol_dels_carrers","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Camperol_dels_carrers","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Camperol_dels_carrers","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Camperol_dels_carrers","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Camperol_dels_carrers","attributeId":"lamina","valueId":"free"},{"mushroomId":"Camperol_dels_carrers","attributeId":"vel","valueId":"ring"},{"mushroomId":"Carboner_ver","attributeId":"capell","valueId":"convex"},{"mushroomId":"Carboner_ver","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Carboner_ver","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Carboner_ver","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Carboner_ver","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Carboner_ver","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Carboner_ver","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Carboner_ver","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Carboner_ver","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Carboner_ver","attributeId":"vel","valueId":"bare"},{"mushroomId":"Carlet_bolet","attributeId":"capell","valueId":"convex"},{"mushroomId":"Carlet_bolet","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Carlet_bolet","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Carlet_bolet","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Carlet_bolet","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Carlet_bolet","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Carlet_bolet","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Carlet_bolet","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Carlet_bolet","attributeId":"vel","valueId":"bare"},{"mushroomId":"Cep_bolet","attributeId":"capell","valueId":"convex"},{"mushroomId":"Cep_bolet","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Cep_bolet","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Cep_bolet","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cep_bolet","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Cep_bolet","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Cep_bolet","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cep_bolet","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Cep_bolet","attributeId":"vel","valueId":"bare"},{"mushroomId":"Cep_destiu","attributeId":"capell","valueId":"convex"},{"mushroomId":"Cep_destiu","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Cep_destiu","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Cep_destiu","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cep_destiu","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Cep_destiu","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Cep_destiu","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cep_destiu","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Cep_destiu","attributeId":"vel","valueId":"bare"},{"mushroomId":"Cogoma_groga","attributeId":"capell","valueId":"flat"},{"mushroomId":"Cogoma_groga","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Cogoma_groga","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cogoma_groga","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Cogoma_groga","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cogoma_groga","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Cogoma_groga","attributeId":"lamina","valueId":"free"},{"mushroomId":"Cogoma_groga","attributeId":"vel","valueId":"ring and volva"},{"mushroomId":"Conocybe","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Conocybe","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Conocybe","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Conocybe","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Conocybe","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Conocybe","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Conocybe","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Conocybe","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Coprinus_picaceus","attributeId":"capell","valueId":"conical"},{"mushroomId":"Coprinus_picaceus","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Coprinus_picaceus","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Coprinus_picaceus","attributeId":"color_capell","valueId":"negre"},{"mushroomId":"Coprinus_picaceus","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Coprinus_picaceus","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Coprinus_picaceus","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Coprinus_picaceus","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Coprinus_picaceus","attributeId":"lamina","valueId":"free"},{"mushroomId":"Coprinus_picaceus","attributeId":"vel","valueId":"bare"},{"mushroomId":"Cortinarius_trivialis","attributeId":"capell","valueId":"convex"},{"mushroomId":"Cortinarius_trivialis","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Cortinarius_trivialis","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Cortinarius_trivialis","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Cortinarius_trivialis","attributeId":"color_capell","valueId":"verdMarro"},{"mushroomId":"Cortinarius_trivialis","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Cortinarius_trivialis","attributeId":"color_peu","valueId":"gris_fosc"},{"mushroomId":"Cortinarius_trivialis","attributeId":"color_peu","valueId":"marro"},{"mushroomId":"Cortinarius_trivialis","attributeId":"color_peu","valueId":"verdMarro"},{"mushroomId":"Cortinarius_trivialis","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Cortinarius_trivialis","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cortinarius_trivialis","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Cortinarius_trivialis","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Cortinarius_trivialis","attributeId":"vel","valueId":"cortina"},{"mushroomId":"Cortinari_gros","attributeId":"capell","valueId":"convex"},{"mushroomId":"Cortinari_gros","attributeId":"capell","valueId":"flat"},{"mushroomId":"Cortinari_gros","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Cortinari_gros","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cortinari_gros","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Cortinari_gros","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cortinari_gros","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Cortinari_gros","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Cortinari_gros","attributeId":"vel","valueId":"bare"},{"mushroomId":"Cortinari_rutilant","attributeId":"capell","valueId":"umbonate"},{"mushroomId":"Cortinari_rutilant","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Cortinari_rutilant","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Cortinari_rutilant","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Cortinari_rutilant","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Cortinari_rutilant","attributeId":"comestibilitat","valueId":"deadly"},{"mushroomId":"Cortinari_rutilant","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cortinari_rutilant","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Cortinari_rutilant","attributeId":"lamina","valueId":"adnexed"},{"mushroomId":"Cortinari_rutilant","attributeId":"vel","valueId":"cortina"},{"mushroomId":"Crualga_vinosa","attributeId":"capell","valueId":"convex"},{"mushroomId":"Crualga_vinosa","attributeId":"capell","valueId":"flat"},{"mushroomId":"Crualga_vinosa","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Crualga_vinosa","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Crualga_vinosa","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Crualga_vinosa","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Crualga_vinosa","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Crualga_vinosa","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Crualga_vinosa","attributeId":"lamina","valueId":"free"},{"mushroomId":"Crualga_vinosa","attributeId":"vel","valueId":"bare"},{"mushroomId":"Crucibulum_laeve","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Crucibulum_laeve","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Crucibulum_laeve","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Crucibulum_laeve","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Crucibulum_laeve","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Crucibulum_laeve","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Cualbra_morada","attributeId":"capell","valueId":"convex"},{"mushroomId":"Cualbra_morada","attributeId":"capell","valueId":"flat"},{"mushroomId":"Cualbra_morada","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Cualbra_morada","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cualbra_morada","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Cualbra_morada","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cualbra_morada","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Cualbra_morada","attributeId":"lamina","valueId":"free"},{"mushroomId":"Cualbra_morada","attributeId":"vel","valueId":"bare"},{"mushroomId":"Cualbra_pudent","attributeId":"capell","valueId":"convex"},{"mushroomId":"Cualbra_pudent","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Cualbra_pudent","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cualbra_pudent","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Cualbra_pudent","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cualbra_pudent","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Cualbra_pudent","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Cualbra_pudent","attributeId":"vel","valueId":"bare"},{"mushroomId":"Cualbra_retgera","attributeId":"capell","valueId":"convex"},{"mushroomId":"Cualbra_retgera","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Cualbra_retgera","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Cualbra_retgera","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Cualbra_retgera","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Cualbra_retgera","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Cualbra_retgera","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Cualbra_retgera","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Cualbra_retgera","attributeId":"lamina","valueId":"adnexed"},{"mushroomId":"Cualbra_retgera","attributeId":"lamina","valueId":"free"},{"mushroomId":"Cualbra_retgera","attributeId":"vel","valueId":"bare"},{"mushroomId":"Escaldabec_fragil","attributeId":"capell","valueId":"convex"},{"mushroomId":"Escaldabec_fragil","attributeId":"capell","valueId":"flat"},{"mushroomId":"Escaldabec_fragil","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Escaldabec_fragil","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Escaldabec_fragil","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Escaldabec_fragil","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Escaldabec_fragil","attributeId":"lamina","valueId":"adnexed"},{"mushroomId":"Escaldabec_fragil","attributeId":"vel","valueId":"bare"},{"mushroomId":"Esclata-sang_blanc","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Esclata-sang_blanc","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Esclata-sang_blanc","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Esclata-sang_blanc","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Fals_camagroc","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Fals_camagroc","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Fals_camagroc","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Fals_camagroc","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Fals_rossinyol","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Fals_rossinyol","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Fals_rossinyol","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Farinera","attributeId":"capell","valueId":"convex"},{"mushroomId":"Farinera","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Farinera","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Farinera","attributeId":"comestibilitat","valueId":"caution"},{"mushroomId":"Farinera","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Farinera","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Farinera","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Farinera","attributeId":"lamina","valueId":"free"},{"mushroomId":"Farinera","attributeId":"vel","valueId":"ring and volva"},{"mushroomId":"Farinera_borda","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Farinera_borda","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Farinera_borda","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Farinera_borda","attributeId":"color_capell","valueId":"verdMarro"},{"mushroomId":"Farinera_borda","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Farinera_borda","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Fetge_de_vaca","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Fetge_de_vaca","attributeId":"color_peu","valueId":"vermell"},{"mushroomId":"Flammulina_","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Flammulina_","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Fredolic","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Fredolic","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Fredolic","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Fredolic_gros","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Fredolic_gros","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Fredolic_gros","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Fredolic_gros_bord","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Fredolic_gros_bord","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Fredolic_gros_bord","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Fredolic_gros_bord","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Galerina","attributeId":"capell","valueId":"convex"},{"mushroomId":"Galerina","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Galerina","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Galerina","attributeId":"comestibilitat","valueId":"deadly"},{"mushroomId":"Galerina","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Galerina","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Galerina","attributeId":"lamina","valueId":"adnexed"},{"mushroomId":"Galerina","attributeId":"vel","valueId":"bare"},{"mushroomId":"Galerina","attributeId":"vel","valueId":"ring"},{"mushroomId":"Galerina_marginata","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Galerina_marginata","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Galerina_marginata","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Girgola_de_castanyer","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Girgola_de_castanyer","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Girgola_de_castanyer","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Girgola_de_castanyer","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Girgola_de_castanyer","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Girgola_de_panical","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Girgola_de_panical","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Girgola_de_panical","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Girgola_de_panical","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Girgola_dolivera","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Girgola_dolivera","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Girgola_dolivera","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Girgola_dolivera","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Girgola_vermella","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Girgola_vermella","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Girgola_vermella","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Girgola_vermella","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Girgola_vermella","attributeId":"color_peu","valueId":"vermell"},{"mushroomId":"Greixa_davet","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Greixa_davet","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Greixa_davet","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Greixa_davet","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Hygrophorus_marzuolus","attributeId":"capell","valueId":"convex"},{"mushroomId":"Hygrophorus_marzuolus","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Hygrophorus_marzuolus","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Hygrophorus_marzuolus","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Hygrophorus_marzuolus","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Hygrophorus_marzuolus","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Hygrophorus_marzuolus","attributeId":"lamina","valueId":"subdecurrent"},{"mushroomId":"Hygrophorus_marzuolus","attributeId":"vel","valueId":"bare"},{"mushroomId":"Lactarius_obscuratus","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Lactarius_obscuratus","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Lactarius_quieticolor","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Lactarius_quieticolor","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Lepiota_brunneoincarnata","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Lepiota_brunneoincarnata","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Leucocoprinus_birnbaumii","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Leucocoprinus_birnbaumii","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Leucocoprinus_birnbaumii","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Leucocoprinus_birnbaumii","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Llenegall_dolc","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Llenegall_dolc","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Llenega_negra","attributeId":"capell","valueId":"convex"},{"mushroomId":"Llenega_negra","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Llenega_negra","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Llenega_negra","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Llenega_negra","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Llenega_negra","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Llenega_negra","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Llenega_negra","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Llenega_negra","attributeId":"vel","valueId":"bare"},{"mushroomId":"Llengua_de_bou_bolet","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Llengua_de_bou_bolet","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Llengua_de_bou_bolet","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Llengua_de_bou_bolet","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Llengua_de_bou_vermellosa","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Llengua_de_bou_vermellosa","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Llengua_de_bou_vermellosa","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Lleterola_de_llet_groga","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Lleterola_de_llet_groga","attributeId":"capell","valueId":"flat"},{"mushroomId":"Lleterola_de_llet_groga","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Lleterola_de_llet_groga","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Lleterola_de_llet_groga","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Lleterola_de_llet_groga","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Lleterola_de_llet_groga","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Lleterola_de_llet_groga","attributeId":"vel","valueId":"bare"},{"mushroomId":"Lleterola_roja","attributeId":"capell","valueId":"convex"},{"mushroomId":"Lleterola_roja","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Lleterola_roja","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Lleterola_roja","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Lleterola_roja","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Lleterola_roja","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Lleterola_roja","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Lleterola_roja","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Lleterola_roja","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Lleterola_roja","attributeId":"vel","valueId":"bare"},{"mushroomId":"Lleterola_verda","attributeId":"capell","valueId":"flat"},{"mushroomId":"Lleterola_verda","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Lleterola_verda","attributeId":"color_peu","valueId":"marro"},{"mushroomId":"Lleterola_verda","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Lleterola_verda","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Lleterola_verda","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Lleterola_verda","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Lleterola_verda","attributeId":"vel","valueId":"bare"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"capell","valueId":"convex"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"comestibilitat","valueId":"caution"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Lleterol_de_bedoll","attributeId":"vel","valueId":"bare"},{"mushroomId":"Llora_blanca","attributeId":"capell","valueId":"convex"},{"mushroomId":"Llora_blanca","attributeId":"capell","valueId":"flat"},{"mushroomId":"Llora_blanca","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Llora_blanca","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Llora_blanca","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Llora_blanca","attributeId":"color_capell","valueId":"verdMarro"},{"mushroomId":"Llora_blanca","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Llora_blanca","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Llora_blanca","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Llora_blanca","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Llora_blanca","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Llora_blanca","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Llora_blanca","attributeId":"vel","valueId":"bare"},{"mushroomId":"Maneta_arrissada","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Maneta_arrissada","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Maneta_arrissada","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Maneta_arrissada","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Maneta_arrissada","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Maneta_arrissada","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Mataparent","attributeId":"capell","valueId":"convex"},{"mushroomId":"Mataparent","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Mataparent","attributeId":"color_peu","valueId":"vermell"},{"mushroomId":"Mataparent","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Mataparent","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Mataparent","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Mataparent","attributeId":"vel","valueId":"bare"},{"mushroomId":"Mataparent_amarg","attributeId":"capell","valueId":"convex"},{"mushroomId":"Mataparent_amarg","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Mataparent_amarg","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Mataparent_amarg","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Mataparent_amarg","attributeId":"color_peu","valueId":"vermell"},{"mushroomId":"Mataparent_amarg","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Mataparent_amarg","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Mataparent_amarg","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Mataparent_amarg","attributeId":"vel","valueId":"bare"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"capell","valueId":"convex"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"capell","valueId":"flat"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Mataparent_de_cama_amb_olor_de_tinta","attributeId":"vel","valueId":"bare"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"capell","valueId":"convex"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"comestibilitat","valueId":"caution"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Mataparent_de_cama_bleda-rave","attributeId":"vel","valueId":"bare"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"capell","valueId":"convex"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"color_peu","valueId":"vermell"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"comestibilitat","valueId":"caution"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Mataparent_de_cama_roja","attributeId":"vel","valueId":"bare"},{"mushroomId":"Mataparent_radicant","attributeId":"capell","valueId":"convex"},{"mushroomId":"Mataparent_radicant","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Mataparent_radicant","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Mataparent_radicant","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Mataparent_radicant","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Mataparent_radicant","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Mataparent_radicant","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Mataparent_radicant","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Mataparent_radicant","attributeId":"vel","valueId":"bare"},{"mushroomId":"Micena","attributeId":"capell","valueId":"conical"},{"mushroomId":"Micena","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Micena","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Micena","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Micena","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Micena","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Micena","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Micena","attributeId":"color_peu","valueId":"marro"},{"mushroomId":"Micena","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Micena","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Micena","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Micena","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Micena","attributeId":"vel","valueId":"bare"},{"mushroomId":"Mocosa_blanca","attributeId":"capell","valueId":"convex"},{"mushroomId":"Mocosa_blanca","attributeId":"capell","valueId":"flat"},{"mushroomId":"Mocosa_blanca","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Mocosa_blanca","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Mocosa_blanca","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Mocosa_blanca","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Mocosa_blanca","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Mocosa_blanca","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Mocosa_blanca","attributeId":"vel","valueId":"bare"},{"mushroomId":"Moixerno","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Moixerno","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Moixerno","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Molleric_clapat","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Molleric_clapat","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Molleric_clapat","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Molleric_clapat","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Molleric_clapat","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Molleric_granellut","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Molleric_granellut","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Molleric_granellut","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Molleric_granellut","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Molleric_granellut","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Moraga_elastica","attributeId":"capell","valueId":"convex"},{"mushroomId":"Moraga_elastica","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Moraga_elastica","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Moraga_elastica","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Moraga_elastica","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Moraga_elastica","attributeId":"comestibilitat","valueId":"caution"},{"mushroomId":"Moraga_elastica","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Moraga_elastica","attributeId":"himeni","valueId":"smooth"},{"mushroomId":"Moraga_elastica","attributeId":"vel","valueId":"bare"},{"mushroomId":"Mycena_pura","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Mycena_pura","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Mycena_pura","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Mycena_pura","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Mycena_rosella","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Mycena_rosella","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Nematoloma_rogenc","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Nematoloma_rogenc","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Orella_de_Judes","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Orella_de_Judes","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Orella_de_Judes","attributeId":"color_peu","valueId":"marro"},{"mushroomId":"Orella_de_Judes","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"capell","valueId":"convex"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"himeni","valueId":"smooth"},{"mushroomId":"Orella_de_llebre_blanca","attributeId":"vel","valueId":"bare"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"capell","valueId":"convex"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"color_peu","valueId":"gris_fosc"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"himeni","valueId":"smooth"},{"mushroomId":"Orella_de_llebre_negra","attributeId":"vel","valueId":"bare"},{"mushroomId":"Ou_del_diable","attributeId":"capell","valueId":"conical"},{"mushroomId":"Ou_del_diable","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Ou_del_diable","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Ou_del_diable","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Ou_del_diable","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Ou_del_diable","attributeId":"color_capell","valueId":"negre"},{"mushroomId":"Ou_del_diable","attributeId":"color_capell","valueId":"verdMarro"},{"mushroomId":"Ou_del_diable","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Ou_del_diable","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Ou_del_diable","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Ou_del_diable","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Ou_del_diable","attributeId":"himeni","valueId":"gleba"},{"mushroomId":"Ou_del_diable","attributeId":"vel","valueId":"bare"},{"mushroomId":"Ou_de_reig","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Ou_de_reig","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Ou_de_reig","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Ou_de_reig","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Ou_de_reig","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Paloma","attributeId":"capell","valueId":"umbonate"},{"mushroomId":"Paloma","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Paloma","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Paloma","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Paloma","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Paloma","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Paloma","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Paloma","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Paloma","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Paloma","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Paloma","attributeId":"lamina","valueId":"free"},{"mushroomId":"Paloma","attributeId":"vel","valueId":"ring"},{"mushroomId":"Palomi","attributeId":"capell","valueId":"convex"},{"mushroomId":"Palomi","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Palomi","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Palomi","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Palomi","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Palomi","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Palomi","attributeId":"lamina","valueId":"adnexed"},{"mushroomId":"Palomi","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pampeta","attributeId":"capell","valueId":"infundibuliform"},{"mushroomId":"Pampeta","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Pampeta","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Pampeta","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Pampeta","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Pampeta","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pampeta","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Pampeta","attributeId":"vel","valueId":"bare"},{"mushroomId":"Paxillus_involutus","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Paxillus_involutus","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Paxillus_involutus","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Paxillus_involutus","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Pebras","attributeId":"capell","valueId":"convex"},{"mushroomId":"Pebras","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Pebras","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Pebras","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pebras","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Pebras","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pebras","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Pebras","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pebrassa_vellutada","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Pebrassa_vellutada","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Pebrassa_vellutada","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pebrassa_vellutada","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Pebrassa_vellutada","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Pebrassa_vellutada","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pebrassa_vellutada","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Pebrassa_vellutada","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pebras_lleter","attributeId":"capell","valueId":"convex"},{"mushroomId":"Pebras_lleter","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Pebras_lleter","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pebras_lleter","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Pebras_lleter","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Pebras_lleter","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pebras_lleter","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Pebras_lleter","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Pebras_lleter_de_riberada","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pentinella","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Pentinella","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Pentinella","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Pentinella","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pentinella","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Pentinella_rosada","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Pentinella_rosada","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Pet_de_llop","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Pet_de_llop","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Peu_de_rata","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Peu_de_rata","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Peu_de_rata","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Peu_de_rata","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Peu_de_rata_bord","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Peu_de_rata_bord","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pimpinella_morada","attributeId":"capell","valueId":"convex"},{"mushroomId":"Pimpinella_morada","attributeId":"capell","valueId":"umbonate"},{"mushroomId":"Pimpinella_morada","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Pimpinella_morada","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Pimpinella_morada","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pimpinella_morada","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Pimpinella_morada","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Pimpinella_morada","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Pimpinella_morada","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pimpinella_morada","attributeId":"lamina","valueId":"emarginate"},{"mushroomId":"Pimpinella_morada","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pinetell","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Pinetell","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Pinetell","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Pinetell","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Pinetell","attributeId":"color_peu","valueId":"vermell"},{"mushroomId":"Pinetell","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Pinetell","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Pinetell","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pinetell","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Pinetell","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pinetell_bord","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Pinetell_bord","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Pinetell_bord","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Pinetell_bord","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Pinetell_bord","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pinetell_bord","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Pinetell_bord","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Pinetell_bord","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Pinetell_bord","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Pinetell_bord","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pinetell_bord","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Pinetell_bord","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pinetell_davet","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Pinetell_davet","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Pinetell_davet","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Pinetell_davet","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Pinetell_davet","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Pinetell_davet","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pinetell_davet","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Pinetell_davet","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pinetell_de_calceta","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Pinetell_de_calceta","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Pinetell_de_calceta","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Pinetell_de_calceta","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pixaca","attributeId":"capell","valueId":"flat"},{"mushroomId":"Pixaca","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Pixaca","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Pixaca","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Pixaca","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pixaca","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Pixaca","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Pixaca","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Pixaca","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pixaca","attributeId":"lamina","valueId":"free"},{"mushroomId":"Pixaca","attributeId":"vel","valueId":"ring and volva"},{"mushroomId":"Pixeconill","attributeId":"capell","valueId":"conical"},{"mushroomId":"Pixeconill","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Pixeconill","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Pixeconill","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Pixeconill","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Pixeconill","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Pixeconill","attributeId":"color_peu","valueId":"verdMarro"},{"mushroomId":"Pixeconill","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Pixeconill","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Pixeconill","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pixeconill","attributeId":"lamina","valueId":"adnexed"},{"mushroomId":"Pixeconill","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pluteus","attributeId":"capell","valueId":"convex"},{"mushroomId":"Pluteus","attributeId":"capell","valueId":"flat"},{"mushroomId":"Pluteus","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Pluteus","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Pluteus","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Pluteus","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Pluteus","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Pluteus","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Pluteus","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Pluteus","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Pluteus","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Pluteus","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Pluteus","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Pluteus","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Pluteus","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Pluteus","attributeId":"lamina","valueId":"free"},{"mushroomId":"Pluteus","attributeId":"vel","valueId":"bare"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"capell","valueId":"no"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"color_peu","valueId":"gris_fosc"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"comestibilitat","valueId":"inedible"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"himeni","valueId":"smooth"},{"mushroomId":"Pota_de_cavall_bolet","attributeId":"vel","valueId":"bare"},{"mushroomId":"Reig_de_fageda","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Reig_de_fageda","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Reig_de_fageda","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Reixes_del_diable","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Reixes_del_diable","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Rovello","attributeId":"capell","valueId":"depressed"},{"mushroomId":"Rovello","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Rovello","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Rovello","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Rovello","attributeId":"color_peu","valueId":"vermell"},{"mushroomId":"Rovello","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Rovello","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Rovello","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Rovello","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Rovello","attributeId":"vel","valueId":"bare"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"capell","valueId":"convex"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"lamina","valueId":"free"},{"mushroomId":"Rubiol_gros_descates_brunes","attributeId":"vel","valueId":"ring"},{"mushroomId":"Russula_aeruginea","attributeId":"capell","valueId":"convex"},{"mushroomId":"Russula_aeruginea","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Russula_aeruginea","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Russula_aeruginea","attributeId":"color_capell","valueId":"verdMarro"},{"mushroomId":"Russula_aeruginea","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Russula_aeruginea","attributeId":"comestibilitat","valueId":"caution"},{"mushroomId":"Russula_aeruginea","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Russula_aeruginea","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Russula_aeruginea","attributeId":"lamina","valueId":"decurrent"},{"mushroomId":"Russula_aeruginea","attributeId":"vel","valueId":"bare"},{"mushroomId":"Russula_heterophylla","attributeId":"capell","valueId":"convex"},{"mushroomId":"Russula_heterophylla","attributeId":"capell","valueId":"flat"},{"mushroomId":"Russula_heterophylla","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Russula_heterophylla","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Russula_heterophylla","attributeId":"color_capell","valueId":"verdMarro"},{"mushroomId":"Russula_heterophylla","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Russula_heterophylla","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Russula_heterophylla","attributeId":"comestibilitat","valueId":"edible"},{"mushroomId":"Russula_heterophylla","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Russula_heterophylla","attributeId":"lamina","valueId":"adnexed"},{"mushroomId":"Russula_heterophylla","attributeId":"vel","valueId":"bare"},{"mushroomId":"Russula_torulosa","attributeId":"capell","valueId":"convex"},{"mushroomId":"Russula_torulosa","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Russula_torulosa","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Russula_torulosa","attributeId":"comestibilitat","valueId":"poisonous"},{"mushroomId":"Russula_torulosa","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Russula_torulosa","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Russula_torulosa","attributeId":"lamina","valueId":"adnate"},{"mushroomId":"Russula_torulosa","attributeId":"vel","valueId":"bare"},{"mushroomId":"Sarcodon_imbricatus","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Sarcodon_imbricatus","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Sarcodon_imbricatus","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Sarcodon_imbricatus","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Sarcodon_imbricatus","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Sarcodon_imbricatus","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Sarcodon_imbricatus","attributeId":"color_peu","valueId":"gris_fosc"},{"mushroomId":"Sarcoscypha_coccinea","attributeId":"color_capell","valueId":"rosa"},{"mushroomId":"Sarcoscypha_coccinea","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Sarcoscypha_coccinea","attributeId":"color_capell","valueId":"vermell"},{"mushroomId":"Sarcoscypha_coccinea","attributeId":"color_peu","valueId":"rosa"},{"mushroomId":"Sarcoscypha_coccinea","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Sarcoscypha_coccinea","attributeId":"color_peu","valueId":"vermell"},{"mushroomId":"Sureny_fosc","attributeId":"capell","valueId":"convex"},{"mushroomId":"Sureny_fosc","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Sureny_fosc","attributeId":"color_capell","valueId":"marro"},{"mushroomId":"Sureny_fosc","attributeId":"color_peu","valueId":"marro"},{"mushroomId":"Sureny_fosc","attributeId":"color_peu","valueId":"marro_clar"},{"mushroomId":"Sureny_fosc","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Sureny_fosc","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Sureny_fosc","attributeId":"ecologia","valueId":"mycorrhizal"},{"mushroomId":"Sureny_fosc","attributeId":"himeni","valueId":"pores"},{"mushroomId":"Sureny_fosc","attributeId":"vel","valueId":"bare"},{"mushroomId":"Tremella_mesenterica","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Tremella_mesenterica","attributeId":"color_capell","valueId":"taronja"},{"mushroomId":"Tremella_mesenterica","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Tremella_mesenterica","attributeId":"color_peu","valueId":"taronja"},{"mushroomId":"Trompeta_de_la_mort","attributeId":"color_capell","valueId":"gris"},{"mushroomId":"Trompeta_de_la_mort","attributeId":"color_capell","valueId":"gris_fosc"},{"mushroomId":"Trompeta_de_la_mort","attributeId":"color_capell","valueId":"negre"},{"mushroomId":"Trompeta_de_la_mort","attributeId":"color_peu","valueId":"gris"},{"mushroomId":"Trompeta_de_la_mort","attributeId":"color_peu","valueId":"gris_fosc"},{"mushroomId":"Trompeta_de_la_mort","attributeId":"color_peu","valueId":"negre"},{"mushroomId":"Verderol_anisat","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Verderol_anisat","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Verderol_anisat","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Verderol_bolet","attributeId":"color_capell","valueId":"groc"},{"mushroomId":"Verderol_bolet","attributeId":"color_capell","valueId":"marro_clar"},{"mushroomId":"Verderol_bolet","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Verderol_bolet","attributeId":"color_peu","valueId":"groc"},{"mushroomId":"Xampinyo","attributeId":"capell","valueId":"convex"},{"mushroomId":"Xampinyo","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Xampinyo","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Xampinyo","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Xampinyo","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Xampinyo","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Xampinyo","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Xampinyo","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Xampinyo","attributeId":"lamina","valueId":"free"},{"mushroomId":"Xampinyo","attributeId":"vel","valueId":"ring"},{"mushroomId":"Xampinyo_silvestre","attributeId":"capell","valueId":"convex"},{"mushroomId":"Xampinyo_silvestre","attributeId":"capell","valueId":"flat"},{"mushroomId":"Xampinyo_silvestre","attributeId":"color_capell","valueId":"blanc"},{"mushroomId":"Xampinyo_silvestre","attributeId":"color_capell","valueId":"gris_clar"},{"mushroomId":"Xampinyo_silvestre","attributeId":"color_peu","valueId":"blanc"},{"mushroomId":"Xampinyo_silvestre","attributeId":"color_peu","valueId":"gris_clar"},{"mushroomId":"Xampinyo_silvestre","attributeId":"comestibilitat","valueId":"choice"},{"mushroomId":"Xampinyo_silvestre","attributeId":"ecologia","valueId":"saprotrophic"},{"mushroomId":"Xampinyo_silvestre","attributeId":"himeni","valueId":"gills"},{"mushroomId":"Xampinyo_silvestre","attributeId":"lamina","valueId":"free"},{"mushroomId":"Xampinyo_silvestre","attributeId":"vel","valueId":"ring"}];
