'use strict';
var content = document.getElementById('photo-frame');
var page = 1;

function getImg(cont) 
{
  var x = cont.indexOf("<img");
  if(x == -1) return "";

  var y = cont.indexOf("/>", x);
  if(y == -1) y = cont.length;

  return cont.slice(x, y+2);
} 

function getContent(resp) 
{
  var test = resp.toLowerCase();    // to eliminate case sensitivity
  var x = test.indexOf("<div class=\"photo post");
  if(x == -1) return "";

  x = test.indexOf(">", x);
  if(x == -1) return "";

  var y = test.indexOf("</div>", x);
  if(y == -1) y = resp.length;    // If no HTML then just grab everything till end

  var final = getImg(resp.slice(x + 1, y));
  return final;
} 

function load()
{
   var xhr = new XMLHttpRequest({
   mozSystem: true
  });
    
  xhr.onreadystatechange = function () {
    try {
    if (xhr.readyState === 4) {
      content.innerHTML = getContent(xhr.responseText);      
    }
    } catch (e) {
      console.log(e.description);
    }
  };

  var url = 'http://www.bonjourmadame.fr/page/'+page;
  xhr.open('GET', url);
  xhr.send(null);
}

function reload(event) 
{
  event.preventDefault();
  load();
}

function previous(event)
{
  event.preventDefault();
  page++;
  load();
}

function next(event)
{
  event.preventDefault();  
  if (page!=1) {
  page--;
  }
  load();
}

function home(event)
{
  event.preventDefault();
  page = 1;
  load();
}

function random(event)
{
  event.preventDefault();
  page = Math.random() * (1001 - 1) + 1;
  load();
}

window.onload = load();

document.getElementById('previous-a').addEventListener('click', previous, true);
document.getElementById('next-a').addEventListener('click', next, true);
document.getElementById('reload-a').addEventListener('click', reload, true);
document.getElementById('today-a').addEventListener('click', home, true);
document.getElementById('random-a').addEventListener('click', random, true);

