var note = {
    init: function(){

        //loading first
        note.loadingNote();

        $('.contentTask').append("<ul class='list'>"); 

        $('.editContent').jqte();
    
        // settings of status
        var jqteStatus = true;
        $(".status").click(function()
        {
            jqteStatus = jqteStatus ? false : true;
            $('.editContent').jqte({"status" : jqteStatus})
        });

        note.getQuantity('.contentTask');   

        $('.formTask .update').hide();

    },

    loadingNote: function(){
        $('article').hide();

        setTimeout(function(){
            $('.loading-note').hide();
            $('article').slideUp(100).delay(100).fadeIn(400);
        },1400);  

    },

    //get Date and Hour
    getDateNote: function (){

        //get year
        var dateString = "";
        var newDate    = new Date();
            dateString += (newDate.getMonth() + 1) + "/";
            dateString += newDate.getDate() + "/";
            dateString += newDate.getFullYear();

        //get your
        var hour   = newDate.getHours(),
            minute = newDate.getMinutes(),
            second = newDate.getSeconds();
            
            hourPublication = hour + ":" + minute + ":" + second;
            datePublication = dateString;
    },

    //Get - quantidade armazenada
    getQuantity: function(quantity){   
            var qty = $(quantity + ' li[rel]').length;

            $(quantity).children('h2').find('span').remove();
            $(quantity).children('h2').append("<span>("+qty+")</span>");
    },

    //Get - lista armazenada
    getStorageList: function(){

        var getNote = localStorage.length;


        for(var i = 0; i < getNote; i++){

            var str = localStorage.key(i);
                obj = localStorage.getItem(str);
                obj = JSON.parse(obj);
            //console.log(jQuery.isPlainObject() + " - " +obj);

            var setHtml = "<li rel='item' data-item='"+obj.valIndex+"' class='"+obj.valTitle+"'><h3>"+obj.valTitle+"</h3>Posted on: <span class='hour'>"+obj.valHour+"</span> - <span class='date'>"+ obj.valDate +"</span><div class='contentHtml'>"+obj.valEdit+"</div><div class='note-tools'><a class='edit-item' rel='"+obj.valIndex+"note"+"' href='javascript:;' title='Edit Item'>Edit Item</a><a class='remove-item' rel='"+obj.valIndex+"' href='javascript:;' title='Remove Item'>Remove Item</a></div></li>";
            var arr = $.makeArray(setHtml);

            //console.log(arr.reverse());

            $('.contentTask ul.list').prepend(arr.reverse());
        }
        note.getQuantity('.contentTask');
    },

    //Controle de registro
    controlRegistration: function(){


        $('.add').click(function(){
            
            var validateTitle = $('.editTitle').val(),
                validateEditor = $('.jqte_editor').html();


            if(validateTitle == '' || validateEditor == ''){
                alert('Please fill out the field...');
            }else{
                note.getDateNote();

                var index = $('.contentTask ul.list li').length;
                var setItemValue = {};
                    setItemValue.valIndex = index;
                    setItemValue.valTitle = $('.editTitle').val();
                    setItemValue.valEdit  = $('.jqte_editor').html();
                    setItemValue.valHour  = hourPublication;
                    setItemValue.valDate  = datePublication;
                
                var setItemIndex = setItemValue.valIndex + "note";

                var htmlNote = "<li rel='item' data-item='"+setItemValue.valIndex+"' class='"+setItemValue.valIndex+"'><h2>"+setItemValue.valTitle+"</h2>Posted on: <span class='hour'>"+setItemValue.valHour+"</span> - <span class='date'>"+ setItemValue.valDate +"</span><div class='contentHtml'>"+setItemValue.valEdit+"</div><div class='note-tools'><a class='edit-item' rel='"+setItemValue.valIndex+"note"+"' href='javascript:;' title='Edit Item'>Edit Item</a><a class='remove-item' rel='"+setItemValue.valIndex+"' href='javascript:;' title='Remove Item'>Remove Item</a></div></li>";
                $('.contentTask ul.list').prepend(htmlNote);

                try {
                    localStorage.setItem(setItemIndex, JSON.stringify(setItemValue));
                    window.location = window.location;

                    console.log('Quota not exceeded!');
                } catch (e) {
                  if (e == QUOTA_EXCEEDED_ERR) {
                    console.log('Quota exceeded!');
                  }
                }

                note.getQuantity('.contentTask');
            }

        });

    },

    /* Remove Item */
    removeItemClick: function(){

        $('.remove-item').click(function(){
            var item = $(this).siblings('.edit-item').attr('rel');
            localStorage.removeItem(item);     
            $(this).parent().remove();

            window.location = window.location;
            note.getQuantity('.contentTask');   
                  
        });    
    },

    editItem: function(){
        //Click - Edit item 
        $('.edit-item').click(function(){

            $('.formTask .add').hide();
            $('.formTask .update').show();
            
            keyRel  = $(this).attr('rel');

            editKey = localStorage.key(keyRel),
            getEdit = localStorage.getItem(keyRel),
            objEdit = JSON.parse(getEdit);

            $('.formTask .editTitle').val(objEdit.valTitle);
            $('.formTask .jqte_editor').empty().append(objEdit.valEdit);

            $('.formTask .editTitle').attr('date-index',objEdit.valIndex);
            $('.formTask .jqte_editor').attr('date-hour',objEdit.valHour);
            $('.formTask .jqte_editor').attr('date-date',objEdit.valDate);
        });

        //Update local storage
        $('.update').click(function(){
                //history of storage
                var updateIndex = parseInt($('.formTask .editTitle').attr('date-index')),
                    updateHour  = $('.formTask .jqte_editor').attr('date-hour'),
                    updateDate  = $('.formTask .jqte_editor').attr('date-date'); 


                var editSetItemValue = {};
                    editSetItemValue.valIndex = updateIndex;
                    editSetItemValue.valTitle = $('.editTitle').val();
                    editSetItemValue.valEdit  = $('.jqte_editor').html();
                    editSetItemValue.valHour  = updateHour;
                    editSetItemValue.valDate  = updateDate;

                localStorage.setItem(keyRel, JSON.stringify(editSetItemValue));
                window.location = window.location;

        });


    }
};

$(document).ready(function() {   
    note.init();
    note.getStorageList();
    note.controlRegistration();
    note.removeItemClick();
    note.editItem();
});