
function hideImages(pList, pResult) {
	if(pList) {
		for (var i=0; i < pList.length; i++) {
			pList[i].visible = pResult;
        }
    }
}

function deleteImages(pList) {
    if(pList) {
        for (var i=0; i< pList.length; i++) {
            if(pList[i]) {
                pList[i].destroy();
                // console.log("Destroyed ", i);
            }
        }
    }
}



function createOptionScreen(list) {
    setScreenScale();
    if(list != undefined) {
        hideImages(list, false);    
    }
    
    var bg = Crafty.e("2D, Canvas, BG2, Mouse");
    bg.x = Crafty.viewport.width/2-320/2; bg.y = Crafty.viewport.height/2-480/2;

    var stageTab = Crafty.e("2D, Canvas, Image").image("images/options/options_tab.png");
    stageTab.x = bg._x+29; stageTab.y = bg._y+50;

    var optionsTab = Crafty.e("2D, Canvas, Image").image("images/options/optionsH.png");
    optionsTab.x = bg._x+100; optionsTab.y = bg._y+80;

    var soundTab = Crafty.e("2D, Canvas, Image").image("images/options/soundH.png");
    soundTab.x = bg._x+110; soundTab.y = bg._y+150;

    
    var onBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/options/on_btn.png");
    onBtn.x = bg._x+75; onBtn.y = bg._y+190;
    onBtn.originX = onBtn._x;

    var offBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/options/off_btn.png");
    offBtn.x = bg._x+75; offBtn.y = bg._y+190;
    offBtn.originX = offBtn._x;


    bg.bind("MouseDown", function(e) {
        console.log("help bg mouse down ")
        return true;
    })

    if(getAudioIsMuted()) {
        offBtn.visible = true;
        onBtn.visible = false;
        onBtn.x = -1000;
    }
	else {
        offBtn.visible = false;
        onBtn.visible = true;
        offBtn.x = -1000;
    }

    offBtn.bind("MouseDown", function(e) {
        console.log("off btn clicked");
        setAudioIsMuted(false)
        onBtn.visible = true;
        offBtn.visible = false;
        offBtn.x = -1000;
        onBtn.x = onBtn.originX
    });

    onBtn.bind("MouseDown", function(e) {
        console.log("on btn clicked");
        setAudioIsMuted(true)
        offBtn.visible = true;
        onBtn.visible = false;
        offBtn.x = offBtn.originX
        onBtn.x = -1000;
    });


    var backBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/back.png");
    backBtn.x = bg.x+190; backBtn.y = bg._y+410;

    backBtn.bind("MouseDown", function(e) { 
        this.unbind('MouseDown', this.backBtn);
        deleteImages([bg, stageTab,optionsTab, soundTab, onBtn, offBtn, backBtn])
     
    });

}


