function Pi(){
	this.images=new Array();
	this.imageCounter=-1;
	
	this.y=0;
	this.currentYAccel=0;
	this.currentYOffset=0;
	
	this.x=0;
	
	this.view=null;
	this.injump=false;
	
	this.repaint=function(){
		if(this.injump){
			this.currentYAccel=this.currentYAccel+this.view.gravity;
			this.currentYOffset=this.currentYOffset+this.currentYAccel;
			
			if(this.currentYOffset>0){
				this.currentYOffset=0;
				this.currentYAccel=0;
				this.injump=false;
			}
			
			if(this.view.debug){
				this.view.context.fillText(this.currentYAccel+"/"+this.currentYOffset,10,10);
			}			
			this.view.context.drawImage(this.getImage(),this.x,this.y+this.currentYOffset);
		}
		else{
			this.view.context.drawImage(this.getImage(),this.x,this.y);
		}
	};
	
	this.getImage=function(){
		this.imageCounter++;
		if(this.imageCounter>=this.images.length){
			this.imageCounter=0;
		}
		return this.images[this.imageCounter];
	};
}

function Forground(){
	this.images=new Array();
	this.imageCounter=-1;
	
	this.y=0;
	
	this.view=null;
	
	this.repaint=function(){
		this.view.context.drawImage(this.getImage(),0,this.view.pi.y+20,this.view.width,this.view.height);
	};
	
	this.getImage=function(){
		this.imageCounter++;
		if(this.imageCounter>=this.images.length){
			this.imageCounter=0;
		}
		return this.images[this.imageCounter];
	};
}

function SimpleSprite(){
	this.x=0;
	this.y=0;
	
	this.xOffset=0;
	
	this.images=new Array();
	this.imageCounter=-1;
	
	this.stopped=false;
	
	this.view=null;
	
	this.addImage=function(img){
		this.images[this.images.length]=img;
	};
	
	this.getImage=function(){
		this.imageCounter++;
		if(this.imageCounter>=this.images.length){
			this.stopped=true;
		}
		
		if(this.stopped){
			return this.images[this.images.length-1];
		}
		else{
			return this.images[this.imageCounter];
		}		
	};
	
	this.repaint=function(){
		this.view.context.drawImage(this.getImage(),this.x+this.xOffset,this.y);
	};
}

function Boo(){
	this.images=new Array();
	this.x=0;
	this.y=0;
	this.yOffset=0;
	this.width=120;
	
	this.bounceCounter=0;
	
	this.deathOnCrash=false;
	
	this.view=null;
	
	this.imageCounter=0;
	
	this.getImage=function (){
		this.imageCounter++;
		if(this.imageCounter>=this.images.length){
			this.imageCounter=0;
		}
		return this.images[this.imageCounter];
	}
	
	this.repaint=function(){
		var dif=0;
		if(this.bounceCounter>0 && this.bounceCounter%2==0){
			dif=10;
			this.bounceCounter--;
		}
		this.view.context.drawImage(this.getImage(),this.x,this.y+dif+this.yOffset);
	};
}

function View(){
	this.width=0;
	this.height=0;
	
	this.canvasId="";
	this.context=null;
	
	this.gravity=2;
	this.jumpStartAccel=-25;
	this.booVelocity=18;
	
	this.score=0;
	
	this.minDistanceSteps=30;
	this.stepsSinceLastBoo=0;
	
	this.boos=new Array();
	this.booStartHeightAberration=15;
	
	this.spritesArr=new Array();
	
	this.foreground=null;
	this.backgroundImageId=""; //remove in next version
	
	this.backgroundImages=new Array();
	
	this.pi=null;
	
	this.varName="view";
	this.debug=true;
	
	this.stop=true;
	this.bgImage=null;
	this.fgImage=null;
	
	this.bounceSprite=null;
	
	this.nonDeathBooSprites=new Array();
	this.deathBooSprites=new Array();
	
	this.scaleBackground=true;
	
	this.backgroundScoreRatio=0;
	this.useSplash=true;
	
	this.init=function(){
		this.context=document.getElementById(this.canvasId).getContext("2d");
		this.context.canvas.width=this.width;
		this.context.canvas.height=this.height;
		
		this.context.font = "bold 25px Arial";
		
		if(this.backgroundImages.length>0){
			this.bgImage=this.backgroundImages[randomNumber(0,this.backgroundImages.length)];
		}
	}
	
	this.restart=function(){
		this.boos=new Array();
		this.spritesArr=new Array();
		
		this.pi.currentYAccel=0;
		this.pi.injump=false;
		this.pi.currentYOffset=0;
		
		this.score=0;
		
		if(this.backgroundImages.length>0){
			this.bgImage=this.backgroundImages[randomNumber(0,this.backgroundImages.length)];
		}
		
		this.start();
	}
	
	this.action=function(){
		if(this.pi.currentYOffset==0 && !this.stop){
			this.pi.currentYAccel=this.jumpStartAccel;
			this.pi.injump=true;
		}
	};
	
	this.start=function(){
		this.stop=false;
		this.makeStep();
	};
	
	this.gameover=function() {
		this.stop=true;
		document.getElementById("gameover").style.display="block";
		if(document.getElementById("finalScore")){
			this.setInnerText(document.getElementById("finalScore"),this.score+" Points");
		}
	};
	
	this.viewBGImageInDialog=function(){
		this.stop=true;
		document.getElementById("viewimage").style.display="block";
		if(document.getElementById("levelimage")){
			document.getElementById("levelimage").src=this.bgImage.src;
		}
	};
	
	this.removeAllChildrenFromElement=function(element){			
		while(element.childNodes.length>0){
			element.removeChild(element.firstChild);
		}
	};
				
	this.setInnerText=function(element,text){
		this.removeAllChildrenFromElement(element);
		element.appendChild(document.createTextNode(text));
	};
	
	this.printScore=function(){
		this.context.fillStyle="#FFFFFF";
		//font style .. see init
		this.context.fillText("Score: "+this.score,5,25);
		this.context.strokeText("Score: "+this.score,5,25);
	}
	
	this.makeStep=function(){
		var start=new Date().getTime();
		this.context.clearRect(0,0,this.width,this.height);
		
		//draw background
		if(this.bgImage!=null){
			if(this.scaleBackground){
				this.context.drawImage(this.bgImage,0,0,this.width,this.height);
			}
			else{
				this.context.drawImage(this.bgImage,0,0);
			}	
		
			//draw black to hidde part of background
			if(this.backgroundScoreRatio>0){
				var offsetH=Math.round(this.backgroundScoreRatio*this.score);
				if(offsetH>this.height-20){
					this.viewBGImageInDialog();
				}
				else{
					this.context.beginPath();
					this.context.fillStyle="#000000";
					this.context.rect(0,offsetH,this.width,this.height-offsetH);
					this.context.fill();
					this.context.stroke();
					if(this.debug){
						this.context.fillStyle="#FFFFFF";
						this.context.fillText("black-bg: "+offsetH,20,200);
					}
				}
			}
		}
		
		var sLength=this.spritesArr.length;
		for(var i=0;i<sLength;i++){
			var sprite=this.spritesArr[i];
			sprite.x=sprite.x-this.booVelocity;
			sprite.repaint();
		}
		
		this.pi.repaint();
		
		this.createBoo();
		
		var bLength=this.boos.length;
		for(var i=0;i<bLength;i++){
			var boo=this.boos[i];
			boo.x=boo.x-this.booVelocity;
			boo.repaint();
			if(this.debug){
				this.context.fillText("pos("+i+"): "+boo.x+"/"+boo.y,10,30+(i*10));
			}
		}
		if(this.debug){
			this.context.fillText("boos: "+this.boos.length+", sprites: "+this.spritesArr.length,10,20);
		}		
		
		if(this.fgImage!=null){
			this.context.drawImage(this.fgImage,0,this.pi.y+20,this.width,this.height);
		}
		else{
			this.context.rect(0,this.pi.y+20,this.width,this.height);
			this.context.fillStyle="#0000FF";
			this.context.fill();
		}		
		this.checkCollision();
		this.printScore();
		
		var dif=(new Date().getTime())-start;
		
		if(!this.stop){
			window.setTimeout(this.varName+".makeStep()",170-dif);
		}	
		else{
			this.context.clearRect(0,0,this.width,this.height);
		}
	};
	
	this.createBoo=function(){
		if(this.stepsSinceLastBoo>this.minDistanceSteps){		
			var boo=new Boo();
			boo.x=this.width;
			var dyn=0;
			if(this.booStartHeightAberration>0){
				dyn=randomNumber(this.booStartHeightAberration*-1,this.booStartHeightAberration); //default: 15
			} 
			boo.y=this.pi.y-(boo.width/2);
			boo.yOffset=20+dyn;
			
			//from pre defined boo-styles in two array (death and non-death array)
			if(randomNumber(1,9)%3==0){
				boo.images=this.deathBooSprites[randomNumber(0,this.deathBooSprites.length)].images;
				boo.deathOnCrash=true;
			}
			else{				
				boo.images=this.nonDeathBooSprites[randomNumber(0,this.nonDeathBooSprites.length)].images;
				boo.deathOnCrash=false;
			}
			
			boo.view=this;
			
			this.boos[this.boos.length]=boo;
		
			this.stepsSinceLastBoo=0;
			
			this.minDistanceSteps=randomNumber(20,30)-Math.round(this.score/4);
		}
		else{
			this.stepsSinceLastBoo++;
		}
	};
	
	this.checkCollision=function(){
		var spritesSur=new Array();
		var sLength=this.spritesArr.length;
		for(var i=0;i<sLength;i++){
			var sprite=this.spritesArr[i];
			if(!sprite.stopped){
				spritesSur[spritesSur.length]=sprite;
			}
		}
		this.spritesArr=spritesSur;		
		
		var survivors=new Array();
		var bLength=this.boos.length;
		for(var i=0;i<bLength;i++){
			var boo=this.boos[i];
			if(boo.x+boo.width<0){
				this.score++;
			}
			else{
				survivors[survivors.length]=boo;
			}
		}
		this.boos=survivors;
		
		bLength=this.boos.length;
		for(var i=0;i<bLength;i++){
			var boo=this.boos[i];
			var rad=boo.width/2;
			var xd=Math.abs((boo.x+rad)-(this.pi.x+35));
			var yd=Math.abs((boo.y+rad)-(this.pi.y+this.pi.currentYOffset+20));	//pi y offset		
			
			if(this.debug){
				this.context.beginPath();
				this.context.moveTo(boo.x+rad,boo.y+rad);
				this.context.lineTo(this.pi.x+35,this.pi.y+this.pi.currentYOffset+20);
				this.context.stroke();
				this.context.fillText("dist("+i+"): "+xd+"["+(boo.x+rad)+"/"+(this.pi.x+35)+"]/"+yd+" ["+(boo.y+rad)+"/"+(this.pi.y+20)+"]",80,10+(i*10));
			}
			
			if(xd<=rad && yd<=rad){
				if(boo.deathOnCrash || yd<30){
					this.gameover();
				}
				else{
					this.pi.currentYAccel=this.jumpStartAccel+5;
					this.pi.injump=true;
					
					boo.bounceCounter=6;
					this.score=this.score+5;
					
					if(this.useSplash && this.bounceSprite!=null && this.bounceSprite.images.length>0){
						var sprite=new SimpleSprite();
						sprite.images=this.bounceSprite.images;
						sprite.xOffset=this.bounceSprite.xOffset;
						sprite.x=boo.x;
						sprite.y=boo.y-70; //100=sprite height
						sprite.view=this;
						
						this.spritesArr[this.spritesArr.length]=sprite;
					}					
				}
			}			
		}
	};
}

function randomNumber(from, till){
	return Math.floor((Math.random() * till) + from);
}