var vivoStoreVersion = "1.3";
var vivoCategories   = [];
var vivoAppList      = [442892];
var vivoAppLoaded    = [];

var vivoOpenApp = function (urlDownload, nmSlug, isButton)
{
	eventName = 'BRAPPS_INSTALL';
	if (isButton)
		eventName = 'BRAPPS_INSTALL_BUTTON';
	vivoLogEvent(eventName,{'slug':nmSlug});
	window.open(urlDownload, "downloadApp", "scrollbars,status");
};

var vivoLogEvent = function ()
{
	if (typeof(FlurryAgent) != "undefined")
	{
		if (arguments.length > 1)
			FlurryAgent.logEvent(arguments[0], arguments[1]);
		else
			FlurryAgent.logEvent(arguments[0]);
	}
};


if (typeof(FlurryAgent) != "undefined")
	FlurryAgent.setAppVersion(vivoStoreVersion);

(function () {

var vivoBRApps = function ()
{
	var xhr = new XMLHttpRequest({ mozSystem: true });
	    xhr.open("GET", "https://www.vivo.com.br/portalweb/ShowPropertyServlet?nodeId=/UCMRepository/BRAPPS", true);
	    xhr.responseType="json";
	    xhr.send();
	    xhr.onload = function()
	    {
	    	if (xhr.status == 200)
	    	{
	    		vivoAppList = xhr.response.apps;
		    	marketplaceCategories();
	    	}
	    };

}


	var vivoMakeItem = function (urlDownload, urlImage, nmApp, nmDeveloper, nmSlug)
	{
		return '<li><aside class="pack-end">' + 
	           '<img src="images/install.png" alt="Instalar ' + nmApp + '" class="btn-download" data-url-download="' + urlDownload + '" data-slug="' + nmSlug + '"/>' + 
		  	   '</aside><aside>' + 
			   '<img src="' + urlImage + '" alt="photo">' + 
			   '</aside>' + 
			   '<p class="btn-download-detail" data-url-download="' + urlDownload + '" data-slug="' + nmSlug + '">' + nmApp + '</p>' + 
	      	   '<p class="btn-download-detail" data-url-download="' + urlDownload + '" data-slug="' + nmSlug + '">' + nmDeveloper + '</p></li>';

	};

	var vivoMakeList = function (idCategory, nmCategory, arrApps)
	{
		strList  = "";

		for (var i in arrApps)
		{
			var app  = arrApps[i];
			strList += vivoMakeItem(app.url,app.icons["64"],app.name,app.author, app.slug);
		}

		return '<header><h2 class="btn-category" data-category="' +  idCategory + '">' + nmCategory + '<img id="seta' +  idCategory + '" src="images/seta.png" alt="Expandir"/></h2></header><section id="categorylist' + idCategory + '" data-type="list" class="fechado"><ul>' + strList + '</ul></section>';
	};


	var vivoMake = function ()
	{
		var strContent = "";
		for (var slug in vivoCategories)
		{
			var category = vivoCategories[slug];
			if (category.apps.length > 0)
				strContent += vivoMakeList(category.id, category.name, category.apps);
		}
	   	strContent += "<br/><br/><br/>";
		vivoAppLoaded = [];
		document.querySelector("#appContent").innerHTML = strContent;

		var btnCategory = document.querySelectorAll(".btn-category");
		var btnDownload = document.querySelectorAll(".btn-download");
		var btnDownloadDetail = document.querySelectorAll(".btn-download-detail");

		for(var x=0; x<btnDownload.length; x++)
			btnDownload[x].addEventListener("click", function(e) 
			{
				vivoOpenApp(e.target.getAttribute('data-url-download'), e.target.getAttribute('data-slug'), false);
			});

		for(var x=0; x<btnDownloadDetail.length; x++)
			btnDownloadDetail[x].addEventListener("click", function(e) 
			{
				vivoOpenApp(e.target.getAttribute('data-url-download'), e.target.getAttribute('data-slug'), true);
			});


		for(var x=0; x<btnCategory.length; x++)
			btnCategory[x].addEventListener("click", function(e) 
			{

				var categoryId = e.target.getAttribute("data-category");

				var el  = document.querySelector("#categorylist" + categoryId);
				var img = document.querySelector("#seta" + categoryId);

				if (el.className == "fechado")
				{
					el.className = "aberto";
					img.style.transform = "rotate(90deg)";
				}
				else
				{
					el.className = "fechado";
					img.style.transform = "";
				}

			});

		vivoLogEvent("BRAPPS_LOADED_SUCCESSFULLY");
	};

	var marketplaceLoadApps = function ()
	{
		var appId = vivoAppList.pop();

		var xhr = new XMLHttpRequest({ mozSystem: true });
		    xhr.open("GET", "https://marketplace.firefox.com/api/v1/apps/app/" + appId + "/?lang=pt-BR");
		    xhr.responseType="json";
		    xhr.send();
		    xhr.onload = function()
		    {
		    	if (xhr.status == 200)
		    	{
		    		vivoAppLoaded.push(xhr.response);
		    		if (vivoAppList.length > 0)
			    		marketplaceLoadApps();
			    	else
					    marketplaceApplications();
		    	}
		    };

	};

	var marketplaceApplicationsCount = 0;
	var marketplaceApplications = function ()
	{
		for (var i in vivoAppLoaded)
		{
			var app = vivoAppLoaded[i];
			for (var x in app.categories)
			{
				var ac = app.categories[x];
				var cc = vivoCategories[ac];
				if (vivoCategories[ac])
					vivoCategories[ac].apps.push({id:app.id,
												  name:app.name, 
												  author:app.author,
												  icons:app.icons,
												  slug:app.slug,
												  url:"https://marketplace.firefox.com/app/" + app.slug + "/?src=br-apps",
												  resource_uri:"https://marketplace.firefox.com/" + app.resource_uri,
												  ratings:app.ratings});
			}
		}

		vivoMake();
		setTimeout("vivoLogEvent('BRAPPS_RELOAD');marketplaceApplications()", 3600000);

    };

	var marketplaceCategoriesCount = 0;
	var marketplaceCategories = function ()
	{
		var xhr = new XMLHttpRequest({ mozSystem: true });
		    xhr.open("GET", "https://marketplace.firefox.com/api/v1/apps/category/?lang=pt-BR");
		    xhr.responseType="json";
		    xhr.send();
		    xhr.onload = function()
		    {
		    	if (xhr.status == 200)
		    	{
		    		marketplaceCategoriesCount = 0;
		    		for (var i in xhr.response.objects)
		    		{
		    			var e = xhr.response.objects[i];
		    			vivoCategories[e.slug] = {id:e.id, name:e.name, resource_uri:e.resource_uri, apps:[]};
		    		}
				    marketplaceLoadApps();
		    	}
		    	else
		    	{
			    	if (marketplaceCategoriesCount < 3)
			    	{
			    		vivoLogEvent("MOZILLA_API_CATEGORY_RETRY",{'retry':marketplaceCategoriesCount});
			    		marketplaceCategoriesCount++;
			    		setTimeout("marketplaceCategories()",1000);
			    	}
			    	else
			    	{
			    		vivoLogEvent("MOZILLA_API_CATEGORY_FAILED");
			    		alert("Erro ao tentar carregar o BR Apps.\nFeche o aplicativo e tente novamente.")
			    	}
		    	}
		    };

		    xhr.onerror = function ()
		    {
		    	if (marketplaceCategoriesCount < 3)
		    	{
		    		vivoLogEvent("MOZILLA_API_CATEGORY_RETRY",{'retry':marketplaceCategoriesCount});
		    		marketplaceCategoriesCount++;
		    		setTimeout("marketplaceCategories()",1000);
		    	}
		    	else
		    	{
		    		vivoLogEvent("MOZILLA_API_CATEGORY_FAILED");
		    		alert("Erro ao tentar carregar o BR Apps.\nFeche o aplicativo e tente novamente.")
		    	}
		    }

	};

	document.querySelector("#vivoReload").addEventListener('click', function (e)
	{
		document.querySelector("#appContent").innerHTML = '<div class="carregando"><progress></progress><h2>Aguarde, carregando ...</h2></div>';
		vivoBRApps();
		vivoLogEvent("BRAPPS_RELOAD");
	});
	vivoBRApps();
})(); 