var Application = {
    deviceOnline : false,
    onDeviceReady : function() {
        $('#b_play').click(function() {
            Player.playPause();
        });
        $('#b_stop').click(function() {
            Player.stop();
        });
        $('.fb-link').click(function() {
            Application.openUrl($('.fb-link').attr("rel"));
        });
        $('.tw-link').click(function() {
            Application.openUrl($('.tw-link').attr("rel"));
        });
        $('.logo-link').click(function() {
            Application.openUrl($('.logo-link').attr("rel"));
        });
        var connCheck = setInterval(function() {
            //Application.checkConection();
        }, 1000);
        document.addEventListener("deviceready", function() {
            document.addEventListener("pause", function() {}, false);
            document.addEventListener("online", 
        		//Application.checkConection(),
    		false);
            document.addEventListener("offline", 
        		//Application.checkConection(), 
    		false);
        }, false);
    },
    openUrl : function(url) {
        navigator.app.loadUrl(url, {
            openExternal : true
        });
    },
    checkConection : function() {
        var objConnection = navigator.network.connection;
        var connectionInfo = Application.getTypeConextion(objConnection.type);
        var statusConexao = connectionInfo.message;
        $('#statusConexao').html("Conex�o: " + statusConexao);
        Application.deviceOnline = false;
        if (connectionInfo.value != 0) {
            Application.deviceOnline = true;
        }
    },
    getTypeConextion : function(type) {
        var connTypes = {};
        connTypes[Connection.NONE] = {
            message : 'Nenhuma',
            value : 0
        };
        connTypes[Connection.UNKNOWN] = {
            message : 'Desconhecida',
            value : 1
        };
        connTypes[Connection.ETHERNET] = {
            message : 'Ethernet',
            value : 2
        };
        connTypes[Connection.CELL_2G] = {
            message : '2G',
            value : 3
        };
        connTypes[Connection.CELL_3G] = {
            message : '3G',
            value : 4
        };
        connTypes[Connection.CELL_4G] = {
            message : '3G+',
            value : 5
        };
        connTypes[Connection.WIFI] = {
            message : 'WiFi',
            value : 6
        };
        return connTypes[type];
    }
};