var Player = {
    // Gazeta FM
    path : "http://servidor6.crossdigital.com.br:8042/;stream/1",
    media : null,
    mediaTimer : null,
    isPlaying : false,
    initMedia : function() {
        Player.media = new Media(Player.path, function() {
            console.log('Media foi lida com sucesso');
            if (Player.media !== null) {
                Player.media.release();
            }
        }, function(error) {
            /*navigator.notification.alert(
            'Nao foi possivel ler esse tipo de media.', function() {
            }, 'Error');*/
            Button.stopAction();
            console.log('N�o foi possivel ler este aquivo (Code): ' + error.code);
        }, function(status) {
            if (status == '1') { // Status 1: Carregando.
            	Player.statusCarregando();
            } else if (status == '2') { // Status 1: Reproduzindo.
                Player.statusReproduzindo();
            } else if (status == '3') { // Status 3: Pausado.
            } else if (status == '4') { // Status 2: Parado.
                Player.stop();
            }
        });
    },
    playPause : function() {
        if (Application.deviceOnline === false) {
            navigator.notification.alert(
                'Sem conex�o de internet. Favor verificar o seu dispositivo.',
                function() {
                }, 'Aten��o:', 'Ok');
            Player.stop();
            return;
        }
        if (Player.media === null) {
            Player.initMedia();
        }

        if (Player.isPlaying === false) {
            Player.media.play();
            
            Button.playAction();
        } else {
            Player.media.pause();
            clearInterval(Player.mediaTimer);
            Button.stopAction();
        }
        Player.isPlaying = !Player.isPlaying;
    },
    stop : function() {
        if (Player.media !== null) {
            Player.media.stop();
            Player.media.release();
        }
        clearInterval(Player.mediaTimer);
        Player.media = null;
        Player.isPlaying = false;
        Button.stopAction();
        $('#media-played').text(Utility.formatTime(0));
    },
    statusCarregando : function() {
    	$('#media-played').text('Carregando... ');
    },
    statusReproduzindo : function() {
    	Player.mediaTimer = setInterval(function() {
            Player.media.getCurrentPosition(function(position) {
                if (position > -1) {
                    $('#media-played').text(Utility.formatTime(position));
                    Player.updateSliderPosition(position);
                }
            }, function(error) {
                console.log('Erro ao obter a posi��o: ' + error.code);
                $('#media-played').text(Utility.formatTime(0));
            });
        }, 1000);
    },
    
};

var Button = {
    playAction : function() {
        $('#b_play').hide();
        $('#b_stop').show();
        $('#carregando').hide();
    },
    stopAction : function() {
        $('#b_play').show();
        $('#b_stop').hide();
        $('#carregando').hide();
    },
    carregandoAction : function() {
        $('#b_play').hide();
        $('#b_stop').hide();
        $('#carregando').show();
    }
};
