'use strict';

function element(id) {
  return document.getElementById(id);
}

var Player = {
    path : "http://servidor6.crossdigital.com.br:8042/;stream/1",
    //path : "http://jennyfm.eu:5500/jennyfm.ogg",
    media : null,
    mediaTimer : null,
    isPlaying : false,
    initMedia : function () {
    	//Player.media = new Audio();
    	//Player.media.src = Player.path;
        Player.media = element("media_audio");
    	
    	//Player.media.preload             = "none";
        Player.media.autoplay            = false;
        Player.media.controls            = false;
        Player.media.mozAudioChannelType = 'content';
        
        Player.media.load();
        Player.media.play();
        
        Player.media.addEventListener("canplay", function() {
            Button.playAction();
            Player.statusReproduzindo();
            Player.isPlaying = true;
        });
        Player.media.addEventListener("error", function() {
            Button.stopAction();
            Player.stop();
            alert("Ops, tivemos um problema, tente mais tarde! (audio)");
        });
        element("media_source").addEventListener("error", function() {
            Button.stopAction();
            Player.stop();
            alert("Ops, tivemos um problema, tente mais tarde! (source)");
        });
        Player.media.addEventListener("loadstart", function() {
        	Button.carregandoAction();
        });
        Player.media.addEventListener("waiting", function() {
        	Button.carregandoAction();
        });
        
    },
    
    playPause : function() {
        Button.carregandoAction();
        Player.initMedia();
    },
    stop : function() {
        if (Player.media !== null) {
            Player.media.pause();
        }
        clearInterval(Player.mediaTimer);
        Player.media = null;
        Player.isPlaying = false;
        Button.stopAction();
        $('#media-played').text(Utility.formatTime(0));
    },
    statusCarregando : function() {
        $('#media-played').text('Carregando... ');
    },
    statusReproduzindo : function() {
        Player.mediaTimer = setInterval(function() {
            if (Player.media.currentTime > -1) {
                $('#media-played').text(Utility.formatTime(Player.media.currentTime));
            } else {
                console.log('Erro ao obter a posi��o: ' + error.code);
                $('#media-played').text(Utility.formatTime(0));
            };
        }, 1000);
    },
    
};

var Button = {
    playAction : function() {
        $('#b_play').hide();
        $('#b_stop').show();
        $('#media-played').show();
        $('#conectando').hide();
        $('#carregando').hide();
    },
    stopAction : function() {
        $('#b_play').show();
        $('#b_stop').hide();
        $('#media-played').show();
        $('#conectando').hide();
        $('#carregando').hide();
    },
    carregandoAction : function() {
        $('#b_play').hide();
        $('#b_stop').hide();
        $('#media-played').hide();
        $('#conectando').show();
        $('#carregando').show();
    }
};
