var tokens = {
	succ:		'増',
	pred:		'減',
	forward:	'進',
	backward:	'退',
	output:		'書',
	input:		'読',
	begin:		'始',
	end:		'終' };

function demo() {
	document.getElementById('src').value =
		"読進増増始退増増進減終退書";
	document.getElementById('stdin').value = "a";

}

function hello() {
	document.getElementById('src').value =
		"増増増増増増増増増" +
		"始進増増増増増増増増" +
		"進増増増増増増増増増増増" +
		"進増増増増増退退退減終" +
		"進書進増増書増増増増増増増書書" +
		"増増増書進減書" +
		"減減減減減減減減減減減減書" +
		"退増増増増増増増増書" +
		"減減減減減減減減書" +
		"増増増書減減減減減減書" +
		"減減減減減減減減書進増書";
}

function ch(c) {
	var src = document.getElementById('src');
	var cp = src.selectionStart;
	var val = src.value;
	src.value = val.slice(0, cp) + c + val.slice(cp, val.length);
	src.selectionStart = cp + 1;
}

function cl() {
	var src = document.getElementById('src');
	src.value = "";
}

function init() {
	var src = document.getElementById('src').value;
	var stdin = document.getElementById('stdin').value;
	initialize(src, stdin);
}

function step() {
	var stdout = document.getElementById('stdout');
	var ptr = document.getElementById('pointer');
	var mem = document.getElementById('memory');
	brainfuck1();
	stdout.innerHTML = memory.stdout;
	ptr.innerHTML = memory.ptr;
	mem.innerHTML = memory.mem;
}

function run() {
	var src = document.getElementById('src').value;
	var stdin = document.getElementById('stdin').value;
	var stdout = document.getElementById('stdout');
	var ptr = document.getElementById('pointer');
	var mem = document.getElementById('memory');
	initialize(src, stdin);
	brainfuck();
	stdout.innerHTML = memory.stdout;
	ptr.innerHTML = memory.ptr;
	mem.innerHTML = memory.mem;
}

var source;
var memory;

function initialize(src, str) {
	source = new Source(src);
	memory = new Memory(str);
}

function brainfuck1() {
	var c = source.get(memory.get());
	switch (c) {
		case tokens.succ: memory.succ(); break;
		case tokens.pred: memory.pred(); break;
		case tokens.forward: memory.forward(); break;
		case tokens.backward: memory.backward(); break;
		case tokens.output: memory.write(); break;
		case tokens.input: memory.read(); break;
	}
}

function brainfuck() {
	var c = source.get(memory.get());
	while (c !== undefined) {
		switch (c) {
			case tokens.succ: memory.succ(); break;
			case tokens.pred: memory.pred(); break;
			case tokens.forward: memory.forward(); break;
			case tokens.backward: memory.backward(); break;
			case tokens.output: memory.write(); break;
			case tokens.input: memory.read(); break;
		}
		c = source.get(memory.get());
	}
	return memory.stdout;
}

function Memory(stdin) {
	this.mem = [];
	this.ptr = 0;
	this.stdin = stdin;
	this.stdout = "";
	this.get = function() {
			return this.mem[this.ptr] || 0;
		};
	this.set = function(v) { this.mem[this.ptr] = v; };
	this.succ = function() { this.set(this.get() + 1); };
	this.pred = function() { this.set(this.get() - 1); };
	this.forward = function() { this.ptr++ };
	this.backward = function() { this.ptr-- };
	this.write = function() {
			this.stdout += String.fromCharCode(this.mem[this.ptr]);
		}
	this.read = function() {
			this.set(this.stdin.charCodeAt(0));
			this.stdin = this.stdin.slice(1, this.stdin.length);
		}
}

function Source(src) {
	this.src = src;
	this.ptr = 0;
	this.get = function(v) {
			switch (this.src[this.ptr]) {
				case tokens.begin:
					this.ptr++;
					if (v == 0) {
						this.ptr = next(src, this.ptr, 1);
					}
					return this.get(v);
					break;
				case tokens.end:
					if (v == 0) {
						this.ptr++;
						return this.get(v);
					} else {
						this.ptr = before(src, this.ptr - 1, 1);
						return this.get(v);
					}
					break;
				default: return this.src[this.ptr++]; break;
			}
		};
}

function next(src, ptr, i) {
	switch (src[ptr]) {
		case tokens.begin: return next(src, ptr + 1, i + 1); break;
		case tokens.end:
			if (i - 1 > 0) return next(src, ptr + 1, i - 1);
			else return ptr;
			break;
		default: return next(src, ptr + 1, i); break;
	}
}

function before(src, ptr, i) {
	switch (src[ptr]) {
		case tokens.begin:
			if (i - 1 > 0) return before(src, ptr - 1, i - 1);
			else return ptr;
			break;
		case tokens.end: return before(src, ptr - 1, i + 1); break;
		default: return before(src, ptr - 1, i); break;
	}
}

console.log("brainfuck");
initialize("増始減終", "");
console.log(source.get());
console.log(source.get());
console.log(source.get());
console.log(source.get());
/*
console.log(brainfuck(
	"増増増増増増増増増始進増増増増増増増増進+++++++++++進+++++退退退減終進書>++." +
	"+++++++..+++.>-.------------.<++++++++.--------.+++.------.--------.>+."
	, ""));
console.log(brainfuck(",+++.", "hello"));
*/
