Vector = function (x , y) {
    x = x || 0;
    y = y || 0;
    this.x = x;
    this.y = y;
    this.add = function(vec) { 
        this.x += vec.x;
        this.y += vec.y;
        return this;
    };
    this.subtract = function(vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        return this;
    };
    this.normalize = function () {
        var length = this.magnitude();
        return {x: this.x / length, y: this.y / length};
    }; /*Creates normal vector from ordinary one*/
    this.magnitude = function () {
        return Math.sqrt(Math.pow(this.x,2) + Math.pow(this.y,2));
    }; /*Find magnitude of vector*/

    return this;
};

/*Returns random number in (min; max) measures*/
Math.rnd = function ( min, max ) {
    return min + Math.round(Math.random() * Math.abs(max - min));
};
/*REturns distance between 2 points*/
Math.distance = function (vector1, vector2) {
    return Math.sqrt( Math.pow( vector2.x - vector1.x, 2 ) + 
        Math.pow( vector2.y - vector1.y, 2 ));
};

/* Crates vector from 2 points*/
Math.vectorize = function (A, B) {
    return {x: B.x - A.x, y: B.y - A.y};
};
/*returns the angle between AB and horizon*/
Math.angle = function ( A, B ) {
    var a = Math.normalize(Math.vectorize(A,B));
    var b = {x:-1,y:0};
    var mult = a.x * b.x + a.y * b.y;
    return Math.acos( mult / ( Math.magnitude(a) * Math.magnitude(b) ) );
};

Math.radToDeg = function (rad) {
    return rad * (180/Math.PI);
};

Math.degToRad = function (deg) {
    return deg * (Math.PI / 180);
};