$(document).ready(function () {
	var score = 0;
	var scoreRatio = 1;
	var secondsMax = 300;
	var seconds = secondsMax;
	var score_shown = false;
	var equasion = null;

	if (localStorage['best_score'] == null) {
		localStorage['best_score'] = 0;
	}

	AnimateIn = function () {
		Execute();
		$('#body').animate({ opacity:1, top:120 }, 200, 'easeInSine');
	};

	AnimateOut = function (id) {
		$('#body').animate({opacity:0, top:100}, {
			duration:200,
			queue:false,
			easing:'easeOutCirc',
			complete:function () {
				var result = equasion.guess(id == "yes");

				score += ( result ) ? 1 : -1;
				score = Math.max(score, 0);

				AnimateIn();
			}
		});
	};

	$('#variants tr td').click(function () {
		if (seconds != 0) {
			AnimateOut($(this).attr('id'));
		}
	});

	Execute = function () {
		var stage = 0;
		var type = 0;


		if ( seconds < secondsMax && seconds >= Math.floor(seconds / 3 * 2)) {
			type = Math.rnd(0, 1);
			scoreRatio = 1;
		} else if (seconds < Math.floor(seconds / 3 * 2) && seconds >= Math.floor(seconds / 3)) {
			type = Math.rnd(0, 3);
			scoreRatio = 2;
		} else if (seconds < Math.floor(seconds / 3) && seconds >= 0) {
			type = Math.rnd(2, 3);
			scoreRatio = 3;
		}

		equasion = new Equation(stage, type);

		$('#equation').html(equasion.toString());
		$('#answer').html(equasion.getAnswer());
	};

	Execute();

	var was = "";
	var best = localStorage['best_score'] || 0;

	Update = function () {
		if (seconds == 0) {
			if (score_shown == false) {
				// $('#timescore').html('<a href="game.html">RESTART</a>');
				if (localStorage['best_score'] < score) {
					was = " WAS";
					localStorage['best_score'] = score;
				}
				$('#variants').css({display:'none'});
				score_shown = true;
			}

			$('#body')
				.html('<div id="result"> SCORE ' + score + '<br>BEST' + was + ' ' + best + '</div>');

			$('#variants')
				.html('<tr><td id="restart"><a href="game.html">RESTART</a></td></tr>')
				.css({display : 'block'});

			$('#nav')
				.css({display : 'none'});

			console.log("finished timer");
			clearInterval(timer);
		} else {
			seconds--;
			$('#time').html(Math.ceil(seconds / 10));
			$('#score').html(score);
		}

	};

	var timer = setInterval(Update, 100);

	function isLocalStorageAvailable() {
		try {
			return 'localStorage' in window && window['localStorage'] !== null;
		} catch (e) {
			return false;
		}
	}
});

