/*
 * PhoneGap is available under *either* the terms of the modified BSD license *or* the
 * MIT License (2008). See http://opensource.org/licenses/alphabetical for full text.
 *
 * Copyright (c) 2006-2011 Worklight, Ltd. 
 */

//Tracking ID
var TID = 'UA-36125036-12';

//Client ID
var CID = Date.now();


if(typeof(Storage)!=="undefined") {
	if (localStorage.CID) {
  		CID = localStorage.CID;
  	} else {
  		localStorage.CID = CID;
  	}
}

/**
 * Constructor
 */
var Analytics = function () {};

var sendTrackingData = function(parameters) {
	var url = "https://www.google-analytics.com/collect";

	parameters.ul = navigator.mozL10n.language.code.toLowerCase();

	var data = jQuery.param(parameters);

	data += "&cd[1]=" + 'AppVersion';
	data += "&cm[1]=" + '2.0';

    jQuery.ajax({ url: url, type: "POST", data: data, xhr : function() {
			var xhr = new XMLHttpRequest({
				mozSystem: true
			});
			return xhr;
		}				
	}).fail(
		function (jqXHR, textStatus, errorThrows) {
	}).done(
    	function fulfilled(result) {
    });
};


/**
 * Initialize Google Analytics configuration
 * 
 * @param accountId			The Google Analytics account id 
 * @param successCallback	The success callback
 * @param failureCallback	The error callback
 */
Analytics.prototype.start = function(successCallback, failureCallback) {
};

/**
 * Track a page view on Google Analytics
 * @param key				The name of the tracked item (can be a url or some logical name).
 * 							The key name will be presented in Google Analytics report.  
 * @param successCallback	The success callback
 * @param failureCallback	The error callback 
 */
Analytics.prototype.trackPageView = function(key, successCallback, failureCallback) {
	var parameters = {
		v: '1',
		tid: TID,
		cid: CID,
		t: 'pageview',
		dp: key
	};
	
	sendTrackingData(parameters);
};

/**
 * Track an event on Google Analytics
 * @param category			The name that you supply as a way to group objects that you want to track
 * @param action			The name the type of event or interaction you want to track for a particular web object
 * @param label				Provides additional information for events that you want to track (optional)
 * @param value				Assign a numerical value to a tracked page object (optional)

 * @param successCallback	The success callback
 * @param failureCallback	The error callback 
 */

Analytics.prototype.trackEvent = function(category, action, label, value, successCallback, failureCallback){
	var parameters = {
		v: '1',
		tid: TID,
		cid: CID,
		t: 'event',
		ec: category,
		ea: action
	};

	if (label) {
		parameters.el = label;
	}

	if (value) {
		parameters.ev = value;
	}

	sendTrackingData(parameters);
};

/**
 * Set a custom variable on Google Analytics
 * @param index			The slot for the custom variable
 * @param label			The name for the custom variable
 * @param value			The value for the custom variable
 * @param scope			The scope for the custom variable (optional)

 * @param successCallback	The success callback
 * @param failureCallback	The error callback 
 */

Analytics.prototype.setCustomDimension = function(index, value, successCallback, failureCallback){
			
};

/**
 * Load Analytics
 */

if(!window.plugins) {
    window.plugins = {};
}

if (!window.plugins.analytics) {
    window.plugins.analytics = new Analytics();
}
