﻿
define(['jquery', 'app'], function($, App) {
    var app, game;

    var initApp = function() {
        $(document).ready(function() {
        	app = new App();
        	app.center();


        	$('.externalWebView').click(function (event) {
        	    var $input = $(this);
        	    var url = $input.attr("href");
        	    window.open(url, '_system');
        	    event.stopPropagation();
        	    return false;
        	});

        	$('.emailUs').click(function (event) {
        	    try {
                    new MozActivity({
                        name: "new", // Possibly compose-mail in future versions
                        data: {
                            type : "mail",
                            url: "mailto:apps@mpbrun.dk?subject=" + encodeURIComponent("BrowserQuest for Firefox OS (version 2.0) (Feedback/Support)")
                        }
                    });
        	    } catch (e) {
        	    }

        	    event.stopPropagation();
        	    return false;
        	});

        
            if(Detect.isWindows()) {
                // Workaround for graphical glitches on text
                $('body').addClass('windows');
            }
            
            if(Detect.isOpera()) {
                // Fix for no pointer events
                $('body').addClass('opera');
            }
        
            $('body').click(function(event) {
                if($('#parchment').hasClass('credits')) {
                    app.toggleCredits();
                }
                
                if($('#parchment').hasClass('about')) {
                    app.toggleAbout();
                }
            });

            $('.barbutton').click(function() {
        	    $(this).toggleClass('active');
        	});

        	$('#chatbutton').click(function() {
        	    if($('#chatbutton').hasClass('active')) {
        	        app.showChat();
        	    } else {
                    app.hideChat();
        	    }
        	});

        	$('#helpbutton').click(function() {
                app.toggleAbout();
        	});
	
        	$('#achievementsbutton').click(function() {
                app.toggleAchievements();
                if(app.blinkInterval) {
                    clearInterval(app.blinkInterval);
                }
                $(this).removeClass('blink');
        	});
	
        	$('#instructions').click(function() {
                app.hideWindows();
        	});
        	
        	$('#playercount').click(function() {
        	    app.togglePopulationInfo();
        	});
        	
        	$('#population').click(function() {
        	    app.togglePopulationInfo();
        	});
	
        	$('.clickable').click(function(event) {
                event.stopPropagation();
        	});
	
        	$('#toggle-credits').click(function() {
        	    app.toggleCredits();
        	});
	
        	$('#create-new span').click(function() {
        	    app.animateParchment('loadcharacter', 'confirmation');
        	});
	
        	$('.delete').click(function() {
                app.storage.clear();
        	    app.animateParchment('confirmation', 'createcharacter');
        	});
	
        	$('#cancel span').click(function() {
        	    app.animateParchment('confirmation', 'loadcharacter');
        	});

        	var showTotal = true;

        	setInterval(function () {

        	    var instaceElement = $("#playercount .playercountinstance");
        	    var totalElement = $("#playercount .playercounttotal");


        	    if (showTotal) {
        	        instaceElement.fadeOut(500, function () {
        	            totalElement.fadeIn(500);
        	        });

        	    } else {
        	        totalElement.fadeOut(500, function () {
        	            instaceElement.fadeIn(500);
        	        });
        	    }

        	    showTotal = !showTotal;
        	}, 10 * 1000);
        	
        	$('.ribbon').click(function (event) {
        	    app.toggleAbout();
        	    event.stopPropagation();
            });

        	$('#nameinput').attr('placeholder', gls('placeholder.name'));
        	$('#chatinput').attr('placeholder', gls('placeholder.comment'));

            $('#nameinput').bind("keyup", function() {
                app.toggleButton();
            });
    
            $('#previous').click(function() {
                var $achievements = $('#achievements');
        
                if(app.currentPage === 1) {
                    return false;
                } else {
                    app.currentPage -= 1;
                    $achievements.removeClass().addClass('active page' + app.currentPage);
                }
            });
    
            $('#next').click(function() {
                var $achievements = $('#achievements'),
                    $lists = $('#lists'),
                    nbPages = $lists.children('ul').length;
        
                if(app.currentPage === nbPages) {
                    return false;
                } else {
                    app.currentPage += 1;
                    $achievements.removeClass().addClass('active page' + app.currentPage);
                }
            });

            $('#notifications div').bind(TRANSITIONEND, app.resetMessagesPosition.bind(app));
    
            $('.close').click(function() {
                app.hideWindows();
            });
        
            $('.twitter').click(function() {
                var url = $(this).attr('href');

               app.openPopup('twitter', url);
               return false;
            });

            $('.facebook').click(function() {
                var url = $(this).attr('href');

               app.openPopup('facebook', url);
               return false;
            });
        
            var data = app.storage.data;
    		if(data.hasAlreadyPlayed) {
    		    if(data.player.name && data.player.name !== "") {
    		        $('#playername').html(data.player.name);
    		        $('#playerimage').attr('src', data.player.image);
    		        $('#playerimage').show();
    		    }
    		}
    		
    		$('.play div').click(function(event) {
    		    window.plugins.analytics.trackPageView("Play");
    		    window.plugins.analytics.trackEvent("Game", "StartGame");

    		    try {
    		        cordova.exec(null,null, 'BrowserQuestWP8.Plugins.Ads', 'ShowAds',{});
    		    } catch (e) {
    		    }

                var nameFromInput = $('#nameinput').attr('value'),
                    nameFromStorage = $('#playername').html(),
                    name = nameFromInput || nameFromStorage;
                
                app.tryStartingGame(name);
            });
        
            document.addEventListener("touchstart", function() {},false);
            
            $('#resize-check').bind("transitionend", app.resizeUi.bind(app));
            $('#resize-check').bind("webkitTransitionEnd", app.resizeUi.bind(app));
            $('#resize-check').bind("oTransitionEnd", app.resizeUi.bind(app));
        
            log.info("App initialized.");
        
            initGame();
        });
    };
    
    var initGame = function() {
        require(['game'], function(Game) {
            
            var canvas = document.getElementById("entities"),
        	    background = document.getElementById("background"),
        	    foreground = document.getElementById("foreground"),
        	    input = document.getElementById("chatinput");

    		game = new Game(app);
    		game.setup('#bubbles', canvas, background, foreground, input);
    		game.setStorage(app.storage);
    		app.setGame(game);
    		
    		if(app.isDesktop) {
    		    game.loadMap();
    		}
	
    		game.onGameStart(function() {
                app.initEquipmentIcons();
    		});
    		
    		game.onDisconnect(function(message, reason) {
    		    $('#death').find('p').html(message);
    		    $('#respawn').hide();

    		    alert(message, null, false, "Disconnect" + reason);
    		});
	
    		game.onPlayerDeath(function() {
    		    if($('body').hasClass('credits')) {
    		        $('body').removeClass('credits');
    		    }
                $('body').addClass('death');
    		});
	
    		game.onPlayerEquipmentChange(function() {
    		    app.initEquipmentIcons();
    		});
	
    		game.onPlayerInvincible(function() {
    		    $('#hitpoints').toggleClass('invincible');
    		});

    		game.onNbPlayersChange(function(worldPlayers, totalPlayers) {
    		    var setWorldPlayersString = function(string) {
        		        $("#instance-population").find("span:nth-child(2)").text(string);
        		        $("#playercount").find("span.countstring").text(string);
        		    },
        		    setTotalPlayersString = function(string) {
        		        $("#world-population").find("span:nth-child(2)").text(string);
        		    };
    		    
    		    $("#playercount .playercountinstance").find("span.count").text(worldPlayers);
    		    
    		    $("#instance-population").find("span.count").text(worldPlayers);
    		    if(worldPlayers == 1) {
    		        setWorldPlayersString(gls("chrome.player"));
    		    } else {
    		        setWorldPlayersString(gls("chrome.players"));
    		    }

    		    $("#playercount .playercounttotal").find("span.count").text(totalPlayers);
    		    
    		    $("#world-population").find("span.count").text(totalPlayers);
    		    if(totalPlayers == 1) {
    		        setTotalPlayersString(gls("chrome.player"));
    		    } else {
    		        setTotalPlayersString(gls("chrome.players"));
    		    }
    		});
	
    		game.onAchievementUnlock(function(id, name, description) {
    		    app.unlockAchievement(id, name);
    		});
	
    		game.onNotification(function(message, priority) {
    		    app.showMessage(message, priority);
    		});
	
    		app.initHealthBar();
    		app.initXPBar();
	
            $('#nameinput').attr('value', '');
            $('#chatbox').attr('value', '');
    		
        	if(game.renderer.mobile || game.renderer.tablet) {
        	    $('#foreground').bind('touchstart', function (event) { //touchstart
                    app.center();
                    app.setMouseCoordinates(event.originalEvent.touches[0]);
                    if (game) {
                        game.click();
                    }
                    app.hideWindows();
                });
            } else {
                $('#foreground').click(function(event) {
                    app.center();
                    app.setMouseCoordinates(event);
                    if(game) {
                	    game.click();
                	}
                	app.hideWindows();
                    // $('#chatinput').focus();
                });
            }

            $('body').unbind('click');
            $('body').click(function(event) {
                var hasClosedParchment = false;
                
                if($('#parchment').hasClass('credits')) {
                    if(game.started) {
                        app.closeInGameCredits();
                        hasClosedParchment = true;
                    } else {
                        app.toggleCredits();
                    }
                }
                
                if($('#parchment').hasClass('about')) {
                    if(game.started) {
                        app.closeInGameAbout();
                        hasClosedParchment = true;
                    } else {
                        app.toggleAbout();
                    }
                }
                
                //Dont make it click outside. Fixes chatbox clicks bug.
                if (game.started && !game.renderer.mobile && game.player && !hasClosedParchment) {
                    game.click();
                }
                
            });
            
            $('#respawn').click(function(event) {
                game.audioManager.playSound("revive");
                game.restart();
                $('body').removeClass('death');
            });
            
            $(document).mousemove(function(event) {
            	app.setMouseCoordinates(event);
            	if(game.started) {
            	    game.movecursor();
            	}
            });

            $(document).keydown(function(e) {
            	var key = e.which,
                    $chat = $('#chatinput');

                if(key === 13) {
                    if($('#chatbox').hasClass('active')) {
                        app.hideChat();
                    } else {
                        app.showChat();
                    }
                }
            });
            
            $('#chatinput').keydown(function(e) {
                var key = e.which,
                    $chat = $('#chatinput');

                if(key === 13) {
                    if($chat.attr('value') !== '') {
                        if(game.player) {
                            game.say($chat.attr('value'));
                        }
                        $chat.attr('value', '');
                        app.hideChat();
                        $('#foreground').focus();
                        return false;
                    } else {
                        app.hideChat();
                        return false;
                    }
                }
                
                if(key === 27) {
                    app.hideChat();
                    return false;
                }
            });

            $('#nameinput').keypress(function(event) {
                var $name = $('#nameinput'),
                    name = $name.attr('value');

                if(event.keyCode === 13) {
                    if(name !== '') {
                        app.tryStartingGame(name, function() {
                            $name.blur(); // exit keyboard on mobile
                        });
                        return false; // prevent form submit
                    } else {
                        return false; // prevent form submit
                    }
                }
            });
            
            $('#mutebutton').click(function () {
                try {
                    game.audioManager.toggle();
                } catch (e) {
                }
            });
            
            $(document).bind("keydown", function(e) {
            	var key = e.which,
            	    $chat = $('#chatinput');

                if($('#chatinput:focus').size() == 0 && $('#nameinput:focus').size() == 0) {
                    if(key === 13) { // Enter
                        if(game.ready) {
                            $chat.focus();
                            return false;
                        }
                    }
                    if(key === 32) { // Space
                        // game.togglePathingGrid();
                        return false;
                    }
                    if(key === 70) { // F
                        // game.toggleDebugInfo();
                        return false;
                    }
                    if (key === 27) { // ESC
                        try {
                            app.hideWindows();
                            _.each(game.player.attackers, function(attacker) {
                                attacker.stop();
                            });
                        } catch (e) {

                        }
                        return false;
                    }
                    if(key === 65) { // a
                        // game.player.hit();
                        return false;
                    }
                } else {
                    if(key === 13 && game.ready) {
                        $chat.focus();
                        return false;
                    }
                }
            });
            
            if(game.renderer.tablet) {
                $('body').addClass('tablet');
            }
        });
    };
    
    initApp();
});
