alert("Ok para iniciar");
window.requestAnimFrame = (function(){
  return  window.requestAnimationFrame       || 
          window.webkitRequestAnimationFrame || 
          window.mozRequestAnimationFrame    || 
          window.oRequestAnimationFrame      || 
          window.msRequestAnimationFrame     || 
          function( callback ){
            window.setTimeout(callback, 1000 / 60);
          };
})();
var container   = document.querySelector('#container');
var canBubble = document.querySelector('#canBubble');
var maxX = container.clientWidth  - canBubble.clientWidth;
var maxY = container.clientHeight - canBubble.clientHeight;

function handleOrientation() {
    console.log(screen.mozOrientation);
}
var BURBUJA= {
    WIDTH: 320, 
    HEIGHT:  480, 
    scale:  1,    
    offset: {top: 0, left: 0},
    entities: [],
    nextBubble: 100,
    puntuacion: {
        taps: 0,
        rebentadas: 0,
        perdidas: 0
    },
    init: function() {
        BURBUJA.radio = BURBUJA.WIDTH / BURBUJA.HEIGHT;
        BURBUJA.currentWidth = BURBUJA.WIDTH;
        BURBUJA.currentHeight = BURBUJA.HEIGHT;
        BURBUJA.canvas = document.getElementsByTagName('canvas')[0];
        BURBUJA.canvas.width = BURBUJA.WIDTH;
        BURBUJA.canvas.height = BURBUJA.HEIGHT;
        BURBUJA.ctx = BURBUJA.canvas.getContext('2d');
        BURBUJA.wave = {
            x: -25, 
            y: -40, 
            r: 50, 
            time: 0,
            offset: 0
        }; 
        BURBUJA.wave.total = Math.ceil(BURBUJA.WIDTH / BURBUJA.wave.r) + 1;
        window.addEventListener('click', function(e) {
            e.preventDefault();
            BURBUJA.Input.set(e);
        }, false);
        window.addEventListener('touchstart', function(e) {
            e.preventDefault();
            BURBUJA.Input.set(e.touches[0]);
        }, false);
        window.addEventListener('touchmove', function(e) {
            e.preventDefault();
        }, false);
        window.addEventListener('touchend', function(e) {
            e.preventDefault();
        }, false);
        BURBUJA.resize();
        BURBUJA.loop();
        handleOrientation();
    },
    resize: function() {
        BURBUJA.currentHeight = window.innerHeight;
        BURBUJA.currentWidth = BURBUJA.currentHeight * BURBUJA.radio;
        BURBUJA.canvas.style.width = BURBUJA.currentWidth + 'px';
        BURBUJA.canvas.style.height = BURBUJA.currentHeight + 'px';
        BURBUJA.scale = BURBUJA.currentWidth / BURBUJA.WIDTH;
        BURBUJA.offset.top = BURBUJA.canvas.offsetTop;
        BURBUJA.offset.left = BURBUJA.canvas.offsetLeft;
        window.setTimeout(function() {
                window.scrollTo(0,1);
        }, 1);
    },
    update: function() {
        var i,
            checkCollision = false;                       
        BURBUJA.nextBubble -= 1;
        if (BURBUJA.nextBubble < 0) {
            BURBUJA.entities.push(new BURBUJA.Bubble());
            BURBUJA.nextBubble = ( Math.random() * 20 ) + 10;
        }
        if (BURBUJA.Input.tapped) {
            BURBUJA.puntuacion.taps += 1;
            BURBUJA.entities.push(new BURBUJA.Touch(BURBUJA.Input.x, BURBUJA.Input.y));
            BURBUJA.Input.tapped = false;
            checkCollision = true;
        }
        for (i = 0; i < BURBUJA.entities.length; i += 1) {
            BURBUJA.entities[i].update();
            if (BURBUJA.entities[i].type === 'bubble' && checkCollision) {
                rebentadas = BURBUJA.collides(BURBUJA.entities[i], 
                                    {x: BURBUJA.Input.x, y: BURBUJA.Input.y, r: 7});
                if (rebentadas) {
                    for (var n = 0; n < 5; n +=1 ) {
                        BURBUJA.entities.push(new BURBUJA.Particle(
                            BURBUJA.entities[i].x, 
                            BURBUJA.entities[i].y, 
                            2, 
                            'rgba(0,0,0,'+Math.random()*1+')'
                        )); 
                    }
                    BURBUJA.puntuacion.rebentadas += 1;
                }
                BURBUJA.entities[i].remove = rebentadas;
            }
        if (BURBUJA.entities[i].remove) {
                BURBUJA.entities.splice(i, 1);
            }
        }
        BURBUJA.wave.time = new Date().getTime() * 0.002;
        BURBUJA.wave.offset = Math.sin(BURBUJA.wave.time * 0.8) * 5;

    },
    render: function() {
        var i;
        BURBUJA.Draw.rect(0, 0, BURBUJA.WIDTH, BURBUJA.HEIGHT, '#2BC952');
        for (i = 0; i < BURBUJA.wave.total; i++) {
            BURBUJA.Draw.circle(
                        BURBUJA.wave.x + BURBUJA.wave.offset +  (i * BURBUJA.wave.r), 
                        BURBUJA.wave.y,
                        BURBUJA.wave.r, 
                        '#fff'); 
        }
            for (i = 0; i < BURBUJA.entities.length; i += 1) {
                BURBUJA.entities[i].render();
        }
        BURBUJA.Draw.text('Rebentadas: ' + BURBUJA.puntuacion.rebentadas, 20, 30, 14, '#fff');
        BURBUJA.Draw.text('Perdidas: ' + BURBUJA.puntuacion.perdidas, 20, 50, 14, '#fff');
    },
    loop: function() {
        requestAnimFrame( BURBUJA.loop );
        BURBUJA.update();
        BURBUJA.render();

    }
};
BURBUJA.collides = function(a, b) {
        var distance_squared = ( ((a.x - b.x) * (a.x - b.x)) + ((a.y - b.y) * (a.y - b.y)));
        var radii_squared = (a.r + b.r) * (a.r + b.r);
        if (distance_squared < radii_squared) {
            return true;
        } else {
            return false;
        }
};
BURBUJA.Draw = {
    clear: function() {
        BURBUJA.ctx.clearRect(0, 0, BURBUJA.WIDTH, BURBUJA.HEIGHT);
    },
    rect: function(x, y, w, h, col) {
        BURBUJA.ctx.fillStyle = col;
        BURBUJA.ctx.fillRect(x, y, w, h);
    },
    circle: function(x, y, r, col) {
        BURBUJA.ctx.fillStyle = col;
        BURBUJA.ctx.beginPath();
        BURBUJA.ctx.arc(x + 5, y + 5, r, 0,  Math.PI * 2, true);
        BURBUJA.ctx.closePath();
        BURBUJA.ctx.fill();
    },
    text: function(string, x, y, size, col) {
        BURBUJA.ctx.font = 'bold '+size+'px Monospace';
        BURBUJA.ctx.fillStyle = col;
        BURBUJA.ctx.fillText(string, x, y);
    }
};
BURBUJA.Input = {
    x: 0,
    y: 0,
    tapped :false,
    set: function(data) {
        this.x = (data.pageX - BURBUJA.offset.left) / BURBUJA.scale;
        this.y = (data.pageY - BURBUJA.offset.top) / BURBUJA.scale;
        this.tapped = true;
    }
};
BURBUJA.Touch = function(x, y) {
    this.type = 'touch';    
    this.x = x;             
    this.y = y;             
    this.r = 5;             
    this.opacity = 1;       
    this.fade = 0.05;       
    this.update = function() {
        this.opacity -= this.fade; 
        this.remove = (this.opacity < 0) ? true : false;
    };
    this.render = function() {
        BURBUJA.Draw.circle(this.x, this.y, this.r, 'rgba(255,0,0,'+this.opacity+')');
    };
};
BURBUJA.Bubble = function() {
    this.type = 'bubble';
    this.r = (Math.random() * 20) + 10;
    this.speed = (Math.random() * 3) + 1;
    this.x = (Math.random() * (BURBUJA.WIDTH) - this.r);
    this.y = BURBUJA.HEIGHT + (Math.random() * 100) + 100;
    this.waveSize = 5 + this.r;
    this.xConstant = this.x;
    this.remove = false;
    this.update = function() {
        var time = new Date().getTime() * 0.002;
        this.y -= this.speed;
        this.x = this.waveSize * Math.sin(time) + this.xConstant;
        if (this.y < -10) {
            BURBUJA.puntuacion.perdidas += 1;
            if(BURBUJA.puntuacion.perdidas == 30){
                alert("Fin de Juego\nPuntuacion: " + BURBUJA.puntuacion.rebentadas);
                location.reload();
            }
            this.remove = true;
        }
    };
    this.render = function() {
        BURBUJA.Draw.circle(this.x, this.y, this.r, 'rgba(36,247,151,1)');
    };
};
BURBUJA.Particle = function(x, y,r, col) {
    this.x = x;
    this.y = y;
    this.r = r;
    this.col = col;
    this.dir = (Math.random() * 2 > 1) ? 1 : -1;
    this.vx = ~~(Math.random() * 4) * this.dir;
    this.vy = ~~(Math.random() * 7);
    this.remove = false;
    this.update = function() {
        this.x += this.vx;
        this.y += this.vy;
        this.vx *= 0.99;
        this.vy *= 0.99;
        this.vy -= 0.25;
        if (this.y < 0) {
            this.remove = true;
        }
    };
    this.render = function() {
        BURBUJA.Draw.circle(this.x, this.y, this.r, this.col);
    };
};
window.addEventListener('load', BURBUJA.init, false);
window.addEventListener('resize', BURBUJA.resize, false);
screen.addEventListener('orientationchange', handleOrientation, false);