/*global angular */define([ "angular" ], function() {
    var app = angular.module("app", [ "mobile-navigate" ]).config([ "$routeProvider", function($routeProvider) {
        $routeProvider.when("/", {
            templateUrl: "views/start.html",
            controller: "StartCtrl"
        }).when("/about", {
            templateUrl: "views/about.html",
            controller: "AboutCtrl"
        }).when("/routes", {
            templateUrl: "views/routes.html",
            controller: "RoutesCtrl"
        }).when("/stops", {
            templateUrl: "views/stops.html",
            controller: "StopsCtrl"
        }).when("/stops/:near", {
            templateUrl: "views/stops.html",
            controller: "StopsCtrl"
        }).when("/route_stops/:id", {
            templateUrl: "views/route_stops.html",
            controller: "RouteStopsCtrl"
        }).when("/route_stops/:id/:d", {
            templateUrl: "views/route_stops.html",
            controller: "RouteStopsCtrl"
        }).when("/times/:rid/:d/:sid", {
            templateUrl: "views/times.html",
            controller: "TimesCtrl"
        }).when("/times_edit/:rid/:d/:sid", {
            templateUrl: "views/times_edit.html",
            controller: "TimesEditCtrl"
        }).when("/filter", {
            templateUrl: "views/filter.html",
            controller: "FilterCtrl"
        }).when("/download", {
            templateUrl: "views/download.html",
            controller: "DownloadCtrl"
        }).when("/process", {
            templateUrl: "views/process.html",
            controller: "ProcessCtrl"
        }).when("/list", {
            templateUrl: "views/list.html",
            controller: "ListCtrl"
        }).when("/detail/:id", {
            templateUrl: "views/detail.html",
            controller: "DetailCtrl"
        }).when("/add", {
            templateUrl: "views/edit.html",
            controller: "AddCtrl"
        }).when("/edit/:id", {
            templateUrl: "views/edit.html",
            controller: "EditCtrl"
        }).otherwise({
            redirectTo: "/"
        });
    } ]);
    return app.controller("MainCtrl", [ "$scope", "$navigate", "$location", function($scope, $navigate, $location) {
        $scope.$navigate = $navigate;
        var search = $location.search();
        $navigate.go($location.path(), "none").search(search);
    } ]), app.config([ "$httpProvider", function($httpProvider) {
        delete $httpProvider.defaults.headers.common["X-Requested-With"];
    } ]), app.directive("ngTap", function() {
        var isTouch = !1;
        return function(scope, elm, attrs) {
            if (isTouch) {
                var tapping = !1;
                elm.bind("touchstart", function() {
                    tapping = !0;
                }), elm.bind("touchmove", function() {
                    tapping = !1;
                }), elm.bind("touchend", function() {
                    tapping && scope.$apply(attrs.ngTap);
                });
            } else elm.bind("click", function() {
                scope.$apply(attrs.ngTap);
            });
        };
    }), app;
});