/*
 * Copyright (c) 2013 Komjáti László
 */define([ "app" ], function(app) {
    app.controller("DownloadCtrl", [ "$scope", "$routeParams", "$location", "database", "$navigate", "helper", "settings", function DownloadCtrl($scope, $routeParams, $location, database, $navigate, helper, settings) {
        database.dataGenTime(function(genTime) {
            $scope.loadedByte = 0, $scope.totalByte = 0, $scope.percentComplete = 0;
            var checked = !1, download = $.ajax({
                xhr: function() {
                    var xhr = new window.XMLHttpRequest({
                        mozSystem: !0
                    });
                    return xhr.addEventListener("progress", function(evt) {
                        if (!checked && xhr.responseText) {
                            var regExp = new RegExp('dbg:"([0-9]{4}-[0-9]{2}-[0-9]{2})",', "i"), actGenTime = regExp.exec(xhr.responseText);
                            if (actGenTime) {
                                checked = !0;
                                var diff = helper.daysBetween(new Date(Date.parse(actGenTime)), genTime);
                                diff === 0 && download.abort();
                            }
                        }
                        evt.lengthComputable ? ($("#computableProgress").show(), $("#uncomputableProgress").hide(), $scope.loadedByte = Math.round(evt.loaded / 1048576 * 100) / 100, $scope.totalByte = Math.round(evt.total / 1048576 * 100) / 100, $scope.percentComplete = Math.round(evt.loaded * 100 / evt.total), $scope.$apply()) : ($("#computableProgress").hide(), $("#uncomputableProgress").show());
                    }, !1), xhr;
                },
                url: settings.dbUrl(),
                dataType: "json",
                success: function(json) {
                    settings.json = json, $navigate.go("/process", "modal", !1), $scope.$apply();
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    textStatus === "abort" ? helper.showStatusMessage("Letöltés megszakítva!") : textStatus === "error" ? helper.showStatusMessage("Hiba történt a letöltés közben!") : helper.showStatusMessage(textStatus), $navigate.go("/", "modal", !0), $scope.$apply();
                },
                timeout: settings.ajaxTimeout()
            });
            $scope.cancel = function() {
                download.abort();
            };
        });
    } ]);
});