/*
 * Copyright (c) 2013 Komjáti László
 */define([ "app" ], function(app) {
    app.controller("StopsCtrl", [ "$scope", "$routeParams", "$location", "database", "settings", "helper", "geohelper", function StopsCtrl($scope, $routeParams, $location, database, settings, helper, geohelper) {
        var near = $routeParams.near === "near";
        $scope.hasStops = !1;
        var setViewData = function(stops, routes, colors, lat, lon) {
            stops.length > 0 && ($scope.hasStops = !0, stops = helper.setStopViewData(stops, routes, colors, lat, lon)), $scope.stops = near ? stops.sort(function(a, b) {
                return helper.sorterByFieldName(a, b, "distance");
            }) : stops.sort(function(a, b) {
                return helper.sorterByFieldName(a, b, "sn");
            }), $scope.$apply();
        }, onSuccess = function(position) {
            var lat = position.coords.latitude, lon = position.coords.longitude;
            database.getNearStops(lat, lon, function(stops) {
                database.getRoutes(function(routes) {
                    database.getColors(function(colors) {
                        setViewData(stops, routes, colors, lat, lon);
                    });
                });
            });
        }, onError = function(error) {
            alert(geohelper.getErrorText(error));
        };
        near ? geohelper.getCurrentPosition(onSuccess, onError) : database.getAllStops(function(stops) {
            database.getRoutes(function(routes) {
                database.getColors(function(colors) {
                    setViewData(stops, routes, colors, null, null);
                });
            });
        });
    } ]);
});