/*
 * Copyright (c) 2013 Komjáti László
 */define([ "app" ], function(app) {
    app.controller("TimesCtrl", [ "$scope", "$routeParams", "$location", "database", "settings", "$navigate", "helper", function TimesCtrl($scope, $routeParams, $location, database, settings, $navigate, helper) {
        var routeId = $routeParams.rid, direction = $routeParams.d, stopId = $routeParams.sid;
        $scope.routeId = routeId, $scope.directionId = direction, $scope.stopId = stopId, $scope.hasTimes = !1, $scope.bookmarkType = "bookmark", database.getStopsByRouteId(routeId, direction, function(route, stops) {
            database.getColors(function(colors) {
                $scope.route = route.sn, $scope.routeColor = {
                    b: colors[helper.convert(route.c)].b,
                    t: colors[helper.convert(route.c)].t
                }, $scope.direction = direction === settings.direction_in() ? route.hi : route.ho, $scope.stop = stops.filter(function(stop) {
                    return stop.id === stopId;
                })[0], $scope.routeNames = [], settings.actTimeRoute = route, settings.actTimeStops = stops, settings.actTimeDate = settings.actTimeDate || new Date;
                var date = settings.actTimeDate;
                $scope.date = date.getFullYear() + "." + ("00" + (date.getMonth() + 1)).slice(-2) + "." + ("00" + date.getDate()).slice(-2), $scope.day = helper.getDayName(date), database.getTimes(routeId, stopId, direction, function(times, mit, zeroDay) {
                    var hours = helper.getHours(times, mit, zeroDay, date);
                    $scope.hours = hours, $scope.hasTimes = hours.length > 0;
                    var now = new Date;
                    helper.daysBetween(date, now) === 0 && ($scope.next = helper.getNextTime(hours, now)), $scope.$apply();
                }), database.getRoutes(function(routes) {
                    $scope.stop = helper.setStopViewData([ $scope.stop ], routes, colors, null, null)[0], $scope.stop.routeNames = $scope.stop.routeNames.filter(function(route) {
                        return route.id !== routeId && route.di === direction;
                    }), $scope.$apply();
                });
            });
        });
        var refreshFavoriteActionIcon = function() {
            database.isFavorite("2", stopId, function(result) {
                $scope.bookmarkType = result ? "bookmarked" : "bookmark", $scope.$apply();
            });
        };
        refreshFavoriteActionIcon(), $scope.setFavorite = function() {
            database.setStopFavorite(stopId, function(result) {
                var message = "";
                result === "add" ? message = "A megálló bekerült a kedvencek közé!" : message = "A megálló törölve lett a kedvencek közül!", helper.showStatusMessage(message), refreshFavoriteActionIcon();
            });
        };
    } ]);
});