/*
 * Copyright (c) 2013 Komjáti László
 *//*global define */"use strict";

define([ "app" ], function(app) {
    app.factory("database", [ "settings", "helper", function(settings, helper) {
        var DB = function() {
            var DBNAME = "BPMenetrendStorage", DBVERSION = 3, METADATA_KEY = "metadata", METADATA_STORENAME = "metadata", ROUTES_STORENAME = "routes", STOPS_STORENAME = "stops", TIMES_STORENAME = "times", COLORS_STORENAME = "colors", MIT_KEY = "mit", MIT_STORENAME = "mit", FAVORITES_STORENAME = "favorites", SETTINGS_KEY = "settings", SETTINGS_STORENAME = "settings", ROUTES_ID_INDEXNAME = "id", ROUTES_TYPE_INDEXNAME = "type", STOPS_GPS_INDEXNAME = "gps", ROUTE_TYPE_TRAM = "0", ROUTE_TYPE_SUBWAY = "1", ROUTE_TYPE_RAIL = "2", ROUTE_TYPE_BUS = "3", ROUTE_TYPE_FERRY = "4", ROUTE_TYPE_CABLE_CAR = "5", ROUTE_TYPE_GONDOLA = "6", ROUTE_TYPE_FUNICULAR = "7", FAVORITE_ROUTE = "1", FAVORITE_STOP = "2", db = null, direction_in = settings.direction_in(), direction_out = settings.direction_out(), that = this, getTransaction = function(stores, type, callback) {
                if (db) callback(db.transaction(stores, type)); else {
                    var openreq = indexedDB.open(DBNAME, DBVERSION);
                    openreq.onerror = function() {
                        console.error("Can't open database:", openreq.error.name);
                    }, openreq.onupgradeneeded = function() {
                        openreq.result.createObjectStore(METADATA_STORENAME);
                        var routeStore = openreq.result.createObjectStore(ROUTES_STORENAME, {
                            keyPath: "lno",
                            autoIncrement: !0
                        }), stopStore = openreq.result.createObjectStore(STOPS_STORENAME, {
                            keyPath: "id",
                            autoIncrement: !1
                        });
                        openreq.result.createObjectStore(TIMES_STORENAME, {
                            keyPath: [ "r", "s", "d" ],
                            autoIncrement: !1
                        }), openreq.result.createObjectStore(COLORS_STORENAME, {
                            keyPath: "id",
                            autoIncrement: !0
                        }), openreq.result.createObjectStore(MIT_STORENAME), openreq.result.createObjectStore(FAVORITES_STORENAME, {
                            keyPath: [ "t", "id" ],
                            autoIncrement: !1
                        }), openreq.result.createObjectStore(SETTINGS_STORENAME), routeStore.createIndex(ROUTES_ID_INDEXNAME, "id", {
                            unique: !0
                        }), routeStore.createIndex(ROUTES_TYPE_INDEXNAME, "t", {
                            unique: !1
                        }), stopStore.createIndex(STOPS_GPS_INDEXNAME, [ "la", "lo" ], {
                            unique: !1
                        });
                    }, openreq.onsuccess = function() {
                        db = openreq.result, callback(db.transaction(stores, type));
                    };
                }
            }, getStore = function(store, type, callback) {
                getTransaction(store, type, function(transaction) {
                    callback(transaction.objectStore(store));
                });
            };
            this.getRoutes = function(callback) {
                var routes = [];
                getStore(ROUTES_STORENAME, "readonly", function(store) {
                    store.openCursor().onsuccess = function(event) {
                        var cursor = event.target.result;
                        cursor ? (routes.push(cursor.value), cursor.continue()) : callback(routes);
                    };
                });
            }, this.getRoutesByType = function(type, callback) {
                var routes = [], singleKeyRange = IDBKeyRange.only(type);
                getStore(ROUTES_STORENAME, "readonly", function(store) {
                    var index = store.index(ROUTES_TYPE_INDEXNAME);
                    index.openCursor(singleKeyRange).onsuccess = function(event) {
                        var cursor = event.target.result;
                        cursor ? (routes.push(cursor.value), cursor.continue()) : callback(routes);
                    };
                });
            }, this.getRoute = function(id, callback) {
                var route = {}, singleKeyRange = IDBKeyRange.only(id);
                getStore(ROUTES_STORENAME, "readonly", function(store) {
                    var index = store.index(ROUTES_ID_INDEXNAME);
                    index.openCursor(singleKeyRange).onsuccess = function(event) {
                        var cursor = event.target.result;
                        route = cursor.value, callback(route);
                    };
                });
            }, this.getStops = function(near, callback, lat, lon) {
                near ? this.getNearStops(lat, lon, callback) : this.getAllStops(callback);
            }, this.getAllStops = function(callback) {
                var stops = [];
                getStore(STOPS_STORENAME, "readonly", function(store) {
                    store.openCursor().onsuccess = function(event) {
                        var cursor = event.target.result;
                        cursor ? (stops.push(cursor.value), cursor.continue()) : callback(stops);
                    };
                });
            }, this.getNearStops = function(lat, lon, callback) {
                var stops = [], boundKeyRange = IDBKeyRange.bound([ String(lat - settings.maxDistanceLat()) ], [ String(lat + settings.maxDistanceLat()) ], !1, !1);
                getStore(STOPS_STORENAME, "readonly", function(store) {
                    var index = store.index(STOPS_GPS_INDEXNAME);
                    index.openCursor(boundKeyRange).onsuccess = function(event) {
                        var cursor = event.target.result;
                        if (cursor) {
                            var lonKey = cursor.key[1];
                            lonKey >= lon - settings.maxDistanceLon() && lonKey <= lon + settings.maxDistanceLon() && stops.push(cursor.value), cursor.continue();
                        } else callback(stops);
                    };
                });
            }, this.getStop = function(id, callback) {
                getStore(STOPS_STORENAME, "readonly", function(store) {
                    store.get(id).onsuccess = function(event) {
                        callback(event.target.result);
                    };
                });
            }, this.getStopsByRouteId = function(routeId, direction, callback) {
                this.getRoute(routeId, function(route) {
                    var getStopsAsync = function(stopsIds, stops, callback) {
                        stopIds.length > 0 ? that.getStop(stopIds[0], function(stop) {
                            var index = direction === direction_in ? route.ai.length - stopIds.length : route.ao.length - stopIds.length;
                            stop.a = direction === direction_in ? route.ai[index] : route.ao[index], stops.push(stop), stopIds.shift(), getStopsAsync(stopsIds, stops, callback);
                        }) : callback(route, stops);
                    }, stopIds = direction === direction_in ? route.si : route.so, stops = [];
                    getStopsAsync(stopIds, stops, callback);
                });
            }, this.getColors = function(callback) {
                var colors = [];
                getStore(COLORS_STORENAME, "readonly", function(store) {
                    store.openCursor().onsuccess = function(event) {
                        var cursor = event.target.result;
                        cursor ? (colors.push(cursor.value), cursor.continue()) : callback(colors);
                    };
                });
            }, this.getMetaData = function(callback) {
                getStore(METADATA_STORENAME, "readonly", function(store) {
                    store.get(METADATA_KEY).onsuccess = function(event) {
                        callback(event.target.result);
                    };
                });
            }, this.getSettings = function(callback) {
                getStore(SETTINGS_STORENAME, "readonly", function(store) {
                    store.get(SETTINGS_KEY).onsuccess = function(event) {
                        callback(event.target.result);
                    };
                });
            }, this.getMinutesArray = function(callback) {
                getStore(MIT_STORENAME, "readonly", function(store) {
                    store.get(MIT_KEY).onsuccess = function(event) {
                        callback(event.target.result);
                    };
                });
            }, this.getTimes = function(routeId, stopId, direction, callback) {
                getStore(TIMES_STORENAME, "readonly", function(store) {
                    store.get([ routeId, stopId, direction ]).onsuccess = function(event) {
                        that.getMinutesArray(function(mit) {
                            that.getMetaData(function(metaData) {
                                callback(event.target.result, mit, helper.convertDate(metaData.zeroday));
                            });
                        });
                    };
                });
            }, this.loadData = function(data, callback, progressCallback) {
                var needRefresh = !1, total = data.routes.length + data.stops.length + data.times.length + data.colors.length, current = 0, lastInt = 0, setProgressBar = function() {
                    current += 1;
                    if (progressCallback) {
                        var progressValue = current * 100 / total;
                        progressValue > lastInt && (lastInt += 1, progressCallback(lastInt));
                    }
                }, bulk = function(storeName, items, offset, batchSize, callback) {
                    offset >= items.length ? callback(!0) : getTransaction([ storeName ], "readwrite", function(tx) {
                        var store = tx.objectStore(storeName);
                        for (var i = offset, max = Math.min(items.length, offset + batchSize); i < max; ++i) {
                            switch (storeName) {
                              case ROUTES_STORENAME:
                                items[i].sn = helper.changeHtmlEscape(items[i].sn), items[i].ln = helper.changeHtmlEscape(items[i].ln), items[i].d = helper.changeHtmlEscape(items[i].d), items[i].hi = helper.changeHtmlEscape(items[i].hi), items[i].ho = helper.changeHtmlEscape(items[i].ho);
                                break;
                              case STOPS_STORENAME:
                                items[i].sn = helper.changeHtmlEscape(items[i].sn);
                            }
                            var req = store.put(items[i]);
                            setProgressBar();
                        }
                        var stop = !1;
                        req.onsuccess = function() {}, req.onerror = function() {
                            stop = !0;
                        }, tx.oncomplete = function() {
                            stop || setTimeout(function() {
                                bulk(storeName, items, offset + batchSize, batchSize, callback);
                            }, 1);
                        }, tx.onerror = function(event) {
                            callback(!1, event);
                        };
                    });
                }, putItems = function(store, items) {
                    for (var i = 0; i < items.length; i++) {
                        try {
                            store.put(items[i]);
                        } catch (e) {
                            callback("Kivétel történt: " + e.message);
                        }
                        setProgressBar();
                    }
                };
                getTransaction([ METADATA_STORENAME, ROUTES_STORENAME, STOPS_STORENAME, TIMES_STORENAME, COLORS_STORENAME, MIT_STORENAME, SETTINGS_STORENAME ], "readwrite", function(transaction) {
                    transaction.oncomplete = function(event) {
                        needRefresh ? bulk(ROUTES_STORENAME, data.routes, 0, settings.batchSize(), function(result, event) {
                            result ? bulk(STOPS_STORENAME, data.stops, 0, settings.batchSize(), function(result, event) {
                                result ? bulk(TIMES_STORENAME, data.times, 0, settings.batchSize(), function(result, event) {
                                    result ? callback("complete") : callback(event.type);
                                }) : callback(event.type);
                            }) : callback(event.type);
                        }) : callback("A letöltött adatbázis nem frissebb, mint az aktuális!");
                    }, transaction.objectStore(METADATA_STORENAME).get(METADATA_KEY).onsuccess = function(event) {
                        var metaData = event.target.result;
                        needRefresh = !metaData || metaData.version === data.dbv && metaData.gentime < data.dbg, needRefresh && (transaction.objectStore(ROUTES_STORENAME).clear().onsuccess = function(event) {
                            transaction.objectStore(STOPS_STORENAME).clear().onsuccess = function(event) {
                                transaction.objectStore(TIMES_STORENAME).clear().onsuccess = function(event) {
                                    transaction.objectStore(COLORS_STORENAME).clear().onsuccess = function(event) {
                                        putItems(transaction.objectStore(COLORS_STORENAME), data.colors), transaction.objectStore(MIT_STORENAME).put(data.mit, MIT_KEY), transaction.objectStore(SETTINGS_STORENAME).put(data.settings, SETTINGS_KEY), transaction.objectStore(METADATA_STORENAME).put({
                                            version: data.dbv,
                                            gentime: data.dbg,
                                            zeroday: data.zd,
                                            validto: data.vt
                                        }, METADATA_KEY);
                                    };
                                };
                            };
                        });
                    };
                });
            }, this.needDataRefresh = function(callback) {
                getStore(METADATA_STORENAME, "readonly", function(store) {
                    store.get(METADATA_KEY).onsuccess = function(event) {
                        var metaData = event.target.result, validTo = helper.convertDate(metaData.validto), today = new Date, diff = helper.daysBetween(validTo, today);
                        callback(diff > 1 ? !0 : !1);
                    };
                });
            }, this.dataGenTime = function(callback) {
                getStore(METADATA_STORENAME, "readonly", function(store) {
                    store.get(METADATA_KEY).onsuccess = function(event) {
                        var metaData = event.target.result, genTime = helper.convertDate(metaData.gentime);
                        callback(genTime);
                    };
                });
            }, this.getRoutesMetro = function(callback) {
                this.getRoutesByType(ROUTE_TYPE_SUBWAY, callback);
            }, this.getRoutesBus = function(callback) {
                this.getRoutesByType(ROUTE_TYPE_BUS, callback);
            }, this.getRoutesHev = function(callback) {
                this.getRoutesByType(ROUTE_TYPE_RAIL, callback);
            }, this.getRoutesTram = function(callback) {
                this.getRoutesByType(ROUTE_TYPE_TRAM, callback);
            }, this.getRoutesShip = function(callback) {
                this.getRoutesByType(ROUTE_TYPE_FERRY, callback);
            }, this.getFavorites = function(callback) {
                var routeIds = [], stopIds = [], routeDirection = {}, getFavoritesAsync = function(ids, result, getFavorite, type, callback) {
                    ids.length > 0 ? getFavorite(ids[0], function(item) {
                        item && (type === FAVORITE_ROUTE && (item.fd = routeDirection[item.id]), result.push(item)), ids.shift(), getFavoritesAsync(ids, result, getFavorite, type, callback);
                    }) : callback(result);
                };
                getStore(FAVORITES_STORENAME, "readonly", function(store) {
                    store.openCursor().onsuccess = function(event) {
                        var cursor = event.target.result;
                        if (cursor) cursor.value.t === FAVORITE_ROUTE ? (routeIds.push(cursor.value.id), routeDirection[cursor.value.id] = cursor.value.d) : stopIds.push(cursor.value.id), cursor.continue(); else {
                            var routes = [];
                            getFavoritesAsync(routeIds, routes, that.getRoute, FAVORITE_ROUTE, function(routes) {
                                var stops = [];
                                getFavoritesAsync(stopIds, stops, that.getStop, FAVORITE_STOP, function(stops) {
                                    callback(routes, stops);
                                });
                            });
                        }
                    };
                });
            }, this.setRouteFavorite = function(id, direction, callback) {
                this.setFavorite(FAVORITE_ROUTE, id, direction, callback);
            }, this.setStopFavorite = function(id, callback) {
                this.setFavorite(FAVORITE_STOP, id, "", callback);
            }, this.setFavorite = function(type, id, data, callback) {
                var result = "";
                getTransaction(FAVORITES_STORENAME, "readwrite", function(transaction) {
                    transaction.oncomplete = function(event) {
                        callback(result);
                    };
                    var store = transaction.objectStore(FAVORITES_STORENAME);
                    store.get([ type, id ]).onsuccess = function(event) {
                        var favorite = event.target.result;
                        favorite ? (store.delete([ type, id ]), result = "del") : (store.put({
                            t: type,
                            id: id,
                            d: data
                        }), result = "add");
                    };
                });
            }, this.isFavorite = function(type, id, callback) {
                var result = !1;
                getStore(FAVORITES_STORENAME, "readonly", function(store) {
                    store.get([ type, id ]).onsuccess = function(event) {
                        event.target.result ? callback(!0) : callback(!1);
                    };
                });
            };
        };
        return new DB;
    } ]);
});