/*
 * Copyright (c) 2013 Komjáti László
 *//*global define */"use strict";

define([ "app" ], function(app) {
    app.factory("geohelper", [ "settings", function(settings) {
        var GeoHelper = function() {
            var watchProcess = null;
            this.getCurrentPosition = function(successCallback, errorCallback) {
                navigator.geolocation.getCurrentPosition(successCallback, function(error) {
                    error.code === error.TIMEOUT ? navigator.geolocation.getCurrentPosition(successCallback, errorCallback, {
                        maximumAge: settings.gpsMaxAge(),
                        timeout: settings.gpsTimeout(),
                        enableHighAccuracy: !1
                    }) : errorCallback(error);
                }, {
                    maximumAge: settings.gpsMaxAge(),
                    timeout: settings.gpsTimeout(),
                    enableHighAccuracy: !0
                });
            }, this.initiate_watchlocation = function(successCallback, errorCallback) {
                watchProcess == null && (watchProcess = navigator.geolocation.watchPosition(successCallback, errorCallback, {
                    enableHighAccuracy: !0
                }));
            }, this.stop_watchlocation = function() {
                watchProcess != null && (navigator.geolocation.clearWatch(watchProcess), watchProcess = null);
            }, this.getErrorText = function(error) {
                var text;
                switch (error.code) {
                  case error.PERMISSION_DENIED:
                    text = "Nincs engedélyezve a hozzáférés a pozícióadatokhoz!";
                    break;
                  case error.POSITION_UNAVAILABLE:
                    text = "Nem állapítható meg az aktuális pozíció!";
                    break;
                  case error.TIMEOUT:
                    text = "Időtúllépés!";
                    break;
                  default:
                    text = "Ismeretlen hiba történt!";
                }
                return text;
            }, this.getPositionText = function(position) {
                var text = "Latitude: " + position.coords.latitude + "<br/>" + "Longitude: " + position.coords.longitude + "<br/>" + "Accuracy: " + position.coords.accuracy + "m<br/>" + "Altitude: " + position.coords.altitude + "m<br/>" + "Altitude accuracy: " + position.coords.altitudeAccuracy + "m<br/>" + "Heading: " + position.coords.heading + "degree<br/>" + "Speed: " + position.coords.speed + "m/s<br/>" + "Time: " + new Date(position.timestamp);
                return text;
            }, this.getDistance = function(position1, position2) {
                var lat1 = position1.la * Math.PI / 180, lon1 = position1.lo * Math.PI / 180, lat2 = position2.la * Math.PI / 180, lon2 = position2.lo * Math.PI / 180, R = 6371e3, x = (lon2 - lon1) * Math.cos((lat1 + lat2) / 2), y = lat2 - lat1, d = Math.sqrt(x * x + y * y) * R;
                return Math.round(d);
            };
        };
        return new GeoHelper;
    } ]);
});