/*
 * Copyright (c) 2013 Komjáti László
 */define([ "app" ], function(app) {
    app.controller("RouteStopsCtrl", [ "$scope", "$routeParams", "$location", "database", "settings", "helper", function RouteStopsCtrl($scope, $routeParams, $location, database, settings, helper) {
        var direction = $routeParams.d || settings.direction_in(), routeId = $routeParams.id;
        $scope.routeId = routeId, $scope.bookmarkType = "bookmark", settings.actTimeDate = null;
        var refreshStops = function() {
            database.getStopsByRouteId(routeId, direction, function(route, stops) {
                database.getColors(function(colors) {
                    $scope.route = route.sn, $scope.routeColor = {
                        b: colors[helper.convert(route.c)].b,
                        t: colors[helper.convert(route.c)].t
                    }, $scope.stops = stops, $scope.direction = direction === settings.direction_in() ? route.hi : route.ho, $scope.directionId = direction, database.isFavorite("1", routeId, function(result) {
                        $scope.bookmarkType = result ? "bookmarked" : "bookmark", $scope.$apply();
                    });
                });
            });
        };
        refreshStops(), $scope.changeDirection = function() {
            direction === settings.direction_in() ? direction = settings.direction_out() : direction = settings.direction_in(), refreshStops();
        }, $scope.setFavorite = function() {
            database.setRouteFavorite(routeId, direction, function(result) {
                var message = "";
                result === "add" ? message = "A járat bekerült a kedvencek közé!" : message = "A járat törölve lett a kedvencek közül!", helper.showStatusMessage(message), refreshStops();
            });
        };
    } ]);
});