/*global angular *//*
 * angular-mobile-nav by Andy Joslin
 * http://github.com/ajoslin/angular-mobile-nav
 * @license MIT License http://goo.gl/Z8Nlo
 */define([ "angular" ], function() {
    angular.module("mobile-navigate", []), angular.module("mobile-navigate").factory("$change", [ "$rootScope", function($rootScope) {
        var transitionPresets = {
            modal: [ "modal", "" ],
            none: [ "", "" ]
        }, defaultOptions = {
            prefix: "mb-"
        }, IN_CLASS = "in", OUT_CLASS = "out", REVERSE_CLASS = "reverse", DONE_CLASS = "done", ANIMATION_END = typeof document.body.style.webkitBorderRadius != "undefined" ? "webkitAnimationEnd" : "animationend";
        return function change(next, prev, transType, reverse, options, cb) {
            function buildClassString(classes) {
                var classStr = "";
                for (var i = 0, ii = classes.length; i < ii; i++) classes[i].length && (classStr += " " + options.prefix + classes[i]);
                return classStr;
            }
            options = angular.extend(options || {}, defaultOptions);
            var nextTransClass, prevTransClass, transition = transitionPresets[transType] ? transitionPresets[transType] : [ transType, transType ];
            next.css("z-index", "-100"), next[0].offsetWidth += 0;
            var nextClasses = buildClassString([ reverse ? OUT_CLASS : IN_CLASS, nextTransClass = transition[reverse ? 1 : 0], reverse && REVERSE_CLASS || "" ]).trim(), prevClasses;
            prev && (prevClasses = buildClassString([ reverse ? IN_CLASS : OUT_CLASS, prevTransClass = transition[reverse ? 0 : 1], reverse && REVERSE_CLASS || "" ])), setTimeout(function() {
                function done() {
                    prev && prev.css("display", "none"), $rootScope.$apply(function() {
                        then();
                    });
                }
                function then() {
                    cb(), boundElement && boundElement.unbind(ANIMATION_END, done), next.removeClass(nextClasses), prev && prev.removeClass(prevClasses);
                }
                next.css("display", "block"), next.addClass(nextClasses), prev && prev.addClass(prevClasses);
                var boundElement;
                nextTransClass && nextTransClass.length ? (boundElement = next).bind(ANIMATION_END, done) : prev && prevTransClass && prevTransClass.length ? (boundElement = prev).bind(ANIMATION_END, done) : then();
            }), next.css("z-index", ""), next[0].offsetWidth += 0;
        };
    } ]), angular.module("mobile-navigate").service("$navigate", [ "$rootScope", "$location", function($rootScope, $location) {
        function Page(path, transition) {
            this.transition = transition || "slide";
        }
        function navigate(destination, source, isBack) {
            $rootScope.$broadcast("$pageTransitionStart", destination, source, isBack), self.current = self.next;
        }
        var self = this;
        self.onRouteSuccess = angular.noop, $rootScope.$on("$routeChangeSuccess", function($event, next, last) {
            self.onRouteSuccess($event, next, last);
        }), self.go = function go(path, transition, reverse) {
            var req = $location.path(path).search({});
            return self.onRouteSuccess = function($event, next, last) {
                self.next = new Page(path, transition || next.$route.transition), navigate(self.next, self.current, !!reverse);
            }, req;
        };
    } ]), angular.module("mobile-navigate").directive("mobileView", [ "$rootScope", "$compile", "$controller", "$route", "$change", function($rootScope, $compile, $controller, $route, $change) {
        function link(scope, viewElement, attrs) {
            function insertPage(page) {
                var current = $route.current, locals = current && current.locals;
                page.element = angular.element('<div class="mb-page">' + locals.$template + "</div>"), page.element.css({
                    display: "none"
                }), page.scope = scope.$new();
                var contents = page.element.contents();
                current.controller && (locals.$scope = page.scope, page.controller = $controller(current.controller, locals), contents.data("$ngControllerController", page.controller)), $compile(contents)(page.scope), viewElement.append(page.element), page.scope.$emit("$viewContentLoaded"), page.scope.$evalAsync(attrs.onLoad);
            }
            scope.$on("$pageTransitionStart", function transitionStart($event, dest, source, reverse) {
                function transition() {
                    insertPage(dest);
                    var _source = source ? source.element : null, _transition = dest.transition || source.transition;
                    $change(dest.element, _source, _transition, reverse, null, function() {
                        source && ($rootScope.$broadcast("$pageTransitionSuccess", dest, source), source.scope.$destroy(), source.element.remove(), source = undefined);
                    });
                }
                transition(dest, source, reverse);
            });
        }
        return {
            restrict: "EA",
            link: link
        };
    } ]);
});