/*
 * Copyright (c) 2013 Komjáti László
 *//*global define */"use strict";

define([ "app" ], function(app) {
    app.factory("helper", [ "settings", "geohelper", function(settings, geohelper) {
        var Helper = function() {
            var chars = "abcdefghijklmnopqrstuvwxyzABCDFGHIJKLMNOPQRSTUVWXYZ_$0123456789";
            this.convert = function(char) {
                return chars.indexOf(char);
            }, this.convertInt = function(int) {
                return chars[int];
            }, this.convertDate = function(value) {
                if (typeof value == "string") {
                    var a = /^(\d{4})-(\d{2})-(\d{2})$/.exec(value);
                    if (a) {
                        var utcMilliseconds = Date.UTC(+a[1], +a[2] - 1, +a[3]);
                        return new Date(utcMilliseconds);
                    }
                }
                return value;
            }, this.showStatusMessage = function(textStatus, delay) {
                var statusSection = $("#statusSection");
                statusSection.find("p").html(textStatus), statusSection.removeClass("hidden").addClass("onviewport"), window.setTimeout(function() {
                    var statusSection = $("#statusSection");
                    statusSection.find("p").html(""), statusSection.removeClass("onviewport").addClass("hidden");
                }, delay || 2e3);
            }, this.daysBetween = function(first, second) {
                var one = new Date(first.getFullYear(), first.getMonth(), first.getDate()), two = new Date(second.getFullYear(), second.getMonth(), second.getDate()), millisecondsPerDay = 864e5, millisBetween = two.getTime() - one.getTime(), days = millisBetween / millisecondsPerDay;
                return Math.floor(days);
            }, this.minutesBetween = function(first, second) {
                var one = new Date(first.getFullYear(), first.getMonth(), first.getDate(), first.getHours(), first.getMinutes(), first.getSeconds(), first.getMilliseconds()), two = new Date(second.getFullYear(), second.getMonth(), second.getDate(), second.getHours(), second.getMinutes(), second.getSeconds(), second.getMilliseconds()), millisecondsPerMinute = 6e4, millisBetween = two.getTime() - one.getTime(), minutes = millisBetween / millisecondsPerMinute;
                return Math.floor(minutes);
            }, this.convertMinutesStringToArray = function(minutesString) {
                var minutes = [];
                if (minutesString) for (var i = 0; i < minutesString.length; i++) minutes.push(this.convert(minutesString[i]));
                return minutes;
            }, this.getHours = function(times, mit, zeroDay, date) {
                var hours = [];
                if (times && date >= zeroDay) {
                    var dayPrefix = this.getDayPrefix(date), year0 = this.convertInt(Number(date.getFullYear().toString().substr(0, 2))), year1 = this.convertInt(Number(date.getFullYear().toString().substr(2, 2))), month = this.convertInt(date.getMonth() + 1), day = this.convertInt(date.getDate()), datePrefix = year0 + year1 + month + day, hoursAndMinutes = times[datePrefix];
                    hoursAndMinutes || (hoursAndMinutes = times[dayPrefix]);
                    if (hoursAndMinutes === "-") return hours;
                    var properties = hoursAndMinutes.split(";"), hoursObject = {};
                    properties.forEach(function(property) {
                        var tup = property.split(":");
                        hoursObject[tup[0]] = tup[1];
                    });
                    for (var i = 0; i < 24; i++) {
                        var sequenceNumber = hoursObject[this.convertInt(i)];
                        sequenceNumber && hours.push({
                            h: i,
                            ms: this.convertMinutesStringToArray(mit[sequenceNumber])
                        });
                    }
                }
                return hours;
            }, this.getNextTime = function(hours, now) {
                var result = {
                    h: 30,
                    m: 100
                }, actHour = now.getHours(), actMinute = now.getMinutes(), i = 0, hasResult = !1;
                while (i < hours.length && !hasResult) {
                    if (hours[i].h >= actHour) {
                        var j = 0;
                        while (j < hours[i].ms.length && !hasResult) hours[i].h === actHour && hours[i].ms[j] >= actMinute ? (result.h = hours[i].h, result.m = hours[i].ms[j], hasResult = !0) : hours[i].h > actHour && (result.h = hours[i].h, result.m = hours[i].ms[j], hasResult = !0), j += 1;
                    }
                    i += 1;
                }
                return result;
            }, this.sorterByFieldName = function(a, b, fieldName) {
                return a[fieldName] < b[fieldName] ? -1 : a[fieldName] > b[fieldName] ? 1 : 0;
            }, this.changeHtmlEscape = function(value) {
                return value && (value = value.replace(/&aacute;/g, "á").replace(/&Aacute;/g, "Á").replace(/&eacute;/g, "é").replace(/&Eacute;/g, "É").replace(/&Oacute;/g, "Ó").replace(/&oacute;/g, "ó").replace(/&Ouml;/g, "Ö").replace(/&ouml;/g, "ö").replace(/&Otilde;/g, "Ő").replace(/&otilde;/g, "ő").replace(/&Uacute;/g, "Ú").replace(/&uacute;/g, "ú").replace(/&Uuml;/g, "Ü").replace(/&uuml;/g, "ü").replace(/&Ucirc;/g, "Ű").replace(/&ucirc;/g, "ű").replace(/&Iacute;/g, "Í").replace(/&iacute;/g, "í")), value;
            }, this.isOnline = function() {
                return !0;
            }, this.setStopViewData = function(stops, routes, colors, lat, lon) {
                var near = !1;
                lat && lon && (near = !0);
                if (stops.length > 0) {
                    var routesObj = {};
                    for (var i = 0; i < routes.length; i++) routesObj[routes[i].id] = {
                        id: routes[i].id,
                        sn: routes[i].sn,
                        b: colors[this.convert(routes[i].c)].b,
                        t: colors[this.convert(routes[i].c)].t,
                        si: routes[i].si
                    };
                    routes = null;
                    for (var i = 0; i < stops.length; i++) {
                        stops[i].routeNames = [];
                        for (var j = 0; j < stops[i].r.length; j++) {
                            var viewRoute = angular.copy(routesObj[stops[i].r[j]]);
                            viewRoute.di = viewRoute.si.indexOf(stops[i].id) > -1 ? settings.direction_in() : settings.direction_out(), viewRoute.si = null, stops[i].routeNames.push(viewRoute);
                        }
                        near && (stops[i].distance = geohelper.getDistance({
                            la: lat,
                            lo: lon
                        }, {
                            la: stops[i].la,
                            lo: stops[i].lo
                        }));
                    }
                }
                return stops;
            }, this.getDayName = function(date) {
                var day = date.getDay(), days = [ "Vasárnap", "Hétfő", "Kedd", "Szerda", "Csütörtök", "Péntek", "Szombat" ];
                return days[day];
            }, this.getDayPrefix = function(date) {
                var day = date.getDay(), prefixes = [ "u", "w", "w", "w", "w", "f", "a" ];
                return prefixes[day];
            };
        };
        return new Helper;
    } ]);
});