

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>", 
      "<div {countattr}>{n}</div><div {textattr}> helpful votes</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> question solved</div>", 
      "<div {countattr}>{n}</div><div {textattr}> questions solved</div>"
    ], 
    "A user with that email address already exists.": "A user with that email address already exists.", 
    "A user with that username exists": "A user with that username exists", 
    "All My Questions": "All My Questions", 
    "Already registered? Sign in": "Already registered? Sign in", 
    "An account lets you answer questions, track contributions and receive alerts.": "An account lets you answer questions, track contributions and receive alerts.", 
    "Another helper has answered this question, please choose another.": "Another helper has answered this question, please choose another.", 
    "Answer Questions": "Answer Questions", 
    "Answer a Question": "Answer a Question", 
    "Answered Questions": "Answered Questions", 
    "Audio/Music/FMRadio": "Audio/Music/FMRadio", 
    "Be aware that you will lose your history when you sign in to your account.": "Be aware that you will lose your history when you sign in to your account.", 
    "Browser/Download": "Browser/Download", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Camera/Gallery/Video", 
    "Can't change this field.": "Can't change this field.", 
    "Cancel": "Cancel", 
    "Cancel Sign Up": "Cancel Sign Up", 
    "Cellular Data/WiFi/Bluetooth": "Cellular Data/WiFi/Bluetooth", 
    "Choose a category": "Choose a category", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!", 
    "Clock/Alarm": "Clock/Alarm", 
    "Close": "Close", 
    "Confirm Account": "Confirm Account", 
    "Continue": "Continue", 
    "Create account or sign in": "Create account or sign in", 
    "Device": "Device", 
    "Dialer/Contacts": "Dialer/Contacts", 
    "Don't have an account? Register": "Don't have an account? Register", 
    "Done": "Done", 
    "Email Address": "Email Address", 
    "Email/Calendar": "Email/Calendar", 
    "Failed": "Failed", 
    "Forgot your password?": "Forgot your password?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.", 
    "Get a Buddy to help you with your device": "Get a Buddy to help you with your device", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Go to the New tab to answer some questions. We'll keep track of them here.", 
    "Have Answers?": "Have Answers?", 
    "Help Article": "Help Article", 
    "Help other users around the world": "Help other users around the world", 
    "Incompatible version": "Incompatible version", 
    "Keyboard": "Keyboard", 
    "Language": "Language", 
    "Last sync:": "Last sync:", 
    "Load more": "Load more", 
    "Maps/GPS": "Maps/GPS", 
    "Marketplace/Apps Install": "Marketplace/Apps Install", 
    "My Profile": "My Profile", 
    "My Question": "My Question", 
    "My Questions": "My Questions", 
    "My list": "My list", 
    "My preferences": "My preferences", 
    "New": "New", 
    "No active questions": "No active questions", 
    "No matching user setting found.": "No matching user setting found.", 
    "OK": "OK", 
    "Ok": "Ok", 
    "Operator": "Operator", 
    "Other": "Other", 
    "Performance": "Performance", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.", 
    "Previously Answered": "Previously Answered", 
    "Quit": "Quit", 
    "Reset Password": "Reset Password", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Sending\u2026", 
    "Settings": "Settings", 
    "Sign In": "Sign In", 
    "Sign in to answer questions from the Mozilla community.": "Sign in to answer questions from the Mozilla community.", 
    "Sign in to reply": "Sign in to reply", 
    "Solution \u2713": "Solution \u2713", 
    "Storage/SD card": "Storage/SD card", 
    "Support": "Support", 
    "System Updates": "System Updates", 
    "Thank you for your question!": "Thank you for your question!", 
    "There was a problem with Buddy Up, please try again.": "There was a problem with Buddy Up, please try again.", 
    "This field is required.": "This field is required.", 
    "This solved my question": "This solved my question", 
    "This will close the question and let your buddy know you no longer need help.": "This will close the question and let your buddy know you no longer need help.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.", 
    "Top Helpers this Week": "Top Helpers this Week", 
    "Unable to generate username.": "Unable to generate username.", 
    "Unknown error: \"{error}\"": "Unknown error: \"{error}\"", 
    "Unsupported Language": "Unsupported Language", 
    "User not found.": "User not found.", 
    "Username": "Username", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Usernames may only be letters, numbers, \".\" and \"-\".", 
    "We can help<br>Ask us anything!": "We can help<br>Ask us anything!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.", 
    "We've sent a welcome email to:": "We've sent a welcome email to:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "We've sent you an email. Just follow the link in the email to reset your password.", 
    "Whoops!": "Whoops!", 
    "Yay, you're almost done!": "Yay, you're almost done!", 
    "You are not online, please check your connection.": "You are not online, please check your connection.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "You'll get a notification as soon as a Buddy jumps in to the rescue.", 
    "just now": "just now", 
    "x hours ago": "x hours ago", 
    "{n} day ago": [
      "{n} day ago", 
      "{n} days ago"
    ], 
    "{n} helpful vote": [
      "{n} helpful vote", 
      "{n} helpful votes"
    ], 
    "{n} minute ago": [
      "{n} minute ago", 
      "{n} minutes ago"
    ], 
    "{n} question solved": [
      "{n} question solved", 
      "{n} questions solved"
    ], 
    "{user} chose your answer as a solution": "{user} chose your answer as a solution", 
    "{user} left a comment on your question": "{user} left a comment on your question"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "N j, Y, P", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y"
    ], 
    "DATE_FORMAT": "N j, Y", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y"
    ], 
    "DECIMAL_SEPARATOR": ".", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "F j", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "m/d/Y P", 
    "SHORT_DATE_FORMAT": "m/d/Y", 
    "THOUSAND_SEPARATOR": ",", 
    "TIME_FORMAT": "P", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

