

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> voto \u00fatil</div>", 
      "<div {countattr}>{n}</div><div {textattr}> votos \u00fatiles</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> consulta resuelta</div>", 
      "<div {countattr}>{n}</div><div {textattr}> consultas resueltas</div>"
    ], 
    "A user with that email address already exists.": "Ya existe un usuario con esa direcci\u00f3n de correo electr\u00f3nico.", 
    "A user with that username exists": "Ya existe ese nombre de usuario", 
    "All My Questions": "Todas mis consultas", 
    "Already registered? Sign in": "\u00bfYa est\u00e1s registrado? Inicia sesi\u00f3n.", 
    "An account lets you answer questions, track contributions and receive alerts.": "Una cuenta te permite responder consultas, seguir contribuciones y recibir alertas.", 
    "Another helper has answered this question, please choose another.": "Otro ayudante ha respondido a esta pregunta. Elige otra, por favor.", 
    "Answer Questions": "Responder consultas", 
    "Answer a Question": "Responder a una consulta", 
    "Answer questions": "Responder consultas", 
    "Answered Questions": "Consultas respondidas", 
    "Ask a Question": "Haz una pregunta", 
    "Audio/Music/FMRadio": "Audio/M\u00fasica/Radio FM", 
    "Be aware that you will lose your history when you sign in to your account.": "Ten en cuenta que perder\u00e1s tu historial cuando inicies sesi\u00f3n con tu cuenta.", 
    "Browser/Download": "Navegador web/Descargas", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "Actualmente, BuddyUp no admite \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "C\u00e1mara/Galer\u00eda/Video", 
    "Can't change this field.": "Este campo no se puede modificar.", 
    "Cancel": "Cancelar", 
    "Cancel Sign Up": "Cancelar registro", 
    "Cellular Data/WiFi/Bluetooth": "Datos m\u00f3viles/Wi-Fi/Bluetooth", 
    "Choose a category": "Elige una categor\u00eda", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Haz clic en el enlace de tu correo electr\u00f3nico para hacernos saber que ha llegado al lugar correcto. Despu\u00e9s, vuelve a BuddyUp y \u00a1haz felices a otros usuarios!", 
    "Clock/Alarm": "Reloj/Alarma", 
    "Close": "Cerrar", 
    "Confirm Account": "Confirmar cuenta", 
    "Continue": "Continuar", 
    "Create Account": "Crear cuenta", 
    "Create account or sign in": "Crear cuenta o iniciar sesi\u00f3n", 
    "Device": "Dispositivo", 
    "Dialer/Contacts": "Teclado/Contactos", 
    "Don't have an account? Register": "\u00bfNo tienes una cuenta? Reg\u00edstrate", 
    "Done": "Hecho", 
    "Email Address": "Direcci\u00f3n de correo electr\u00f3nico", 
    "Email/Calendar": "Correo electr\u00f3nico/Calendario", 
    "Failed": "Error", 
    "Forgot your password?": "\u00bfOlvidaste tu contrase\u00f1a?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "\u00bfHas olvidado tu contrase\u00f1a? No te preocupes. Introduce debajo tu nombre de usuario y te enviaremos instrucciones para configurar una nueva.", 
    "Get a Buddy to help you with your device": "Consigue un \"Buddy\" para que te ayude con tu dispositivo", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Ve a la Nueva pesta\u00f1a para responder consultas. All\u00ed haremos su seguimiento.", 
    "Has your question been solved?": "\u00bfSe ha resuelto tu consulta?", 
    "Have Answers?": "\u00bfTienes respuestas?", 
    "Have Questions?": "\u00bfTienes preguntas?", 
    "Help Article": "Art\u00edculo de ayuda", 
    "Help other users around the world": "Ayuda a otros usuarios en todo el mundo", 
    "Incompatible version": "Versi\u00f3n incompatible", 
    "Keyboard": "Teclado", 
    "Language": "Idioma", 
    "Last sync:": "\u00daltima sincronizaci\u00f3n:", 
    "Load more": "Cargar m\u00e1s", 
    "Maps/GPS": "Mapas/GPS", 
    "Marketplace/Apps Install": "Marketplace/Instalaci\u00f3n de aplicaciones", 
    "My Profile": "Mi perfil", 
    "My Question": "Mi consulta", 
    "My Questions": "Mis consultas", 
    "My list": "Mi lista", 
    "My preferences": "Mis preferencias", 
    "New": "Nueva", 
    "No active questions": "No hay consultas activas", 
    "No matching user setting found.": "No se ha encontrado ninguna configuraci\u00f3n de usuario.", 
    "No questions": "No hay consultas", 
    "OK": "Aceptar", 
    "Ok": "Ok", 
    "Operator": "Operador", 
    "Other": "Otros", 
    "Password": "Contrase\u00f1a", 
    "Performance": "Rendimiento", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Por favor, haz tus consultas en ingl\u00e9s o visita la p\u00e1gina de <a href=\"http://support.mozilla.org/es/\">Ayuda de Mozilla</a> para m\u00e1s informaci\u00f3n.", 
    "Previously Answered": "Respondida anteriormente", 
    "Quit": "Salir", 
    "Reset Password": "Restablecer contrase\u00f1a", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Enviando\u2026", 
    "Settings": "Configuraci\u00f3n", 
    "Sign In": "Iniciar sesi\u00f3n", 
    "Sign in to answer questions from Firefox OS users.": "Inicia sesi\u00f3n para responder consultas de los usuarios de Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "Inicia sesi\u00f3n para responder consultas de la comunidad de Mozilla.", 
    "Sign in to reply": "Inicia sesi\u00f3n para responder", 
    "Solution \u2713": "Resuelto \u2713", 
    "Storage/SD card": "Almacenamiento/Tarjeta SD", 
    "Support": "Ayuda", 
    "System Updates": "Actualizaciones del sistema", 
    "Thank you for your question!": "\u00a1Gracias por tu consulta!", 
    "There was a problem with Buddy Up, please try again.": "Hubo un problema con Buddy Up. Por favor, int\u00e9ntalo de nuevo.", 
    "This field is required.": "Este campo es obligatorio.", 
    "This solved my question": "Esto resuelve mi pregunta", 
    "This will close the question and let your buddy know you no longer need help.": "Esto cerrar\u00e1 la consulta y le har\u00e1 saber al otro usuario que ya no necesitas ayuda.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "\u00bfDemasiadas consultas? Usa la configuraci\u00f3n de m\u00e1s abajo para reducir la lista \"Responde a una consulta\".", 
    "Top Helpers this Week": "Top ayudantes esta semana", 
    "Unable to generate username.": "No se ha podido generar ese nombre de usuario.", 
    "Unknown error: \"{error}\"": "Error desconocido: \"{error}\"", 
    "Unsupported Language": "Idioma no admitido", 
    "User not found.": "Usuario no encontrado.", 
    "Username": "Nombre de usuario", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Los nombres de usuario solo pueden contener letras, n\u00fameros, \".\" y \"-\".", 
    "We can help<br>Ask us anything!": "Podemos ayudarte<br>\u00a1Preg\u00fantanos lo que sea!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Lo sentimos, pero BuddyUp no se puede instalar en esta versi\u00f3n de Firefox OS. Por favor, cierra la ventana para volver a la pantalla de inicio.", 
    "We've sent a welcome email to:": "Hemos enviado un correo electr\u00f3nico de bienvenida a:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Te hemos enviado un correo electr\u00f3nico. Sigue el enlace del correo para restablecer la contrase\u00f1a.", 
    "Whoops!": "\u00a1Ups!", 
    "Write your message\u2026": "Escribe tu mensaje...", 
    "Yay, you're almost done!": "\u00a1Bien, casi has terminado!", 
    "You are not online, please check your connection.": "No est\u00e1s conectado. Por favor, comprueba tu conexi\u00f3n.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Recibir\u00e1s una notificaci\u00f3n en cuanto alg\u00fan Buddy acuda al rescate.", 
    "just now": "justo ahora", 
    "x hours ago": "hace x horas", 
    "{n} day ago": [
      "hace {n} d\u00eda", 
      "hace {n} d\u00edas"
    ], 
    "{n} helpful vote": [
      "{n} voto \u00fatil", 
      "{n} votos \u00fatiles"
    ], 
    "{n} hour ago": [
      "hace {n} hora", 
      "hace {n} horas"
    ], 
    "{n} minute ago": [
      "hace {n} minuto", 
      "hace {n} minutos"
    ], 
    "{n} question solved": [
      "{n} consulta resuelta", 
      "{n} consultas resueltas"
    ], 
    "{user} chose your answer as a solution": "{user} eligi\u00f3 tu respuesta como soluci\u00f3n", 
    "{user} left a comment on your question": "{user} dej\u00f3 un comentario en tu consulta"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j \\d\\e F \\d\\e Y \\a \\l\\a\\s H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S", 
      "%d/%m/%Y %H:%M:%S.%f", 
      "%d/%m/%Y %H:%M", 
      "%d/%m/%y %H:%M:%S", 
      "%d/%m/%y %H:%M:%S.%f", 
      "%d/%m/%y %H:%M", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j \\d\\e F \\d\\e Y", 
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y", 
      "%d/%m/%y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j \\d\\e F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i", 
    "SHORT_DATE_FORMAT": "d/m/Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F \\d\\e Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

