

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "Answer Questions": "Suallar\u0131 Cavablay\u0131n", 
    "Answer a Question": "Sual\u0131 Cavablay\u0131n", 
    "Answered Questions": "Cavablanm\u0131\u015f Suallar", 
    "Ask a Question": "Sual Ver", 
    "Audio/Music/FMRadio": "S\u0259s/Musiqi/FMRadio", 
    "Browser/Download": "S\u0259yyah/Endirm\u0259", 
    "Camera/Gallery/Video": "Kamera/Qalereya/Video", 
    "Cancel": "L\u0259\u011fv et", 
    "Cancel Sign Up": "Qeydiyyat\u0131 L\u0259\u011fv et", 
    "Cellular Data/WiFi/Bluetooth": "Mobil Data/WiFi/Bluetooth", 
    "Clock/Alarm": "Saat/Alarm", 
    "Close": "Qapat", 
    "Confirm Account": "Hesab\u0131 T\u0259sdiql\u0259yin", 
    "Continue": "Davam et", 
    "Create Account": "Hesab yarat", 
    "Create account or sign in": "Yesab yarad\u0131n v\u0259 ya daxil olun", 
    "Device": "Cihaz", 
    "Don't have an account? Register": "Hesab\u0131n\u0131z yoxdur? Qeyd olun", 
    "Email Address": "E-po\u00e7t \u00dcnvan\u0131", 
    "Email/Calendar": "E-po\u00e7t/T\u0259qvim", 
    "Failed": "M\u00fcmk\u00fcn olmad\u0131", 
    "Forgot your password?": "Parolunuzu unutdunuz?", 
    "Have Answers?": "Cavablar\u0131n\u0131z var?", 
    "Have Questions?": "Sual\u0131n\u0131z var?", 
    "Keyboard": "Klaviatura", 
    "Language": "Dil", 
    "Maps/GPS": "X\u0259rit\u0259/GPS", 
    "Marketplace/Apps Install": "Marketplace/T\u0259tbiq qurma", 
    "My Profile": "M\u0259nim Profil", 
    "My Question": "M\u0259nim Sual\u0131m", 
    "My list": "M\u0259nim siyah\u0131m", 
    "New": "Yeni", 
    "OK": "Tamam", 
    "Ok": "Tamam", 
    "Other": "Dig\u0259r", 
    "Password": "Parol", 
    "Performance": "Performans", 
    "Quit": "\u00c7\u0131x", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "G\u00f6nd\u0259rilir\u2026", 
    "Settings": "T\u0259nziml\u0259m\u0259l\u0259r", 
    "Sign In": "Daxil ol", 
    "Solution \u2713": "H\u0259ll \u2713", 
    "Storage/SD card": "Yadda\u015f/SD kard", 
    "Support": "D\u0259st\u0259k", 
    "System Updates": "Sistem Yenil\u0259m\u0259l\u0259ri", 
    "This field is required.": "Bu s\u0259tir t\u0259l\u0259b olunur.", 
    "This solved my question": "Bu m\u0259nim sual\u0131m\u0131 h\u0259ll etdi", 
    "Unknown error: \"{error}\"": "Bilinm\u0259y\u0259n x\u0259ta: \"{error}\"", 
    "Username": "\u0130stifad\u0259\u00e7i ad\u0131", 
    "Whoops!": "Ayyy!", 
    "just now": "indic\u0259", 
    "{n} day ago": [
      "{n} g\u00fcn \u0259vv\u0259l", 
      "{n} g\u00fcn \u0259vv\u0259l"
    ], 
    "{n} hour ago": [
      "{n} saat \u0259vv\u0259l", 
      "{n} saat \u0259vv\u0259l"
    ], 
    "{n} minute ago": [
      "{n} d\u0259qiq\u0259 \u0259vv\u0259l", 
      "{n} d\u0259qiq\u0259 \u0259vv\u0259l"
    ]
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j E Y \u0433. G:i", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%d.%m.%y %H:%M:%S", 
      "%d.%m.%y %H:%M:%S.%f", 
      "%d.%m.%y %H:%M", 
      "%d.%m.%y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j E Y \u0433.", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y", 
      "%d.%m.%y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d.m.Y H:i", 
    "SHORT_DATE_FORMAT": "d.m.Y", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "G:i", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y \u0433."
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

