

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u09b8\u09b9\u09be\u09af\u09bc\u0995 \u09ad\u09cb\u099f</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u09b8\u09b9\u09be\u09af\u09bc\u0995 \u09ad\u09cb\u099f\u0997\u09c1\u09b2\u09bf</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u09b8\u09ae\u09be\u09a7\u09be\u09a8 \u09b9\u09df\u09c7 \u0997\u09c7\u099b\u09c7</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u0997\u09c1\u09b2\u09bf\u09b0 \u09b8\u09ae\u09be\u09a7\u09be\u09a8 \u09b9\u09df\u09c7 \u0997\u09c7\u099b\u09c7</div>"
    ], 
    "A user with that email address already exists.": "\u098f\u0987 \u0987\u09ae\u09c7\u0987\u09b2 \u098f\u09a1\u09cd\u09b0\u09c7\u09b8\u09c7\u09b0 \u09ac\u09cd\u09af\u09be\u09ac\u09b9\u09be\u09b0\u0995\u09be\u09b0\u09c0 \u0987\u09a4\u09bf\u09ae\u09a7\u09cd\u09af\u09c7\u0987 \u0986\u099b\u09c7\u09a8\u0964", 
    "A user with that username exists": "\u098f\u0987 \u0987\u0989\u099c\u09be\u09b0\u09a8\u09c7\u09ae\u09c7 \u098f\u0995\u099c\u09a8 \u09ac\u09cd\u09af\u09be\u09ac\u09b9\u09be\u09b0\u0995\u09be\u09b0\u09c0 \u0987\u09a4\u09bf\u09ae\u09a7\u09cd\u09af\u09c7\u0987 \u0986\u099b\u09c7\u09a8", 
    "All My Questions": "\u0986\u09ae\u09be\u09b0 \u09b8\u09ae\u09b8\u09cd\u09a4 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8", 
    "Already registered? Sign in": "\u0987\u09a4\u09bf\u09ae\u09a7\u09cd\u09af\u09c7 \u09b0\u09c7\u099c\u09bf\u09b8\u09cd\u099f\u09be\u09b0 \u0995\u09b0\u09c7\u099b\u09c7\u09a8? \u09b8\u09be\u0987\u09a8 \u0987\u09a8", 
    "An account lets you answer questions, track contributions and receive alerts.": "\u098f\u0995\u099f\u09bf \u0985\u09cd\u09af\u09be\u0995\u09be\u0989\u09a8\u09cd\u099f \u09a5\u09be\u0995\u09b2\u09c7 \u0986\u09aa\u09a8\u09bf \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0, \u0985\u09ac\u09a6\u09be\u09a8 \u09a8\u09bf\u09b0\u09c0\u0995\u09cd\u09b7\u09a3 \u0993 \u09b8\u09a4\u09b0\u09cd\u0995\u09a4\u09be \u09b8\u0982\u0997\u09cd\u09b0\u09b9 \u0995\u09b0\u09a4\u09c7 \u09aa\u09be\u09b0\u09ac\u09c7\u09a8\u0964", 
    "Another helper has answered this question, please choose another.": "\u0985\u09a8\u09cd\u09af \u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af\u0995\u09be\u09b0\u09c0 \u098f\u0987 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09bf\u09df\u09c7\u099b\u09c7\u09a8, \u09a6\u09df\u09be \u0995\u09b0\u09c7 \u0985\u09a8\u09cd\u09af \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u09a8\u09bf\u09b0\u09cd\u09ac\u09be\u099a\u09a8 \u0995\u09b0\u09c1\u09a8\u0964", 
    "Answer Questions": "\u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09bf\u09a8", 
    "Answer a Question": "\u098f\u0995\u099f\u09be \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09be\u0993", 
    "Answer questions": "\u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09bf\u09a8", 
    "Answered Questions": "\u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09c7\u0993\u09df\u09be \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8", 
    "Ask a Question": "\u098f\u0995\u099f\u09bf \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u099c\u09bf\u099c\u09cd\u099e\u09be\u09b8\u09be \u0995\u09b0\u09c1\u09a8", 
    "Audio/Music/FMRadio": "\u0985\u09a1\u09bf\u0993/Music/FMRadio", 
    "Be aware that you will lose your history when you sign in to your account.": "\u09b8\u09be\u09ac\u09a7\u09be\u09a8 \u09af\u0996\u09a8-\u0987 \u0985\u09cd\u09af\u09be\u0995\u09be\u0989\u09a8\u09cd\u099f\u09c7 \u09b8\u09be\u0987\u09a8 \u0987\u09a8 \u0995\u09b0\u09ac\u09c7\u09a8 \u0986\u09aa\u09a8\u09be\u09b0 \u09b9\u09bf\u09b8\u09cd\u099f\u09cd\u09b0\u09bf \u09b9\u09be\u09b0\u09bf\u09df\u09be \u09af\u09be\u09ac\u09c7\u0964", 
    "Browser/Download": "\u09ac\u09cd\u09b0\u09be\u0989\u099c\u09be\u09b0/Download", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp \u098f\u0987\u09ae\u09c1\u09b9\u09c2\u09b0\u09cd\u09a4\u09c7 \u09b8\u09be\u09aa\u09cb\u09b0\u09cd\u099f\u09c7\u09a1 \u09a8\u09df \"<span id=\"language\"></span>\"\u0964", 
    "Camera/Gallery/Video": "\u0995\u09cd\u09af\u09be\u09ae\u09c7\u09b0\u09be/Gallery/Video", 
    "Can't change this field.": "\u09ab\u09bf\u09b2\u09cd\u09a1\u099f\u09bf \u09aa\u09be\u09b2\u099f\u09be\u09a8\u09cb \u09b8\u09ae\u09cd\u09ad\u09ad \u09a8\u09df\u0964", 
    "Cancel": "\u09ac\u09be\u09a4\u09bf\u09b2 \u0995\u09b0\u09c1\u09a8", 
    "Cancel Sign Up": "\u09b8\u09be\u0987\u09a8 \u0986\u09aa \u09ac\u09be\u09a4\u09bf\u09b2 \u0995\u09b0\u09c1\u09a8", 
    "Cellular Data/WiFi/Bluetooth": "\u09b8\u09c7\u09b2\u09c1\u09b2\u09be\u09b0 \u09a1\u09c7\u099f\u09be/WiFi/Bluetooth", 
    "Choose a category": "\u098f\u0995\u099f\u09be \u09b6\u09cd\u09b0\u09c7\u09a3\u09c0 \u09a8\u09bf\u09b0\u09cd\u09ac\u09be\u099a\u09a8 \u0995\u09b0\u09c1\u09a8", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "\u0987\u09ae\u09c7\u0987\u09b2-\u098f\u09b0 \u09b2\u09bf\u0999\u09cd\u0995\u099f\u09bf\u09a4\u09c7 \u0995\u09cd\u09b2\u09bf\u0995 \u0995\u09b0\u09c7 \u0986\u09ae\u09be\u09a6\u09c7\u09b0 \u09ac\u09c1\u099d\u09a4\u09c7 \u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af \u0995\u09b0\u09c1\u09a8 \u09b8\u09c7\u099f\u09bf \u09a0\u09bf\u0995 \u099c\u09be\u09df\u0997\u09be\u09df \u09aa\u09c1\u0981\u099b\u09c7\u099b\u09c7\u0964 \u098f\u09b0\u09aa\u09b0, BuddyUp-\u098f \u09ab\u09bf\u09b0\u09c7 \u0986\u09b8\u09c1\u09a8 \u0993 \u0985\u09a8\u09cd\u09af \u09ac\u09cd\u09af\u09be\u09ac\u09b9\u09be\u09b0\u0995\u09be\u09b0\u09c0\u09a6\u09c7\u09b0 \u0996\u09c1\u09b6\u09bf \u0995\u09b0\u09c1\u09a8!", 
    "Clock/Alarm": "\u0998\u09dc\u09bf/Alarm", 
    "Close": "\u09ac\u09a8\u09cd\u09a7 \u0995\u09b0\u09c1\u09a8", 
    "Confirm Account": "\u0986\u09aa\u09a8\u09be\u09b0 \u0985\u09cd\u09af\u09be\u0995\u09be\u0989\u09a8\u09cd\u099f \u09a8\u09bf\u09b6\u09cd\u099a\u09bf\u09a4 \u0995\u09b0\u09c1\u09a8", 
    "Continue": "\u098f\u0997\u09bf\u09df\u09c7 \u099a\u09b2\u09c1\u09a8", 
    "Create Account": "\u098f\u0995\u09be\u0989\u09a8\u09cd\u099f \u09a4\u09c8\u09b0\u09bf \u0995\u09b0\u09c1\u09a8", 
    "Create account or sign in": "\u0985\u09cd\u09af\u09be\u0995\u09be\u0989\u09a8\u09cd\u099f \u09a4\u09c8\u09b0\u09bf \u09ac\u09be \u09b8\u09be\u0987\u09a8 \u0987\u09a8", 
    "Device": "\u09a1\u09bf\u09ad\u09be\u0987\u09b8", 
    "Dialer/Contacts": "\u09a1\u09be\u09af\u09bc\u09be\u09b2\u09be\u09b0/Contacts", 
    "Don't have an account? Register": "\u0995\u09cb\u09a8\u09cb \u0985\u09cd\u09af\u09be\u0995\u09be\u0989\u09a8\u09cd\u099f \u09a8\u09c7\u0987? \u09b0\u09c7\u099c\u09bf\u09b8\u09cd\u099f\u09be\u09b0 \u0995\u09b0\u09c1\u09a8", 
    "Done": "\u09b8\u09ae\u09be\u09aa\u09cd\u09a4", 
    "Email Address": "\u0987-\u09ae\u09c7\u0987\u09b2 \u09a0\u09bf\u0995\u09be\u09a8\u09be", 
    "Email/Calendar": "\u0987\u09ae\u09c7\u0987\u09b2/Calendar", 
    "Failed": "\u09ac\u09cd\u09af\u09b0\u09cd\u09a5", 
    "Forgot your password?": "\u0986\u09aa\u09a8\u09be\u09b0 \u09aa\u09be\u09b8\u0993\u09df\u09be\u09b0\u09cd\u09a1 \u09ad\u09c1\u09b2\u09c7 \u0997\u09c7\u099b\u09c7\u09a8?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "\u09aa\u09be\u09b0\u09cd\u09b8\u0993\u09df\u09be\u09b0\u09cd\u09a1 \u09ad\u09c1\u09b2\u09c7 \u0997\u09c7\u099b\u09c7\u09a8? \u09ad\u09df \u09aa\u09be\u09ac\u09c7\u09a8 \u09a8\u09be\u0964 \u09a8\u09bf\u099a\u09c7 \u0986\u09aa\u09a8\u09be\u09b0 \u0987\u0989\u099c\u09be\u09b0\u09a8\u09c7\u09ae \u09a6\u09bf\u09a8 \u0986\u09ae\u09b0\u09be \u0986\u09aa\u09a8\u09be\u0995\u09c7 \u09a8\u09a4\u09c1\u09a8 \u09aa\u09be\u09b0\u09cd\u09b8\u0993\u09df\u09be\u09b0\u09cd\u09a1 \u09a8\u09bf\u09b0\u09cd\u09ac\u09be\u099a\u09a8 \u0995\u09b0\u09be\u09b0 \u09a8\u09bf\u09b0\u09cd\u09a6\u09c7\u09b6\u09be\u09ac\u09b2\u09c0 \u09aa\u09be\u099f\u09bf\u09df\u09c7 \u09a6\u09c7\u09ac\u09cb\u0964", 
    "Get a Buddy to help you with your device": "\u0986\u09aa\u09a8\u09be\u09b0 \u09a1\u09bf\u09ad\u09be\u0987\u09b8\u09c7\u09b0 \u09ac\u09cd\u09af\u09be\u09aa\u09be\u09b0\u09c7 \u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af \u0995\u09b0\u09be\u09b0 \u09ae\u09a4 \u09ac\u09a8\u09cd\u09a7\u09c1 \u09aa\u09be\u09a8", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "\u09a8\u09a4\u09c1\u09a8 \u099f\u09cd\u09af\u09be\u09ac\u09c7 \u099c\u09be\u09a8 \u0995\u09bf\u099b\u09c1 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09bf\u09a4\u09c7\u0964 \u0986\u09ae\u09b0\u09be \u098f\u0996\u09be\u09a8 \u09a5\u09c7\u0995\u09c7 \u09b8\u09c7\u0997\u09c1\u09b2\u09bf \u09a8\u09bf\u09b0\u09c0\u0995\u09cd\u09b7\u09a3 \u0995\u09b0\u09ac\u09cb\u0964", 
    "Has your question been solved?": "\u0986\u09aa\u09a8\u09be\u09b0 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u09b8\u09ae\u09be\u09a7\u09be\u09a8 \u09b9\u09af\u09bc\u09c7\u099b\u09c7 \u0995\u09bf?", 
    "Have Answers?": "\u0989\u09a4\u09cd\u09a4\u09b0 \u0986\u099b\u09c7 \u0995\u09bf?", 
    "Have Questions?": "\u0995\u09bf\u099b\u09c1 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u09b0\u09df\u09c7\u099b\u09c7 \u0995\u09bf?", 
    "Help Article": "\u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af\u0995\u09be\u09b0\u09c0 \u09aa\u09cd\u09b0\u09ac\u09a8\u09cd\u09a7", 
    "Help other users around the world": "\u09aa\u09c3\u09a5\u09bf\u09ac\u09c0\u09b0 \u0985\u09a8\u09cd\u09af\u09be\u09a8\u09cd\u09af \u09ac\u09cd\u09af\u09be\u09ac\u09b9\u09be\u09b0\u0995\u09be\u09b0\u09c0\u0995\u09c7 \u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af \u0995\u09b0\u09c1\u09a8", 
    "Incompatible version": "\u0985\u09b8\u09be\u09ae\u099e\u09cd\u099c\u09b8\u09cd\u09af\u09aa\u09c2\u09b0\u09cd\u09a3 \u09ad\u09be\u09b0\u09cd\u09b8\u09a8", 
    "Keyboard": "\u0995\u09c0\u09ac\u09cb\u09b0\u09cd\u09a1", 
    "Language": "\u09ad\u09be\u09b7\u09be", 
    "Last sync:": "\u09b8\u09b0\u09cd\u09ac\u09b6\u09c7\u09b7 \u09b8\u09bf\u0999\u09cd\u0995:", 
    "Load more": "\u0986\u09b0\u09cb \u09a6\u09c7\u0996\u09c1\u09a8", 
    "Maps/GPS": "\u09ae\u09be\u09aa/GPS", 
    "Marketplace/Apps Install": "\u09ae\u09be\u09b0\u0995\u09c7\u099f\u09aa\u09cd\u09b2\u09c7\u09b8/Apps \u0987\u09a8\u09cd\u09b8\u099f\u09b2", 
    "My Profile": "\u0986\u09ae\u09be\u09b0 \u09aa\u09cd\u09b0\u09cb\u09ab\u09be\u0987\u09b2", 
    "My Question": "\u0986\u09ae\u09be\u09b0 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8", 
    "My Questions": "\u0986\u09ae\u09be\u09b0 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09b8\u09ae\u09c2\u09b9", 
    "My list": "\u0986\u09ae\u09be\u09b0 \u09a4\u09be\u09b2\u09bf\u0995\u09be", 
    "My preferences": "\u0986\u09ae\u09be\u09b0 \u09aa\u099b\u09a8\u09cd\u09a6", 
    "New": "\u09a8\u09a4\u09c1\u09a8", 
    "No active questions": "\u0995\u09cb\u09a8\u09cb \u09b8\u0995\u09cd\u09b0\u09bf\u09af\u09bc \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u09a8\u09c7\u0987", 
    "No matching user setting found.": "\u09ac\u09c8\u09b6\u09bf\u09b7\u09cd\u099f\u09cd\u09af\u09af\u09c1\u0995\u09cd\u09a4 \u0987\u0989\u099c\u09be\u09b0 \u0996\u09c1\u0981\u099c\u09c7 \u09aa\u09be\u0993\u09df\u09be \u09af\u09be\u099a\u09cd\u099b\u09c7 \u09a8\u09be\u0964", 
    "No questions": "\u0995\u09cb\u09a8\u09cb \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u09a8\u09c7\u0987", 
    "OK": "\u09a0\u09bf\u0995 \u0986\u099b\u09c7", 
    "Ok": "\u09a0\u09bf\u0995 \u0986\u099b\u09c7", 
    "Operator": "\u0985\u09aa\u09be\u09b0\u09c7\u099f\u09b0", 
    "Other": "\u0985\u09a8\u09cd\u09af\u09be\u09a8\u09cd\u09af", 
    "Password": "\u09aa\u09be\u09b8\u0993\u09df\u09be\u09b0\u09cd\u09a1", 
    "Performance": "\u0995\u09b0\u09cd\u09ae\u0995\u09cd\u09b7\u09ae\u09a4\u09be", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "\u09a6\u09df\u09be \u0995\u09b0\u09c7 \u0987\u0982\u09b0\u09be\u099c\u09c0\u09a4\u09c7 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u0995\u09b0\u09c1\u09a8, \u09ac\u09be \u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af\u09c7\u09b0 \u099c\u09a8\u09cd\u09af \u09af\u09be\u09a8 <ahref=\"http://support.mozilla.org\"> http://support.mozilla.org </a>\u0964", 
    "Previously Answered": "\u0986\u0997\u09c7 \u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09c7\u0993\u09df\u09be \u09b9\u09df\u09c7\u099b\u09c7", 
    "Quit": "\u09aa\u09cd\u09b0\u09b8\u09cd\u09a5\u09be\u09a8", 
    "Reset Password": "\u09aa\u09be\u09b8\u0993\u09df\u09be\u09b0\u09cd\u09a1 \u09aa\u09c1\u09a8\u09b0\u09be\u09df \u09a8\u09bf\u09b0\u09cd\u09a7\u09be\u09b0\u09a3 \u0995\u09b0\u09c1\u09a8", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "\u09aa\u09be\u09a0\u09be\u09a8\u09cb \u09b9\u099a\u09cd\u099b\u09c7...", 
    "Settings": "\u09b8\u09c7\u099f\u09bf\u0982\u09b8", 
    "Sign In": "\u09b8\u09be\u0987\u09a8 \u0987\u09a8", 
    "Sign in to answer questions from Firefox OS users.": "\u09b8\u09be\u0987\u09a8 \u0987\u09a8 \u0995\u09b0\u09c1\u09a8 Firefox OS \u09ac\u09cd\u09af\u09be\u09ac\u09b9\u09be\u09b0\u0995\u09be\u09b0\u09c0\u09b0 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09bf\u09a4\u09c7\u0964", 
    "Sign in to answer questions from the Mozilla community.": "Mozilla \u0995\u09ae\u09bf\u0989\u09a8\u09bf\u099f\u09bf\u09b0 \u09aa\u0995\u09cd\u09b7 \u09a5\u09c7\u0995\u09c7 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0 \u09a6\u09bf\u09a4\u09c7 \u09b8\u09be\u0987\u09a8 \u0987\u09a8 \u0995\u09b0\u09c1\u09a8\u0964", 
    "Sign in to reply": "\u09b0\u09bf\u09aa\u09cd\u09b2\u09be\u0987 \u0995\u09b0\u09be\u09b0 \u099c\u09a8\u09cd\u09af \u09b8\u09be\u0987\u09a8 \u0987\u09a8 \u0995\u09b0\u09c1\u09a8", 
    "Solution \u2713": "\u09b8\u09ae\u09be\u09a7\u09be\u09a8 \u2713", 
    "Storage/SD card": "\u09b8\u0982\u0997\u09cd\u09b0\u09b9\u09b8\u09cd\u09a5\u09b2/\u098f\u09b8\u09a1\u09bf \u0995\u09be\u09b0\u09cd\u09a1", 
    "Support": "\u09b8\u09b9\u09be\u09df\u09a4\u09be", 
    "System Updates": "\u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae \u0986\u09aa\u09a1\u09c7\u099f", 
    "Thank you for your question!": "\u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u0995\u09b0\u09be\u09b0 \u099c\u09a8\u09cd\u09af \u09a7\u09a8\u09cd\u09af\u09ac\u09be\u09a6!", 
    "There was a problem with Buddy Up, please try again.": "\u09ac\u09be\u09a1\u09bf \u0986\u09aa \u098f\u09b0 \u09b8\u0999\u09cd\u0997\u09c7 \u098f\u0995\u099f\u09bf \u09b8\u09ae\u09b8\u09cd\u09af\u09be \u099b\u09bf\u09b2, \u09a6\u09df\u09be \u0995\u09b0\u09c7 \u0986\u09ac\u09be\u09b0 \u099a\u09c7\u09b7\u09cd\u099f\u09be \u0995\u09b0\u09c1\u09a8\u0964", 
    "This field is required.": "\u098f\u0987 \u0995\u09cd\u09b7\u09c7\u09a4\u09cd\u09b0\u099f\u09bf \u09aa\u09cd\u09b0\u09df\u09cb\u099c\u09a8\u0964", 
    "This solved my question": "\u098f\u099f\u09be \u0986\u09ae\u09be\u09b0 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u09b8\u09ae\u09be\u09a7\u09be\u09a8 \u0995\u09b0\u09c7\u099b\u09c7", 
    "This will close the question and let your buddy know you no longer need help.": "\u098f\u099f\u09be \u0986\u09aa\u09a8\u09be\u09b0 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u09ac\u09a8\u09cd\u09a7 \u0995\u09b0\u09c7 \u09a6\u09c7\u09ac\u09c7 \u0993 \u0986\u09aa\u09be\u09a8\u09be\u09b0 \u09ac\u09a8\u09cd\u09a7\u09c1\u0995\u09c7 \u099c\u09c7\u09a8\u09c7 \u09af\u09be\u09ac\u09c7 \u0986\u09aa\u09a8\u09be\u09b0 \u0986\u09b0 \u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af\u09c7\u09b0 \u09a6\u09b0\u0995\u09be\u09b0 \u09a8\u09c7\u0987\u0964", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "\u0985\u09b8\u0982\u0996\u09cd\u09af \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8? \u09a8\u09bf\u099b\u09c7\u09b0 \u09b8\u09c7\u099f\u09bf\u0982\u09b8 \u09ac\u09cd\u09af\u09be\u09ac\u09b9\u09be\u09b0 \u0995\u09b0\u09c1\u09a8 \"\u098f\u0995\u099f\u09bf \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0\" \u09a4\u09be\u09b2\u09bf\u0995\u09be\u099f\u09bf \u099b\u09cb\u099f\u09cb \u0995\u09b0\u09be\u09b0 \u099c\u09a8\u09cd\u09af\u0964", 
    "Top Helpers this Week": "\u098f\u0987 \u09b8\u09aa\u09cd\u09a4\u09be\u09b9\u09c7\u09b0 \u09b8\u09c7\u09b0\u09be \u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af\u0995\u09be\u09b0\u09c0", 
    "Unable to generate username.": "\u0987\u0989\u099c\u09be\u09b0\u09a8\u09c7\u09ae \u09a4\u09c8\u09b0\u09bf \u0995\u09b0\u09be \u09af\u09be\u099a\u09cd\u099b\u09c7 \u09a8\u09be\u0964", 
    "Unknown error: \"{error}\"": "\u0985\u099c\u09be\u09a8\u09be \u09a4\u09cd\u09b0\u09c1\u099f\u09bf: \"{error}\"", 
    "Unsupported Language": "\u09ad\u09be\u09b7\u09be \u09b8\u09ae\u09b0\u09cd\u09a5\u09bf\u09a4 \u09a8\u09df", 
    "User not found.": "\u09ac\u09cd\u09af\u09ac\u09b9\u09be\u09b0\u0995\u09be\u09b0\u09c0\u0995\u09c7 \u0996\u09c1\u0981\u099c\u09c7 \u09aa\u09be\u0993\u09df\u09be \u09af\u09be\u09df\u09a8\u09bf\u0964", 
    "Username": "\u09ac\u09cd\u09af\u09ac\u09b9\u09be\u09b0\u0995\u09be\u09b0\u09c0\u09b0 \u09a8\u09be\u09ae", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "\u0987\u0989\u099c\u09be\u09b0\u09a8\u09c7\u09ae\u09c7 \u09b6\u09c1\u09a7\u09c1\u09ae\u09be\u09a4\u09cd\u09b0 \u0985\u0995\u09cd\u09b7\u09b0, \u09b8\u0982\u0996\u09cd\u09af\u09be,  \".\" \u0993 \"-\" \u09a5\u09be\u0995\u09a4\u09c7 \u09aa\u09be\u09b0\u09c7\u0964", 
    "We can help<br>Ask us anything!": "\u0986\u09ae\u09b0\u09be \u09b8\u09be\u09b9\u09be\u09af\u09cd\u09af \u0995\u09b0\u09a4\u09c7 \u09aa\u09be\u09b0\u09bf<br>\u09af\u09be \u0996\u09c1\u09b6\u09bf \u099c\u09bf\u099c\u09cd\u099e\u09be\u09b8\u09be \u0995\u09b0\u09c1\u09a8!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "\u0986\u09ae\u09b0\u09be \u09a6\u09c1\u0983\u0996\u09bf\u09a4, \u0986\u09aa\u09a8\u09be\u09b0 Firefox OS \u09ad\u09be\u09b0\u09cd\u09b8\u09a8\u09c7 BuddyUp \u0987\u09a8\u09cd\u09b8\u099f\u09b2 \u0995\u09b0\u09be \u09af\u09be\u099a\u09cd\u099b\u09c7 \u09a8\u09be\u0964 \u09a6\u09df\u09be \u0995\u09b0\u09c7 \u098f\u0987 \u0989\u0987\u09a8\u09cd\u09a1\u09cb\u099f\u09bf \u09ac\u09a8\u09cd\u09a7 \u0995\u09b0\u09c1\u09a8 \u0986\u09aa\u09a8\u09be\u09b0 \u09b9\u09cb\u09ae \u09b8\u099a\u09cd\u09b0\u09c0\u09a8-\u098f \u09af\u09be\u0993\u09df\u09be\u09b0 \u099c\u09a8\u09cd\u09af\u0964", 
    "We've sent a welcome email to:": "\u0986\u09ae\u09b0\u09be \u098f\u0995\u099f\u09bf \u0985\u09ad\u09cd\u09af\u09b0\u09cd\u09a5\u09a8\u09be \u0987-\u09ae\u09c7\u0987\u09b2 \u09aa\u09be\u09a0\u09bf\u0987\u09df\u09c7\u099b\u09bf:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "\u0986\u09ae\u09b0\u09be \u098f\u0995\u099f\u09bf \u0987\u09ae\u09c7\u0987\u09b2 \u09aa\u09be\u099f\u09bf\u09df\u09c7\u099b\u09bf\u0964 \u0987\u09ae\u09c7\u0987\u09b2\u09c7 \u09aa\u09be\u099f\u09be\u09a8\u09cb \u09b2\u09bf\u0999\u09cd\u0995\u099f\u09bf \u0985\u09a8\u09c1\u09b8\u09b0\u09a8 \u0995\u09b0\u09c1\u09a8 \u09aa\u09be\u09b0\u09cd\u09b8\u0993\u09df\u09be\u09b0\u09cd\u09a1 \u09aa\u09be\u09b2\u099f\u09be\u09a8\u09cb\u09b0 \u099c\u09a8\u09cd\u09af\u0964", 
    "Whoops!": "\u0993\u09b9!", 
    "Write your message\u2026": "\u0986\u09aa\u09a8\u09be\u09b0 \u09ae\u09c7\u09b8\u09c7\u099c \u09b2\u09bf\u0996\u09c1\u09a8\u2026", 
    "Yay, you're almost done!": "\u0987\u09df\u09be, \u0986\u09aa\u09a8\u09be\u09b0 \u09aa\u09cd\u09b0\u09be\u09df \u09b9\u09df\u09c7 \u098f\u09b8\u09c7\u099b\u09c7!", 
    "You are not online, please check your connection.": "\u0986\u09aa\u09a8\u09bf \u0985\u09a8\u09b2\u09be\u0987\u09a8 \u09a8\u09c7\u0987, \u09a6\u09df\u09be \u0995\u09b0\u09c7 \u0986\u09aa\u09a8\u09be\u09b0 \u0995\u09be\u09a8\u09c7\u0995\u09b6\u09a8 \u09aa\u09b0\u09c0\u0995\u09cd\u09b7\u09be \u0995\u09b0\u09c1\u09a8\u0964", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "\u0986\u09aa\u09a8\u09bf \u09ac\u09bf\u099c\u09cd\u099e\u09aa\u09cd\u09a4\u09bf \u09aa\u09c7\u09df\u09c7 \u09af\u09be\u09ac\u09c7\u09a8 \u09af\u0996\u09a8 \u0995\u09cb\u09a8\u09cb \u09ac\u09a8\u09cd\u09a7\u09c1 \u0986\u09aa\u09a8\u09be\u0995\u09c7 \u09ac\u09be\u099b\u09be\u09a4\u09c7 \u099d\u09be\u09aa\u09bf\u09df\u09be \u09aa\u09b0\u09ac\u09c7\u0964", 
    "just now": "\u098f\u0996\u09c1\u09a8\u09bf", 
    "x hours ago": "x \u0998\u09a8\u09cd\u099f\u09be \u09aa\u09c2\u09b0\u09cd\u09ac\u09c7", 
    "{n} day ago": [
      "{n} \u09a6\u09bf\u09a8 \u0986\u0997\u09c7", 
      "{n} \u09a6\u09bf\u09a8 \u0986\u0997\u09c7"
    ], 
    "{n} helpful vote": [
      "{n} \u09b8\u09b9\u09be\u09df\u0995 \u09ad\u09cb\u099f", 
      "{n} \u09b8\u09b9\u09be\u09df\u0995 \u09ad\u09cb\u099f"
    ], 
    "{n} hour ago": [
      "{n} \u0998\u09a8\u09cd\u099f\u09be \u0986\u0997\u09c7", 
      "{n} \u0998\u09a8\u09cd\u099f\u09be \u0986\u0997\u09c7"
    ], 
    "{n} minute ago": [
      "{n} \u09ae\u09bf\u09a8\u09bf\u099f \u0986\u0997\u09c7", 
      "{n} \u09ae\u09bf\u09a8\u09bf\u099f \u0986\u0997\u09c7"
    ], 
    "{n} question solved": [
      "{n} \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09b8\u09ae\u09c2\u09b9\u09c7\u09b0 \u09b8\u09ae\u09be\u09a7\u09be\u09a8 \u09b9\u09df\u09c7 \u0997\u09c7\u099b\u09c7", 
      "{n} \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8 \u09b8\u09ae\u09be\u09a7\u09be\u09a8 \u09b9\u09df\u09c7 \u0997\u09c7\u099b\u09c7"
    ], 
    "{user} chose your answer as a solution": "{user} \u0986\u09aa\u09a8\u09be\u09b0 \u0989\u09a4\u09cd\u09a4\u09b0\u0995\u09c7 \u09b8\u09ae\u09be\u09a7\u09be\u09a8 \u09b9\u09bf\u09b8\u09c7\u09ac\u09c7 \u09b8\u09cd\u09ac\u09c0\u0995\u09c3\u09a4\u09bf \u09a6\u09bf\u09df\u09be\u099b\u09c7\u09a8", 
    "{user} left a comment on your question": "{user} \u0986\u09aa\u09a8\u09be\u09b0 \u09aa\u09cd\u09b0\u09b6\u09cd\u09a8\u09c7 \u0995\u09ae\u09c7\u09a8\u09cd\u099f \u0995\u09b0\u09c7\u099b\u09c7\u09a8"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "N j, Y, P", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y"
    ], 
    "DATE_FORMAT": "j F, Y", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y", 
      "%b %d %Y", 
      "%b %d, %Y", 
      "%d %b %Y", 
      "%d %b, %Y", 
      "%B %d %Y", 
      "%B %d, %Y", 
      "%d %B %Y", 
      "%d %B, %Y"
    ], 
    "DECIMAL_SEPARATOR": ".", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "0", 
    "SHORT_DATETIME_FORMAT": "m/d/Y P", 
    "SHORT_DATE_FORMAT": "j M, Y", 
    "THOUSAND_SEPARATOR": ",", 
    "TIME_FORMAT": "g:i:s A", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

