

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2;
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> hlas o u\u017eite\u010dnosti</div>", 
      "<div {countattr}>{n}</div><div {textattr}> hlasy o u\u017eite\u010dnosti</div>", 
      "<div {countattr}>{n}</div><div {textattr}> hlas\u016f o u\u017eite\u010dnosti</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> odpov\u011b\u010f vy\u0159e\u0161ena</div>", 
      "<div {countattr}>{n}</div><div {textattr}> odpov\u011bdi vy\u0159e\u0161eny</div>", 
      "<div {countattr}>{n}</div><div {textattr}> odpov\u011bd\u00ed vy\u0159e\u0161eno</div>"
    ], 
    "A user with that email address already exists.": "U\u017eivatel s touto e-mailovou adresou ji\u017e existuje.", 
    "A user with that username exists": "U\u017eivatel s t\u00edmto u\u017eivatelsk\u00fdm jm\u00e9nem ji\u017e existuje", 
    "All My Questions": "V\u0161echny m\u00e9 ot\u00e1zky", 
    "Already registered? Sign in": "U\u017e jste registrov\u00e1n\u00ed? P\u0159ihlaste se", 
    "An account lets you answer questions, track contributions and receive alerts.": "\u00da\u010det v\u00e1m umo\u017en\u00ed odpov\u00eddat na ot\u00e1zky, sledovat p\u0159\u00edsp\u011bvky a dost\u00e1vat upozorn\u011bn\u00ed.", 
    "Another helper has answered this question, please choose another.": "Na tuto ot\u00e1zku ji\u017e odpov\u011bd\u011bl jin\u00fd p\u0159isp\u011bvatel, vyberte si pros\u00edm jinou.", 
    "Answer Questions": "Odpov\u00eddat na ot\u00e1zky", 
    "Answer a Question": "Odpov\u011bd\u011bt na ot\u00e1zku", 
    "Answer questions": "Odpov\u00eddat na ot\u00e1zky", 
    "Answered Questions": "Zodpov\u011bzen\u00e9 ot\u00e1zky", 
    "Ask a Question": "Zeptat se", 
    "Audio/Music/FMRadio": "Audio/Hudba/FM R\u00e1dio", 
    "Be aware that you will lose your history when you sign in to your account.": "Berte na v\u011bdom\u00ed, \u017ee p\u0159ihl\u00e1\u0161en\u00edm ztrat\u00edte svou historii.", 
    "Browser/Download": "Prohl\u00ed\u017ee\u010d/Stahov\u00e1n\u00ed", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp nyn\u00ed nepodporuje jazyk \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Fotoapar\u00e1t/Galerie/Video", 
    "Can't change this field.": "Toto pole nelze zm\u011bnit.", 
    "Cancel": "Zru\u0161it", 
    "Cancel Sign Up": "Zru\u0161it registraci", 
    "Cellular Data/WiFi/Bluetooth": "Mobiln\u00ed data/Wi-Fi/Bluetooth", 
    "Choose a category": "Zvolte kategorii", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Klepn\u011bte na odkaz ve va\u0161em e-mailu a dejte n\u00e1m tak v\u011bd\u011bt, \u017ee dorazil na spr\u00e1vn\u00e9 m\u00edsto. Pot\u00e9 se vra\u0165te na BuddyUp a za\u010dn\u011bte d\u011blat dal\u0161\u00edm u\u017eivatel\u016fm radost!", 
    "Clock/Alarm": "Hodiny/Bud\u00edk", 
    "Close": "Zav\u0159\u00edt", 
    "Confirm Account": "Potvrdit \u00fa\u010det", 
    "Continue": "Pokra\u010dovat", 
    "Create Account": "Vytvo\u0159it \u00fa\u010det", 
    "Create account or sign in": "Vytvo\u0159it \u00fa\u010det nebo se p\u0159ihl\u00e1sit", 
    "Device": "Za\u0159\u00edzen\u00ed", 
    "Dialer/Contacts": "Hovory/Kontakty", 
    "Don't have an account? Register": "Nem\u00e1te \u00fa\u010det? Zaregistrujte se", 
    "Done": "Hotovo", 
    "Email Address": "E-mailov\u00e1 adresa", 
    "Email/Calendar": "E-mail/Kalend\u00e1\u0159", 
    "Enter a valid email address.": "Zadejte platnou e-mailovou adresu.", 
    "Failed": "Selhalo", 
    "Forgot your password?": "Zapomn\u011bli jste heslo?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Zapomn\u011bli jste heslo? Nevad\u00ed. Zadejte n\u00ed\u017ee sv\u00e9 u\u017eivatelsk\u00e9 jm\u00e9no a my v\u00e1m za\u0161leme postup jak si nastavit nov\u00e9.", 
    "Get a Buddy to help you with your device": "Z\u00edskejte kamar\u00e1da, kter\u00fd v\u00e1m s va\u0161\u00edm za\u0159\u00edzen\u00edm pom\u016f\u017ee", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Pro odpov\u011bzen\u00ed ot\u00e1zek p\u0159ejd\u011bte do nov\u00e9ho panelu. Budeme je tam hl\u00eddat.", 
    "Has your question been solved?": "Byla va\u0161e ot\u00e1zka vy\u0159e\u0161ena?", 
    "Have Answers?": "M\u00e1te odpov\u011bdi?", 
    "Have Questions?": "M\u00e1te ot\u00e1zky?", 
    "Help Article": "\u010cl\u00e1nek n\u00e1pov\u011bdy", 
    "Help other users around the world": "Pom\u00e1hejte ostatn\u00edm u\u017eivatel\u016fm po cel\u00e9m sv\u011bt\u011b", 
    "Incompatible version": "Nekompatibiln\u00ed verze", 
    "Keyboard": "Kl\u00e1vesnice", 
    "Language": "Jazyk", 
    "Last sync:": "Posledn\u00ed synchronizace:", 
    "Load more": "Na\u010d\u00edst v\u00edce", 
    "Maps/GPS": "Mapy/GPS", 
    "Marketplace/Apps Install": "Marketplace/Instalace aplikac\u00ed", 
    "My Profile": "M\u016fj profil", 
    "My Question": "M\u00e1 ot\u00e1zka", 
    "My Questions": "M\u00e9 ot\u00e1zky", 
    "My list": "M\u016fj seznam", 
    "My preferences": "Moje p\u0159edvolby", 
    "New": "Nov\u00e1", 
    "No active questions": "\u017d\u00e1dn\u00e9 aktivn\u00ed ot\u00e1zky", 
    "No matching user setting found.": "Odpov\u00eddaj\u00edc\u00ed u\u017eivatelsk\u00e9 nastaven\u00ed nenalezeno.", 
    "No questions": "\u017d\u00e1dn\u00e9 ot\u00e1zky", 
    "OK": "OK", 
    "Ok": "Ok", 
    "Operator": "Oper\u00e1tor", 
    "Other": "Jin\u00e9", 
    "Password": "Heslo", 
    "Performance": "Rychlost", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Pokl\u00e1dejte pros\u00edm sv\u00e9 ot\u00e1zky v angli\u010dtin\u011b, nebo nav\u0161tivte <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> pro dal\u0161\u00ed pomoc.", 
    "Previously Answered": "D\u0159\u00edve zodpov\u011bzen\u00e9", 
    "Quit": "Odej\u00edt", 
    "Reset Password": "Obnovit heslo", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Odes\u00edl\u00e1n\u00ed\u2026", 
    "Settings": "Nastaven\u00ed", 
    "Sign In": "P\u0159ihl\u00e1\u0161en\u00ed", 
    "Sign in to answer questions from Firefox OS users.": "Pro odpov\u00edd\u00e1n\u00ed na ot\u00e1zky u\u017eivatel\u016f Firefox OS se pros\u00edm p\u0159ihlaste.", 
    "Sign in to answer questions from the Mozilla community.": "Pro odpov\u00edd\u00e1n\u00ed na ot\u00e1zky komunity Mozilly se pros\u00edm p\u0159ihlaste.", 
    "Sign in to reply": "Pro odpov\u011b\u010f se p\u0159ihlaste", 
    "Solution \u2713": "Vy\u0159e\u0161eno \u2713", 
    "Storage/SD card": "\u00dalo\u017ei\u0161t\u011b/SD karta", 
    "Support": "Podpora", 
    "System Updates": "Aktualizace syst\u00e9mu", 
    "Thank you for your question!": "D\u011bkujeme za v\u00e1\u0161 dotaz!", 
    "There was a problem with Buddy Up, please try again.": "Do\u0161lo k probl\u00e9mu s BuddyUp, zkuste to pros\u00edm znovu.", 
    "This field is required.": "Toto pole je vy\u017eadov\u00e1no.", 
    "This solved my question": "Toto vy\u0159e\u0161ilo mou ot\u00e1zku", 
    "This will close the question and let your buddy know you no longer need help.": "T\u00edmto zav\u0159ete ot\u00e1zku a d\u00e1te sv\u00fdm kamar\u00e1d\u016fm v\u011bd\u011bt, \u017ee ji\u017e nepot\u0159ebujete dal\u0161\u00ed pomoc.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "P\u0159\u00edli\u0161 mnoho ot\u00e1zek? Pou\u017eijte mo\u017enosti nastaven\u00ed n\u00ed\u017ee pro zkr\u00e1cen\u00ed cel\u00e9ho seznamu \"Odpov\u00eddat na ot\u00e1zky\".", 
    "Top Helpers this Week": "Nejlep\u0161\u00ed p\u0159isp\u011bvatel\u00e9 tohoto t\u00fddne", 
    "Unable to generate username.": "U\u017eivatelsk\u00e9 jm\u00e9no nelze vygenerovat.", 
    "Unable to log in with provided credentials.": "Se zadan\u00fdmi \u00fadaji se nelze p\u0159ihl\u00e1sit.", 
    "Unknown error: \"{error}\"": "Nezn\u00e1m\u00e1 chyba: \"{error}\"", 
    "Unsupported Language": "Nepodporovan\u00fd jazyk", 
    "User account is disabled.": "U\u017eivatelsk\u00fd \u00fa\u010det je deaktivov\u00e1n.", 
    "User not found.": "U\u017eivatel nebyl nalezen.", 
    "Username": "U\u017eivatelsk\u00e9 jm\u00e9no", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "U\u017eivatelsk\u00e1 jm\u00e9na mohou obsahovat pouze p\u00edsmena, \u010d\u00edsla a symboly \".\" a \"-\".", 
    "We can help<br>Ask us anything!": "M\u016f\u017eeme pomoci<br>Zeptejte se n\u00e1s!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Je n\u00e1m l\u00edto, ale BuddyUp nelze nainstalovat na va\u0161i verzi Firefox OS. Pro n\u00e1vrat na domovskou obrazovku pros\u00edm zav\u0159ete toto okno.", 
    "We've sent a welcome email to:": "Poslali jsme v\u00e1m uv\u00edtac\u00ed e-mail na:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Poslali jsme v\u00e1m e-mail. Pro obnoven\u00ed hesla sta\u010d\u00ed otev\u0159\u00edt odkaz, kter\u00fd v e-mailu najdete.", 
    "Whoops!": "Jejda!", 
    "Write your message\u2026": "Napi\u0161te svou zpr\u00e1vu\u2026", 
    "Yay, you're almost done!": "Hur\u00e1, u\u017e je skoro hotovo!", 
    "You are not online, please check your connection.": "Nejste online, zkontrolujte pros\u00edm sv\u00e9 p\u0159ipojen\u00ed.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Jakmile p\u0159ijde n\u011bjak\u00fd kamar\u00e1d na pomoc, budete po\u0161leme v\u00e1m notifikaci.", 
    "just now": "pr\u00e1v\u011b te\u010f", 
    "x hours ago": "x hodin zp\u011bt", 
    "{n} day ago": [
      "p\u0159ed {n} dnem", 
      "p\u0159ed {n} dny", 
      "p\u0159ed {n} dny"
    ], 
    "{n} helpful vote": [
      "{n} hlas o u\u017eite\u010dnosti", 
      "{n} hlasy o u\u017eite\u010dnosti", 
      "{n} hlas\u016f o u\u017eite\u010dnosti"
    ], 
    "{n} hour ago": [
      "p\u0159ed {n} hodinou", 
      "p\u0159ed {n} hodinami", 
      "p\u0159ed {n} hodinami"
    ], 
    "{n} minute ago": [
      "p\u0159ed {n} minutou", 
      "p\u0159ed {n} minutami", 
      "p\u0159ed {n} minutami"
    ], 
    "{n} question solved": [
      "{n} hlas o u\u017eite\u010dnosti", 
      "{n} hlasy o u\u017eite\u010dnosti", 
      "{n} hlas\u016f o u\u017eite\u010dnosti"
    ], 
    "{user} chose your answer as a solution": "U\u017eivatel {user} zvolil va\u0161i odpov\u011b\u010f jako \u0159e\u0161en\u00ed", 
    "{user} left a comment on your question": "U\u017eivatel {user} okomentoval va\u0161i ot\u00e1zku"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j. E Y G:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H.%M", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%d. %m. %Y %H:%M:%S", 
      "%d. %m. %Y %H:%M:%S.%f", 
      "%d. %m. %Y %H.%M", 
      "%d. %m. %Y %H:%M", 
      "%d. %m. %Y", 
      "%Y-%m-%d %H.%M", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j. E Y", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y", 
      "%d.%m.%y", 
      "%d. %m. %Y", 
      "%d. %m. %y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j. F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d.m.Y G:i:s", 
    "SHORT_DATE_FORMAT": "d.m.Y", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "G:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H.%M", 
      "%H:%M", 
      "%H:%M:%S.%f"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

