

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> nyttig-stemme</div>", 
      "<div {countattr}>{n}</div><div {textattr}> nyttig-stemmer</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> sp\u00f8rgsm\u00e5l besvaret</div>", 
      "<div {countattr}>{n}</div><div {textattr}> sp\u00f8rgsm\u00e5l besvaret</div>"
    ], 
    "A user with that email address already exists.": "En bruger med denne mailadresse findes allerede.", 
    "A user with that username exists": "En bruger med dette brugernavn findes", 
    "All My Questions": "Alle mine sp\u00f8rgsm\u00e5l", 
    "Already registered? Sign in": "Allerede registreret? Log ind", 
    "An account lets you answer questions, track contributions and receive alerts.": "En konto lader dig besvare sp\u00f8rgsm\u00e5l, spore bidrag og modtage alarmer.", 
    "Another helper has answered this question, please choose another.": "En anden hj\u00e6lper har besvaret dette sp\u00f8rgsm\u00e5l, v\u00e6lg et andet.", 
    "Answer Questions": "Besvar sp\u00f8rgsm\u00e5l", 
    "Answer a Question": "Besvar et sp\u00f8rgsm\u00e5l", 
    "Answer questions": "Besvar sp\u00f8rgsm\u00e5l", 
    "Answered Questions": "Besvarede sp\u00f8rgsm\u00e5l", 
    "Ask a Question": "Stil et sp\u00f8rgsm\u00e5l", 
    "Audio/Music/FMRadio": "Lyd/Musik/FM-radio", 
    "Be aware that you will lose your history when you sign in to your account.": "V\u00e6r opm\u00e6rksom p\u00e5, at du vil miste din historik, n\u00e5r du logger ind p\u00e5 din konto.", 
    "Browser/Download": "Browser/Download", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp underst\u00f8tter i \u00f8jeblikket ikke \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Kamera/Galleri/Video", 
    "Can't change this field.": "Kan ikke \u00e6ndre dette felt.", 
    "Cancel": "Annuller", 
    "Cancel Sign Up": "Annuller registrering", 
    "Cellular Data/WiFi/Bluetooth": "Mobildata/Wi-fi/Bluetooth", 
    "Choose a category": "V\u00e6lg en kategori", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Klik p\u00e5 linket i din mail, s\u00e5 vi ved, at den er n\u00e5et frem til den rigtige modtager. Return\u00e9r til BuddyUp og g\u00f8r en anden bruger glad!", 
    "Clock/Alarm": "Ur/Alarm", 
    "Close": "Luk", 
    "Confirm Account": "Bekr\u00e6ft konto", 
    "Continue": "Forts\u00e6t", 
    "Create Account": "Opret en konto", 
    "Create account or sign in": "Opret en konto eller log ind", 
    "Device": "Enhed", 
    "Dialer/Contacts": "Opkald/Kontakter", 
    "Don't have an account? Register": "Har du ikke en konto? Registrer dig", 
    "Done": "F\u00e6rdig", 
    "Email Address": "Mailadresse", 
    "Email/Calendar": "Mail/Kalender", 
    "Failed": "Mislykkedes", 
    "Forgot your password?": "Glemt din adgangskode?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Glemt din adgangskode? Intet problem. Indtast dit brugernavn nedenunder, s\u00e5 vil vi sende dig en vejledning i, hvordan du laver et nyt.", 
    "Get a Buddy to help you with your device": "F\u00e5 en buddy til at hj\u00e6lpe dig med din enhed", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "G\u00e5 til det nye faneblad for at besvare nogle sp\u00f8rgsm\u00e5l. Vi holder styr p\u00e5 dem her.", 
    "Has your question been solved?": "Er dit sp\u00f8rgsm\u00e5l blevet besvaret?", 
    "Have Answers?": "Har du svarene?", 
    "Have Questions?": "Har du sp\u00f8rgsm\u00e5l?", 
    "Help Article": "Hj\u00e6lpeartikle", 
    "Help other users around the world": "Hj\u00e6lp andre brugere rundt om i verden", 
    "Incompatible version": "Inkompatibel version", 
    "Keyboard": "Tastatur", 
    "Language": "Sprog", 
    "Last sync:": "Seneste synkronisering:", 
    "Load more": "L\u00e6s mere", 
    "Maps/GPS": "Kort/GPS", 
    "Marketplace/Apps Install": "Marketplace/Apps-installeringer", 
    "My Profile": "Min profil", 
    "My Question": "Mit sp\u00f8rgsm\u00e5l", 
    "My Questions": "Mine sp\u00f8rgsm\u00e5l", 
    "My list": "Min liste", 
    "My preferences": "Mine indstillinger", 
    "New": "Nye", 
    "No active questions": "Ingen aktive sp\u00f8rgsm\u00e5l", 
    "No matching user setting found.": "Ingen matchende brugerindstillinger fundet.", 
    "No questions": "Ingen sp\u00f8rgsm\u00e5l", 
    "OK": "OK", 
    "Ok": "OK", 
    "Operator": "Operator", 
    "Other": "Andet", 
    "Password": "Adgangskode", 
    "Performance": "Ydelse", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Stil dit sp\u00f8rgsm\u00e5l p\u00e5 engelsk, eller g\u00e5 til <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for mere hj\u00e6lp.", 
    "Previously Answered": "Besvaret tidligere", 
    "Quit": "Afslut", 
    "Reset Password": "Nulstil adgangskode", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Sender...", 
    "Settings": "Indstillinger", 
    "Sign In": "Log ind", 
    "Sign in to answer questions from Firefox OS users.": "Log ind for at besvare sp\u00f8rgsm\u00e5l fra Firefox OS-brugere.", 
    "Sign in to answer questions from the Mozilla community.": "Log ind for at besvare sp\u00f8rgsm\u00e5l fra Mozilla-f\u00e6llesskabet.", 
    "Sign in to reply": "Log ind for at svare", 
    "Solution \u2713": "L\u00f8snung \u2713", 
    "Storage/SD card": "Lager/SD-kort", 
    "Support": "Support", 
    "System Updates": "Systemopdateringer", 
    "Thank you for your question!": "Tak for dit sp\u00f8rgsm\u00e5l!", 
    "There was a problem with Buddy Up, please try again.": "Der var et problem med Buddy Up, pr\u00f8v igen.", 
    "This field is required.": "Dette felt skal udfyldes.", 
    "This solved my question": "Dette l\u00f8ste mit problem", 
    "This will close the question and let your buddy know you no longer need help.": "Dette vil lukke sp\u00f8rgsm\u00e5let og lade din buddy vide, at du ikke l\u00e6ngere beh\u00f8ver hj\u00e6lp.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "For mange sp\u00f8rgsm\u00e5l? Brug indstillingerne nedenunder for at begr\u00e6nse listen \"Besvar et sp\u00f8rgsm\u00e5l\".", 
    "Top Helpers this Week": "Top-hj\u00e6lpere denne uge", 
    "Unable to generate username.": "Kan ikke generere brugernavn.", 
    "Unknown error: \"{error}\"": "Ukendt fejl: \"{error}\"", 
    "Unsupported Language": "Sprog ikke underst\u00f8ttet", 
    "User not found.": "Bruger ikke fundet", 
    "Username": "Brugernavn", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Brugernavne m\u00e5 kun indeholde bogstaver, tal, \".\" og \"-\".", 
    "We can help<br>Ask us anything!": "Vi kan hj\u00e6lpe<br>Sp\u00f8rg os om alt!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Vi beklager, men BuddyUp kan ikke installeres p\u00e5 din version af Firefox OS. Luk dette vindue for at returnere til din startsk\u00e6rm.", 
    "We've sent a welcome email to:": "Vi har sendt en velkomstmail til:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Vi har sendt dig en mail. Klik bare p\u00e5 linket i mailen for at nulstille din adgangskode.", 
    "Whoops!": "Hovsa!", 
    "Write your message\u2026": "Skriv din meddelelse...", 
    "Yay, you're almost done!": "S\u00e5 er du n\u00e6sten f\u00e6rdig!", 
    "You are not online, please check your connection.": "Du er ikke online, kontroller din forbindelse.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Du vil modtage en meddelelse s\u00e5 snart en Buddy kommer til unds\u00e6tning.", 
    "just now": "netop nu", 
    "x hours ago": "x timer siden", 
    "{n} day ago": [
      "{n} dag siden", 
      "{n} dage siden"
    ], 
    "{n} helpful vote": [
      "{n} nyttig-stemme", 
      "{n} nyttig-stemmer"
    ], 
    "{n} hour ago": [
      "{n} timer siden", 
      "{n} timer siden"
    ], 
    "{n} minute ago": [
      "{n} minut siden", 
      "{n} minutter siden"
    ], 
    "{n} question solved": [
      "{n} sp\u00f8rgsm\u00e5l besvaret", 
      "{n} sp\u00f8rgsm\u00e5l besvaret"
    ], 
    "{user} chose your answer as a solution": "{user} valgte dit svar som l\u00f8sning", 
    "{user} left a comment on your question": "{user} skrev en kommentar til dit sp\u00f8rgsm\u00e5l"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j. F Y H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j. F Y", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j. F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d.m.Y H:i", 
    "SHORT_DATE_FORMAT": "d.m.Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

