

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> Stimme f\u00fcr \u201ehilfreich\u201c</div>", 
      "<div {countattr}>{n}</div><div {textattr}> Stimmen f\u00fcr \u201ehilfreich\u201c</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> Frage beantwortet</div>", 
      "<div {countattr}>{n}</div><div {textattr}> Fragen beantwortet</div>"
    ], 
    "A user with that email address already exists.": "Ein Benutzer mit dieser E-Mail-Adresse existiert bereits.", 
    "A user with that username exists": "Ein Benutzer mit diesem Benutzernamen existiert bereits", 
    "All My Questions": "Alle meine Fragen", 
    "Already registered? Sign in": "Sind Sie bereits registriert? Melden Sie sich an", 
    "An account lets you answer questions, track contributions and receive alerts.": "Mit einem Benutzerkonto k\u00f6nnen Sie Fragen beantworten, Beitr\u00e4ge verfolgen und Benachrichtigungen erhalten.", 
    "Another helper has answered this question, please choose another.": "Ein anderer Helfer hat diese Frage beantwortet, bitte w\u00e4hlen Sie eine andere.", 
    "Answer Questions": "Beantworten Sie Fragen", 
    "Answer a Question": "Beantworten Sie eine Frage", 
    "Answer questions": "Beantworten Sie Fragen", 
    "Answered Questions": "Beantwortete Fragen", 
    "Ask a Question": "Stellen Sie eine Frage", 
    "Audio/Music/FMRadio": "Audio/Musik/UKW-Radio", 
    "Be aware that you will lose your history when you sign in to your account.": "Achtung, Sie verlieren Ihre Chronik, wenn Sie sich mit Ihrem Konto anmelden.", 
    "Browser/Download": "Browser/Download", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp unterst\u00fctzt \u201e<span id=\"language\"></span>\u201c derzeit nicht.", 
    "Camera/Gallery/Video": "Kamera/Galerie/Video", 
    "Can't change this field.": "Dieses Feld kann nicht ge\u00e4ndert werden.", 
    "Cancel": "Abbrechen", 
    "Cancel Sign Up": "Registrierung abbrechen", 
    "Cellular Data/WiFi/Bluetooth": "Datenverbindung/WLAN/Bluetooth", 
    "Choose a category": "W\u00e4hlen Sie eine Kategorie", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Klicken Sie auf den Link in Ihrer E-Mail, um uns mitzuteilen, dass der richtige Adressat sie erhalten hat. Kehren Sie dann zu BuddyUp zur\u00fcck und machen Sie andere Benutzer gl\u00fccklich!", 
    "Clock/Alarm": "Uhr/Wecker", 
    "Close": "Schlie\u00dfen", 
    "Confirm Account": "Benutzerkonto best\u00e4tigen", 
    "Continue": "Weiter", 
    "Create Account": "Konto erstellen", 
    "Create account or sign in": "Erstellen Sie ein Konto oder melden Sie sich an", 
    "Device": "Ger\u00e4t", 
    "Dialer/Contacts": "W\u00e4hlen/Kontakte", 
    "Don't have an account? Register": "Haben Sie noch kein Benutzerkonto? Registrieren Sie sich.", 
    "Done": "Fertig", 
    "Email Address": "E-Mail-Adresse", 
    "Email/Calendar": "E-Mail/Kalender", 
    "Enter a valid email address.": "Geben Sie eine g\u00fcltige E-Mail-Adresse ein.", 
    "Failed": "Fehlgeschlagen", 
    "Forgot your password?": "Haben Sie Ihr Passwort vergessen?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Haben Sie Ihr Passwort vergessen? Keine Sorge. Geben Sie hier unten Ihren Benutzernamen ein und wir schicken Ihnen Anweisungen, um ein neues Passwort festzulegen.", 
    "Get a Buddy to help you with your device": "Ein Buddy kann Ihnen vielleicht mit Ihrem Ger\u00e4t helfen", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "\u00d6ffnen Sie den neuen Tab, um ein paar Fragen zu beantworten. Wir behalten hier den \u00dcberblick.", 
    "Has your question been solved?": "Wurde Ihre Frage beantwortet?", 
    "Have Answers?": "Haben Sie Antworten?", 
    "Have Questions?": "Haben Sie Fragen?", 
    "Help Article": "Hilfeartikel", 
    "Help other users around the world": "Helfen Sie Benutzern auf der ganzen Welt", 
    "Incompatible version": "Inkompatible Version", 
    "Keyboard": "Tastatur", 
    "Language": "Sprache", 
    "Last sync:": "Letzte Synchronisation:", 
    "Load more": "Mehr laden", 
    "Maps/GPS": "Karten/GPS", 
    "Marketplace/Apps Install": "Marketplace/App-Installation", 
    "My Profile": "Mein Profil", 
    "My Question": "Meine Frage", 
    "My Questions": "Meine Frage", 
    "My list": "Meine Liste", 
    "My preferences": "Meine Einstellungen", 
    "New": "Neu", 
    "No active questions": "Keine aktiven Fragen", 
    "No matching user setting found.": "Keine passende Benutzereinstellung gefunden.", 
    "No questions": "Keine Fragen", 
    "OK": "Ok", 
    "Ok": "OK", 
    "Operator": "Anbieter", 
    "Other": "Sonstiges", 
    "Password": "Passwort", 
    "Performance": "Leistung", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Bitte stellen Sie Ihre Frage auf Englisch oder besuchen Sie <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a>, um weitere Hilfe zu erhalten.", 
    "Previously Answered": "Bereits beantwortet", 
    "Quit": "Beenden", 
    "Reset Password": "Passwort zur\u00fccksetzen", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Wird gesendet\u2026", 
    "Settings": "Einstellungen", 
    "Sign In": "Anmelden", 
    "Sign in to answer questions from Firefox OS users.": "Melden Sie sich an, um Fragen von anderen Firefox-OS-Nutzern zu beantworten.", 
    "Sign in to answer questions from the Mozilla community.": "Melden Sie sich an, um Fragen aus der Mozilla-Gemeinschaft zu beantworten.", 
    "Sign in to reply": "Melden Sie sich an, um zu antworten", 
    "Solution \u2713": "L\u00f6sung \u2713", 
    "Storage/SD card": "Speicher/SD-Karte", 
    "Support": "Hilfe", 
    "System Updates": "System-Aktualisierungen", 
    "Thank you for your question!": "Vielen Dank f\u00fcr Ihre Frage!", 
    "There was a problem with Buddy Up, please try again.": "Mit Buddy Up ist ein Problem aufgetreten, bitte versuchen Sie es erneut.", 
    "This field is required.": "Dieses Feld ist erforderlich.", 
    "This solved my question": "Dies hat meine Frage beantwortet", 
    "This will close the question and let your buddy know you no longer need help.": "Damit wird die Frage geschlossen und Ihrem Buddy mitgeteilt, dass Sie keine Hilfe mehr ben\u00f6tigen.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Zu viele Fragen? Verwenden Sie die folgenden Einstellungen, um die Liste unbeantworteter Fragen einzugrenzen.", 
    "Top Helpers this Week": "Wichtigste Helfer in dieser Woche", 
    "Unable to generate username.": "Benutzername konnte nicht erzeugt werden.", 
    "Unable to log in with provided credentials.": "Anmeldung mit angegebenen Daten nicht m\u00f6glich.", 
    "Unknown error: \"{error}\"": "Unbekannter Fehler: \u201e{error}\u201c", 
    "Unsupported Language": "Nicht unterst\u00fctzte Sprache", 
    "User account is disabled.": "Benutzerkonto ist deaktiviert.", 
    "User not found.": "Benutzer nicht gefunden.", 
    "Username": "Benutzername", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Benutzernamen d\u00fcrfen nur aus Buchstaben, Zahlen, \u201e.\u201c und \u201e-\u201c bestehen.", 
    "We can help<br>Ask us anything!": "Wir k\u00f6nnen helfen<br>Stellen Sie uns Ihre Fragen!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Es tut uns leid, aber BuddyUp kann auf Ihrer Firefox-OS-Version nicht installiert werden. Bitte schlie\u00dfen Sie dieses Fenster, um zu Ihrem Startbildschirm zur\u00fcckzukehren.", 
    "We've sent a welcome email to:": "Wir haben eine Willkommens-E-Mail verschickt an:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Wir haben Ihnen eine E-Mail geschickt. Folgen Sie einfach dem Link darin, um Ihr Passwort zur\u00fcckzusetzen.", 
    "Whoops!": "Hoppla!", 
    "Write your message\u2026": "Schreiben Sie Ihre Nachricht\u2026", 
    "Yay, you're almost done!": "Hurra, Sie haben es gleich geschafft!", 
    "You are not online, please check your connection.": "Sie sind nicht online, bitte \u00fcberpr\u00fcfen Sie Ihre Verbindung.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Sie werden benachrichtigt, sobald ein Buddy zur Rettung naht.", 
    "just now": "gerade eben", 
    "x hours ago": "Vor x Stunden", 
    "{n} day ago": [
      "vor {n} Tag", 
      "vor {n} Tagen"
    ], 
    "{n} helpful vote": [
      "{n} Stimme f\u00fcr \u201ehilfreich\u201c", 
      "{n} Stimmen f\u00fcr \u201ehilfreich\u201c"
    ], 
    "{n} hour ago": [
      "vor {n} Stunde", 
      "vor {n} Stunden"
    ], 
    "{n} minute ago": [
      "vor {n} Minute", 
      "vor {n} Minuten"
    ], 
    "{n} question solved": [
      "{n} Frage beantwortet", 
      "{n} Frage beantwortet"
    ], 
    "{user} chose your answer as a solution": "{user} hat Ihre Antwort als L\u00f6sung ausgew\u00e4hlt", 
    "{user} left a comment on your question": "{user} hat einen Kommentar zu Ihrer Frage abgegeben"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j. F Y H:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j. F Y", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y", 
      "%d.%m.%y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j. F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d.m.Y H:i:s", 
    "SHORT_DATE_FORMAT": "d.m.Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

