

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> g\u0142os za \"wu\u017eytny\"</div>", 
      "<div {countattr}>{n}</div><div {textattr}> g\u0142osa za \"wu\u017eytny\"</div>", 
      "<div {countattr}>{n}</div><div {textattr}> g\u0142ose za \"wu\u017eytny\"</div>", 
      "<div {countattr}>{n}</div><div {textattr}> g\u0142osow za \"wu\u017eytny\"</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "Jo se na <div {countattr}>{n}</div><div {textattr}> p\u0161a\u0161anje w\u00f3tegroni\u0142o</div>", 
      "Jo se na <div {countattr}>{n}</div><div {textattr}> p\u0161a\u0161ani w\u00f3tegroni\u0142o</div>", 
      "Jo se na <div {countattr}>{n}</div><div {textattr}> p\u0161a\u0161anja w\u00f3tegroni\u0142o</div>", 
      "Jo se na <div {countattr}>{n}</div><div {textattr}> p\u0161a\u0161anjow w\u00f3tegroni\u0142o</div>"
    ], 
    "A user with that email address already exists.": "Wu\u017eywa\u0155 z teju e-mailowu adresu ju\u017eo eksist\u011brujo.", 
    "A user with that username exists": "Wu\u017eywa\u0155 z tym wu\u017eywarskim mjenim eksist\u011brujo", 
    "All My Questions": "W\u0161ykne m\u00f3je p\u0161a\u0161anja", 
    "Already registered? Sign in": "S\u0107o ju\u017eo zregistr\u011browany? P\u015bizjaw\u015bo se", 
    "An account lets you answer questions, track contributions and receive alerts.": "Z kontom m\u00f3\u017eo\u015bo na p\u0161a\u0161anja w\u00f3tegroni\u015b, p\u015binoski sl\u011bdowa\u015b a pow\u011b\u017ae\u0144ki dosta\u015b.", 
    "Another helper has answered this question, please choose another.": "Drugi pomoca\u0155 jo na to\u015b to p\u0161a\u0161anje w\u00f3tegroni\u0142, p\u0161osym wubje\u0155\u015bo druge.", 
    "Answer Questions": "W\u00f3tegro\u0144\u015bo na p\u0161a\u0161anja", 
    "Answer a Question": "W\u00f3tegro\u0144\u015bo na p\u0161a\u0161anje", 
    "Answer questions": "W\u00f3tegro\u0144\u015bo na p\u0161a\u0161anja", 
    "Answered Questions": "W\u00f3tegronjone p\u0161a\u0161anja", 
    "Ask a Question": "Staj\u015bo p\u0161a\u0161anje", 
    "Audio/Music/FMRadio": "Awdio/Muzika/UKW-radijo", 
    "Be aware that you will lose your history when you sign in to your account.": "Gl\u011bdaj\u015bo: Zgubijo\u015bo sw\u00f3ju historiju, ga\u017e p\u015bizjawijo\u015bo so ze sw\u00f3jim kontom", 
    "Browser/Download": "Wobgl\u011bdowak/Ze\u015b\u011bgnjenje", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp tuchylu  njep\u00f3dp\u011bra \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Kamera/Galerija/Wideo", 
    "Can't change this field.": "To\u015b to p\u00f3lo njedajo se zm\u011bni\u015b.", 
    "Cancel": "P\u015betergnu\u015b", 
    "Cancel Sign Up": "Registr\u011browanje p\u015betergnu\u015b", 
    "Cellular Data/WiFi/Bluetooth": "Datowy zwisk/WLAN/Bluetooth", 
    "Choose a category": "Wubje\u0155\u015bo kategoriju", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Klikni\u015bo na w\u00f3tkaz w sw\u00f3jej mejlce, aby nam w\u011bs\u0107i da\u0142, a\u017e p\u0161awy adresat jo ju dosta\u0142. Wro\u015b\u0107o se p\u00f3n k BuddyUp a zawjasel\u015bo druge wu\u017eywarje!", 
    "Clock/Alarm": "Zeger/Alarm", 
    "Close": "Zacyni\u015b", 
    "Confirm Account": "Konto wobk\u0161u\u015bi\u015b", 
    "Continue": "Dalej", 
    "Create Account": "Konto za\u0142o\u017ey\u015b", 
    "Create account or sign in": "Za\u0142o\u017e\u0107o konto abo p\u015bizjaw\u015bo se", 
    "Device": "R\u011bd", 
    "Dialer/Contacts": "W\u00f3li\u015b/Kontakty", 
    "Don't have an account? Register": "Njama\u015bo konto? Registr\u011bruj\u015bo se", 
    "Done": "G\u00f3towo", 
    "Email Address": "E-mailowa adresa", 
    "Email/Calendar": "E-mail/Kalender", 
    "Enter a valid email address.": "Zap\u00f3daj\u015bo p\u0142a\u015biwu e-mailowu adresu.", 
    "Failed": "Njejo se ra\u017ai\u0142o", 
    "Forgot your password?": "S\u0107o sw\u00f3jo gronid\u0142o zaby\u0142?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "S\u0107o sw\u00f3jo gronid\u0142o zaby\u0142? Nic se njestaraj\u015bo. Zap\u00f3daj\u015bo do\u0142ojce sw\u00f3jo wu\u017eywarske m\u011b a p\u00f3s\u0107elomy wam instrukcije, aby nowe gronid\u0142o p\u00f3staji\u0142.", 
    "Get a Buddy to help you with your device": "P\u015bija\u015bel m\u00f3\u017eo wam sna\u017a z wa\u0161ym r\u011bdom pomaga\u015b", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "W\u00f3cy\u0144\u015bo nowy rejtark, aby na n\u011bkotare p\u0161a\u0161anja w\u00f3tegroni\u0142. Wobchowajomy how p\u015begl\u011bd.", 
    "Has your question been solved?": "Jo se wa\u0161o p\u0161a\u0161anje w\u00f3tegroni\u0142o?", 
    "Have Answers?": "Ma\u015bo w\u00f3tegrona?", 
    "Have Questions?": "Ma\u015bo p\u0161a\u0161anja?", 
    "Help Article": "Nastawk pomocy", 
    "Help other users around the world": "Pomagaj\u015bo drugim wu\u017eywarjam z ce\u0142ego sw\u011bta", 
    "Incompatible version": "Inkompatibelna wersija", 
    "Keyboard": "Tastatura", 
    "Language": "R\u011bc", 
    "Last sync:": "Sl\u011bdna synchronizacija:", 
    "Load more": "W\u011bcej zacyta\u015b", 
    "Maps/GPS": "K\u00f3rty/GPS", 
    "Marketplace/Apps Install": "Wikowani\u0161\u0107o/Instalacija na\u0142o\u017eenjow", 
    "My Profile": "M\u00f3j profil", 
    "My Question": "M\u00f3jo p\u0161a\u0161anje", 
    "My Questions": "M\u00f3je p\u0161a\u0161anja", 
    "My list": "M\u00f3ja lis\u0107ina", 
    "My preferences": "M\u00f3je nastajenja", 
    "New": "Nowy", 
    "No active questions": "\u017dedne aktiwne p\u0161a\u0161anja", 
    "No matching user setting found.": "\u017dedno g\u00f3\u017abne nastajenje namakane.", 
    "No questions": "\u017dedne p\u0161a\u0161anja", 
    "OK": "W p\u00f3r\u011b\u017ae", 
    "Ok": "W p\u00f3r\u011b\u017ae", 
    "Operator": "P\u00f3bitowa\u0155", 
    "Other": "Druge", 
    "Password": "Gronid\u0142o", 
    "Performance": "Wugba\u015be", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "P\u0161osym staj\u015bo sw\u00f3jo p\u0161a\u0161anja engelski abo \u017ai\u015bo k <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> za dal\u0161nu pomoc.", 
    "Previously Answered": "Ju\u017eo w\u00f3tegronjony", 
    "Quit": "Sk\u00f3\u0144cy\u015b", 
    "Reset Password": "Gronid\u0142o sl\u011bdk staji\u015b", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "S\u0107elo se\u2026", 
    "Settings": "Nastajenja", 
    "Sign In": "P\u015bizjawi\u015b", 
    "Sign in to answer questions from Firefox OS users.": "P\u015bizjaw\u015bo se, aby na p\u0161a\u0161anja wu\u017eywarjow Firefox OS w\u00f3tegroni\u0142.", 
    "Sign in to answer questions from the Mozilla community.": "P\u015bizjaw\u015bo se, aby na p\u0161a\u0161anja ze zgroma\u017ae\u0144stwa Mozilla w\u00f3tegroni\u0142.", 
    "Sign in to reply": "P\u015bizjaw\u015bo se, aby w\u00f3tegroni\u0142", 
    "Solution \u2713": "Rozw\u011bzanje \u2713", 
    "Storage/SD card": "Sk\u0142adowak/SD-k\u00f3rta", 
    "Support": "Pomoc", 
    "System Updates": "Systemowe aktualizacije", 
    "Thank you for your question!": "Wjeliki \u017a\u011bk za wa\u0161o p\u0161a\u0161anje!", 
    "There was a problem with Buddy Up, please try again.": "Problem jo z Buddy Up nasta\u0142, p\u0161osym wopytaj\u015bo hy\u0161\u0107i raz.", 
    "This field is required.": "To\u015b to p\u00f3lo jo tr\u011bbne.", 
    "This solved my question": "To jo na m\u00f3jo p\u0161a\u0161anje w\u00f3tegroni\u0142o", 
    "This will close the question and let your buddy know you no longer need help.": "To zacynijo p\u0161a\u0161anje a wa\u0161 p\u015bija\u015bel  se inform\u011brujo, a\u017e njetrjeba\u015bo w\u011bcej pomoc.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "P\u015bewjele p\u0161a\u0161anjow? Wu\u017eywaj\u015bo sl\u011bdujuce nastajenja, aby lis\u0107inu p\u0161a\u0161anjow b\u017aez w\u00f3tegrona zagranicowa\u0142.", 
    "Top Helpers this Week": "Nejl\u011bp\u0161e pomagarje w to\u015b tom ty\u017aenju", 
    "Unable to generate username.": "Wu\u017eywarske m\u011b njedajo se tw\u00f3ri\u015b.", 
    "Unable to log in with provided credentials.": "P\u015bizjawjenje z p\u00f3danymi datami njejo m\u00f3\u017eno.", 
    "Unknown error: \"{error}\"": "Njeznata zm\u00f3lka: \"{error}\"", 
    "Unsupported Language": "Njep\u00f3dp\u011brana r\u011bc", 
    "User account is disabled.": "Wu\u017eywarske konto jo znjem\u00f3\u017enjone.", 
    "User not found.": "Wu\u017eywa\u0155 njejo se namaka\u0142.", 
    "Username": "Wu\u017eywarske m\u011b", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Wu\u017eywarske mjenja sm\u011bju jano z pismikow, licbow, \u201e.\u201c a \u201e-\u201c wobstoja\u015b.", 
    "We can help<br>Ask us anything!": "M\u00f3\u017eomy pomaga\u015b<br>Staj\u015bo nam sw\u00f3je p\u0161a\u0161anja!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Jo nam luto, ale BuddyUp njedajo se instal\u011browa\u015b na wa\u0161ej wersiji Firefox OS. P\u0161osym zacy\u0144\u015bo to\u015b to wokno, aby se k sw\u00f3jej startowej wobrazowce wro\u015bi\u0142.", 
    "We've sent a welcome email to:": "Smy p\u00f3wita\u0144sku mejlku p\u00f3s\u0142ali na:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Smy wam mejlku p\u00f3s\u0142ali. Sl\u011bduj\u015bo w\u00f3tkazoju w mejlce, aby sw\u00f3jo gronid\u0142o sl\u011bdk staji\u0142.", 
    "Whoops!": "Hopla!", 
    "Write your message\u2026": "Pi\u0161\u0107o sw\u00f3ju pow\u011bs\u0107\u2026", 
    "Yay, you're almost done!": "Hura, s\u0107o to sk\u00f3ro docyni\u0142!", 
    "You are not online, please check your connection.": "Njejs\u0107o online, p\u0161osym p\u015begl\u011bduj\u015bo sw\u00f3j zwisk.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Dostanjo\u015bo pow\u011b\u017ae\u0144ku, ga\u017e p\u015bija\u015bel chwata na pomoc.", 
    "just now": "rowno akle", 
    "x hours ago": "P\u015bed x g\u00f3\u017ainami", 
    "{n} day ago": [
      "p\u015bed {n} dnjom", 
      "p\u015bed {n} dnjoma", 
      "p\u015bed {n} dnjami", 
      "p\u015bed {n} dnjami"
    ], 
    "{n} helpful vote": [
      "{n} g\u0142os za \"wu\u017eytny\"", 
      "{n} g\u0142osa za \"wu\u017eytny\"", 
      "{n} g\u0142ose za \"wu\u017eytny\"", 
      "{n} g\u0142osow za \"wu\u017eytny\""
    ], 
    "{n} hour ago": [
      "p\u015bed {n} g\u00f3\u017ainu", 
      "p\u015bed {n} g\u00f3\u017ainoma", 
      "p\u015bed {n} g\u00f3\u017ainami", 
      "p\u015bed {n} g\u00f3\u017ainami"
    ], 
    "{n} minute ago": [
      "p\u015bed {n} minutu", 
      "p\u015bed {n} minutoma", 
      "p\u015bed {n} minutami", 
      "p\u015bed {n} minutami"
    ], 
    "{n} question solved": [
      "Jo se na {n} p\u0161a\u0161anje w\u00f3tegroni\u0142o", 
      "Jo se na {n} p\u0161a\u0161ani w\u00f3tegroni\u0142o", 
      "Jo se na {n} p\u0161a\u0161anja w\u00f3tegroni\u0142o", 
      "Jo se na {n} p\u0161a\u0161anjow w\u00f3tegroni\u0142o"
    ], 
    "{user} chose your answer as a solution": "{user} jo wa\u0161o w\u00f3tegrono ako rozw\u011bzanje wubra\u0142", 
    "{user} left a comment on your question": "{user} jo komentar k wa\u0161omu p\u0161a\u0161anjeju zaw\u00f3staji\u0142"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "N j, Y, P", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y"
    ], 
    "DATE_FORMAT": "N j, Y", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y", 
      "%b %d %Y", 
      "%b %d, %Y", 
      "%d %b %Y", 
      "%d %b, %Y", 
      "%B %d %Y", 
      "%B %d, %Y", 
      "%d %B %Y", 
      "%d %B, %Y"
    ], 
    "DECIMAL_SEPARATOR": ".", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "F j", 
    "NUMBER_GROUPING": "0", 
    "SHORT_DATETIME_FORMAT": "m/d/Y P", 
    "SHORT_DATE_FORMAT": "m/d/Y", 
    "THOUSAND_SEPARATOR": ",", 
    "TIME_FORMAT": "P", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

