

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n > 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> vote utile</div>", 
      "<div {countattr}>{n}</div><div {textattr}> votes utiles</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> question r\u00e9solue</div>", 
      "<div {countattr}>{n}</div><div {textattr}> questions r\u00e9solues</div>"
    ], 
    "A user with that email address already exists.": "Un utilisateur avec la m\u00eame adresse \u00e9lectronique existe d\u00e9j\u00e0.", 
    "A user with that username exists": "Un utilisateur avec ce nom d\u2019utilisateur existe d\u00e9j\u00e0.", 
    "All My Questions": "Toutes mes questions", 
    "Already registered? Sign in": "D\u00e9j\u00e0 inscrit ? Connectez-vous", 
    "An account lets you answer questions, track contributions and receive alerts.": "Un compte vous permet de r\u00e9pondre \u00e0 des questions, suivre les contributions et recevoir des alertes.", 
    "Another helper has answered this question, please choose another.": "Un autre utilisateur a r\u00e9pondu \u00e0 cette question, veuillez en choisir une autre.", 
    "Answer Questions": "R\u00e9pondre \u00e0 des questions", 
    "Answer a Question": "R\u00e9pondre \u00e0 une question", 
    "Answer questions": "R\u00e9pondre \u00e0 des questions", 
    "Answered Questions": "Questions r\u00e9pondues", 
    "Ask a Question": "Poser une question", 
    "Audio/Music/FMRadio": "Audio/Musique/Radio FM", 
    "Be aware that you will lose your history when you sign in to your account.": "Attention, vous perdrez votre historique lorsque vous vous connecterez \u00e0 votre compte.", 
    "Browser/Download": "Navigateur/T\u00e9l\u00e9chargement", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp ne prend pas en charge la langue \u00ab <span id=\"language\"></span> \u00bb.", 
    "Camera/Gallery/Video": "Appareil photo/Galerie/Vid\u00e9o", 
    "Can't change this field.": "Impossible de modifier ce champ.", 
    "Cancel": "Annuler", 
    "Cancel Sign Up": "Annuler l\u2019inscription", 
    "Cellular Data/WiFi/Bluetooth": "Donn\u00e9es mobiles/Wi-Fi/Bluetooth", 
    "Choose a category": "Choisissez une cat\u00e9gorie", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Cliquez sur le lien dans le message afin de confirmer qu\u2019il a \u00e9t\u00e9 correctement envoy\u00e9. Retournez ensuite sur BuddyUp et vous pouvez commencer \u00e0 aider les autres utilisateurs.", 
    "Clock/Alarm": "Horloge/Alarme", 
    "Close": "Fermer", 
    "Confirm Account": "Confirmer le compte", 
    "Continue": "Continuer", 
    "Create Account": "Cr\u00e9er un compte", 
    "Create account or sign in": "Cr\u00e9ez un compte ou connectez-vous", 
    "Device": "Appareil", 
    "Dialer/Contacts": "T\u00e9l\u00e9phone/Contacts", 
    "Don't have an account? Register": "Vous n\u2019avez pas de compte\u00a0? Inscrivez-vous", 
    "Done": "Termin\u00e9", 
    "Email Address": "Adresse \u00e9lectronique", 
    "Email/Calendar": "Courriel/Agenda", 
    "Enter a valid email address.": "Veuillez saisir une adresse \u00e9lectronique valide.", 
    "Failed": "\u00c9chec", 
    "Forgot your password?": "Mot de passe oubli\u00e9 ?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Vous avez oubli\u00e9 votre mot de passe ? Ne vous inqui\u00e9tez pas. Saisissez votre nom d\u2019utilisateur ci-dessous et nous vous enverrons des instructions pour en d\u00e9finir un nouveau.", 
    "Get a Buddy to help you with your device": "Trouvez quelqu\u2019un qui vous aidera", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Ouvrez un nouvel onglet pour r\u00e9pondre \u00e0 des questions. Nous allons les suivre \u00e0 cet emplacement.", 
    "Has your question been solved?": "Votre question a-t-elle \u00e9t\u00e9 r\u00e9solue ?", 
    "Have Answers?": "Vous avez des r\u00e9ponses ?", 
    "Have Questions?": "Vous avez des questions ?", 
    "Help Article": "Article d\u2019aide", 
    "Help other users around the world": "Aidez les autres utilisateurs du monde entier", 
    "Incompatible version": "Version incompatible", 
    "Keyboard": "Clavier", 
    "Language": "Langue", 
    "Last sync:": "Derni\u00e8re synchronisation :", 
    "Load more": "Afficher davantage", 
    "Maps/GPS": "Cartes/GPS", 
    "Marketplace/Apps Install": "Marketplace/Installation d\u2019application", 
    "My Profile": "Mon profil", 
    "My Question": "Ma question", 
    "My Questions": "Mes questions", 
    "My list": "Ma liste", 
    "My preferences": "Mes pr\u00e9f\u00e9rences", 
    "New": "Nouvelles", 
    "No active questions": "Pas de questions actives", 
    "No matching user setting found.": "Aucun param\u00e8tre utilisateur correspondant n\u2019a \u00e9t\u00e9 trouv\u00e9.", 
    "No questions": "Aucune question", 
    "OK": "OK", 
    "Ok": "OK", 
    "Operator": "Op\u00e9rateur", 
    "Other": "Autre", 
    "Password": "Mot de passe", 
    "Performance": "Performances", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Veuillez poser vos questions en anglais, ou rendez-vous sur <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> pour davantage d\u2019assistance.", 
    "Previously Answered": "R\u00e9pondues pr\u00e9c\u00e9demment", 
    "Quit": "Quitter", 
    "Reset Password": "R\u00e9initialiser le mot de passe", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Envoi en cours\u2026", 
    "Settings": "Param\u00e8tres", 
    "Sign In": "Se connecter", 
    "Sign in to answer questions from Firefox OS users.": "Connectez-vous pour r\u00e9pondre aux questions des utilisateurs de Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "Connectez-vous pour r\u00e9pondre aux questions de la part de la communaut\u00e9 Mozilla.", 
    "Sign in to reply": "Connectez-vous pour r\u00e9pondre", 
    "Solution \u2713": "Solution \u2713", 
    "Storage/SD card": "Stockage/Carte SD", 
    "Support": "Assistance", 
    "System Updates": "Mises \u00e0 jour syst\u00e8me", 
    "Thank you for your question!": "Merci d\u2019avoir pos\u00e9 une question !", 
    "There was a problem with Buddy Up, please try again.": "Il y a eu un probl\u00e8me avec Buddy Up, veuillez r\u00e9essayer.", 
    "This field is required.": "Ce champ est requis.", 
    "This solved my question": "Ceci a r\u00e9pondu \u00e0 ma question", 
    "This will close the question and let your buddy know you no longer need help.": "Cette action fermera la question et signalera \u00e0 la personne qui vous a r\u00e9pondu que vous n\u2019avez plus besoin d\u2019aide.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Trop de questions ? Utilisez les param\u00e8tres ci-dessous pour filtrer la liste \u00ab R\u00e9pondre \u00e0 une question \u00bb.", 
    "Top Helpers this Week": "Meilleurs contributeurs de la semaine", 
    "Unable to generate username.": "Impossible de g\u00e9n\u00e9rer un nom d\u2019utilisateur.", 
    "Unable to log in with provided credentials.": "Connexion impossible avec les informations saisies.", 
    "Unknown error: \"{error}\"": "Erreur inconnue\u00a0: \u00ab\u00a0{error}\u00a0\u00bb", 
    "Unsupported Language": "Langue non prise en charge", 
    "User account is disabled.": "Ce compte utilisateur est d\u00e9sactiv\u00e9.", 
    "User not found.": "Utilisateur introuvable.", 
    "Username": "Nom d\u2019utilisateur", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Un nom d\u2019utilisateur peut uniquement contenir des lettres, des chiffres, \u00ab\u00a0.\u00a0\u00bb et \u00ab\u00a0-\u00a0\u00bb.", 
    "We can help<br>Ask us anything!": "Nous pouvons vous aider<br>Demandez-nous ce que vous voulez !", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Nous sommes d\u00e9sol\u00e9s, BuddyUp ne peut pas \u00eatre install\u00e9 sur votre version de Firefox OS. Veuillez fermer cette fen\u00eatre pour revenir \u00e0 l\u2019\u00e9cran d\u2019accueil.", 
    "We've sent a welcome email to:": "Nous avons envoy\u00e9 un message de bienvenue \u00e0 :", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Nous vous avons envoy\u00e9 un courriel. Cliquez sur le lien dans le message pour r\u00e9initialiser votre mot de passe.", 
    "Whoops!": "Oups !", 
    "Write your message\u2026": "R\u00e9digez votre message\u2026", 
    "Yay, you're almost done!": "Encore un petit effort\u2026", 
    "You are not online, please check your connection.": "Vous \u00eates hors connexion, veuillez v\u00e9rifier votre connexion.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Vous recevrez une notification d\u00e8s qu\u2019un autre utilisateur viendra apporter son aide.", 
    "just now": "\u00e0 l\u2019instant", 
    "x hours ago": "il y a x heures", 
    "{n} day ago": [
      "il y a {n} jour", 
      "il y a {n} jours"
    ], 
    "{n} helpful vote": [
      "{n} vote utile", 
      "{n} votes utiles"
    ], 
    "{n} hour ago": [
      "il y a {n} heure", 
      "il y a {n} heures"
    ], 
    "{n} minute ago": [
      "il y a {n} minute", 
      "il y a {n} minutes"
    ], 
    "{n} question solved": [
      "{n} question r\u00e9solue", 
      "{n} questions r\u00e9solues"
    ], 
    "{user} chose your answer as a solution": "{user} a choisi votre r\u00e9ponse comme solution", 
    "{user} left a comment on your question": "{user} a laiss\u00e9 un commentaire \u00e0 votre question"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j F Y H:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S", 
      "%d/%m/%Y %H:%M:%S.%f", 
      "%d/%m/%Y %H:%M", 
      "%d/%m/%Y", 
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j F Y", 
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y", 
      "%d/%m/%y", 
      "%d.%m.%Y", 
      "%d.%m.%y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "j N Y H:i:s", 
    "SHORT_DATE_FORMAT": "j N Y", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

